/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.pca.PcaBalanceAnaFacadeFactory;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.client.AbstractPcaBalanceAnalysisUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PcaBalanceAnalysisUI
extends AbstractPcaBalanceAnalysisUI {
    private static final String RES = "com.kingdee.eas.fi.gl.BalanceAnalysisResource";
    private static final Logger logger = CoreUIObject.getLogger(PcaBalanceAnalysisUI.class);
    private int maxHistory = 120;
    private int maxFuture = 13;
    private boolean stop = false;
    private static final Color bgColor = new Color(240, 240, 240);
    private static final Color successColor = new Color(0, 130, 0);
    private static final Color curColor = new Color(50, 205, 50);
    private static final Color futColor = new Color(30, 144, 255);
    private KDButtonGroup bgCompare = new KDButtonGroup();
    Map<String, String> relations = new HashMap<String, String>();
    Map<String, CompanyOrgUnitInfo> companys = new HashMap<String, CompanyOrgUnitInfo>();
    DataChangeListener companyListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                PcaBalanceAnalysisUI.this.initPeriod();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                PcaBalanceAnalysisUI.this.handUIException(ex);
            }
            try {
                PcaBalanceAnalysisUI.this.initTable();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                PcaBalanceAnalysisUI.this.handUIException(ex);
            }
        }
    };
    ItemListener tableListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                PcaBalanceAnalysisUI.this.initAccount();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                PcaBalanceAnalysisUI.this.handUIException(ex);
            }
        }
    };

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        try {
            IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)"select FKey, FValue from T_GL_AnaConfig where FKey in ('AnaBal_MaxHistory','AnaBal_MaxFuture') ").executeSQL();
            while (rs.next()) {
                String key = rs.getString("FKey");
                String value = rs.getString("FValue");
                if ("AnaBal_MaxHistory".equals(key)) {
                    if (value == null) continue;
                    try {
                        this.maxHistory = Integer.parseInt(value);
                        if (this.maxHistory > 0) continue;
                        this.maxHistory = 120;
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!"AnaBal_MaxFuture".equals(key) || value == null) continue;
                try {
                    this.maxFuture = Integer.parseInt(value);
                    if (this.maxFuture > 0) continue;
                    this.maxFuture = 13;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onLoad();
        this.initMyIcon();
        this.initTableStyle();
        this.initCompany();
    }

    private void initMyIcon() throws Exception {
        this.periodFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.periodFrom.setEditable(true);
        this.periodFrom.setEditFormat("$number$");
        this.periodFrom.setCommitFormat("$number$");
        this.periodTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.periodTo.setEditable(true);
        this.periodTo.setEditFormat("$number$");
        this.periodTo.setCommitFormat("$number$");
        this.spHistorys.setModel((SpinnerModel)new SpinnerNumberModel(0, -1, this.maxHistory, 1));
        this.spFutures.setModel((SpinnerModel)new SpinnerNumberModel(0, 0, this.maxFuture, 1));
        this.spMaxRecord.setModel((SpinnerModel)new SpinnerNumberModel(500, 0, 100000, 500));
        this.cbPosted.setSelected(true);
        this.cbUnPost.setSelected(true);
        this.cbBein.setSelected(true);
        this.cbCurrent.setSelected(true);
        this.cbOrigin.setSelected(true);
        this.cbAccount.setSelected(true);
        this.cbAssist.setSelected(true);
        this.cbCompareAmt.setSelected(true);
        this.cbCompareAmt.setEnabled(false);
        this.rbCompareDou.setSelected(true);
        this.bgCompare.add((AbstractButton)this.rbCompareFwd);
        this.bgCompare.add((AbstractButton)this.rbCompareRev);
        this.bgCompare.add((AbstractButton)this.rbCompareDou);
        this.kDTable1.checkParsed();
        this.btnOk.setEnabled(true);
        this.cbPosted.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PcaBalanceAnalysisUI.this.cbPosted.isSelected() && !PcaBalanceAnalysisUI.this.cbUnPost.isSelected()) {
                    PcaBalanceAnalysisUI.this.cbUnPost.setSelected(true);
                }
            }
        });
        this.cbUnPost.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PcaBalanceAnalysisUI.this.cbPosted.isSelected() && !PcaBalanceAnalysisUI.this.cbUnPost.isSelected()) {
                    PcaBalanceAnalysisUI.this.cbPosted.setSelected(true);
                }
            }
        });
        this.cbBein.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PcaBalanceAnalysisUI.this.cbBein.isSelected() && !PcaBalanceAnalysisUI.this.cbCurrent.isSelected()) {
                    PcaBalanceAnalysisUI.this.cbCurrent.setSelected(true);
                }
            }
        });
        this.cbCurrent.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PcaBalanceAnalysisUI.this.cbBein.isSelected() && !PcaBalanceAnalysisUI.this.cbCurrent.isSelected()) {
                    PcaBalanceAnalysisUI.this.cbBein.setSelected(true);
                }
            }
        });
        this.cbOrigin.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!(PcaBalanceAnalysisUI.this.cbOrigin.isSelected() || PcaBalanceAnalysisUI.this.cbLocal.isSelected() || PcaBalanceAnalysisUI.this.cbReport.isSelected())) {
                    PcaBalanceAnalysisUI.this.cbLocal.setSelected(true);
                }
            }
        });
        this.cbLocal.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!(PcaBalanceAnalysisUI.this.cbOrigin.isSelected() || PcaBalanceAnalysisUI.this.cbLocal.isSelected() || PcaBalanceAnalysisUI.this.cbReport.isSelected())) {
                    PcaBalanceAnalysisUI.this.cbReport.setSelected(true);
                }
            }
        });
        this.cbReport.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!(PcaBalanceAnalysisUI.this.cbOrigin.isSelected() || PcaBalanceAnalysisUI.this.cbLocal.isSelected() || PcaBalanceAnalysisUI.this.cbReport.isSelected())) {
                    PcaBalanceAnalysisUI.this.cbOrigin.setSelected(true);
                }
            }
        });
        this.cbAccount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PcaBalanceAnalysisUI.this.cbAccount.isSelected() && !PcaBalanceAnalysisUI.this.cbAssist.isSelected()) {
                    PcaBalanceAnalysisUI.this.cbAssist.setSelected(true);
                }
            }
        });
        this.cbAssist.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PcaBalanceAnalysisUI.this.cbAccount.isSelected() && !PcaBalanceAnalysisUI.this.cbAssist.isSelected()) {
                    PcaBalanceAnalysisUI.this.cbAccount.setSelected(true);
                }
            }
        });
    }

    private void initCompany() throws Exception {
        this.promptProfitCenter.setQueryInfo("com.kingdee.eas.basedata.org.app.ProfitCenterOrgUnitQuery");
        this.promptProfitCenter.setEditable(true);
        this.promptProfitCenter.setEditFormat("$number$");
        this.promptProfitCenter.setCommitFormat("$name$;$number$");
        this.promptProfitCenter.setDisplayFormat("$number$-$name$");
        this.promptProfitCenter.setEnabledMultiSelection(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isSealup", (Object)new Integer(0)));
        StringBuffer sql = new StringBuffer();
        sql.append("select c.FID \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_BD_SystemStatus s \n");
        sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 1006 \n");
        sql.append("join T_ORG_ProfitCenter c on c.FID = sc.FProfitCenterID \n");
        sql.append("where sc.FIsStart = 1 and c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
        sql.append("    and sc.FStartPeriodID is not null \n");
        sql.append("    and sc.FCurrentPeriodID is not null \n");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        view.setFilter(filter);
        this.promptProfitCenter.setEntityViewInfo(view);
        ProfitCenterOrgUnitInfo profitCenter = this.getFirstOrg();
        if (profitCenter != null) {
            this.promptProfitCenter.setValue((Object)new Object[]{profitCenter});
        } else {
            this.promptProfitCenter.setValue((Object)new Object[0]);
        }
        this.promptProfitCenter.addDataChangeListener(this.companyListener);
        this.initPeriod();
        this.initTable();
    }

    private void initTable() throws Exception {
        this.cbTable.removeItemListener(this.tableListener);
        this.cbTable.setEnabled(false);
        this.prmptAccount.setEnabled(false);
        this.cbTable.removeAllItems();
        this.prmptAccount.setValue(null);
        Object[] objects = (Object[])this.promptProfitCenter.getValue();
        if (objects != null && objects.length > 0) {
            ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)objects[0];
            CompanyOrgUnitInfo company = this.queryCompany(profitCenter);
            if (company == null) {
                return;
            }
            this.cbTable.addItems(this.getAccountTables(company).toArray());
            GlUtils.setSelectedItem((KDComboBox)this.cbTable, (CoreBaseInfo)company.getAccountTable());
            this.cbTable.setEnabled(true);
            this.prmptAccount.setEnabled(true);
            this.cbTable.addItemListener(this.tableListener);
            this.initAccount();
        }
    }

    private AccountTableCollection getAccountTables(CompanyOrgUnitInfo company) throws BOSException {
        try {
            HashSet<String> ids = new HashSet<String>();
            ids.add(company.getAccountTable().getId().toString());
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("refType", (Object)1));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("disabledAcctTable.id"));
            sic.add(new SelectorItemInfo("enabledAcctTable.id"));
            view.setSelector(sic);
            AccountRefContrastCollection col = AccountRefContrastFactory.getRemoteInstance().getAccountRefContrastCollection(view);
            if (col.size() > 0) {
                for (int i = 0; i < col.size(); ++i) {
                    AccountRefContrastInfo info = col.get(i);
                    if (info.getDisabledAcctTable() != null && info.getDisabledAcctTable().getId() != null) {
                        ids.add(info.getDisabledAcctTable().getId().toString());
                    }
                    if (info.getEnabledAcctTable() == null || info.getEnabledAcctTable().getId() == null) continue;
                    ids.add(info.getEnabledAcctTable().getId().toString());
                }
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            evi.setFilter(filter2);
            return AccountTableFactory.getRemoteInstance().getAccountTableCollection(evi);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return new AccountTableCollection();
        }
    }

    protected void initAccount() throws Exception {
        this.prmptAccount.setEnabled(false);
        this.prmptAccount.setValue(null);
        Object[] objects = (Object[])this.promptProfitCenter.getValue();
        if (objects != null && objects.length > 0) {
            ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)objects[0];
            CompanyOrgUnitInfo company = this.queryCompany(profitCenter);
            if (company == null) {
                return;
            }
            AccountTableInfo table = (AccountTableInfo)this.cbTable.getSelectedItem();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
            if (table != null) {
                fic.add(new FilterItemInfo("accountTableID.id", (Object)table.getId().toString()));
            } else {
                fic.add(new FilterItemInfo("accountTableID.id", (Object)"emptyid"));
            }
            filter.setMaskString("#0 and #1");
            AccountPromptBox apb = new AccountPromptBox((IUIObject)this, company, table, filter, false, false);
            this.prmptAccount.setValue(null);
            this.prmptAccount.setEditable(false);
            this.prmptAccount.setEditFormat("$number$");
            this.prmptAccount.setCommitFormat("$helpCode$;$name$;$number$");
            this.prmptAccount.setDisplayFormat("$number$ - $name$");
            this.prmptAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
            this.prmptAccount.setEnabledMultiSelection(true);
            this.prmptAccount.setSelector((KDPromptSelector)apb);
            this.prmptAccount.setEnabled(true);
        }
    }

    private void initPeriod() throws Exception {
        this.periodFrom.setEnabled(false);
        this.periodTo.setEnabled(false);
        this.spHistorys.setEnabled(false);
        this.spFutures.setEnabled(false);
        Object[] objects = (Object[])this.promptProfitCenter.getValue();
        if (objects == null || objects.length == 0) {
            this.periodFrom.setValue(null);
            this.periodTo.setValue(null);
            this.spHistorys.setValue((Object)0);
            this.spFutures.setValue((Object)0);
            return;
        }
        if (objects.length == 1) {
            ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)objects[0];
            CompanyOrgUnitInfo company = this.queryCompany(profitCenter);
            PeriodInfo startPeriod = SystemStatusCtrolFactory.getRemoteInstance().getProfitStartPeriod(1006, profitCenter.getId().toString());
            PeriodInfo curPeriod = SystemStatusCtrolFactory.getRemoteInstance().getProfitCurrentPeriod(1006, profitCenter.getId().toString());
            if (company != null) {
                EntityViewInfo tView = new EntityViewInfo();
                FilterInfo tFilter = new FilterInfo();
                tView.setFilter(tFilter);
                tFilter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)company.getAccountPeriodType().getId().toString()));
                tFilter.getFilterItems().add(new FilterItemInfo("number", (Object)curPeriod.getNumber(), CompareType.GREATER));
                SelectorItemCollection tSelector = new SelectorItemCollection();
                tSelector.add("number");
                tView.setSelector(tSelector);
                SorterItemCollection sorter = new SorterItemCollection();
                SorterItemInfo si = new SorterItemInfo("number");
                si.setSortType(SortType.ASCEND);
                sorter.add(si);
                tView.setSorter(sorter);
                PeriodCollection coll = PeriodFactory.getRemoteInstance().getPeriodCollection(tView);
                int maxPeriod = curPeriod.getNumber();
                if (coll.size() >= this.maxFuture) {
                    maxPeriod = coll.get(this.maxFuture - 1).getNumber();
                } else if (coll.size() > 0) {
                    maxPeriod = coll.get(coll.size() - 1).getNumber();
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)company.getAccountPeriodType().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)startPeriod.getNumber(), CompareType.GREATER_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)maxPeriod, CompareType.LESS_EQUALS));
                this.periodFrom.setEntityViewInfo(view);
                this.periodTo.setEntityViewInfo(view);
            }
            this.periodFrom.setValue((Object)curPeriod);
            this.periodTo.setValue((Object)curPeriod);
            this.periodFrom.setEnabled(true);
            this.periodTo.setEnabled(true);
            this.spHistorys.setValue((Object)0);
            this.spFutures.setValue((Object)0);
        } else {
            this.periodFrom.setValue(null);
            this.periodTo.setValue(null);
            this.spHistorys.setEnabled(true);
            this.spFutures.setEnabled(true);
        }
    }

    private CompanyOrgUnitInfo queryCompany(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company.getAccountPeriodType() != null) {
            return company;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("accountPeriodType.id");
        CompanyOrgUnitInfo c = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), selector);
        company.setAccountPeriodType(c.getAccountPeriodType());
        return company;
    }

    @Override
    public void actionComfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.btnOk.getClientProperty((Object)"canStop") != null) {
            this.stop = true;
            this.actionComfirm.setEnabled(false);
            this.btnOk.setEnabled(false);
            return;
        }
        final Object[] objects = (Object[])this.promptProfitCenter.getValue();
        if (objects == null || objects.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SelectOrg"));
            return;
        }
        final int mode = objects.length == 1 ? 1 : 2;
        final HashMap<String, Object> params = new HashMap<String, Object>();
        if (mode == 1) {
            PeriodInfo periodfrom = null;
            PeriodInfo periodto = null;
            Object ofrom = this.periodFrom.getValue();
            Object[] oto = this.periodTo.getValue();
            if (ofrom instanceof PeriodInfo) {
                periodfrom = (PeriodInfo)ofrom;
            } else {
                this.periodFrom.setValue(null);
            }
            if (oto instanceof PeriodInfo) {
                periodto = (PeriodInfo)oto;
            } else {
                this.periodTo.setValue(null);
            }
            if (periodfrom == null || periodto == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"selectPeriod"));
                return;
            }
            if (periodfrom.getPeriodYear() > periodto.getPeriodYear() || periodfrom.getPeriodYear() == periodto.getPeriodYear() && periodfrom.getPeriodNumber() > periodto.getPeriodNumber()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"StartPeriodMoreThanEndPeriod"));
                return;
            }
            params.put("periodFrom", periodfrom);
            params.put("periodTo", periodto);
        } else {
            params.put("AnaBal_Historys", (Integer)this.spHistorys.getValue());
            params.put("AnaBal_Futures", (Integer)this.spFutures.getValue());
        }
        HashSet<String> accountNumbers = new HashSet<String>();
        Object objAccount = this.prmptAccount.getValue();
        if (objAccount instanceof AccountViewInfo) {
            accountNumbers.add(((AccountViewInfo)objAccount).getNumber());
        } else if (objAccount instanceof Object[]) {
            Object[] objAccounts;
            for (Object obj : objAccounts = (Object[])objAccount) {
                if (!(obj instanceof AccountViewInfo)) continue;
                accountNumbers.add(((AccountViewInfo)obj).getNumber());
            }
        }
        String strAccount = this.txtAccount.getText();
        if (strAccount != null) {
            String[] strAccounts;
            strAccount = strAccount.trim();
            for (String str : strAccounts = strAccount.split(";")) {
                if ((str = str.trim()).length() <= 0) continue;
                accountNumbers.add(str);
            }
        }
        params.put("accountNumbers", accountNumbers);
        int r = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"AnalysisWarn"));
        if (r != 0) {
            return;
        }
        params.put("AnaBal_Posted", this.cbPosted.isSelected());
        params.put("AnaBal_UnPost", this.cbUnPost.isSelected());
        params.put("AnaBal_Begin", this.cbBein.isSelected());
        params.put("AnaBal_Current", this.cbCurrent.isSelected());
        int cyType = 0;
        if (this.cbOrigin.isSelected()) {
            cyType |= 1;
        }
        if (this.cbLocal.isSelected()) {
            cyType |= 2;
        }
        if (this.cbReport.isSelected()) {
            cyType |= 4;
        }
        params.put("AnaBal_Currency", cyType);
        params.put("AnaBal_ShowName", this.cbShowName.isSelected());
        params.put("AnaBal_CompareFwd", this.rbCompareFwd.isSelected());
        params.put("AnaBal_CompareRev", this.rbCompareRev.isSelected());
        params.put("AnaBal_CompareDou", this.rbCompareDou.isSelected());
        params.put("AnaBal_Account", this.cbAccount.isSelected());
        params.put("AnaBal_Assist", this.cbAssist.isSelected());
        params.put("AnaBal_CompareAmt", this.cbCompareAmt.isSelected());
        params.put("AnaBal_CompareQty", this.cbCompareQty.isSelected());
        params.put("AnaBal_ComparePNL", this.cbComparePNL.isSelected());
        int maxSize = (Integer)this.spMaxRecord.getValue();
        if (maxSize == 0) {
            maxSize = Integer.MAX_VALUE;
        }
        params.put("AnaBal_MaxSize", maxSize);
        final boolean repair = this.cbRepair.isSelected();
        params.put("AnaBal_Repair", repair);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    PcaBalanceAnalysisUI.this.tfInfo.setText("");
                    PcaBalanceAnalysisUI.this.kDTable1.removeRows();
                    int ocount = 0;
                    int rcount = 0;
                    if (mode == 1) {
                        PcaBalanceAnalysisUI.this.actionComfirm.setEnabled(false);
                        PcaBalanceAnalysisUI.this.btnOk.setEnabled(false);
                    } else {
                        PcaBalanceAnalysisUI.this.btnOk.putClientProperty((Object)"canStop", (Object)true);
                        PcaBalanceAnalysisUI.this.btnOk.setText(EASResource.getString((String)PcaBalanceAnalysisUI.RES, (String)"Stop"));
                    }
                    PcaBalanceAnalysisUI.this.enableComponent(mode, false);
                    for (int i = 0; i < objects.length; ++i) {
                        ProfitCenterOrgUnitInfo c = (ProfitCenterOrgUnitInfo)objects[i];
                        try {
                            PcaBalanceAnalysisUI.this.tfInfo.setText(EASResource.getString((String)PcaBalanceAnalysisUI.RES, (String)"Analysis") + " (" + (i + 1) + "/" + objects.length + ") " + c.getName() + "[" + c.getNumber() + "] ...");
                            CompanyOrgUnitInfo company = PcaBalanceAnalysisUI.this.queryCompany(c);
                            if (company == null) {
                                PcaBalanceAnalysisUI.this.showCompany(c, null, EASResource.getString((String)PcaBalanceAnalysisUI.RES, (String)"NoSetMainCompany"), i % 2 != 0 ? bgColor : null, Color.RED);
                                continue;
                            }
                            Map result = (Map)PcaBalanceAnaFacadeFactory.getRemoteInstance().analysis(c.getId().toString(), params);
                            if (repair) {
                                if (result.get("isNeedRepair") != null) {
                                    String periodMsg = ((PeriodInfo)result.get("periodfrom")).getNumber() + "-" + ((PeriodInfo)result.get("periodto")).getNumber();
                                    Map rresult = PcaBalanceAnalysisUI.this.repair(c, result);
                                    String status = (String)rresult.get("status");
                                    if ("Success".equals(status)) {
                                        PcaBalanceAnalysisUI.this.showCompany(c, periodMsg, EASResource.getString((String)PcaBalanceAnalysisUI.RES, (String)"RepairSuccess"), i % 2 != 0 ? bgColor : null, successColor);
                                        ++ocount;
                                    } else {
                                        PcaBalanceAnalysisUI.this.showCompany(c, periodMsg, (String)rresult.get("message"), i % 2 != 0 ? bgColor : null, Color.RED);
                                    }
                                } else {
                                    PcaBalanceAnalysisUI.this.showCompany(c, null, EASResource.getString((String)PcaBalanceAnalysisUI.RES, (String)"NoNeedRepair"), i % 2 != 0 ? bgColor : null, null);
                                }
                            } else {
                                List list = (List)result.get("errors");
                                rcount += list.size();
                                PcaBalanceAnalysisUI.this.showRecords(result, list, ocount % 2 != 0 ? bgColor : null);
                                if (list.size() > 0) {
                                    ++ocount;
                                }
                            }
                        }
                        catch (Exception e) {
                            String balMsg = repair ? EASResource.getString((String)PcaBalanceAnalysisUI.RES, (String)"RepairError") : EASResource.getString((String)PcaBalanceAnalysisUI.RES, (String)"AnalysisError");
                            PcaBalanceAnalysisUI.this.showCompany(c, null, balMsg, i % 2 != 0 ? bgColor : null, Color.RED);
                            logger.error((Object)balMsg, (Throwable)e);
                        }
                        if (PcaBalanceAnalysisUI.this.stop) break;
                    }
                    if (repair) {
                        PcaBalanceAnalysisUI.this.tfInfo.setText(EASResource.getString((String)PcaBalanceAnalysisUI.RES, (String)"RepairResult", (Object[])new Object[]{objects.length, ocount}));
                    } else {
                        PcaBalanceAnalysisUI.this.tfInfo.setText(EASResource.getString((String)PcaBalanceAnalysisUI.RES, (String)"AnalysisResult", (Object[])new Object[]{objects.length, rcount}));
                    }
                }
                finally {
                    PcaBalanceAnalysisUI.this.btnOk.setText(EASResource.getString((String)PcaBalanceAnalysisUI.RES, (String)"Execute"));
                    PcaBalanceAnalysisUI.this.enableComponent(mode, true);
                    PcaBalanceAnalysisUI.this.actionComfirm.setEnabled(true);
                    PcaBalanceAnalysisUI.this.btnOk.setEnabled(true);
                    PcaBalanceAnalysisUI.this.btnOk.putClientProperty((Object)"canStop", null);
                    PcaBalanceAnalysisUI.this.stop = false;
                }
            }
        }).start();
    }

    private void enableComponent(int mode, boolean enable) {
        this.promptProfitCenter.setEnabled(enable);
        if (mode == 1) {
            this.periodFrom.setEnabled(enable);
            this.periodTo.setEnabled(enable);
        } else {
            this.spHistorys.setEnabled(enable);
            this.spFutures.setEnabled(enable);
        }
        this.spMaxRecord.setEnabled(enable);
        this.cbPosted.setEnabled(enable);
        this.cbUnPost.setEnabled(enable);
        this.cbBein.setEnabled(enable);
        this.cbCurrent.setEnabled(enable);
        this.cbOrigin.setEnabled(enable);
        this.cbLocal.setEnabled(enable);
        this.cbReport.setEnabled(enable);
        this.cbShowName.setEnabled(enable);
        this.rbCompareFwd.setEnabled(enable);
        this.rbCompareRev.setEnabled(enable);
        this.rbCompareDou.setEnabled(enable);
        this.cbAccount.setEnabled(enable);
        this.cbAssist.setEnabled(enable);
        this.cbCompareQty.setEnabled(enable);
        this.cbComparePNL.setEnabled(enable);
        this.cbRepair.setEnabled(enable);
        this.cbTable.setEnabled(enable);
        this.prmptAccount.setEnabled(enable);
        this.txtAccount.setEnabled(enable);
    }

    public boolean checkBeforeWindowClosing() {
        this.stop = true;
        return super.checkBeforeWindowClosing();
    }

    private Map repair(ProfitCenterOrgUnitInfo profitCenter, Map param) throws Exception {
        PcaUtils.updateBalance(new String[]{profitCenter.getId().toString()});
        return PcaBalanceAnaFacadeFactory.getRemoteInstance().repair(param);
    }

    private void showRecords(final Map result, final List<Map<String, Object>> list, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Map data : list) {
                    PcaBalanceAnalysisUI.this.showRecord(result, data, PcaBalanceAnalysisUI.this.isPnlNotEqual(data), color);
                }
            }
        });
    }

    private void showRecord(Map result, Map<String, Object> data, boolean isPnl, Color color) {
        Integer balType;
        IRow row = this.kDTable1.addRow();
        Integer anaPt = (Integer)data.get("anaPt");
        if (anaPt == null) {
            anaPt = 1;
        }
        row.getCell("company").setValue(result.get("company"));
        row.getCell("startPeriod").setValue(result.get("startPeriod"));
        row.getCell("currentPeriod").setValue(result.get("currentPeriod"));
        row.getCell("period").setValue(data.get("period"));
        if (anaPt == 1 || anaPt == 11) {
            if (anaPt == 11) {
                row.getCell("period").getStyleAttributes().setItalic(true);
            }
        } else if (anaPt == 2 || anaPt == 21) {
            row.getCell("period").getStyleAttributes().setFontColor(curColor);
            if (anaPt == 21) {
                row.getCell("period").getStyleAttributes().setItalic(true);
            }
        } else {
            row.getCell("period").getStyleAttributes().setFontColor(futColor);
        }
        if ((balType = (Integer)data.get("balType")) == 5) {
            row.getCell("balType").setValue((Object)EASResource.getString((String)RES, (String)"Posted"));
        } else {
            row.getCell("balType").setValue((Object)EASResource.getString((String)RES, (String)"UnPost"));
        }
        Integer sourceType = (Integer)data.get("sourceType");
        if (sourceType == 2) {
            row.getCell("sourceType").setValue((Object)EASResource.getString((String)RES, (String)"Current"));
        } else {
            row.getCell("sourceType").setValue((Object)EASResource.getString((String)RES, (String)"Begin"));
        }
        row.getCell("currency").setValue(data.get("currency"));
        row.getCell("account").setValue(data.get("account"));
        row.getCell("accountTable").setValue(data.get("accountTable"));
        row.getCell("currentAccountTable").setValue(result.get("currentAccountTable"));
        row.getCell("assist").setValue(data.get("assist"));
        row.getCell("curBegAmount").setValue(data.get("curBegAmount"));
        row.getCell("preEndAmount").setValue(data.get("preEndAmount"));
        row.getCell("curBegQty").setValue(data.get("curBegQty"));
        row.getCell("preEndQty").setValue(data.get("preEndQty"));
        if (isPnl) {
            row.getCell("balDebitAmount").setValue(data.get("balMonthPnlAmount"));
            row.getCell("vchDebitAmount").setValue(data.get("vchMonthPnlAmount"));
            row.getCell("balDebitQty").setValue(data.get("balMonthPnlQty"));
            row.getCell("vchDebitQty").setValue(data.get("vchMonthPnlQty"));
            row.getCell("balCreditAmount").setValue((Object)"PNL");
            row.getCell("vchCreditAmount").setValue((Object)"PNL");
            row.getCell("balCreditQty").setValue((Object)"PNL");
            row.getCell("vchCreditQty").setValue((Object)"PNL");
        } else {
            row.getCell("balDebitAmount").setValue(data.get("balDebitAmount"));
            row.getCell("vchDebitAmount").setValue(data.get("vchDebitAmount"));
            row.getCell("balDebitQty").setValue(data.get("balDebitQty"));
            row.getCell("vchDebitQty").setValue(data.get("vchDebitQty"));
            row.getCell("balCreditAmount").setValue(data.get("balCreditAmount"));
            row.getCell("vchCreditAmount").setValue(data.get("vchCreditAmount"));
            row.getCell("balCreditQty").setValue(data.get("balCreditQty"));
            row.getCell("vchCreditQty").setValue(data.get("vchCreditQty"));
        }
        if (color != null) {
            row.getStyleAttributes().setBackground(color);
        }
    }

    private boolean isPnlNotEqual(Map<String, Object> data) {
        Integer sourceType = (Integer)data.get("sourceType");
        if (sourceType != 2) {
            return false;
        }
        BigDecimal balDebitAmount = (BigDecimal)data.get("balDebitAmount");
        BigDecimal vchDebitAmount = (BigDecimal)data.get("vchDebitAmount");
        BigDecimal balDebitQty = (BigDecimal)data.get("balDebitQty");
        BigDecimal vchDebitQty = (BigDecimal)data.get("vchDebitQty");
        BigDecimal balCreditAmount = (BigDecimal)data.get("balCreditAmount");
        BigDecimal vchCreditAmount = (BigDecimal)data.get("vchCreditAmount");
        BigDecimal balCreditQty = (BigDecimal)data.get("balCreditQty");
        BigDecimal vchCreditQty = (BigDecimal)data.get("vchCreditQty");
        if (balDebitAmount.compareTo(vchDebitAmount) != 0 || balDebitQty.compareTo(vchDebitQty) != 0 || balCreditAmount.compareTo(vchCreditAmount) != 0 || balCreditQty.compareTo(vchCreditQty) != 0) {
            return false;
        }
        if (this.cbComparePNL.isSelected()) {
            BigDecimal balMonthPnlAmount = (BigDecimal)data.get("balMonthPnlAmount");
            BigDecimal vchMonthPnlAmount = (BigDecimal)data.get("vchMonthPnlAmount");
            BigDecimal balMonthPnlQty = (BigDecimal)data.get("balMonthPnlQty");
            BigDecimal vchMonthPnlQty = (BigDecimal)data.get("vchMonthPnlQty");
            if (balMonthPnlAmount != null && balMonthPnlAmount.compareTo(vchMonthPnlAmount) != 0 || balMonthPnlQty != null && balMonthPnlQty.compareTo(vchMonthPnlQty) != 0) {
                return true;
            }
        }
        return false;
    }

    private void showCompany(final ProfitCenterOrgUnitInfo company, final String periodMsg, final String balMsg, final Color bgColor, final Color fontColor) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IRow row = PcaBalanceAnalysisUI.this.kDTable1.addRow();
                row.getCell("company").setValue((Object)company.getNumber());
                if (periodMsg != null) {
                    row.getCell("period").setValue((Object)periodMsg);
                }
                if (balMsg != null) {
                    row.getCell("balType").setValue((Object)balMsg);
                }
                if (bgColor != null) {
                    row.getStyleAttributes().setBackground(bgColor);
                }
                if (fontColor != null) {
                    row.getStyleAttributes().setFontColor(fontColor);
                }
            }
        });
    }

    protected void initTableStyle() {
    }

    @Override
    public void actionPcaBalanceRepair_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        Object[] objects = (Object[])this.promptProfitCenter.getValue();
        if (objects != null && objects.length > 0) {
            uiContext.put((Object)"profitCenter", objects[0]);
            if (objects.length == 1) {
                Object ofrom = this.periodFrom.getValue();
                Object oto = this.periodTo.getValue();
                if (ofrom instanceof PeriodInfo) {
                    uiContext.put((Object)"periodfrom", ofrom);
                }
                if (oto instanceof PeriodInfo) {
                    uiContext.put((Object)"periodto", oto);
                }
            }
            AccountTableInfo table = (AccountTableInfo)this.cbTable.getSelectedItem();
            uiContext.put((Object)"table", (Object)table);
            Object objAccount = this.prmptAccount.getValue();
            uiContext.put((Object)"accounts", objAccount);
            String strAccount = this.txtAccount.getText();
            uiContext.put((Object)"strAccounts", (Object)strAccount);
        }
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.pca.client.PcaBalanceRepairUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (UIException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            this.handUIException(ex);
        }
    }

    private ProfitCenterOrgUnitInfo getFirstOrg() {
        IRowSet rs;
        StringBuffer sql;
        Map context = this.getUIContext();
        if (context.get("profitCenter") != null) {
            return (ProfitCenterOrgUnitInfo)context.get("profitCenter");
        }
        String profitCenterId = null;
        ProfitCenterOrgUnitInfo profitCenter = SysContext.getSysContext().getCurrentProfitUnit();
        if (profitCenter != null && profitCenter.isIsBizUnit() && !profitCenter.isIsSealUp()) {
            sql = new StringBuffer();
            sql.append("select pc.FID \n");
            sql.append("from T_BD_SystemStatusCtrol sc \n");
            sql.append("join T_BD_SystemStatus s \n");
            sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 1006 \n");
            sql.append("join T_ORG_ProfitCenter pc on pc.FID = sc.FProfitCenterID \n");
            sql.append("where sc.FIsStart = 1 and pc.FIsBizUnit = 1 and pc.FIsSealup = 0 \n");
            sql.append("    and sc.FStartPeriodID is not null \n");
            sql.append("    and sc.FCurrentPeriodID is not null \n");
            sql.append("    and pc.FID = '" + profitCenter.getId().toString() + "' \n");
            try {
                rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                if (rs.next()) {
                    profitCenterId = profitCenter.getId().toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (profitCenterId == null) {
            sql = new StringBuffer();
            sql.append("select top 1 pc.FID \n");
            sql.append("from T_BD_SystemStatusCtrol sc \n");
            sql.append("join T_BD_SystemStatus s \n");
            sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 1006 \n");
            sql.append("join T_ORG_ProfitCenter pc on pc.FID = sc.FProfitCenterID \n");
            sql.append("where sc.FIsStart = 1 and pc.FIsBizUnit = 1 and pc.FIsSealup = 0 \n");
            sql.append("    and sc.FStartPeriodID is not null \n");
            sql.append("    and sc.FCurrentPeriodID is not null \n");
            try {
                rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                if (rs.next()) {
                    profitCenterId = rs.getString("FID");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (profitCenterId != null) {
            try {
                return ProfitCenterOrgUnitFactory.getRemoteInstance().getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private CompanyOrgUnitInfo queryCompany(ProfitCenterOrgUnitInfo profitCenter) throws EASBizException, BOSException {
        String companyId = null;
        if (this.relations.containsKey(profitCenter.getId().toString())) {
            companyId = this.relations.get(profitCenter.getId().toString());
        } else {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)profitCenter.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)6));
            filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("toUnit.id");
            view.setSelector(selector);
            OrgUnitRelationCollection coll = OrgUnitRelationFactory.getRemoteInstance().getOrgUnitRelationCollection(view);
            if (coll.size() > 0) {
                companyId = coll.get(0).getToUnit().getId().toString();
            }
            this.relations.put(profitCenter.getId().toString(), companyId);
        }
        if (companyId == null) {
            return null;
        }
        if (this.companys.containsKey(companyId)) {
            return this.companys.get(companyId);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("accountPeriodType.id");
        selector.add("accountTable.id");
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
        this.companys.put(companyId, company);
        return company;
    }
}

