/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.pca.PcaBalanceAnaFacadeFactory;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.client.AbstractPcaBalanceRepairUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.apache.log4j.Logger;

public class PcaBalanceRepairUI
extends AbstractPcaBalanceRepairUI {
    private static final String RES = "com.kingdee.eas.fi.gl.BalanceRepairResource";
    private static final Logger logger = CoreUIObject.getLogger(PcaBalanceRepairUI.class);
    private int maxFuture = 13;
    private SimpleAttributeSet attributeSet = new SimpleAttributeSet();
    Map<String, String> relations = new HashMap<String, String>();
    Map<String, CompanyOrgUnitInfo> companys = new HashMap<String, CompanyOrgUnitInfo>();
    DataChangeListener orgListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                PcaBalanceRepairUI.this.initPeriod(false);
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                PcaBalanceRepairUI.this.handUIException(ex);
            }
            try {
                PcaBalanceRepairUI.this.initTable(false);
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                PcaBalanceRepairUI.this.handUIException(ex);
            }
        }
    };
    ItemListener tableListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                PcaBalanceRepairUI.this.initAccount(false);
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                PcaBalanceRepairUI.this.handUIException(ex);
            }
        }
    };

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        block5: {
            try {
                String value;
                IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)"select FValue from T_GL_AnaConfig where FKey = 'AnaBal_MaxFuture' ").executeSQL();
                if (!rs.next() || (value = rs.getString("FValue")) == null) break block5;
                try {
                    this.maxFuture = Integer.parseInt(value);
                    if (this.maxFuture <= 0) {
                        this.maxFuture = 13;
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.onLoad();
        this.initMyIcon();
        this.initOrg();
    }

    private void initMyIcon() throws Exception {
        this.periodFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.periodFrom.setEditable(true);
        this.periodFrom.setEditFormat("$number$");
        this.periodFrom.setCommitFormat("$number$");
        this.periodTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.periodTo.setEditable(true);
        this.periodTo.setEditFormat("$number$");
        this.periodTo.setCommitFormat("$number$");
        this.cbAccount.setSelected(true);
        this.cbAssist.setSelected(true);
        this.btnOk.setEnabled(true);
        this.cbAccount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PcaBalanceRepairUI.this.cbAccount.isSelected() && !PcaBalanceRepairUI.this.cbAssist.isSelected()) {
                    PcaBalanceRepairUI.this.cbAssist.setSelected(true);
                }
            }
        });
        this.cbAssist.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!PcaBalanceRepairUI.this.cbAccount.isSelected() && !PcaBalanceRepairUI.this.cbAssist.isSelected()) {
                    PcaBalanceRepairUI.this.cbAccount.setSelected(true);
                }
            }
        });
    }

    private void initOrg() throws Exception {
        this.promptProfitCenter.setQueryInfo("com.kingdee.eas.basedata.org.app.ProfitCenterOrgUnitQuery");
        this.promptProfitCenter.setEditable(true);
        this.promptProfitCenter.setEditFormat("$number$");
        this.promptProfitCenter.setCommitFormat("$name$;$number$");
        this.promptProfitCenter.setDisplayFormat("$number$-$name$");
        this.promptProfitCenter.setEnabledMultiSelection(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("isSealup", (Object)new Integer(0)));
        StringBuffer sql = new StringBuffer();
        sql.append("select pc.FID \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_BD_SystemStatus s \n");
        sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 1006 \n");
        sql.append("join T_ORG_ProfitCenter pc on pc.FID = sc.FProfitCenterID \n");
        sql.append("where sc.FIsStart = 1 and pc.FIsBizUnit = 1 and pc.FIsSealup = 0 \n");
        sql.append("    and sc.FStartPeriodID is not null \n");
        sql.append("    and sc.FCurrentPeriodID is not null \n");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        view.setFilter(filter);
        this.promptProfitCenter.setEntityViewInfo(view);
        ProfitCenterOrgUnitInfo profitCenter = this.getFirstOrg();
        this.promptProfitCenter.setValue((Object)profitCenter);
        this.promptProfitCenter.addDataChangeListener(this.orgListener);
        this.initPeriod(true);
        this.initTable(true);
    }

    private ProfitCenterOrgUnitInfo getFirstOrg() {
        IRowSet rs;
        StringBuffer sql;
        Map context = this.getUIContext();
        if (context.get("profitCenter") != null) {
            return (ProfitCenterOrgUnitInfo)context.get("profitCenter");
        }
        String profitCenterId = null;
        ProfitCenterOrgUnitInfo profitCenter = SysContext.getSysContext().getCurrentProfitUnit();
        if (profitCenter != null && profitCenter.isIsBizUnit() && !profitCenter.isIsSealUp()) {
            sql = new StringBuffer();
            sql.append("select pc.FID \n");
            sql.append("from T_BD_SystemStatusCtrol sc \n");
            sql.append("join T_BD_SystemStatus s \n");
            sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 1006 \n");
            sql.append("join T_ORG_ProfitCenter pc on pc.FID = sc.FProfitCenterID \n");
            sql.append("where sc.FIsStart = 1 and pc.FIsBizUnit = 1 and pc.FIsSealup = 0 \n");
            sql.append("    and sc.FStartPeriodID is not null \n");
            sql.append("    and sc.FCurrentPeriodID is not null \n");
            sql.append("    and pc.FID = '" + profitCenter.getId().toString() + "' \n");
            try {
                rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                if (rs.next()) {
                    profitCenterId = profitCenter.getId().toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (profitCenterId == null) {
            sql = new StringBuffer();
            sql.append("select top 1 pc.FID \n");
            sql.append("from T_BD_SystemStatusCtrol sc \n");
            sql.append("join T_BD_SystemStatus s \n");
            sql.append("    on s.FID = sc.FSystemStatusID and s.FName = 1006 \n");
            sql.append("join T_ORG_ProfitCenter pc on pc.FID = sc.FProfitCenterID \n");
            sql.append("where sc.FIsStart = 1 and pc.FIsBizUnit = 1 and pc.FIsSealup = 0 \n");
            sql.append("    and sc.FStartPeriodID is not null \n");
            sql.append("    and sc.FCurrentPeriodID is not null \n");
            try {
                rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                if (rs.next()) {
                    profitCenterId = rs.getString("FID");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (profitCenterId != null) {
            try {
                return ProfitCenterOrgUnitFactory.getRemoteInstance().getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void initTable(boolean first) throws Exception {
        this.cbTable.removeItemListener(this.tableListener);
        this.cbTable.setEnabled(false);
        this.prmptAccount.setEnabled(false);
        this.cbTable.removeAllItems();
        this.prmptAccount.setValue(null);
        Object object = this.promptProfitCenter.getValue();
        if (object instanceof ProfitCenterOrgUnitInfo) {
            Map context;
            ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)object;
            CompanyOrgUnitInfo company = this.queryCompany(profitCenter);
            if (company == null) {
                return;
            }
            this.cbTable.addItems(this.getAccountTables(company).toArray());
            AccountTableInfo table = company.getAccountTable();
            if (first && (context = this.getUIContext()).get("table") != null) {
                table = (AccountTableInfo)context.get("table");
            }
            GlUtils.setSelectedItem((KDComboBox)this.cbTable, (CoreBaseInfo)table);
            this.cbTable.setEnabled(true);
            this.prmptAccount.setEnabled(true);
            this.cbTable.addItemListener(this.tableListener);
            this.initAccount(first);
        }
    }

    private AccountTableCollection getAccountTables(CompanyOrgUnitInfo company) throws BOSException {
        try {
            HashSet<String> ids = new HashSet<String>();
            ids.add(company.getAccountTable().getId().toString());
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("refType", (Object)1));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("disabledAcctTable.id"));
            sic.add(new SelectorItemInfo("enabledAcctTable.id"));
            view.setSelector(sic);
            AccountRefContrastCollection col = AccountRefContrastFactory.getRemoteInstance().getAccountRefContrastCollection(view);
            if (col.size() > 0) {
                for (int i = 0; i < col.size(); ++i) {
                    AccountRefContrastInfo info = col.get(i);
                    if (info.getDisabledAcctTable() != null && info.getDisabledAcctTable().getId() != null) {
                        ids.add(info.getDisabledAcctTable().getId().toString());
                    }
                    if (info.getEnabledAcctTable() == null || info.getEnabledAcctTable().getId() == null) continue;
                    ids.add(info.getEnabledAcctTable().getId().toString());
                }
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("*"));
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            evi.setFilter(filter2);
            return AccountTableFactory.getRemoteInstance().getAccountTableCollection(evi);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return new AccountTableCollection();
        }
    }

    protected void initAccount(boolean first) throws Exception {
        this.prmptAccount.setEnabled(false);
        this.prmptAccount.setValue(null);
        Object object = this.promptProfitCenter.getValue();
        if (object instanceof ProfitCenterOrgUnitInfo) {
            ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)object;
            CompanyOrgUnitInfo company = this.queryCompany(profitCenter);
            if (company == null) {
                return;
            }
            AccountTableInfo table = (AccountTableInfo)this.cbTable.getSelectedItem();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
            if (table != null) {
                fic.add(new FilterItemInfo("accountTableID.id", (Object)table.getId().toString()));
            } else {
                fic.add(new FilterItemInfo("accountTableID.id", (Object)"emptyid"));
            }
            filter.setMaskString("#0 and #1");
            AccountPromptBox apb = new AccountPromptBox((IUIObject)this, company, table, filter, false, false);
            this.prmptAccount.setValue(null);
            this.prmptAccount.setEditable(false);
            this.prmptAccount.setEditFormat("$number$");
            this.prmptAccount.setCommitFormat("$helpCode$;$name$;$number$");
            this.prmptAccount.setDisplayFormat("$number$ - $name$");
            this.prmptAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
            this.prmptAccount.setEnabledMultiSelection(true);
            this.prmptAccount.setSelector((KDPromptSelector)apb);
            this.prmptAccount.setEnabled(true);
            if (first) {
                Map context = this.getUIContext();
                if (context.get("accounts") != null) {
                    this.prmptAccount.setValue(context.get("accounts"));
                }
                if (context.get("strAccounts") != null) {
                    this.txtAccount.setText((String)context.get("strAccounts"));
                }
            }
        }
    }

    private void initPeriod(boolean first) throws Exception {
        this.periodFrom.setEnabled(false);
        this.periodTo.setEnabled(false);
        Object object = this.promptProfitCenter.getValue();
        if (object instanceof ProfitCenterOrgUnitInfo) {
            ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)object;
            CompanyOrgUnitInfo company = this.queryCompany(profitCenter);
            if (company == null) {
                this.periodFrom.setValue(null);
                this.periodTo.setValue(null);
                return;
            }
            PeriodInfo startPeriod = SystemStatusCtrolFactory.getRemoteInstance().getProfitStartPeriod(1006, profitCenter.getId().toString());
            PeriodInfo curPeriod = SystemStatusCtrolFactory.getRemoteInstance().getProfitCurrentPeriod(1006, profitCenter.getId().toString());
            EntityViewInfo tView = new EntityViewInfo();
            FilterInfo tFilter = new FilterInfo();
            tView.setFilter(tFilter);
            tFilter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)company.getAccountPeriodType().getId().toString()));
            tFilter.getFilterItems().add(new FilterItemInfo("number", (Object)curPeriod.getNumber(), CompareType.GREATER));
            SelectorItemCollection tSelector = new SelectorItemCollection();
            tSelector.add("number");
            tView.setSelector(tSelector);
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo si = new SorterItemInfo("number");
            si.setSortType(SortType.ASCEND);
            sorter.add(si);
            tView.setSorter(sorter);
            PeriodCollection coll = PeriodFactory.getRemoteInstance().getPeriodCollection(tView);
            int maxPeriod = curPeriod.getNumber();
            if (coll.size() >= this.maxFuture) {
                maxPeriod = coll.get(this.maxFuture - 1).getNumber();
            } else if (coll.size() > 0) {
                maxPeriod = coll.get(coll.size() - 1).getNumber();
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)company.getAccountPeriodType().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)startPeriod.getNumber(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)maxPeriod, CompareType.LESS_EQUALS));
            this.periodFrom.setEntityViewInfo(view);
            this.periodTo.setEntityViewInfo(view);
            this.periodFrom.setValue((Object)curPeriod);
            this.periodTo.setValue((Object)curPeriod);
            if (first) {
                Map context = this.getUIContext();
                if (context.get("periodfrom") != null) {
                    this.periodFrom.setValue(context.get("periodfrom"));
                }
                if (context.get("periodto") != null) {
                    this.periodTo.setValue(context.get("periodto"));
                }
            }
            this.periodFrom.setEnabled(true);
            this.periodTo.setEnabled(true);
        } else {
            this.periodFrom.setValue(null);
            this.periodTo.setValue(null);
        }
    }

    private CompanyOrgUnitInfo queryCompany(ProfitCenterOrgUnitInfo profitCenter) throws EASBizException, BOSException {
        String companyId = null;
        if (this.relations.containsKey(profitCenter.getId().toString())) {
            companyId = this.relations.get(profitCenter.getId().toString());
        } else {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)profitCenter.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)6));
            filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("toUnit.id");
            view.setSelector(selector);
            OrgUnitRelationCollection coll = OrgUnitRelationFactory.getRemoteInstance().getOrgUnitRelationCollection(view);
            if (coll.size() > 0) {
                companyId = coll.get(0).getToUnit().getId().toString();
            }
            this.relations.put(profitCenter.getId().toString(), companyId);
        }
        if (companyId == null) {
            return null;
        }
        if (this.companys.containsKey(companyId)) {
            return this.companys.get(companyId);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("accountPeriodType.id");
        selector.add("accountTable.id");
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), selector);
        this.companys.put(companyId, company);
        return company;
    }

    @Override
    public void actionComfirm_actionPerformed(ActionEvent e) throws Exception {
        Object object = this.promptProfitCenter.getValue();
        if (!(object instanceof ProfitCenterOrgUnitInfo)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SelectOrg"));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        ProfitCenterOrgUnitInfo profitCenter = (ProfitCenterOrgUnitInfo)object;
        params.put("profitCenterId", profitCenter.getId().toString());
        CompanyOrgUnitInfo company = this.queryCompany(profitCenter);
        if (company == null) {
            this.showMessage(EASResource.getString((String)RES, (String)"NoSetMainCompany"));
            return;
        }
        params.put("companyId", company.getId().toString());
        PeriodInfo periodfrom = null;
        PeriodInfo periodto = null;
        Object ofrom = this.periodFrom.getValue();
        Object oto = this.periodTo.getValue();
        if (ofrom instanceof PeriodInfo) {
            periodfrom = (PeriodInfo)ofrom;
        } else {
            this.periodFrom.setValue(null);
        }
        if (oto instanceof PeriodInfo) {
            periodto = (PeriodInfo)oto;
        } else {
            this.periodTo.setValue(null);
        }
        if (periodfrom == null || periodto == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"selectPeriod"));
            return;
        }
        if (periodfrom.getPeriodYear() > periodto.getPeriodYear() || periodfrom.getPeriodYear() == periodto.getPeriodYear() && periodfrom.getPeriodNumber() > periodto.getPeriodNumber()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"StartPeriodMoreThanEndPeriod"));
            return;
        }
        params.put("periodfrom", periodfrom);
        params.put("periodto", periodto);
        HashSet<String> accountNumbers = new HashSet<String>();
        Object objAccount = this.prmptAccount.getValue();
        if (objAccount instanceof AccountViewInfo) {
            accountNumbers.add(((AccountViewInfo)objAccount).getNumber());
        } else if (objAccount instanceof Object[]) {
            Object[] objAccounts;
            for (Object obj : objAccounts = (Object[])objAccount) {
                if (!(obj instanceof AccountViewInfo)) continue;
                accountNumbers.add(((AccountViewInfo)obj).getNumber());
            }
        }
        String strAccount = this.txtAccount.getText();
        if (strAccount != null) {
            String[] strAccounts;
            strAccount = strAccount.trim();
            for (String str : strAccounts = strAccount.split(";")) {
                if ((str = str.trim()).length() <= 0) continue;
                accountNumbers.add(str);
            }
        }
        params.put("accountNumbers", accountNumbers);
        int r = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"RepairWarn"));
        if (r != 0) {
            return;
        }
        params.put("repairAccount", this.cbAccount.isSelected());
        params.put("repairAssist", this.cbAssist.isSelected());
        params.put("repairMeasure", this.cbAssist.isSelected());
        params.put("onlyClean", this.cbClean.isSelected());
        String message = this.repair(profitCenter, params);
        this.showMessage(message);
    }

    private String repair(ProfitCenterOrgUnitInfo profitCenter, Map param) throws Exception {
        PcaUtils.updateBalance(new String[]{profitCenter.getId().toString()});
        Map result = PcaBalanceAnaFacadeFactory.getRemoteInstance().repair(param);
        return (String)result.get("message");
    }

    private void showMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Document doc = PcaBalanceRepairUI.this.taLog.getDocument();
                try {
                    doc.insertString(doc.getLength(), message + "\n", PcaBalanceRepairUI.this.attributeSet);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                PcaBalanceRepairUI.this.taLog.setSelectionStart(doc.getLength());
            }
        });
    }
}

