/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaPeriodEndException;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.SynVoucherUtil;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.ma.pca.cache.PcVoucherProcessCache;
import com.kingdee.eas.ma.pca.validator.AbstractPcVoucherBaseValidator;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PcVoucherBasePostValidator
extends AbstractPcVoucherBaseValidator {
    protected static final Logger logger = Logger.getLogger(PcVoucherBasePostValidator.class);
    protected GlParam sysParam;

    public PcVoucherBasePostValidator(GlParam sysParam) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
    }

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        this.checkCloseInit(ctx, voucherInfo, this.sysParam);
        SynVoucherUtil.checkPcVoucherCannotOperateInPca(ctx, (PcVoucherInfo)baseVoucherInfo, VoucherOperateStatusEnum.POST);
        this.checkVoucherPeriod(ctx, voucherInfo);
    }

    private void checkCloseInit(Context ctx, PcVoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        ProfitCenterOrgUnitInfo curPro = voucherInfo.getProfitCenter();
        boolean isClosed = false;
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getGLCloseInitStateMap().containsKey(curPro.getId().toString())) {
            isClosed = (Boolean)cache.getGLCloseInitStateMap().get(curPro.getId().toString());
        } else {
            isClosed = PcVoucherUtil.closeInit((Context)ctx, (String)curPro.getId().toString(), (String)voucherInfo.getCompany().getId().toString(), (String)voucherInfo.getCompany().getAccountTable().getId().toString());
            if (cache != null) {
                cache.getGLCloseInitStateMap().put(curPro.getId().toString(), isClosed);
            }
        }
        if (!isClosed) {
            this.checkAccountInited(ctx, voucherInfo);
            this.checkAssitInited(ctx, voucherInfo);
        }
    }

    private void checkAccountInited(Context ctx, PcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        ProfitCenterOrgUnitInfo curCompany = voucherInfo.getProfitCenter();
        boolean isAccountClosed = false;
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        isAccountClosed = cache != null && cache.getAccountInitStateMap().containsKey(curCompany.getId().toString()) ? (Boolean)cache.getAccountInitStateMap().get(curCompany.getId().toString()) : PcVoucherUtil.isAccountInited((Context)ctx, (String)curCompany.getId().toString());
        if (!isAccountClosed) {
            throw new PcaPeriodEndException(PcaPeriodEndException.PCA_INIT_NOT_CLOSED);
        }
    }

    private void checkAssitInited(Context ctx, PcVoucherInfo voucherInfo) throws EASBizException, BOSException {
        String curCompanyID = voucherInfo.getProfitCenter().getId().toString();
        Map checkMap = null;
        PcVoucherProcessCache cache = PcVoucherProcessCache.getCache(ctx);
        checkMap = cache != null ? cache.getAssistInitStateMap() : PcVoucherUtil.checkAssitInited((Context)ctx, (String)("'" + voucherInfo.getId().toString() + "'"), (String)curCompanyID);
        if (checkMap != null && checkMap.containsKey(voucherInfo.getId().toString())) {
            String errMsg = ((StringBuffer)checkMap.get(voucherInfo.getId().toString())).toString();
            throw new PcaPeriodEndException(PcaPeriodEndException.ASST_INIT_NOT_CLOSED, new String[]{errMsg});
        }
    }

    @Override
    protected void checkVoucherPeriod(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getPeriod() == null) {
            throw new VoucherException(VoucherException.PERIOD_CANNOT_NULL);
        }
        PeriodInfo currPeriod = PcaUtils.getCurrentPeriod(ctx, voucherInfo.getProfitCenter().getId().toString());
        if (voucherInfo.getPeriod().isIsAdjustPeriod() && voucherInfo.getPeriod().getPeriodYear() == currPeriod.getPeriodYear() - 1) {
            return;
        }
        if (voucherInfo.getPeriod().getPeriodYear() != currPeriod.getPeriodYear() || voucherInfo.getPeriod().getPeriodNumber() != currPeriod.getPeriodNumber()) {
            throw new VoucherException(VoucherException.NO_MSG, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"VCH_NOT_IN_CURRENT_PERIOD", (Locale)ctx.getLocale())});
        }
    }

    private void checkVoucherCheck(Context ctx, PcVoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        boolean useWorkflow = false;
        boolean isCheckBeforPost = sysParam.getBoolean("PCA_046");
        if (!useWorkflow && isCheckBeforPost && !voucherInfo.isIsCheck() && voucherInfo.existsCashOrBankAccount()) {
            String errMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"VOUCHERNOTCHECK", (Locale)ctx.getLocale());
            throw new VoucherException(VoucherException.NO_MSG, (Object[])new String[]{errMsg});
        }
    }
}

