/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlItemType;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlLevelInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.ma.pca.PcVoucherCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.SynVoucherUtil;
import com.kingdee.eas.ma.pca.app.PcVoucherUtil;
import com.kingdee.eas.ma.pca.validator.AbstractPcVoucherBaseValidator;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class PcVoucherBaseSubmitValidator
extends AbstractPcVoucherBaseValidator {
    protected static final Logger logger = Logger.getLogger(PcVoucherBaseSubmitValidator.class);
    protected Context ctx;
    protected GlParam sysParam;
    protected PcVoucherInfo voucherInfo;

    public PcVoucherBaseSubmitValidator(GlParam sysParam) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
    }

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        this.ctx = ctx;
        this.voucherInfo = voucherInfo;
        this.checkMutex(ctx, voucherInfo);
        boolean isFzz = this.sysParam.getBoolean("GL_008");
        if (isFzz && voucherInfo.getCurrency() == null) {
            throw new VoucherException(VoucherException.VOUCHER_CURRENCY_NULL);
        }
        if (voucherInfo.getCompany() == null) {
            throw new VoucherException(VoucherException.COMPANY_CANNOT_NULL);
        }
        if (voucherInfo.getSourceSys() == null) {
            throw new VoucherException(VoucherException.SOUCESYS_NULL);
        }
        if (voucherInfo.getSourceType() == null) {
            throw new VoucherException(VoucherException.SOUCETYPE_NULL);
        }
        if (voucherInfo.getReportingCreditAmount().compareTo(PcaUtils.maxBigDecimal) > 0) {
            throw new GLException(GLException.RPT_AMT_REACH_LIMITED);
        }
        if (voucherInfo.getReportingDebitAmount().compareTo(PcaUtils.maxBigDecimal) > 0) {
            throw new GLException(GLException.RPT_AMT_REACH_LIMITED);
        }
        if (voucherInfo.isIsCheck()) {
            throw new VoucherException(VoucherException.VOUCHERCHECKED);
        }
        SynVoucherUtil.checkPcVoucherCannotOperateInPca(ctx, voucherInfo, VoucherOperateStatusEnum.SUBMIT);
        this.checkVoucherDate(ctx, voucherInfo);
        if (voucherInfo.isIncludeBNAccount() && voucherInfo.isIncludeBWAccount()) {
            throw new VoucherException(VoucherException.CANNOT_EXIST_BNANDBW);
        }
        boolean GL_112 = this.sysParam.getBoolean("GL_112");
        if (GL_112 && !voucherInfo.isIncludeBWAccount() && voucherInfo.getEntries().size() < 2) {
            throw new VoucherException(VoucherException.ATLEAST_TOW_LINES);
        }
        if (voucherInfo.getEntries().size() == 0) {
            throw new VoucherException(VoucherException.ATLEAST_ONE_LINES);
        }
        this.checkVoucherType(ctx, voucherInfo);
        this.checkLimitMultDebitCredit(ctx, voucherInfo);
        this.checkVoucherTypeCtrlItem(ctx, voucherInfo);
        this.checkVoucherHeadAmount(ctx, voucherInfo);
        this.checkVoucherPeriod(ctx, voucherInfo);
        this.checkVerifiedStatus(ctx, voucherInfo, VoucherOperateStatusEnum.SUBMIT);
        voucherInfo.setAccountUserProperty(this.getAccountUserProperty());
    }

    protected void checkMutex(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (PcaUtils.isExisted(ctx, voucherInfo)) {
            this.checkMutex(ctx, (IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()));
        }
    }

    private void checkVoucherTypeCtrlItem(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        Object[] para;
        PcVoucherUtil.fillVoucherTypeCtrlItem((Context)ctx, (PcVoucherInfo)voucherInfo);
        boolean vaildDebit = false;
        StringBuffer sbDebit = new StringBuffer();
        boolean vaildCredit = false;
        StringBuffer sbCredit = new StringBuffer();
        boolean vaildDC = false;
        StringBuffer sbDC = new StringBuffer();
        PcVoucherEntryCollection voucherEntryCollection = voucherInfo.getEntries();
        VoucherTypeCtrlItemCollection voucherTypeCtrlItemCollection = voucherInfo.getVoucherType().getItems();
        Iterator iteratorVoucher = voucherTypeCtrlItemCollection.iterator();
        Iterator iteratorEntry = null;
        block8: while (iteratorVoucher.hasNext()) {
            VoucherTypeCtrlItemInfo voucherTypeCtrlItemInfo = (VoucherTypeCtrlItemInfo)iteratorVoucher.next();
            if (voucherTypeCtrlItemInfo == null) continue;
            VoucherTypeCtrlItemType voucherTypeCtrlItemType = voucherTypeCtrlItemInfo.getType();
            AccountViewInfo accountViewInfo = voucherTypeCtrlItemInfo.getAccount();
            if (accountViewInfo == null) continue;
            switch (voucherTypeCtrlItemType.getValue()) {
                case 0: {
                    if (vaildDebit) continue block8;
                    sbDebit.append(accountViewInfo.getNumber());
                    sbDebit.append(";");
                    for (PcVoucherEntryInfo voucherEntryInfo : voucherEntryCollection) {
                        this.checkEntryAccount(voucherEntryInfo);
                        if (!voucherEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) || !voucherEntryInfo.getAccount().getLongNumber().startsWith(accountViewInfo.getLongNumber())) continue;
                        vaildDebit = true;
                        continue block8;
                    }
                    continue block8;
                }
                case 1: {
                    if (vaildCredit) continue block8;
                    sbCredit.append(accountViewInfo.getNumber());
                    sbCredit.append(";");
                    for (PcVoucherEntryInfo voucherEntryInfo : voucherEntryCollection) {
                        this.checkEntryAccount(voucherEntryInfo);
                        if (!voucherEntryInfo.getEntryDC().equals((Object)EntryDC.CREDIT) || !voucherEntryInfo.getAccount().getLongNumber().startsWith(accountViewInfo.getLongNumber())) continue;
                        vaildCredit = true;
                        continue block8;
                    }
                    continue block8;
                }
                case 2: {
                    for (PcVoucherEntryInfo voucherEntryInfo : voucherEntryCollection) {
                        this.checkEntryAccount(voucherEntryInfo);
                        if (!voucherEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) || !voucherEntryInfo.getAccount().getLongNumber().startsWith(accountViewInfo.getLongNumber())) continue;
                        Object[] para2 = new String[]{VoucherTypeCtrlItemType.DEBIT_MUST_NOT.toString(), accountViewInfo.getNumber()};
                        throw new VoucherException(VoucherException.VTYPE_NOT_VAILD, para2);
                    }
                    continue block8;
                }
                case 3: {
                    for (PcVoucherEntryInfo voucherEntryInfo : voucherEntryCollection) {
                        this.checkEntryAccount(voucherEntryInfo);
                        if (!voucherEntryInfo.getEntryDC().equals((Object)EntryDC.CREDIT) || !voucherEntryInfo.getAccount().getLongNumber().startsWith(accountViewInfo.getLongNumber())) continue;
                        Object[] para3 = new String[]{VoucherTypeCtrlItemType.CREDIT_MUST_NOT.toString(), accountViewInfo.getNumber()};
                        throw new VoucherException(VoucherException.VTYPE_NOT_VAILD, para3);
                    }
                    continue block8;
                }
                case 4: {
                    if (vaildDC) continue block8;
                    sbDC.append(accountViewInfo.getNumber());
                    sbDC.append(";");
                    for (PcVoucherEntryInfo voucherEntryInfo : voucherEntryCollection) {
                        this.checkEntryAccount(voucherEntryInfo);
                        if (!voucherEntryInfo.getAccount().getLongNumber().startsWith(accountViewInfo.getLongNumber())) continue;
                        vaildDC = true;
                        continue block8;
                    }
                    continue block8;
                }
                case 5: {
                    for (PcVoucherEntryInfo voucherEntryInfo : voucherEntryCollection) {
                        this.checkEntryAccount(voucherEntryInfo);
                        if (!voucherEntryInfo.getAccount().getLongNumber().startsWith(accountViewInfo.getLongNumber())) continue;
                        Object[] para4 = new String[]{VoucherTypeCtrlItemType.DEBIT_AND_CREDIT_MUST_NOT.toString(), accountViewInfo.getNumber()};
                        throw new VoucherException(VoucherException.VTYPE_NOT_VAILD, para4);
                    }
                    continue block8;
                }
            }
        }
        if (sbDebit.length() != 0 && !vaildDebit) {
            para = new String[]{VoucherTypeCtrlItemType.DEBIT_MUST.toString(), sbDebit.toString().substring(0, sbDebit.length() - 1)};
            throw new VoucherException(VoucherException.VTYPE_NOT_VAILD, para);
        }
        if (sbCredit.length() != 0 && !vaildCredit) {
            para = new String[]{VoucherTypeCtrlItemType.CREDIT_MUST.toString(), sbCredit.toString().substring(0, sbCredit.length() - 1)};
            throw new VoucherException(VoucherException.VTYPE_NOT_VAILD, para);
        }
        if (sbDC.length() != 0 && !vaildDC) {
            para = new String[]{VoucherTypeCtrlItemType.DEBIT_OR_CREDIT_MUST.toString(), sbDC.toString().substring(0, sbDC.length() - 1)};
            throw new VoucherException(VoucherException.VTYPE_NOT_VAILD, para);
        }
    }

    private void checkEntryAccount(PcVoucherEntryInfo entryInfo) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = entryInfo.getAccount();
        if (accountViewInfo == null) {
            throw new VoucherException(VoucherException.ACCOUNT_CANNOT_NULL, new Object[]{entryInfo.getSeq()});
        }
    }

    private void checkVoucherDate(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getBookedDate() == null) {
            throw new VoucherException(VoucherException.BOOKEDDATE_NULL);
        }
        if (voucherInfo.getBizDate() == null) {
            throw new VoucherException(VoucherException.BIZDATE_NULL);
        }
        if (voucherInfo.isCheckDate() && voucherInfo.getBizDate().after(voucherInfo.getBookedDate())) {
            throw new VoucherException(VoucherException.NOTALLOWEDBIZAFTBOOK);
        }
    }

    private void checkVerifiedStatus(Context ctx, PcVoucherInfo vocuherInfo, VoucherOperateStatusEnum status) throws BOSException, EASBizException {
        boolean hasVerified;
        boolean isInTimeVerify;
        boolean bl = isInTimeVerify = this.sysParam.getInt("GL_052") == 0;
        if (!isInTimeVerify && this.voucherInfo.getId() != null && !this.voucherInfo.isFromSaveSubmit() && this.voucherInfo.getId() != null && (hasVerified = AcctCussentHistoryFacadeFactory.getLocalInstance((Context)ctx).hasVerify(this.voucherInfo.getId().toString()))) {
            throw new VoucherException(VoucherException.CANNOT_OPER_AFTER_VERIFIED, new Object[]{status.toString()});
        }
    }

    private void checkVoucherHeadAmount(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        boolean checkProfitCenterBalane = this.sysParam.getBoolean("GL_112");
        if (!checkProfitCenterBalane) {
            return;
        }
        boolean isFzz = this.sysParam.getBoolean("GL_008");
        CurrencyInfo localCur = null;
        localCur = isFzz ? voucherInfo.getCurrency() : voucherInfo.getCompany().getBaseCurrency();
        boolean isValidatorOriginalCurrency = this.sysParam.getBoolean("GL_101");
        if (!isFzz && isValidatorOriginalCurrency) {
            this.checkOriginalAmount(ctx, voucherInfo);
        }
        if (voucherInfo.getLocalCreditAmount().compareTo(voucherInfo.getLocalDebitAmount()) != 0) {
            throw new VoucherException(VoucherException.LOCAL_DC_NOT_EQUAL, new Object[]{PcaUtils.formatNumber(voucherInfo.getLocalDebitAmount(), localCur.getPrecision()), PcaUtils.formatNumber(voucherInfo.getLocalCreditAmount(), localCur.getPrecision())});
        }
        boolean useReportingCurrency = false;
        if (!isFzz) {
            useReportingCurrency = this.sysParam.getBoolean("G001");
        }
        if (useReportingCurrency && voucherInfo.getReportingCreditAmount().compareTo(voucherInfo.getReportingDebitAmount()) != 0) {
            throw new VoucherException(VoucherException.REPORT_DC_NOT_EQUAL);
        }
    }

    private Map getAccountUserProperty() throws BOSException {
        PcVoucherCollection voucherColl = new PcVoucherCollection();
        voucherColl.add(this.voucherInfo);
        return PcVoucherUtil.getAccountUserProperty((Context)this.ctx, (PcVoucherCollection)voucherColl);
    }

    private void checkLimitMultDebitCredit(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherTypeCtrlLevelInfo levelInfo = PcVoucherUtil.getVoucherTypeCtrlLevelInfo((Context)ctx, (String)voucherInfo.getCompany().getId().toString(), (String)voucherInfo.getVoucherType().getId().toString());
        if (levelInfo != null && levelInfo.isLimitMultDebitCredit() && voucherInfo.getDebitEntryCount() > 1 && voucherInfo.getCreditEntryCount() > 1) {
            throw new VoucherException(VoucherException.LIMITVOUCHER);
        }
    }
}

