/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.budget.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNDataInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.view.BgRollFactory;
import com.kingdee.eas.ma.view.BgRollHelper;
import com.kingdee.eas.ma.view.BgRollInterface;
import com.kingdee.eas.ma.view.BgViewFacadeFactory;
import com.kingdee.eas.ma.view.client.common.BgReportRollViewProvider;
import com.kingdee.eas.ma.view.client.designer.IProvider;
import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.BgDimensionMember;
import com.kingdee.eas.ma.view.common.BgNViewDataInfo;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgRollHandler {
    private Set<String> orgIds = new HashSet<String>();
    private Map<String, BgRollInterface> rollMap = new HashMap<String, BgRollInterface>();
    private BgReportRollViewProvider provider = null;

    public BgRollHandler(BgReportRollViewProvider provider) {
        this.setProvider(provider);
    }

    public void loadData(IBgDimensionManager dimensionManager, Set orgUnitSet, BgFormInfo bgFormInfo, boolean isHistory) throws EASBizException, BOSException {
        String orgId;
        this.getOrgIds().clear();
        this.getRollMap().clear();
        boolean isOrgAtPage = false;
        List pageDisplayListDimension = dimensionManager.getPageDisplayDimension();
        for (int i = 0; i < pageDisplayListDimension.size(); ++i) {
            BgDimensionInfo bgDimensionInfo = (BgDimensionInfo)pageDisplayListDimension.get(i);
            if (!bgDimensionInfo.getType().equalsIgnoreCase("ORGUNIT")) continue;
            isOrgAtPage = true;
            break;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("state");
        sic.add("orgUnit.id");
        sic.add("currency.id");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.number");
        sic.add("bgRollPeriod.number");
        sic.add("entries.rollMethod");
        sic.add("entries.dimensionData");
        sic.add("entries.rollType");
        sic.add("entries.rollStep");
        sic.add("entries.rollLength");
        if (isOrgAtPage) {
            orgId = this.provider.getOrgUnitId();
            this.getOrgIds().add(orgId);
            if (isHistory) {
                this.getRollMap().put(orgId, BgRollFactory.getBgRollInstance(dimensionManager, bgFormInfo));
            } else {
                this.getRollMap().put(orgId, BgRollFactory.getBgRollInstance(dimensionManager, (BgFormInfo)BgFormFacadeFactory.getRemoteInstance().queryBgFormByOrgUnitId(bgFormInfo, (Object[])new String[]{orgId}, sic).get(orgId)));
            }
        } else if (isHistory) {
            orgId = this.provider.getOrgUnitId();
            HashSet newOrgUnitSet = new HashSet();
            newOrgUnitSet.addAll(orgUnitSet);
            newOrgUnitSet.remove(orgId);
            this.getOrgIds().add(orgId);
            this.getRollMap().put(orgId, BgRollFactory.getBgRollInstance(dimensionManager, bgFormInfo));
        } else {
            this.loadData(bgFormInfo, orgUnitSet.toArray(), false);
        }
    }

    private void loadData(BgFormInfo bgFormInfo, Object[] orgIds, boolean isHistory) throws EASBizException, BOSException {
        Map map = null;
        map = isHistory ? BgViewFacadeFactory.getRemoteInstance().batchQueryAllPeriodMemberForHistory(bgFormInfo.getId().toString(), orgIds) : BgViewFacadeFactory.getRemoteInstance().batchQueryAllPeriodMember(bgFormInfo, orgIds);
        Map periodNumMap = (Map)map.get("PeriodNumSet");
        Map bgFormInfoMap = (Map)map.get("BgFormInfo");
        for (Object o : periodNumMap.keySet()) {
            this.getOrgIds().add((String)o);
            this.getRollMap().put((String)o, BgRollFactory.getBgRollInstance((Set)periodNumMap.get(o), (BgFormInfo)bgFormInfoMap.get(o)));
        }
    }

    public Map pickAdjustFormula(Map _formulaMap) {
        HashMap resultMap = new HashMap();
        resultMap.put("AdjustBudget", new HashMap());
        for (String orgId : this.getOrgIds()) {
            this.getRollMap().get(orgId).pickAdjustFormula(_formulaMap, (Map)resultMap.get("AdjustBudget"));
        }
        return resultMap;
    }

    public void diffDisplayPeriod(Map<String, Set> lockActualPeriodNum, Map<String, Set> lockBudgetPeriodNum, Map<String, Set> adjustCoverPeriodNum) {
        for (String orgId : this.getOrgIds()) {
            this.getRollMap().get(orgId).diffDisplayPeriod(lockActualPeriodNum, lockBudgetPeriodNum, adjustCoverPeriodNum);
        }
    }

    public boolean isLockedForBudgetForm(BgNDataInfo bgData) {
        return bgData != null && bgData.getState() != 1;
    }

    public void fillData(Book book, IProvider provider, Map bgDataMap, Map adjustMap, Map newBgDataMap, Map newAdjustMap) {
        if (book == null) {
            return;
        }
        if (bgDataMap == null) {
            bgDataMap = new HashMap();
        }
        if (adjustMap == null) {
            adjustMap = new HashMap();
        }
        if (newBgDataMap == null) {
            newBgDataMap = new HashMap();
        }
        if (newAdjustMap == null) {
            newAdjustMap = new HashMap();
        }
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        book.getUndoManager().discardAllEdits();
        BgNViewDataInfo data = null;
        BgAdjustFormDiversityData adjustData = null;
        Map subMap = null;
        Range locked = null;
        Range unLocked = null;
        HashMap<String, Set> lockActualPeriodNum = new HashMap<String, Set>();
        HashMap<String, Set> lockBudgetPeriodNum = new HashMap<String, Set>();
        HashMap<String, Set> adjustCoverPeriodNum = new HashMap<String, Set>();
        this.diffDisplayPeriod(lockActualPeriodNum, lockBudgetPeriodNum, adjustCoverPeriodNum);
        int periodColStep = 0;
        int periodCount = 0;
        String bgPeriodNum = ((BgFormInfo)provider.getEditValue()).getBgPeriod().getNumber();
        List colDisplayDimension = this.getProvider().getBgDimensionManager().getColDisplayDimension();
        BgDimensionInfo dimensionInfo = null;
        for (int i = 0; i < colDisplayDimension.size(); ++i) {
            dimensionInfo = (BgDimensionInfo)colDisplayDimension.get(i);
            if ("BGPERIOD".equalsIgnoreCase(dimensionInfo.getType())) {
                periodColStep = 1;
                BgDimensionMember member = null;
                for (Object o : dimensionInfo.getMember()) {
                    member = (BgDimensionMember)o;
                    if (!member.getNumber().contains(bgPeriodNum)) continue;
                    ++periodCount;
                }
                continue;
            }
            periodColStep *= dimensionInfo.getMember().size();
        }
        BgRollInterface rollInstance = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            Sheet sheet = book.getSheet(s);
            int maxRow = sheet.getMaxRowIndex();
            int maxCol = sheet.getMaxColIndex();
            for (int r = 0; r <= maxRow; ++r) {
                for (int c = 0; c <= maxCol; ++c) {
                    Range range;
                    Cell cell = sheet.getCell(r, c, false);
                    ItemFormula formula = BgNFSHelper.getItemFormula((Cell)cell);
                    if (formula == null) continue;
                    BgNFSHelper.setBackGroup((Cell)cell, (Color)BgNConstants.BASE_COLOR);
                    String orgId = formula.getExt("ORGUNITID");
                    rollInstance = this.getRollMap().get(orgId);
                    if (rollInstance == null) continue;
                    if (rollInstance.getRollMethod() == 2 && 1 == BgNPeriodHelper.parserBgPeriodType((String)BgRollHelper.getPeriodNum(formula.getFormula()))) {
                        if (bgDataMap.containsKey(orgId)) {
                            subMap = (Map)bgDataMap.get(orgId);
                            data = (BgNViewDataInfo)((Object)subMap.get(formula.getFormula()));
                        }
                        if (data != null) {
                            cell.setValue(new Variant((Object)data.getBudgetValueNoDef()));
                        } else {
                            cell.setValue(Variant.emptyVariant);
                        }
                        range = sheet.getRange(cell);
                        if (unLocked == null) {
                            unLocked = range;
                        } else {
                            unLocked.addAll((SortedCellBlockArray)range);
                        }
                        if (periodCount <= 1) continue;
                        String expression = "=Sum(";
                        for (int i = 1; i <= periodCount - 1; ++i) {
                            expression = expression + SheetBaseMath.getColumnName((Sheet)sheet, (int)(c + i * periodColStep)) + "" + (r + 1) + ",";
                        }
                        expression = expression.substring(0, expression.length() - 1);
                        expression = expression + ")";
                        cell.setFormula(expression);
                        this.getProvider().setNeedReCalculate(true);
                        continue;
                    }
                    if (lockActualPeriodNum.get(orgId) != null && ((Set)lockActualPeriodNum.get(orgId)).contains(BgRollHelper.getPeriodNum(formula.getFormula()))) {
                        if (bgDataMap.containsKey(orgId)) {
                            subMap = (Map)bgDataMap.get(orgId);
                            data = (BgNViewDataInfo)((Object)subMap.get(formula.getFormula()));
                        }
                        cell.setUserObject("BgRollDataType", (Object)1);
                        if (data != null) {
                            cell.setValue(new Variant((Object)data.getBudgetValueNoDef()));
                            cell.setUserObject("BG_ROLL_BGACTUAL_VALUE", (Object)data.getBizActual());
                        } else {
                            cell.setValue(Variant.emptyVariant);
                            cell.setUserObject("BG_ROLL_BGACTUAL_VALUE", (Object)Variant.emptyVariant);
                        }
                        BgNFSHelper.setBackGroup((Cell)cell, (Color)BgNConstants.LOCK_COLOR);
                        BgNFSHelper.setItalicFont((Cell)cell);
                        range = sheet.getRange(cell);
                        if (locked == null) {
                            locked = range;
                            continue;
                        }
                        locked.addAll((SortedCellBlockArray)range);
                        continue;
                    }
                    if (adjustCoverPeriodNum.get(orgId) != null && ((Set)adjustCoverPeriodNum.get(orgId)).contains(BgRollHelper.getPeriodNum(formula.getFormula()))) {
                        BigDecimal oldValue = null;
                        BigDecimal newValue = null;
                        if (bgDataMap.containsKey(orgId) && (subMap = (Map)bgDataMap.get(orgId)).containsKey(formula.getFormula())) {
                            data = (BgNViewDataInfo)((Object)subMap.get(formula.getFormula()));
                        }
                        if (newBgDataMap.containsKey(orgId) && (subMap = (Map)newBgDataMap.get(orgId)).containsKey(formula.getFormula())) {
                            data = (BgNViewDataInfo)((Object)subMap.get(formula.getFormula()));
                        }
                        if (data != null) {
                            cell.setValue(new Variant((Object)data.getBudgetValueNoDef()));
                            oldValue = data.getBudgetValueNoDef();
                        } else {
                            cell.setValue(Variant.emptyVariant);
                            oldValue = null;
                        }
                        if (adjustMap.containsKey(orgId) && (subMap = (Map)adjustMap.get(orgId)) != null && subMap.get(formula.getFormula()) != null) {
                            adjustData = (BgAdjustFormDiversityData)subMap.get(formula.getFormula());
                        }
                        if (newAdjustMap.containsKey(orgId) && (subMap = (Map)newAdjustMap.get(orgId)) != null && subMap.get(formula.getFormula()) != null && (adjustData = (BgAdjustFormDiversityData)subMap.get(formula.getFormula())) != null) {
                            if (this.getProvider().getAdjustMap().get(orgId) == null) {
                                this.getProvider().getAdjustMap().put(orgId, new HashMap());
                            }
                            if (!((Map)this.getProvider().getAdjustMap().get(orgId)).containsKey(formula.getFormula())) {
                                ((Map)this.getProvider().getAdjustMap().get(orgId)).put(formula.getFormula(), adjustData);
                            }
                        }
                        if (adjustData != null) {
                            cell.setValue(new Variant((Object)adjustData.getNewValue()));
                            newValue = adjustData.getNewValue();
                            if (!BgViewHelper.compareDivValue(newValue, oldValue)) {
                                BgNFSHelper.setBackGroup((Cell)cell, (Color)BgNConstants.EDIT_COLOR);
                            }
                        }
                        boolean isLocked = false;
                        isLocked = rollInstance.isAdjustForm() ? false : this.isLockedForBudgetForm(data);
                        Range range2 = sheet.getRange(cell);
                        if (isLocked != cell.isLocked()) {
                            if (isLocked) {
                                if (locked == null) {
                                    locked = range2;
                                } else {
                                    locked.addAll((SortedCellBlockArray)range2);
                                }
                            } else if (unLocked == null) {
                                unLocked = range2;
                            } else {
                                unLocked.addAll((SortedCellBlockArray)range2);
                            }
                        }
                        adjustData = null;
                        data = null;
                        continue;
                    }
                    if (bgDataMap.containsKey(orgId)) {
                        subMap = (Map)bgDataMap.get(orgId);
                        data = (BgNViewDataInfo)((Object)subMap.get(formula.getFormula()));
                    }
                    if (data != null) {
                        cell.setValue(new Variant((Object)data.getBudgetValueNoDef()));
                    } else {
                        cell.setValue(Variant.emptyVariant);
                    }
                    BgNFSHelper.setBackGroup((Cell)cell, (Color)BgNConstants.LOCK_COLOR);
                    range = sheet.getRange(cell);
                    if (locked == null) {
                        locked = range;
                        continue;
                    }
                    locked.addAll((SortedCellBlockArray)range);
                }
            }
        }
        StyleAttributes sa = Styles.getEmptySA();
        if (locked != null) {
            sa.setLocked(true);
            locked.setStyle(sa, Styles.getEmptySA());
        }
        if (unLocked != null) {
            sa.setLocked(false);
            unLocked.setStyle(sa, Styles.getEmptySA());
        }
        BgNFSHelper.enableUndo((Book)book);
        if (this.getProvider().isNeedReCalculate()) {
            book.calc();
            Sheet _sheet = null;
            int size = book.getSheetCount();
            for (int index = 0; index < size; ++index) {
                _sheet = book.getSheet(index);
                if (_sheet == null) {
                    return;
                }
                Cell _cell = null;
                int rowCount = _sheet.getMaxRowIndex();
                int colCount = _sheet.getMaxColIndex();
                for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                    for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        this.getProvider().updateCellChangeValueInfo(_cell);
                    }
                }
            }
        }
    }

    public Set<String> getLegalPeriodSet(String orgId) {
        return this.getRollMap().get(orgId).getLegalPeriodSet();
    }

    public Map<String, Set> getLegalPeriodSet() {
        HashMap<String, Set> res = new HashMap<String, Set>();
        for (String orgId : this.getRollMap().keySet()) {
            res.put(orgId, this.getRollMap().get(orgId).getLegalPeriodSet());
        }
        return res;
    }

    public Set<String> getOrgIds() {
        return this.orgIds;
    }

    public Map<String, BgRollInterface> getRollMap() {
        return this.rollMap;
    }

    public BgReportRollViewProvider getProvider() {
        return this.provider;
    }

    public void setProvider(BgReportRollViewProvider provider) {
        this.provider = provider;
    }
}

