/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.view.BgViewFacadeFactory;
import com.kingdee.eas.ma.view.common.BgDimensionManagerImpl;
import com.kingdee.eas.ma.view.common.BudgetViewLoaderImpl;
import com.kingdee.eas.ma.view.common.IBudgetView;
import java.util.Map;
import java.util.Set;

public class BgRollHelper {
    public static String getPeriodTypeCode(BgPeriodEnum periodEnum) {
        String periodType = null;
        if (periodEnum.getValue() == 1) {
            periodType = "Y";
        } else if (periodEnum.getValue() == 2) {
            periodType = "HY";
        } else if (periodEnum.getValue() == 3) {
            periodType = "Q";
        } else if (periodEnum.getValue() == 4) {
            periodType = "M";
        } else if (periodEnum.getValue() == 9) {
            periodType = "TD";
        }
        return periodType;
    }

    public static Set<String> loadFormEntry(BgFormInfo bgFormInfo) throws EASBizException, BOSException {
        IBudgetView view = BudgetViewLoaderImpl.getIntance();
        BgDimensionManagerImpl dimensionManager = new BgDimensionManagerImpl();
        Object bgPeriodDimensionInfo = null;
        try {
            view.load(dimensionManager, bgFormInfo.getEntries().get(0).getDimensionData());
        }
        catch (Exception e) {
            throw new BgFormException(BgFormException.NODATA, (Throwable)e);
        }
        Map cacheMap = BgViewFacadeFactory.getRemoteInstance().getInitBgViewDimensionInfo(dimensionManager, bgFormInfo.getId().toString());
        Map bgPeriodMap = (Map)cacheMap.get("BGPERIOD");
        return bgPeriodMap.keySet();
    }

    public static boolean hasRoll(BgFormInfo bgFormInfo) {
        BgPeriodInfo periodInfo = bgFormInfo.getBgPeriod();
        BgPeriodInfo rollPeriodInfo = bgFormInfo.getBgRollPeriod();
        if (periodInfo == null || rollPeriodInfo == null || periodInfo.getNumber() == null || rollPeriodInfo.getNumber() == null) {
            return false;
        }
        return !periodInfo.getNumber().equalsIgnoreCase(rollPeriodInfo.getNumber());
    }

    public static String getPeriodNum(String fomulaStr) {
        String[] parameter = BgNFSHelper.parseFormulaPara((String)fomulaStr);
        return parameter[1];
    }
}

