/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.view.client.AbstractBgBillIntegrateCommentEditUI;
import com.kingdee.eas.ma.view.util.BgViewCommonHelper;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgBillIntegrateCommentEditUI
extends AbstractBgBillIntegrateCommentEditUI {
    private static final long serialVersionUID = -1519460746013619826L;
    private static final Logger logger = CoreUIObject.getLogger(BgBillIntegrateCommentEditUI.class);
    private Map ids = null;

    public Map getIds() {
        return this.ids;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.ids = (Map)this.getUIContext().get("BGFORM_ID");
        this.fillTable();
    }

    private void fillTable() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(this.ids.keySet()), CompareType.INCLUDE));
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("orgUnit.name");
        evi.getSelector().add("bgScheme.name");
        evi.getSelector().add("bgTemplate.name");
        evi.setSorter(new SorterItemCollection());
        evi.getSorter().add(new SorterItemInfo("orgUnit.number"));
        evi.getSorter().add(new SorterItemInfo("bgScheme.number"));
        evi.getSorter().add(new SorterItemInfo("bgTemplate.number"));
        BgFormCollection col = BgFormFactory.getRemoteInstance().getBgFormCollection(evi);
        for (int i = 0; i < col.size(); ++i) {
            IRow row = this.tblMain.addRow();
            BgFormInfo bgForm = col.get(i);
            row.getCell(0).setUserObject((Object)bgForm);
            row.getCell("orgUnit.name").setValue((Object)bgForm.getOrgUnit().getName());
            row.getCell("bgScheme.name").setValue((Object)bgForm.getBgScheme().getName());
            row.getCell("bgTemplate.name").setValue((Object)bgForm.getBgTemplate().getName());
        }
        this.tblMain.getSelectManager().select(0, 0);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeRow(this.tblMain.getSelectManager().getActiveRowIndex());
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            this.ids.put(((BgFormInfo)row.getCell(0).getUserObject()).getId().toString(), row.getUserObject());
        }
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        if (e.getPrevSelectBlock() != null) {
            this.storeRow(e.getPrevSelectBlock().getBeginRow());
        }
        if (e.getSelectBlock() != null) {
            this.loadRow(e.getSelectBlock().getBeginRow());
        }
    }

    protected void loadRow(int rowIndex) {
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            this.kdText.setText(BgViewCommonHelper.valueOf(row.getUserObject()));
        }
    }

    protected void storeRow(int rowIndex) {
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            row.setUserObject((Object)this.kdText.getText());
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.storeFields();
        this.getUIWindow().close();
    }
}

