/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.view.BgBillIntegrateRuleInfo;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeFacadeFactory;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeFactory;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeInfo;
import com.kingdee.eas.ma.view.client.AbstractBgBillIntegrateSchemeEditUI;
import com.kingdee.eas.ma.view.client.common.BgBillIntegrateClientHelper;
import com.kingdee.eas.ma.view.client.common.BgBillIntegrateItemMapHelper;
import com.kingdee.eas.ma.view.client.common.BgBillIntegrateRuleHelper;
import com.kingdee.eas.ma.view.common.BgBillIntegrateCommonHelper;
import com.kingdee.eas.ma.view.common.BgBillIntegrateConstants;
import com.kingdee.eas.ma.view.common.BizBillMetaBriefInfo;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Timestamp;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BgBillIntegrateSchemeEditUI
extends AbstractBgBillIntegrateSchemeEditUI {
    private static final long serialVersionUID = -3548519024250030790L;
    private static final Logger logger = CoreUIObject.getLogger(BgBillIntegrateSchemeEditUI.class);
    private Map initData = null;

    public void onLoad() throws Exception {
        this.chkAutoFlash.setVisible(false);
        this.initData = BgBillIntegrateSchemeFacadeFactory.getRemoteInstance().initData();
        Map subSystem = (Map)this.initData.get("SUB_SYS_BILL");
        BgBillIntegrateClientHelper.initSubSystem(this.cbxSubSystem, subSystem);
        if (subSystem == null || subSystem.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"noFdcSys"));
            SysUtil.abort();
        }
        super.onLoad();
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.btnRuleAddLine.setEnabled(false);
        this.btnRulesDeleteLine.setEnabled(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setSelectItem(this.cbxSubSystem, this.editData.getSubSystemName(), true);
        this.setSelectItem(this.cbxBoName, this.editData.getBoName(), false);
        this.tblRules.checkParsed();
        this.tblRules.removeRows();
        for (int i = 0; i < this.editData.getRules().size(); ++i) {
            this.loadRule(this.tblRules.addRow().getRowIndex(), this.editData.getRules().get(i));
        }
        this.tblItemMap.checkParsed();
        this.tblItemMap.removeRows();
        try {
            BgBillIntegrateItemMapHelper.resetItemMap(this.tblRules, this.tblItemMap, this.getCurrEntity(), this.isShowNumber());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        BgBillIntegrateItemMapHelper.initBgItemColF7(this.tblItemMap, this.getCurrentOrgUnitId(), (Object)this);
        BgBillIntegrateItemMapHelper.loadItemMap(this.editData.getItemMap(), this.tblItemMap);
        this.tblRules.getSelectManager().select(0, 0);
    }

    protected void loadRule(int rowIndex, BgBillIntegrateRuleInfo rule) {
        IRow r = this.tblRules.getRow(rowIndex);
        EntityObjectInfo entity = this.getCurrEntity();
        try {
            BgBillIntegrateRuleHelper.loadRule(r, rule, entity, this.tblRules);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
    }

    public void setEnableAddItemMap(boolean isEnable) {
        isEnable = isEnable && (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState()));
        this.btnItemMapAddLine.setEnabled(isEnable);
        this.btnItemMapDeleteLine.setEnabled(isEnable);
    }

    @Override
    protected void btnRulesAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnRulesAddLine_actionPerformed(e);
        BgBillIntegrateRuleInfo rule = this.createNewRule(this.editData);
        this.loadRule(this.tblRules.addRow().getRowIndex(), rule);
    }

    @Override
    protected void btnRulesDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnRulesDeleteLine_actionPerformed(e);
        int currRow = this.tblRules.getSelectManager().getActiveRowIndex();
        if (currRow >= 0) {
            this.tblRules.removeRow(currRow);
            BgBillIntegrateItemMapHelper.resetItemMap(this.tblRules, this.tblItemMap, this.getCurrEntity(), this.isShowNumber());
            String property = BgBillIntegrateRuleHelper.getRuleProperty(this.tblRules, this.tblRules.getSelectManager().getActiveRowIndex());
            BgBillIntegrateItemMapHelper.setCurrentBgItemSource(property, this.tblItemMap, this, this.isShowNumber());
        }
    }

    @Override
    protected void tblRules_editStopped(KDTEditEvent e) throws Exception {
        super.tblRules_editStopped(e);
        if (e.getOldValue() == e.getValue()) {
            return;
        }
        if (e.getColIndex() == this.tblRules.getColumnIndex("dimension")) {
            BgBillIntegrateItemMapHelper.resetItemMap(this.tblRules, this.tblItemMap, this.getCurrEntity(), this.isShowNumber());
            String property = BgBillIntegrateRuleHelper.getRuleProperty(this.tblRules, e.getRowIndex());
            BgBillIntegrateItemMapHelper.setCurrentBgItemSource(property, this.tblItemMap, this, this.isShowNumber());
        }
    }

    @Override
    protected void tblRules_tableSelectChanged(KDTSelectEvent e) {
        if (e == null) {
            return;
        }
        if (e.getPrevSelectBlock() == null || e.getSelectBlock().getBeginRow() != e.getPrevSelectBlock().getBeginRow()) {
            String property = BgBillIntegrateRuleHelper.getRuleProperty(this.tblRules, e.getSelectBlock().getBeginRow());
            BgBillIntegrateItemMapHelper.setCurrentBgItemSource(property, this.tblItemMap, this, this.isShowNumber());
        }
    }

    @Override
    protected void tblItemMap_editStopped(KDTEditEvent e) throws Exception {
        BgBillIntegrateItemMapHelper.cellDataChanged(e);
    }

    @Override
    protected void btnAddBgItemFromTemplate_actionPerformed(ActionEvent e) throws Exception {
        BgBillIntegrateItemMapHelper.batchAddBgItemFromBgTemplate(this.tblItemMap, (CoreUI)this, this.getCurrentOrgUnitId());
    }

    @Override
    protected void btnBatchAddBillItem_actionPerformed(ActionEvent e) throws Exception {
        BgBillIntegrateItemMapHelper.batchAddBillItem(this.tblItemMap, this.getCurrEntity());
    }

    @Override
    protected void btnBatchAddBgItem_actionPerformed(ActionEvent e) throws Exception {
        BgBillIntegrateItemMapHelper.batchAddBgItem(this.tblItemMap, (CoreUI)this, this.getCurrentOrgUnitId());
    }

    @Override
    protected void btnSetItemMapWilDcard_actionPerformed(ActionEvent e) throws Exception {
        BgBillIntegrateItemMapHelper.setWilDard(this.tblItemMap);
    }

    @Override
    protected void btnItemMapUp_actionPerformed(ActionEvent e) throws Exception {
        BgBillIntegrateItemMapHelper.move(this.tblItemMap, true);
    }

    @Override
    protected void btnItemMapDown_actionPerformed(ActionEvent e) throws Exception {
        BgBillIntegrateItemMapHelper.move(this.tblItemMap, false);
    }

    @Override
    protected void btnItemMapAddLine_actionPerformed(ActionEvent e) throws Exception {
        BgBillIntegrateItemMapHelper.addRow(this.tblItemMap);
    }

    @Override
    protected void btnItemMapDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        BgBillIntegrateItemMapHelper.removeRow(this.tblItemMap);
    }

    @Override
    protected void cbxShowNum_actionPerformed(ActionEvent e) throws Exception {
        BgBillIntegrateItemMapHelper.setColumnShow(this.tblItemMap, this.isShowNumber());
    }

    @Override
    public void storeFields() {
        int i;
        super.storeFields();
        this.editData.setSubSystemName(((BizBillMetaBriefInfo)this.cbxSubSystem.getSelectedItem()).getFullName());
        this.editData.setBoName(this.getCurrEntity().getFullName());
        PackageInfo pg = (PackageInfo)((BizBillMetaBriefInfo)this.cbxSubSystem.getSelectedItem()).getMetaData(null);
        EntityObjectInfo entity = (EntityObjectInfo)((BizBillMetaBriefInfo)this.cbxBoName.getSelectedItem()).getMetaData(null);
        List locales = BgBillIntegrateConstants.locales;
        for (i = 0; i < locales.size(); ++i) {
            Locale l = (Locale)locales.get(i);
            this.editData.setSubSystemAlias(pg.getAlias(l), l);
            this.editData.setBoAlias(entity.getAlias(l), l);
        }
        this.editData.getRules().clear();
        for (i = 0; i < this.tblRules.getRowCount(); ++i) {
            this.storeRule(i);
        }
        try {
            BgBillIntegrateItemMapHelper.resetItemMap(this.tblRules, this.tblItemMap, this.getCurrEntity(), this.isShowNumber());
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        BgBillIntegrateItemMapHelper.storeItemMap(this.editData, this.tblItemMap);
    }

    protected void storeRule(int row) {
        IRow r = this.tblRules.getRow(row);
        BgBillIntegrateRuleInfo rule = (BgBillIntegrateRuleInfo)r.getUserObject();
        rule.setSeq(row);
        try {
            BgBillIntegrateRuleHelper.storeRule(r, rule);
            this.editData.getRules().add(rule);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
    }

    @Override
    protected void cbxSubSystem_itemStateChanged(ItemEvent e) throws Exception {
        super.cbxSubSystem_itemStateChanged(e);
        Map subSysBill = (Map)this.initData.get("SUB_SYS_BILL");
        if (e.getStateChange() == 1 && this.cbxSubSystem.getSelectedIndex() >= 0 && subSysBill != null) {
            BizBillMetaBriefInfo subSys = (BizBillMetaBriefInfo)this.cbxSubSystem.getSelectedItem();
            if (subSysBill.get(subSys) instanceof List) {
                List bills = (List)subSysBill.get(subSys);
                this.cbxBoName.addItems(bills.toArray());
            }
        } else {
            this.cbxBoName.removeAllItems();
        }
    }

    @Override
    protected void cbxBoName_itemStateChanged(ItemEvent e) throws Exception {
        super.cbxBoName_itemStateChanged(e);
        if (e.getStateChange() == 1 && this.editData != null) {
            this.tblRules.removeRows();
            this.editData.getRules().clear();
            this.tblItemMap.removeRows();
            this.editData.getItemMap().clear();
            BgBillIntegrateItemMapHelper.resetItemMap(this.tblRules, this.tblItemMap, this.getCurrEntity(), this.isShowNumber());
            this.createNewRule(this.editData);
            this.loadRule(this.tblRules.addRow().getRowIndex(), this.editData.getRules().get(0));
        }
    }

    protected void setSelectItem(KDComboBox box, String fullName, boolean isFireListen) {
        if (box == null || StringUtils.isEmpty((String)fullName)) {
            return;
        }
        for (int i = 0; i < box.getItemCount(); ++i) {
            BizBillMetaBriefInfo bgMetaInfo = (BizBillMetaBriefInfo)box.getItemAt(i);
            if (!fullName.equalsIgnoreCase(bgMetaInfo.getFullName())) continue;
            box.setSelectedIndex(i, isFireListen);
            break;
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            throw new EASBizException(EASBizException.CHECKNAMEBLANK);
        }
        BgBillIntegrateRuleHelper.verifyRules(this.tblRules, this.editData.getRules());
        BgBillIntegrateItemMapHelper.verifyItemMap(this, this.editData.getItemMap(), this.getCurrentOrgUnitId());
    }

    public void showItemMapMsgAndAbort(int row, String msgKey) {
        this.tabMain.setSelectedIndex(1);
        this.tblItemMap.getSelectManager().select(row, 0, 2);
        MsgBox.showInfo((Component)((Object)this), (String)BgBillIntegrateClientHelper.getResource(msgKey));
        SysUtil.abort();
    }

    protected IObjectValue createNewData() {
        BgBillIntegrateSchemeInfo info = new BgBillIntegrateSchemeInfo();
        UserInfo self = SysContext.getSysContext().getCurrentUserInfo();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        info.setAutoFlash(false);
        info.setCreateTime(now);
        info.setCreator(self);
        info.setCU(new CtrlUnitInfo());
        info.getCU().setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        info.setLastUpdateTime(now);
        info.setLastUpdateUser(self);
        info.setState(false);
        this.createNewRule(info);
        return info;
    }

    private BgBillIntegrateRuleInfo createNewRule(BgBillIntegrateSchemeInfo info) {
        BgBillIntegrateRuleInfo rule = new BgBillIntegrateRuleInfo();
        rule.setScheme(info);
        info.getRules().add(rule);
        return rule;
    }

    protected EntityObjectInfo getCurrEntity() {
        BizBillMetaBriefInfo bgMetaInfo = (BizBillMetaBriefInfo)this.cbxBoName.getSelectedItem();
        EntityObjectInfo entity = (EntityObjectInfo)bgMetaInfo.getMetaData(null);
        return entity;
    }

    protected String getCurrentOrgUnitId() {
        return SysContext.getSysContext().getCurrentCostUnit().getId().toString();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (!StringUtils.isEmpty((String)this.getCurrentOrgUnitId())) {
            return new ObjectStringPK(this.getCurrentOrgUnitId());
        }
        return super.getOrgPK(action);
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        BgViewHelper.removeEditHelper(this.tblRules);
        this.tblRules.checkParsed();
        this.tblRules.getSelectManager().setSelectMode(2);
        BgBillIntegrateRuleHelper.initRulesTableF7((CoreUI)this, this.tblRules);
        this.tblItemMap.addAfterActionListener(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                if (7 == e.getType()) {
                    BgBillIntegrateItemMapHelper.deleteCellContent(BgBillIntegrateSchemeEditUI.this.tblItemMap);
                }
            }
        });
    }

    protected boolean isEditOprt() {
        return OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState());
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgBillIntegrateSchemeFactory.getRemoteInstance();
    }

    protected SorterItemCollection getSortor() {
        return BgBillIntegrateCommonHelper.getSchemeSorter();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return BgBillIntegrateCommonHelper.addSchemeSelectors(super.getSelectors());
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        return this.getBizInterface().getValue(pk, this.getMergedSelector(), this.getSortor());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnItemMapUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnItemMapDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnItemMapAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnItemMapDeleteLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnBatchAddBgItem.setEnabled(false);
            this.btnBatchAddBillItem.setEnabled(false);
            this.btnAddBgItemFromTemplate.setEnabled(false);
            this.btnSetItemMapWilDcard.setEnabled(false);
            this.btnItemMapUp.setEnabled(false);
            this.btnItemMapDown.setEnabled(false);
        }
    }

    private boolean isShowNumber() {
        return this.cbxShowNum.isSelected();
    }
}

