/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.BaseCommonQueryClientException;
import com.kingdee.eas.base.commonquery.LeftBracketSignEnum;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.commonquery.RightBracketSignEnum;
import com.kingdee.eas.base.commonquery.RowObject;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.view.client.rules.BgConditionHelper;
import com.kingdee.eas.ma.view.client.rules.BgRuleDataInfo;
import com.kingdee.eas.ma.view.common.BgBillIntegrateCommonHelper;
import com.kingdee.eas.ma.view.common.BgRuleField;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JScrollBar;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BgEntityFilterPanel
extends KDPanel {
    private static final long serialVersionUID = -5715116402608487497L;
    private static final Logger logger = Logger.getLogger((String)BgEntityFilterPanel.class.getName());
    private CoreUI parent = null;
    private KDTable tblMain;
    private KDPanel pnlFilter;
    private KDWorkButton btnAddLine;
    private KDWorkButton btnDeleteLine;
    private KDWorkButton btnClearAll;
    private FilterInfo filterInfo;
    private EntityObjectInfo entity;
    private int width = 540;
    private int height = 400;
    private int[] FILTER_COLUMN_WIDTHs = this.calculateWidths();

    public BgEntityFilterPanel(CoreUI parent) throws BaseCommonQueryClientException {
        this.parent = parent;
        this.jbInit();
    }

    public CoreUI getParentUI() {
        return this.parent;
    }

    private int[] calculateWidths() {
        int unit = (this.width - 8 - 8) / 5;
        return new int[]{unit / 2, unit, unit, unit, unit / 2, unit - 45};
    }

    public void setData(EntityObjectInfo entity, FilterInfo filterInfo) {
        this.entity = entity;
        this.filterInfo = filterInfo;
        try {
            this.fillFilterTableBody();
        }
        catch (BaseCommonQueryClientException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void jbInit() throws BaseCommonQueryClientException {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.btnAddLine = new KDWorkButton();
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)"addRow"));
        this.btnAddLine.setBounds(this.width - 8 - 22 - 3 - 22 - 3 - 22, 3, 22, 19);
        this.btnAddLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgEntityFilterPanel.this.btnAddLine_actionPerformed(e);
            }
        });
        this.add((Component)this.btnAddLine);
        this.btnDeleteLine = new KDWorkButton();
        this.btnDeleteLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDeleteLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)"removeRow"));
        this.btnDeleteLine.setBounds(this.width - 8 - 22 - 3 - 22, 3, 22, 19);
        this.btnDeleteLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgEntityFilterPanel.this.btnDeleteLine_actionPerformed(e);
            }
        });
        this.add((Component)this.btnDeleteLine);
        this.btnClearAll = new KDWorkButton();
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.btnClearAll.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)"clear"));
        this.btnClearAll.setBounds(this.width - 8 - 22, 3, 22, 19);
        this.btnClearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgEntityFilterPanel.this.btnClearAll_actionPerformed(e);
            }
        });
        this.add((Component)this.btnClearAll);
        this.tblMain = new KDTable();
        this.initTable();
        this.tblMain.setBounds(8, 23, this.width - 8 - 8, this.height - 19 - 1 - 3);
        this.add((Component)this.tblMain);
    }

    private void addTableListener() {
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    BgEntityFilterPanel.this.tblMain_editStopped(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    private void initTable() throws BaseCommonQueryClientException {
        int columnSize = BgConditionHelper.FILTER_COLUMN_KEYS.length;
        for (int i = 0; i < columnSize; ++i) {
            IColumn iColumn = this.tblMain.addColumn();
            iColumn.setKey(BgConditionHelper.FILTER_COLUMN_KEYS[i]);
            iColumn.setWidth(this.FILTER_COLUMN_WIDTHs[i]);
            BgConditionHelper.setColumnF7(this.tblMain, iColumn);
        }
        IRow headRow = this.tblMain.addHeadRow();
        for (int i = 0; i < columnSize; ++i) {
            headRow.getCell(i).setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)BgConditionHelper.FILTER_COLUMN_KEYS[i]));
        }
        this.addTableListener();
        this.tblMain.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.tblMain.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
    }

    private void fillFilterTableBody() throws BaseCommonQueryClientException {
        if (this.filterInfo != null) {
            this.checkFilters();
            ArrayList rowInfos = BgConditionHelper.getRowInfos(this.entity, this.filterInfo);
            if (rowInfos.isEmpty()) {
                rowInfos.add(BgConditionHelper.getDefaultRow());
            }
            for (int i = 0; i < rowInfos.size(); ++i) {
                BgConditionHelper.loadFilter(this.entity, this.tblMain.addRow(), (RowObject)rowInfos.get(i));
            }
        }
    }

    private void checkFilters() {
        if (this.filterInfo == null) {
            return;
        }
        int filterSize = this.filterInfo.getFilterItems().size();
        for (int i = 0; i < filterSize; ++i) {
            String currentField = this.filterInfo.getFilterItems().get(i).getPropertyName();
            PropertyInfo property = BgRuleField.getProperty(this.entity, currentField, false);
            if (property != null) continue;
            MsgBox.showError((String)(currentField + EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)"checkFilterWarning")));
            SysUtil.abort();
        }
    }

    private void increaseRow(KDTEditEvent e) {
        ICell cell;
        int rowIndex = e.getRowIndex();
        String colKey = this.tblMain.getColumnKey(e.getColIndex());
        if ("loginSign".equals(colKey) && rowIndex == this.tblMain.getRowCount() - 1 && (cell = this.tblMain.getCell(rowIndex, colKey)) != null && cell.getValue() != null && !StringUtils.isEmpty((String)cell.getValue().toString())) {
            this.addRow();
        }
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        this.increaseRow(e);
        BgConditionHelper.editedCellAfter(e);
    }

    protected void btnAddLine_actionPerformed(ActionEvent e) {
        this.addRow();
    }

    protected void btnDeleteLine_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex >= 0) {
            this.tblMain.removeRow(selectedRowIndex);
        }
    }

    protected void btnClearAll_actionPerformed(ActionEvent e) {
        this.clear();
    }

    private void addRow() {
        BgConditionHelper.loadFilter(this.entity, this.tblMain.addRow(), BgConditionHelper.getDefaultRow());
    }

    protected void clearTable() {
        this.tblMain.removeRows();
        this.addRow();
    }

    protected boolean isExistLogicSign(int rowIndex) {
        return true;
    }

    protected void verifyBracketMatching() {
        int rowCount = this.tblMain.getRowCount();
        int balance = 0;
        for (int i = 0; i < rowCount; ++i) {
            RightBracketSignEnum rightBracketSignEnum;
            LeftBracketSignEnum leftBracketSignEnum;
            Object object = null;
            object = this.tblMain.getRow(i).getCell("leftBracketSign").getValue();
            if (object != null && !StringUtils.isEmpty((String)object.toString()) && (leftBracketSignEnum = (LeftBracketSignEnum)object) != null && leftBracketSignEnum.getValue() != null) {
                balance += leftBracketSignEnum.getValue().length();
            }
            if ((object = this.tblMain.getRow(i).getCell("rightBracketSign").getValue()) != null && !StringUtils.isEmpty((String)object.toString()) && (rightBracketSignEnum = (RightBracketSignEnum)object) != null && rightBracketSignEnum.getValue() != null) {
                balance -= rightBracketSignEnum.getValue().length();
            }
            if (balance < 0) break;
        }
        if (balance != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)"bracketWarning"));
            SysUtil.abort();
        }
    }

    private BgRuleDataInfo getFilterData() {
        String maskString;
        StringBuffer filterAlias = new StringBuffer();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer maskStringBuffer = new StringBuffer();
        boolean isOk = true;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (BgConditionHelper.isBlankRow(row)) continue;
            String leftBracket = (String)BgConditionHelper.getValue(row.getCell("leftBracketSign").getValue());
            filterAlias.append(BgConditionHelper.getAlias(row.getCell("leftBracketSign").getValue()));
            String condition = (String)BgConditionHelper.getValue(row.getCell("condition").getValue());
            filterAlias.append(BgConditionHelper.getAlias(row.getCell("condition").getValue()));
            String compare = (String)BgConditionHelper.getValue(row.getCell("compareSign").getValue());
            filterAlias.append(BgConditionHelper.getAlias(row.getCell("compareSign").getValue()));
            Object compareValue = BgConditionHelper.getValue(row.getCell("compareValue").getValue());
            Object compareAlias = BgConditionHelper.getAlias(row.getCell("compareValue").getValue());
            if (compareValue instanceof Date && !StringUtils.isEmpty((String)row.getCell("compareValue").getStyleAttributes().getNumberFormat())) {
                try {
                    SimpleDateFormat format = new SimpleDateFormat(row.getCell("compareValue").getStyleAttributes().getNumberFormat());
                    compareValue = BgBillIntegrateCommonHelper.setBeginDate((Date)compareValue);
                    if (compareAlias instanceof Date) {
                        compareAlias = format.format(compareAlias) + " ";
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
            filterAlias.append(compareAlias);
            String rightBracket = (String)BgConditionHelper.getValue(row.getCell("rightBracketSign").getValue());
            filterAlias.append(BgConditionHelper.getAlias(row.getCell("rightBracketSign").getValue()));
            String logic = (String)BgConditionHelper.getValue(row.getCell("loginSign").getValue());
            filterAlias.append(BgConditionHelper.getAlias(row.getCell("loginSign").getValue()));
            if (i == this.tblMain.getRowCount() - 1) {
                if (!StringUtils.isEmpty((String)logic)) {
                    isOk = false;
                    break;
                }
            } else if (StringUtils.isEmpty((String)logic)) {
                logic = "AND";
                filterAlias.append(LogicSignEnum.AND.getAlias());
            }
            if (BgConditionHelper.isNotCompareValue(compare)) {
                if (compareValue != null && !StringUtils.isEmpty((String)compareValue.toString())) {
                    isOk = false;
                    break;
                }
                compareValue = null;
            } else if (compareValue == null || StringUtils.isEmpty((String)compareValue.toString())) {
                isOk = false;
                break;
            }
            if (StringUtils.isEmpty((String)compare)) {
                isOk = false;
                break;
            }
            if (StringUtils.isEmpty((String)condition)) {
                isOk = false;
                break;
            }
            String targetProperty = BgConditionHelper.getPropertyName(condition);
            DataObject dataInfo = BgConditionHelper.getDataObject(this.entity, condition);
            if (dataInfo == null) {
                String filterCond = EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)"filterCond");
                String notExsit = EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)"notExsit");
                MsgBox.showError((Component)((Object)this), (String)(filterCond + "\"" + targetProperty + "\"" + notExsit));
                SysUtil.abort();
            }
            FilterItemInfo filterItemInfo = null;
            if (DataType.SHORT.getName().equals(dataInfo.getName()) || DataType.INTEGER.getName().equals(dataInfo.getName()) || DataType.LONG.getName().equals(dataInfo.getName()) || DataType.FLOAT.getName().equals(dataInfo.getName()) || DataType.DOUBLE.getName().equals(dataInfo.getName()) || DataType.DECIMAL.getName().equals(dataInfo.getName())) {
                if (compareValue != null) {
                    try {
                        compareValue = new BigDecimal(compareValue.toString());
                    }
                    catch (NumberFormatException e) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonQueryPanel", (String)"SolutionDefineError"));
                        SysUtil.abort();
                    }
                }
                filterItemInfo = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
            } else if (compareValue != null) {
                if (CompareType.LIKE.getName().equalsIgnoreCase(compare) || CompareType.NOTLIKE.getName().equalsIgnoreCase(compare)) {
                    compareValue = "%" + compareValue.toString() + "%";
                    compare = compare.toLowerCase();
                } else if ("LEFT LIKE".equalsIgnoreCase(compare)) {
                    compareValue = compareValue.toString() + "%";
                    compare = CompareType.LIKE.getName();
                } else if ("RIGHT LIKE".equalsIgnoreCase(compare)) {
                    compareValue = "%" + compareValue.toString();
                    compare = CompareType.LIKE.getName();
                } else if ("NOT LEFT LIKE".equalsIgnoreCase(compare)) {
                    compareValue = compareValue.toString() + "%";
                    compare = CompareType.NOTLIKE.getName();
                } else if (compare.equalsIgnoreCase("IS")) {
                    compareValue = null;
                    compare = "=";
                } else if (compare.equalsIgnoreCase("IS NOT")) {
                    compareValue = null;
                    compare = "<>";
                }
                filterItemInfo = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
            }
            filterInfo.getFilterItems().add(filterItemInfo);
            maskStringBuffer.append(leftBracket).append(" ").append("#").append(String.valueOf(filterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
        }
        if (!isOk) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonEntityFilter", (String)"blankRowWarning"));
            SysUtil.abort();
        }
        if (!StringUtils.isEmpty((String)(maskString = maskStringBuffer.toString().trim()))) {
            filterInfo.setMaskString(maskString);
        }
        this.filterInfo = filterInfo;
        BgRuleDataInfo data = new BgRuleDataInfo(this.entity, null, null);
        data.setExpression(filterInfo.toString());
        data.setAlias(filterAlias.toString().trim());
        return data;
    }

    public BgRuleDataInfo getReturnData() {
        this.verifyBracketMatching();
        return this.getFilterData();
    }

    public KDTable getKdtTable() {
        return this.tblMain;
    }

    public KDWorkButton getAddRowButton() {
        return this.btnAddLine;
    }

    public KDWorkButton getClearButton() {
        return this.btnClearAll;
    }

    public KDWorkButton getDelRowButton() {
        return this.btnDeleteLine;
    }

    public KDPanel getFilterButtonPanel() {
        return this.pnlFilter;
    }

    public EntityObjectInfo getEntity() {
        return this.entity;
    }

    public void clear() {
        this.clearTable();
    }
}

