/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.view.client.AbstractBgFormulaUI;
import com.kingdee.eas.ma.view.client.rules.BgRuleDataInfo;
import com.kingdee.eas.ma.view.common.IBgDataSynchSelector;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgFormulaUI
extends AbstractBgFormulaUI
implements IBgDataSynchSelector {
    private static final long serialVersionUID = 2798778846686516127L;
    private static final Logger logger = CoreUIObject.getLogger(BgFormulaUI.class);
    private BgRuleDataInfo data = null;
    private Set formulaSet = new HashSet();
    private boolean isCancel = true;

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTFormula.setEditable(false);
        this.kDTFormula.setEnabled(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        try {
            this.checkFormula();
        }
        catch (InterpreterException e1) {
            logger.error((Object)e1);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"formulaError"));
            SysUtil.abort();
        }
        catch (ParserException e1) {
            logger.error((Object)e1);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"formulaError"));
            SysUtil.abort();
        }
        catch (ArithmeticException e1) {
            logger.error((Object)e1);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"formulaError"));
            SysUtil.abort();
        }
        catch (NullPointerException e1) {
            logger.error((Object)e1);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"formulaError"));
            SysUtil.abort();
        }
        if (this.data == null) {
            return;
        }
        if (this.kDTFormula.getUserObject() != null) {
            this.data.setAlias(this.kDTFormula.getText().trim());
            this.data.setExpression(this.kDTFormula.getUserObject().toString());
            String extendExpress = "";
            Iterator it = this.formulaSet.iterator();
            while (it.hasNext()) {
                extendExpress = extendExpress + it.next() + ",";
            }
            if (extendExpress.length() > 1) {
                extendExpress = extendExpress.substring(0, extendExpress.length() - 1);
                this.data.setExtendExpression(extendExpress);
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.data != null) {
            this.kDTFormula.setText(this.data.getAlias());
            this.kDTFormula.setUserObject((Object)this.data.getExpression());
            if (this.data.getExtendExpression() != null && !this.data.getExtendExpression().trim().equals("")) {
                String extendExp = this.data.getExtendExpression().trim();
                String[] strs = extendExp.split(",");
                this.formulaSet.clear();
                for (int i = 0; i < strs.length; ++i) {
                    this.formulaSet.add(strs[i]);
                }
            }
        }
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.storeFields();
        this.isCancel = false;
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    public void actionRemoveFormula_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveFormula_actionPerformed(e);
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"isRemoveAll")))) {
            this.kDTFormula.setText(null);
            this.kDTFormula.setUserObject(null);
            this.formulaSet.clear();
        }
    }

    @Override
    public void actionAddBgItem_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddBgItem_actionPerformed(e);
        if (this.data == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.view.client.BgRuleSelectUI", (Map)uiContext);
        IBgDataSynchSelector selector = (IBgDataSynchSelector)window.getUIObject();
        selector.setData(BgRuleDataInfo.clone(this.data));
        window.show();
        if (selector.isCancel() && selector.getData() == null) {
            return;
        }
        BgRuleDataInfo info = (BgRuleDataInfo)selector.getData();
        this.kDTFormula.append(info.getAlias());
        this.formulaSet.add(info.getExpression());
        if (this.kDTFormula.getUserObject() == null || !(this.kDTFormula.getUserObject() instanceof String)) {
            this.kDTFormula.setUserObject((Object)info.getExpression());
        } else {
            this.kDTFormula.setUserObject((Object)(this.kDTFormula.getUserObject().toString() + info.getExpression()));
        }
    }

    @Override
    public void actionAddExpression_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddExpression_actionPerformed(e);
        String expression = e.getActionCommand().trim();
        this.kDTFormula.append(expression);
        if (this.kDTFormula.getUserObject() == null || !(this.kDTFormula.getUserObject() instanceof String)) {
            this.kDTFormula.setUserObject((Object)expression);
        } else {
            this.kDTFormula.setUserObject((Object)(this.kDTFormula.getUserObject().toString() + expression));
        }
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public boolean isCancel() {
        return this.isCancel;
    }

    @Override
    public void setData(Object data) {
        if (data instanceof BgRuleDataInfo) {
            this.data = (BgRuleDataInfo)data;
            this.data.setTargetClazzName(null);
            this.loadFields();
        }
    }

    public void checkFormula() throws InterpreterException, ParserException {
        if (this.kDTFormula.getUserObject() != null && this.kDTFormula.getUserObject() instanceof String) {
            String formula = this.kDTFormula.getUserObject().toString();
            HashMap<String, Integer> correctFormulaParamMap = new HashMap<String, Integer>();
            for (String key : this.formulaSet) {
                correctFormulaParamMap.put(key.replaceAll("\\.", "_"), new Integer(1));
            }
            new Interpreter().evalExpr("f=" + formula.replaceAll("\\.", "_"), correctFormulaParamMap);
        }
    }
}

