/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemGroupFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.view.client.AbstractBgItemByGroupForViewUI;
import com.kingdee.eas.ma.view.client.BgViewDimensionInfo2;
import com.kingdee.eas.ma.view.client.BgViewItemEnum;
import com.kingdee.eas.ma.view.util.BgItemViewObject;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BgItemByGroupForViewUI
extends AbstractBgItemByGroupForViewUI {
    private static final Logger logger = CoreUIObject.getLogger(BgItemByGroupForViewUI.class);
    private BgItemCollection bgItemCollection;
    private BgItemCollection bgItemCollectionReturn;
    private BgItemViewObject returnObject;
    private BgItemViewObject selectedObject;
    private BgViewDimensionInfo2 dimensionInfo;
    private String orgUnitId = null;
    private String longNumber = null;
    private boolean isCancel = true;
    private boolean isDisplayAll = false;
    private String disType;
    private static final String COL_NUMBER = "number";
    private static final String COL_NAME = "name";

    public BgItemByGroupForViewUI() throws Exception {
    }

    public BgItemByGroupForViewUI(BgViewDimensionInfo2 info) throws Exception {
        this.dimensionInfo = info;
    }

    public BgItemByGroupForViewUI(boolean all) throws Exception {
        this.isDisplayAll = all;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tableLeft.checkParsed();
        this.tableRight.checkParsed();
        if (this.getUIContext().get("BgViewDimensionInfo") instanceof BgViewDimensionInfo2) {
            this.dimensionInfo = (BgViewDimensionInfo2)this.getUIContext().get("BgViewDimensionInfo");
            this.txtName.setText(this.dimensionInfo.getName());
            this.txtName.setEnabled(false);
        }
        if (!StringUtils.isEmpty((String)this.dimensionInfo.getShowType())) {
            this.comBoxDisplay.setSelectedItem((Object)BgViewItemEnum.getEnum(this.dimensionInfo.getShowType()));
        }
        if (this.getUIContext().get("selectedObj") instanceof BgItemViewObject) {
            this.setSelectedObject((BgItemViewObject)((Object)this.getUIContext().get("selectedObj")));
        }
        this.btnAdd.setEnabled(true);
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnDelete.setEnabled(true);
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.addAll.setEnabled(true);
        this.addAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnDeleteAll.setEnabled(true);
        this.btnDeleteAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.checkBoxDisplayAll.setSelected(true);
        if (this.getUIContext().get("ORGUNITID") != null) {
            this.orgUnitId = (String)this.getUIContext().get("ORGUNITID");
            OrgUnitInfo ou = CostCenterOrgUnitFactory.getRemoteInstance().getOrgUnitInfo("select longnumber where id='" + this.orgUnitId + "'");
            this.longNumber = ou.getLongNumber();
        } else {
            this.orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            this.longNumber = SysContext.getSysContext().getCurrentOrgUnit().getLongNumber();
        }
        this.init();
    }

    private void init() throws EASBizException, BOSException {
        this.initData();
        this.initTable();
    }

    private void initTable() {
        this.btnOk.setEnabled(true);
        this.btnCancel.setEnabled(true);
        BgItemCollection items = this.getBgItemCollection();
        BgItemCollection selectedItem = null;
        ArrayList<String> list = new ArrayList<String>();
        if (this.getSelectedObject() != null) {
            selectedItem = this.getSelectedObject().getResult();
            if (selectedItem == null || selectedItem.isEmpty()) {
                this.checkBoxDisplayAll.setSelected(true);
            } else {
                for (int n = 0; n < selectedItem.size(); ++n) {
                    list.add(selectedItem.get(n).getNumber());
                }
                this.checkBoxDisplayAll.setSelected(false);
            }
            BgItemViewObject bgitemViewObject = this.getSelectedObject();
            String type = bgitemViewObject.getShowType();
            if ("NAME".equals(type)) {
                this.comBoxDisplay.setSelectedItem((Object)BgViewItemEnum.NAME);
            } else if ("NAMEANDNUMBER".equals(type)) {
                this.comBoxDisplay.setSelectedItem((Object)BgViewItemEnum.NAMEANDNUMBER);
            } else if ("NUMBER".equals(type)) {
                this.comBoxDisplay.setSelectedItem((Object)BgViewItemEnum.NUMBER);
            }
        }
        if (items == null || items.isEmpty()) {
            return;
        }
        this.tableLeft.checkParsed();
        this.tableRight.checkParsed();
        this.tableLeft.getStyleAttributes().setLocked(true);
        this.tableRight.getStyleAttributes().setLocked(true);
        this.tableLeft.getSelectManager().setSelectMode(10);
        this.tableRight.getSelectManager().setSelectMode(10);
        BgItemInfo info = null;
        for (int n = 0; n < items.size(); ++n) {
            info = items.get(n);
            if (selectedItem == null) {
                this.addRowToTable(info, this.tableLeft);
                continue;
            }
            if (list.contains(info.getNumber()) && !this.isDisplayAll()) {
                this.addRowToTable(info, this.tableRight);
                continue;
            }
            this.addRowToTable(info, this.tableLeft);
        }
    }

    private void addRowToTable(BgItemInfo info, KDTable table) {
        if (info == null || table == null) {
            return;
        }
        IRow row = table.addRow();
        row.setUserObject((Object)info);
        row.getCell(COL_NUMBER).setValue((Object)info.getNumber());
        row.getCell(COL_NAME).setValue((Object)info.getName());
    }

    private void deleteRow(KDTable table, List list) {
        if (table == null || list == null || list.isEmpty()) {
            return;
        }
        for (int n = list.size(); n > 0; --n) {
            table.removeRow(Integer.parseInt(list.get(n - 1).toString()));
        }
    }

    private void initData() throws EASBizException, BOSException {
        String sql = "select id,number,name where number = '" + this.dimensionInfo.getNumber() + "'";
        BgItemGroupInfo item = null;
        item = BgItemGroupFactory.getRemoteInstance().getBgItemGroupInfo(sql);
        IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.ma.budget.BgItemQuery"));
        queryExecutor.setObjectView(" WHERE bgItemGroup.id = '" + item.getId() + "' and isEffective = 1");
        EntityViewInfo viewInfo = queryExecutor.getObjectView();
        FilterInfo filter = viewInfo.getFilter();
        int maskSize = filter.getFilterItems().size();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg((String)this.orgUnitId), CompareType.EQUALS));
        if (StringUtils.isEmpty((String)filter.getMaskString())) {
            filter.setMaskString("#0");
        } else {
            filter.setMaskString("(" + filter.getMaskString() + ") and #" + String.valueOf(maskSize));
        }
        if (!BgSHelper.isBgItemIsolate()) {
            filter = BgSHelper.getFilter((FilterInfo)filter, (String)this.longNumber);
        }
        queryExecutor.setObjectView(viewInfo);
        IRowSet rowSet = queryExecutor.executeQuery();
        this.bgItemCollection = new BgItemCollection();
        try {
            while (rowSet.next()) {
                BgItemInfo itemInfo = this.createBgItem(rowSet);
                this.bgItemCollection.add(itemInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private BgItemInfo createBgItem(IRowSet rowSet) throws SQLException {
        String id = rowSet.getString("id");
        String number = rowSet.getString(COL_NUMBER);
        String name = rowSet.getString(COL_NAME);
        String refField = rowSet.getString("refField");
        String specialNumber = rowSet.getString("specialNumber");
        String bgItemGroupId = rowSet.getString("bgItemGroup.id");
        String bgItemGroupNumber = rowSet.getString("bgItemGroup.number");
        BgItemInfo item = new BgItemInfo();
        item.setNumber(number);
        item.setName(name);
        item.setRefField(refField);
        item.setSpecialNumber(specialNumber);
        item.setId(BOSUuid.create((String)id));
        BgItemGroupInfo group = new BgItemGroupInfo();
        group.setId(BOSUuid.read((String)bgItemGroupId));
        group.setNumber(bgItemGroupNumber);
        item.setBgItemGroup(group);
        return item;
    }

    @Override
    protected void comBoxDisplay_actionPerformed(ActionEvent e) throws Exception {
        BgViewItemEnum select = (BgViewItemEnum)((Object)this.comBoxDisplay.getSelectedItem());
        if (select == BgViewItemEnum.NAME) {
            this.setDisType("NAME");
        } else if (select == BgViewItemEnum.NAMEANDNUMBER) {
            this.setDisType("NAMEANDNUMBER");
        } else {
            this.setDisType("NUMBER");
        }
    }

    @Override
    protected void checkBoxDisplayAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkBoxDisplayAll.isSelected()) {
            this.setDisplayAll(true);
            this.btnDeleteAll_actionPerformed(null);
        } else {
            this.setDisplayAll(false);
        }
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        List selectRowIndex = BgViewHelper.getSelectRowIndexes(this.tableLeft);
        ArrayList<Integer> needDeleteRowIndex = new ArrayList<Integer>();
        for (int n = 0; n < selectRowIndex.size(); ++n) {
            int rowIndex = Integer.parseInt(selectRowIndex.get(n).toString());
            Object obj = this.tableLeft.getRow(rowIndex).getUserObject();
            if (obj == null || !(obj instanceof BgItemInfo)) continue;
            this.addRowToTable((BgItemInfo)obj, this.tableRight);
            needDeleteRowIndex.add(rowIndex);
        }
        this.deleteRow(this.tableLeft, needDeleteRowIndex);
        if (this.tableRight.getRowCount() == 0) {
            this.checkBoxDisplayAll.setSelected(true);
        } else {
            this.checkBoxDisplayAll.setSelected(false);
        }
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        List selectRowIndex = BgViewHelper.getSelectRowIndexes(this.tableRight);
        ArrayList<Integer> needDeleteRowIndex = new ArrayList<Integer>();
        for (int n = 0; n < selectRowIndex.size(); ++n) {
            int rowIndex = Integer.parseInt(selectRowIndex.get(n).toString());
            Object obj = this.tableRight.getRow(rowIndex).getUserObject();
            if (obj == null || !(obj instanceof BgItemInfo)) continue;
            this.addRowToTable((BgItemInfo)obj, this.tableLeft);
            needDeleteRowIndex.add(rowIndex);
        }
        this.deleteRow(this.tableRight, needDeleteRowIndex);
        if (this.tableRight.getRowCount() == 0) {
            this.checkBoxDisplayAll.setSelected(true);
        } else {
            this.checkBoxDisplayAll.setSelected(false);
        }
    }

    @Override
    protected void btnDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<Integer> needDeleteRowIndex = new ArrayList<Integer>();
        for (int n = 0; n < this.tableRight.getRowCount(); ++n) {
            Object obj = this.tableRight.getRow(n).getUserObject();
            if (obj == null || !(obj instanceof BgItemInfo)) continue;
            this.addRowToTable((BgItemInfo)obj, this.tableLeft);
            needDeleteRowIndex.add(n);
        }
        this.deleteRow(this.tableRight, needDeleteRowIndex);
        if (this.tableRight.getRowCount() == 0) {
            this.checkBoxDisplayAll.setSelected(true);
        } else {
            this.checkBoxDisplayAll.setSelected(false);
        }
    }

    @Override
    protected void addAll_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<Integer> needDeleteRowIndex = new ArrayList<Integer>();
        for (int n = 0; n < this.tableLeft.getRowCount(); ++n) {
            Object obj = this.tableLeft.getRow(n).getUserObject();
            if (obj == null || !(obj instanceof BgItemInfo)) continue;
            this.addRowToTable((BgItemInfo)obj, this.tableRight);
            needDeleteRowIndex.add(n);
        }
        this.deleteRow(this.tableLeft, needDeleteRowIndex);
        if (this.tableRight.getRowCount() == 0) {
            this.checkBoxDisplayAll.setSelected(true);
        } else {
            this.checkBoxDisplayAll.setSelected(false);
        }
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tableRight.getRowCount();
        BgItemViewObject itemObj = new BgItemViewObject(null);
        itemObj.setShowType(((BgViewItemEnum)((Object)this.comBoxDisplay.getSelectedItem())).getName());
        if (!this.checkBoxDisplayAll.isSelected()) {
            if (!this.checkBoxDisplayAll.isSelected() && rowCount < 1) {
                return;
            }
            int size = this.tableRight.getRowCount();
            Object obj = null;
            BgItemCollection itemCon = new BgItemCollection();
            for (int n = 0; n < size; ++n) {
                obj = this.tableRight.getRow(n).getUserObject();
                if (obj == null || !(obj instanceof BgItemInfo)) continue;
                itemCon.add((BgItemInfo)obj);
            }
            itemObj.setResult(itemCon);
        }
        itemObj.setShowType(this.getDisType());
        this.setReturnObject(itemObj);
        this.setCancel(false);
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setCancel(true);
        this.getUIWindow().close();
    }

    public Object getReult() {
        return this.getReturnObject();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public BgItemCollection getBgItemCollection() {
        return this.bgItemCollection;
    }

    public void setBgItemCollection(BgItemCollection bgItemCollection) {
        this.bgItemCollection = bgItemCollection;
    }

    public BgItemCollection getBgItemCollectionReturn() {
        return this.bgItemCollectionReturn;
    }

    public void setBgItemCollectionReturn(BgItemCollection bgItemCollectionReturn) {
        this.bgItemCollectionReturn = bgItemCollectionReturn;
    }

    public BgItemViewObject getReturnObject() {
        return this.returnObject;
    }

    public void setReturnObject(BgItemViewObject returnObject) {
        this.returnObject = returnObject;
    }

    public BgViewDimensionInfo2 getDimensionInfo() {
        return this.dimensionInfo;
    }

    public void setDimensionInfo(BgViewDimensionInfo2 dimensionInfo) {
        this.dimensionInfo = dimensionInfo;
    }

    public String getOrgUnitId() {
        return this.orgUnitId;
    }

    public void setOrgUnitId(String orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    public String getLongNumber() {
        return this.longNumber;
    }

    public void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public boolean isDisplayAll() {
        return this.isDisplayAll;
    }

    public void setDisplayAll(boolean isDisplayAll) {
        this.isDisplayAll = isDisplayAll;
    }

    public BgItemViewObject getSelectedObject() {
        return this.selectedObject;
    }

    public void setSelectedObject(BgItemViewObject selectedObject) {
        this.selectedObject = selectedObject;
    }

    public String getDisType() {
        return this.disType;
    }

    public void setDisType(String disType) {
        this.disType = disType;
    }
}

