/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client;

import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.ma.budget.BgAdjustDiversityData;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.client.BgAdjustBillEditUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.view.client.BgReportViewProcessUI;
import com.kingdee.eas.ma.view.client.common.BgAdjustViewSelectItemContextManage;
import com.kingdee.eas.ma.view.client.common.BgReportViewContextManager;
import com.kingdee.eas.ma.view.client.common.BgViewClientHelper;
import com.kingdee.eas.ma.view.client.designer.IContextManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class BgNAdjustViewProcessUI
extends BgReportViewProcessUI {
    private static final long serialVersionUID = -1633138083389387333L;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        ToolBarManager toolBarManager = ((BgReportViewContextManager)this.getContextManager()).getSpreadContext().getToolBarManager();
        BgViewClientHelper.removeAction(toolBarManager);
    }

    @Override
    public IContextManager createContextManagerImpl() {
        BgAdjustViewSelectItemContextManage bookCtx = new BgAdjustViewSelectItemContextManage(this.getUIContext(), this);
        return bookCtx;
    }

    @Override
    public void actionRefer_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("Owner") instanceof BgAdjustBillEditUI) {
            Sheet.ICellsIterator iterator;
            int i;
            BgAdjustBillEditUI processUI = (BgAdjustBillEditUI)this.getUIContext().get("Owner");
            HashMap<String, BgAdjustDiversityData> adjustMap = new HashMap<String, BgAdjustDiversityData>();
            LinkedHashMap adjustCtrlMap = new LinkedHashMap();
            Cell cell = null;
            String formulaString = null;
            String[] parameter = null;
            BgAdjustDiversityData divData = null;
            CellBlock block = null;
            Sheet sheet = ((BgReportViewContextManager)this.getContextManager()).getSpreadContext().getBook().getActiveSheet();
            Range range = sheet.getSelectionRange();
            boolean hasItem = false;
            int n = range.size();
            block2: for (i = 0; i < n; ++i) {
                block = (CellBlock)range.getAt(i);
                iterator = sheet.getCellsIterator(block, false, false);
                while (iterator.hasNext()) {
                    cell = iterator.next();
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) continue;
                    hasItem = true;
                    continue block2;
                }
            }
            if (!hasItem) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAdjustBillResource", (String)"noItemError"));
                SysUtil.abort();
            }
            n = range.size();
            for (i = 0; i < n; ++i) {
                block = (CellBlock)range.getAt(i);
                iterator = sheet.getCellsIterator(block, false, false);
                while (iterator.hasNext()) {
                    cell = iterator.next();
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell) || (formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell)) == null || formulaString.trim().length() <= 0) continue;
                    parameter = BgNFSHelper.parseFormulaPara((Map)this.getFormulaMap(), (String)formulaString);
                    divData = new BgAdjustDiversityData();
                    divData.setFormula(formulaString);
                    if (cell.getValue() != null && cell.getValue().toString().trim().length() > 0) {
                        divData.setNewValue(new BigDecimal(cell.getValue().toString().trim()));
                    } else {
                        divData.setNewValue(BgConstants.BIGZERO);
                    }
                    divData.setParameter(parameter);
                    adjustMap.put(formulaString, divData);
                    LinkedHashMap tmp = new LinkedHashMap();
                    this.setCtrlMap(cell, tmp);
                    adjustCtrlMap.put(formulaString, tmp);
                }
            }
            processUI.setReportInfo(this.getEditData());
            processUI.setAdjustInfo(adjustMap);
            processUI.setAdjustCtrlMap(adjustCtrlMap);
            processUI.updateAdjustMapInfo();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAdjustBillResource", (String)"submitAdjustInfo"));
        }
    }

    private void setCtrlMap(Cell cell, HashMap map) {
        Boolean isCtrl = BgNFSHelper.getItemFormula((Cell)cell).getExt("isCtrl") == null ? Boolean.FALSE : new Boolean(BgNFSHelper.getItemFormula((Cell)cell).getExt("isCtrl").toString());
        Boolean isFlexCtrl = BgNFSHelper.getItemFormula((Cell)cell).getExt("isFlexCtrl") == null ? Boolean.FALSE : new Boolean(BgNFSHelper.getItemFormula((Cell)cell).getExt("isFlexCtrl").toString());
        BigDecimal flexCtrlParam = BgNFSHelper.getItemFormula((Cell)cell).getExt("flexCtrlParam") == null ? new BigDecimal("1.00") : new BigDecimal(BgNFSHelper.getItemFormula((Cell)cell).getExt("flexCtrlParam").toString());
        Integer periodCtrlPolicy = BgNFSHelper.getItemFormula((Cell)cell).getExt("periodCtrlPolicy") == null ? new Integer(-1) : new Integer(BgNFSHelper.getItemFormula((Cell)cell).getExt("periodCtrlPolicy").toString());
        Boolean isGroupCtrl = BgNFSHelper.getItemFormula((Cell)cell).getExt("isGroupCtrl") == null ? Boolean.FALSE : new Boolean(BgNFSHelper.getItemFormula((Cell)cell).getExt("isGroupCtrl").toString());
        Integer groupNo = new Integer(-1);
        if (BgNFSHelper.getItemFormula((Cell)cell).getExt("groupCtrlNo") != null) {
            try {
                groupNo = new Integer(BgNFSHelper.getItemFormula((Cell)cell).getExt("groupCtrlNo").toString());
            }
            catch (NumberFormatException e) {
                groupNo = new Integer(-1);
            }
        }
        Boolean isAllowAccess = BgNFSHelper.getItemFormula((Cell)cell).getExt("isAllowAccess") == null ? Boolean.TRUE : new Boolean(BgNFSHelper.getItemFormula((Cell)cell).getExt("isAllowAccess").toString());
        map.put("isCtrl", isCtrl);
        map.put("isFlexCtrl", isFlexCtrl);
        map.put("flexCtrlParam", flexCtrlParam);
        map.put("periodCtrlPolicy", periodCtrlPolicy);
        map.put("isGroupCtrl", isGroupCtrl);
        map.put("groupCtrlNo", groupNo);
        map.put("isAllowAccess", isAllowAccess);
        if (this.getContextManager().getProvider().getEditValue() instanceof BgFormInfo) {
            map.put("BGTEMPLATE_ID", ((BgFormInfo)this.getContextManager().getProvider().getEditValue()).getBgTemplate().getId().toString());
        }
    }
}

