/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.client.BgNCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.utils.BgCodeRuleCUtils;
import com.kingdee.eas.ma.view.BgViewDimensionCollection;
import com.kingdee.eas.ma.view.BgViewDimensionInfo;
import com.kingdee.eas.ma.view.BgViewFacadeFactory;
import com.kingdee.eas.ma.view.client.AbstractBgReportViewAddNewUI;
import com.kingdee.eas.ma.view.client.common.BgViewClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgReportViewAddNewUI
extends AbstractBgReportViewAddNewUI {
    private static final long serialVersionUID = 160151892931492099L;
    private static final Logger logger = CoreUIObject.getLogger(BgReportViewAddNewUI.class);
    private Map bgViewDimensionColMap = new HashMap();
    private boolean hasOldBgForm = false;

    protected void initTitle() {
        super.initTitle();
        this.setUITitle(BgViewClientHelper.getString("view") + " - " + this.getMessageStr(this.getCcOprtState()));
    }

    protected boolean checkBgTemplateType(int bgTemplateFormType) {
        return 4 == bgTemplateFormType;
    }

    protected void loadData() throws Exception {
        super.loadData();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String OUID = this.editData.getOrgUnit().getId().toString();
            this.getNumberByCodingRule((IObjectValue)this.editData, OUID);
        }
    }

    protected void getNumberByCodingRule(IObjectValue caller, String orgId) {
        BgFormInfo _calller = new BgFormInfo();
        _calller.setSourceType(RptSrcTypeEnum.BGFORMREPORT);
        this.getCodeRule().applyNumber(this.txtNumber, (IObjectValue)_calller, orgId, "sourceType", null);
        this.getCodeRule().applyNumber(this.txtName, (IObjectValue)_calller, orgId, "sourceType", "name");
    }

    protected void comBgTemplate_actionPerformed(ActionEvent e) throws Exception {
        super.comBgTemplate_actionPerformed(e);
        this.checkBgForm();
        this.dealPrmtBgPeriod();
    }

    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriod_dataChanged(e);
        this.checkBgForm();
    }

    protected void comCurrency_itemStateChanged(ItemEvent e) throws Exception {
        this.checkBgForm();
    }

    protected void checkBgForm() throws Exception {
        if (!OprtState.ADDNEW.equals(this.getCcOprtState())) {
            return;
        }
        BgFormInfo old = null;
        if (this.checkCreateName()) {
            this.storeFields();
            old = BgViewFacadeFactory.getRemoteInstance().checkBgForm(this.editData);
        }
        if (old == null) {
            if (this.hasOldBgForm) {
                this.hasOldBgForm = false;
                this.txtNumber.setText(null);
                if (this.getCodeRule().isHasCodeRule()) {
                    this.txtNumber.setEnabled(false);
                    if (this.getCodeRule().isHasShowCodeNumber()) {
                        this.getNumberByCodingRule((IObjectValue)this.editData, this.editData.getOrgUnit().getId().toString());
                    }
                } else {
                    this.txtNumber.setEnabled(true);
                }
                this.txtName.setText(null);
                if (!this.txtName.isEnabled()) {
                    this.storeFields();
                    this.getCodeRule().applyNumber(this.txtName, (IObjectValue)this.editData, this.editData.getOrgUnit().getId().toString(), "sourceType", "name");
                } else {
                    this.updateBgFormName();
                }
                this.txtContent.setEnabled(true);
                this.txtContent.setText(null);
            }
        } else {
            this.hasOldBgForm = true;
            this.txtNumber.setText(old.getNumber());
            this.txtNumber.setEnabled(false);
            this.txtName.setText(old.getName());
            this.txtName.setEnabled(false);
            this.txtContent.setEnabled(false);
            this.txtContent.setText(old.getDescription());
        }
    }

    protected void updateBgFormName() {
        super.updateBgFormName();
        this.getNameCode();
    }

    public void getNameCode() {
        if (OprtState.ADDNEW.equals(this.getCcOprtState()) && this.checkCreateName() && !this.txtName.isEnabled()) {
            this.storeFields();
            this.getCodeRule().applyNumber(this.txtName, (IObjectValue)this.editData, this.editData.getOrgUnit().getId().toString(), "sourceType", "name");
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    protected void beforeLoad() throws Exception {
        super.beforeLoad();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.dealCheckInfo();
        this.comCurrency.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    BgReportViewAddNewUI.this.comCurrency_itemStateChanged(e);
                }
                catch (Exception ex) {
                    logger.error((Object)"", (Throwable)ex);
                    BgReportViewAddNewUI.this.handUIExceptionAndAbort(ex);
                }
            }
        });
    }

    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        Object obj = this.prmtBgScheme.getData();
        if (obj != null && obj instanceof BgSchemeInfo) {
            BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
            this.initTemplateFormBgScheme(_bgSchemeInfo);
            this.initBgViewDimensionFormBgScheme(_bgSchemeInfo);
            this.dealPrmtBgPeriod();
        } else {
            this.prmtBgScheme.setData(null);
            this.comBgTemplate.removeAllItems();
        }
    }

    protected void dealPrmtBgPeriod() throws EASBizException, BOSException {
        BgViewDimensionInfo bgViewDimensionInfo2;
        if (this.comBgTemplate.getSelectedItem() == null || this.prmtBgScheme.getData() == null) {
            return;
        }
        BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)this.comBgTemplate.getSelectedItem();
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtBgScheme.getData();
        Object obj = this.prmtBgPeriod.getData();
        boolean hasDealBgPeriod = false;
        if (bgTemplateInfo != null && this.bgViewDimensionColMap.containsKey(bgTemplateInfo.getId().toString()) && ((bgViewDimensionInfo2 = (BgViewDimensionInfo)this.bgViewDimensionColMap.get(bgTemplateInfo.getId().toString())).getRollMethod().getValue() == 2 || bgViewDimensionInfo2.getRollMethod().getValue() == 1)) {
            IBgPeriod ibgPeriod;
            BgPeriodCollection bgPeriodCol;
            BgPeriodInfo periodInfo;
            Date beginDate = BgHelper.getDayBegin((Date)bgSchemeInfo.getDateFrom());
            Date endDate = BgHelper.getDayBegin((Date)bgSchemeInfo.getDateTo());
            CalendarHelper calendar = new CalendarHelper();
            int periodType = 0;
            this.prmtBgPeriod.setSelector(null);
            this.prmtBgPeriod.setQueryInfo("com.kingdee.eas.ma.nbudget.BgPeriodF7Query");
            if (this.prmtBgPeriod.getEntityViewInfo() == null) {
                this.prmtBgPeriod.setEntityViewInfo(new EntityViewInfo());
            }
            if (this.prmtBgPeriod.getEntityViewInfo().getFilter() == null) {
                this.prmtBgPeriod.getEntityViewInfo().setFilter(new FilterInfo());
            }
            this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().clear();
            this.prmtBgPeriod.getEntityViewInfo().getFilter().setMaskString(null);
            if (bgViewDimensionInfo2.getRollMethod().getValue() == 2) {
                periodType = 1;
                this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)calendar.getCurrentlyYear(beginDate), CompareType.GREATER_EQUALS));
                this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)calendar.getCurrentlyYear(endDate), CompareType.LESS_EQUALS));
                this.prmtBgPeriod.getEntityViewInfo().getFilter().setMaskString("#0 and #1");
            } else if (bgViewDimensionInfo2.getRollMethod().getValue() == 1) {
                periodType = bgViewDimensionInfo2.getRollType().getValue();
                if (1 == periodType) {
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)calendar.getCurrentlyYear(beginDate), CompareType.GREATER_EQUALS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)calendar.getCurrentlyYear(endDate), CompareType.LESS_EQUALS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().setMaskString("#0 and #1");
                } else if (2 == periodType) {
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)calendar.getCurrentlyYear(beginDate), CompareType.GREATER));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)calendar.getCurrentlyYear(endDate), CompareType.LESS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)calendar.getCurrentlyYear(beginDate), CompareType.EQUALS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("halfYear", (Object)calendar.getCurrentlyHalfYear(beginDate), CompareType.GREATER_EQUALS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)calendar.getCurrentlyYear(endDate), CompareType.EQUALS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("halfYear", (Object)calendar.getCurrentlyHalfYear(endDate), CompareType.LESS_EQUALS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().setMaskString("(#0 and #1) or (#2 and #3) or (#4 and #5)");
                } else if (3 == periodType) {
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)calendar.getCurrentlyYear(beginDate), CompareType.GREATER));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)calendar.getCurrentlyYear(endDate), CompareType.LESS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)calendar.getCurrentlyYear(beginDate), CompareType.EQUALS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("quarter", (Object)calendar.getCurrentlyQuarter(beginDate), CompareType.GREATER_EQUALS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)calendar.getCurrentlyYear(endDate), CompareType.EQUALS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("quarter", (Object)calendar.getCurrentlyQuarter(endDate), CompareType.LESS_EQUALS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().setMaskString("(#0 and #1) or (#2 and #3) or (#4 and #5)");
                } else if (4 == periodType) {
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)calendar.getCurrentlyYear(beginDate), CompareType.GREATER));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)calendar.getCurrentlyYear(endDate), CompareType.LESS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)calendar.getCurrentlyYear(beginDate), CompareType.EQUALS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("month", (Object)calendar.getCurrentlyMonth(beginDate), CompareType.GREATER_EQUALS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("year", (Object)calendar.getCurrentlyYear(endDate), CompareType.EQUALS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("month", (Object)calendar.getCurrentlyMonth(endDate), CompareType.LESS_EQUALS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().setMaskString("(#0 and #1) or (#2 and #3) or (#4 and #5)");
                } else if (9 == periodType) {
                    Calendar beginCalendar = Calendar.getInstance();
                    beginCalendar.setTime(beginDate);
                    Calendar endCalendar = Calendar.getInstance();
                    endCalendar.setTime(endDate);
                    int beginDateNum = beginCalendar.get(5);
                    if (beginDateNum >= 0 && beginDateNum <= 10) {
                        beginCalendar.set(5, 1);
                    } else if (beginDateNum >= 11 && beginDateNum <= 20) {
                        beginCalendar.set(5, 11);
                    } else {
                        beginCalendar.set(5, 21);
                    }
                    int endDateNum = endCalendar.get(5);
                    if (endDateNum >= 0 && endDateNum <= 10) {
                        endCalendar.set(5, 10);
                    } else if (endDateNum >= 11 && endDateNum <= 20) {
                        endCalendar.set(5, 20);
                    } else {
                        endCalendar.set(5, endCalendar.getMaximum(5));
                    }
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("beginDate", (Object)beginCalendar.getTime(), CompareType.GREATER_EQUALS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("endDate", (Object)endCalendar.getTime(), CompareType.LESS_EQUALS));
                    this.prmtBgPeriod.getEntityViewInfo().getFilter().setMaskString("#0 and #1");
                }
            }
            this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("periodType", (Object)periodType, CompareType.EQUALS));
            this.prmtBgPeriod.getEntityViewInfo().getFilter().setMaskString("(" + this.prmtBgPeriod.getEntityViewInfo().getFilter().getMaskString() + ") and #" + (this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().size() - 1));
            for (int i = this.prmtBgPeriod.getEntityViewInfo().getSorter().size() - 1; i >= 0; --i) {
                if (!this.prmtBgPeriod.getEntityViewInfo().getSorter().get(i).getPropertyName().equals("number")) continue;
                this.prmtBgPeriod.getEntityViewInfo().getSorter().removeObject(i);
            }
            this.prmtBgPeriod.getEntityViewInfo().getSorter().add(new SorterItemInfo("number"));
            if (!(obj == null || (periodInfo = (BgPeriodInfo)obj).getPeriodType().getValue() == periodType && periodInfo.getBeginDate().after(beginDate) && periodInfo.getEndDate().before(endDate))) {
                this.prmtBgPeriod.setData(null);
            }
            if (OprtState.ADDNEW.equals(this.getCcOprtState()) && (bgPeriodCol = (ibgPeriod = BgPeriodFactory.getRemoteInstance()).getBgPeriodCollection(this.prmtBgPeriod.getEntityViewInfo())).size() > 0) {
                this.prmtBgPeriod.setValue((Object)bgPeriodCol.get(0));
            }
            hasDealBgPeriod = true;
        }
        if (!hasDealBgPeriod) {
            this.prmtBgPeriod.setQueryInfo(null);
            try {
                this.prmtBgPeriod.getEntityViewInfo().getFilter().getFilterItems().clear();
                this.prmtBgPeriod.getEntityViewInfo().getFilter().setMaskString(null);
                this.prmtBgPeriod.getEntityViewInfo().getSorter().clear();
            }
            catch (NullPointerException bgViewDimensionInfo2) {
                // empty catch block
            }
            BgPeriodDialog dialog = null;
            if (this.prmtBgPeriod.getSelector() != null && this.prmtBgPeriod.getSelector() instanceof BgPeriodDialog) {
                dialog = (BgPeriodDialog)this.prmtBgPeriod.getSelector();
                dialog.close();
            }
            dialog = new BgPeriodDialog((CoreUIObject)this);
            dialog.setBgPeriodBeginDate(bgSchemeInfo.getDateFrom());
            dialog.setBgPeriodEndDate(bgSchemeInfo.getDateTo());
            this.prmtBgPeriod.setSelector((KDPromptSelector)dialog);
            if (OprtState.ADDNEW.equals(this.getCcOprtState())) {
                this.prmtBgPeriod.setValue((Object)BgPeriodHelper.getNextPeriodOfDate((int)bgSchemeInfo.getPeriod().getValue(), (Date)bgSchemeInfo.getDateFrom(), (Date)bgSchemeInfo.getDateTo(), null));
            }
        }
    }

    protected void initBgViewDimensionFormBgScheme(BgSchemeInfo bgSchemeInfo) throws Exception {
        this.bgViewDimensionColMap.clear();
        BgViewDimensionCollection bgViewDimensionColl = this.getNFacadeInterface().getBgViewDimensionInfo(bgSchemeInfo.getId().toString(), this.ccOrgUnitInfo.getId().toString(), false, true);
        BgViewDimensionInfo bgViewDimensionInfo = null;
        for (int i = 0; i < bgViewDimensionColl.size(); ++i) {
            bgViewDimensionInfo = bgViewDimensionColl.get(i);
            this.bgViewDimensionColMap.put(bgViewDimensionInfo.getTemplate().getId().toString(), bgViewDimensionInfo);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    public IObjectValue getDataObject() {
        return this.editData;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (StringUtils.isEmpty((String)this.txtName.getText()) && this.txtName.isEnabled()) {
            this.txtName.requestFocus();
            BgNFCHelper.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"noName"));
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            BgPeriodInfo info;
            Object obj;
            if (this.getCodeRule().isHasCodeRule()) {
                if (this.getCodeRule().isHasShowCodeNumber() && StringUtils.isEmpty((String)this.txtNumber.getText())) {
                    this.txtNumber.requestFocus();
                    BgNFCHelper.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"noNumber"));
                }
            } else if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                this.txtNumber.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"noNumber"));
            }
            if (this.prmtBgScheme.getData() == null || !(this.prmtBgScheme.getData() instanceof BgSchemeInfo)) {
                this.prmtBgScheme.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"noBgScheme"));
            }
            if (this.comBgTemplate.getSelectedItem() == null || !(this.comBgTemplate.getSelectedItem() instanceof BgTemplateInfo)) {
                this.comBgTemplate.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"noBgTemplate"));
            }
            if (this.comCurrency.getSelectedItem() == null || !(this.comCurrency.getSelectedItem() instanceof CurrencyInfo)) {
                this.comCurrency.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"noCurrency"));
            }
            if (this.prmtBgPeriod.getData() == null || !(this.prmtBgPeriod.getData() instanceof BgPeriodInfo)) {
                this.prmtBgPeriod.requestFocus();
                BgNFCHelper.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"noPeriod"));
            }
            if ((obj = this.prmtBgPeriod.getData()) != null && obj instanceof BgPeriodInfo && (info = (BgPeriodInfo)obj).getPeriodType().getValue() == 8) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"bgFormSelfDefPeriod"));
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.verify(e);
            if (this.getNFacadeInterface().checkBgFormInfoRepeat(((FullOrgUnitInfo)this.prmtOrgUnit.getData()).getId(), ((BgSchemeInfo)this.prmtBgScheme.getData()).getId(), ((BgTemplateInfo)this.comBgTemplate.getSelectedItem()).getId(), ((BgPeriodInfo)this.prmtBgPeriod.getData()).getId(), ((CurrencyInfo)this.comCurrency.getSelectedItem()).getId())) {
                MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(BgViewClientHelper.getString("checkRepeat"), ((CurrencyInfo)this.comCurrency.getSelectedItem()).getName(), ((BgPeriodInfo)this.prmtBgPeriod.getData()).getName(), ((BgTemplateInfo)this.comBgTemplate.getSelectedItem()).getName()));
                SysUtil.abort();
            }
            this.storeBgFormInfo();
            int flag = MsgBox.showConfirm2New((Component)((Object)this), (String)BgViewClientHelper.getString("addNewConfirm"));
            boolean isBatch = true;
            if (flag == 0) {
                isBatch = true;
            } else if (flag == 1) {
                isBatch = false;
            } else {
                return;
            }
            List orgs = BgViewFacadeFactory.getRemoteInstance().checkNumber(this.editData, isBatch);
            if (orgs != null && !orgs.isEmpty()) {
                boolean hasAllDup = Boolean.TRUE.equals(orgs.get(0));
                String tmp = BgViewClientHelper.getString("numberDetail");
                StringBuffer msg = new StringBuffer();
                for (int i = 1; i < orgs.size(); ++i) {
                    if (i != 1) {
                        msg.append("\n");
                    }
                    OrgUnitInfo o = (OrgUnitInfo)orgs.get(i);
                    msg.append(MessageFormat.format(tmp, o.getNumber(), o.getName(), this.editData.getNumber()));
                }
                int f = MsgBox.showConfirm3((Component)((Object)this), (String)MessageFormat.format(BgViewClientHelper.getString("numberConfirm"), orgs.size() - 1), (String)msg.toString());
                if (hasAllDup || f != 0) {
                    return;
                }
            }
            this.openProgressUI(isBatch);
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            super.actionSubmit_actionPerformed(e);
        }
    }

    public IObjectPK runSubmit() throws Exception {
        return BgViewFacadeFactory.getRemoteInstance().updateBgFormInfo(this.editData);
    }

    protected void openProgressUI(final boolean isBatch) throws Exception {
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgReportViewAddNewUI.this.saveBgFormInfo(isBatch);
                return BgReportViewAddNewUI.this.editData;
            }

            public void afterExec(Object result) throws Exception {
                if (result instanceof IObjectValue) {
                    BgReportViewAddNewUI.this.setHasSubmit(true);
                    BgReportViewAddNewUI.this.destroyWindow();
                    BgNCHelper.refreshListUI((CoreUI)BgReportViewAddNewUI.this);
                }
            }
        });
        dialog.show();
    }

    public BgFormInfo getEditData() {
        return this.editData;
    }

    public void storeBgFormInfo() throws Exception {
        IRow row = null;
        BgTemplateInfo _bgTemplateInfo = null;
        BgMeasureUnitInfo bgMeasureUnit = null;
        _bgTemplateInfo = (BgTemplateInfo)this.comBgTemplate.getSelectedItem();
        _bgTemplateInfo = this.getBgTemplateInfo(_bgTemplateInfo.getId(), true, false);
        this.verifyBookPermission(_bgTemplateInfo);
        this.editData.setData(_bgTemplateInfo.getData());
        this.editData.setTemplateLastUpdateTime(_bgTemplateInfo.getLastUpdateTime());
        int count = this.tblMeasureUnit.getBody().size();
        for (int index = 0; index < count; ++index) {
            row = this.tblMeasureUnit.getRow(index);
            if (row.getCell(4).getValue() == null || !(row.getCell(4).getValue() instanceof MeasureUnitInfo)) continue;
            bgMeasureUnit = new BgMeasureUnitInfo();
            bgMeasureUnit.setBgForm(this.editData);
            bgMeasureUnit.setBgElement((BgElementInfo)row.getUserObject());
            bgMeasureUnit.setMeasureUnit((MeasureUnitInfo)row.getCell(4).getValue());
            this.editData.getBgMeasureUnit().add(bgMeasureUnit);
        }
        if (this.txtNumber.isEnabled() && !this.editData.getNumber().startsWith(this.editData.getBgTemplate().getNumber() + "-")) {
            this.editData.setNumber(this.editData.getBgTemplate().getNumber() + "-" + this.editData.getNumber());
        }
        if (this.getCodeRule().isHasCodeRule() && !this.getCodeRule().isHasShowCodeNumber() && !this.hasOldBgForm) {
            BgFormInfo caller = new BgFormInfo();
            caller.setSourceType(RptSrcTypeEnum.BGFORMREPORT);
            BgCodeRuleCUtils bgCodeRuleCUtils = this.getCodeRule();
            String string = this.editData.getOrgUnit().getId().toString();
            this.getCodeRule();
            bgCodeRuleCUtils.applyNumber(this.txtNumber, (IObjectValue)caller, string, "sourceType", null);
        }
    }

    public void saveBgFormInfo(boolean isBatch) throws Exception {
        String id = BgViewFacadeFactory.getRemoteInstance().addNewViewInfo(this.editData, isBatch);
        if (id != null) {
            this.editData.setId(BOSUuid.read((String)id));
        }
    }

    private void verifyBookPermission(BgTemplateInfo templateInfo) throws Exception {
    }

    public boolean isModify() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            return false;
        }
        return super.isModify();
    }

    protected void dealCheckInfo() throws Exception {
        BgPeriodInfo _bgPeriodInfo;
        BgSchemeInfo _bgSchemeInfo;
        Object obj = this.getUIContext().get("BGFORM_LINK_SCHEME");
        if (obj != null && (_bgSchemeInfo = this.getLinkBgSchemeInfo(obj.toString())) != null) {
            this.prmtBgScheme.setData((Object)_bgSchemeInfo);
        }
        if ((obj = this.getUIContext().get("BGFORM_LINK_TEMPLATE")) != null) {
            this.setSelectBgTemplateInfo(obj.toString());
        }
        if ((obj = this.getUIContext().get("BGFORM_LINK_PERIOD")) != null && (_bgPeriodInfo = this.getLinkBgPeriodInfo(obj.toString())) != null) {
            this.prmtBgPeriod.setData((Object)_bgPeriodInfo);
        }
        if ((obj = this.getUIContext().get("BGFORM_LINK_CURRENCY")) != null) {
            this.setSelectCurrencyInfo(obj.toString());
        }
    }

    protected BgSchemeInfo getLinkBgSchemeInfo(String bgSchemeNumber) throws Exception {
        if (StringUtils.isEmpty((String)bgSchemeNumber)) {
            return null;
        }
        BgSchemeInfo _bgSchemeInfo = null;
        BgSchemeCollection _bgSchemeCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getCcOrgUnitInfo().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)bgSchemeNumber, CompareType.EQUALS));
        view.setFilter(filter);
        IBgScheme ibgScheme = BgSchemeFactory.getRemoteInstance();
        _bgSchemeCol = ibgScheme.getBgSchemeCollection(view);
        if (_bgSchemeCol != null && !_bgSchemeCol.isEmpty()) {
            _bgSchemeInfo = _bgSchemeCol.get(0);
        }
        return _bgSchemeInfo;
    }

    protected void setSelectBgTemplateInfo(String bgTemplateNumber) throws Exception {
        if (StringUtils.isEmpty((String)bgTemplateNumber)) {
            return;
        }
        BgTemplateInfo _bgTemplateInfo = null;
        int in = this.comBgTemplate.getItemCount();
        for (int i = 0; i < in; ++i) {
            _bgTemplateInfo = (BgTemplateInfo)this.comBgTemplate.getItemAt(i);
            if (!bgTemplateNumber.equals(_bgTemplateInfo.getNumber())) continue;
            this.comBgTemplate.setSelectedIndex(i);
            break;
        }
    }

    protected BgPeriodInfo getLinkBgPeriodInfo(String bgPeriodId) throws Exception {
        if (StringUtils.isEmpty((String)bgPeriodId)) {
            return null;
        }
        BgPeriodInfo _bgPeriodInfo = null;
        IBgPeriod ibgPeriod = BgPeriodFactory.getRemoteInstance();
        _bgPeriodInfo = ibgPeriod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(bgPeriodId));
        return _bgPeriodInfo;
    }

    protected void setSelectCurrencyInfo(String currencyId) throws Exception {
        if (StringUtils.isEmpty((String)currencyId)) {
            return;
        }
        CurrencyInfo _currencyInfo = null;
        int in = this.comCurrency.getItemCount();
        for (int i = 0; i < in; ++i) {
            _currencyInfo = (CurrencyInfo)this.comCurrency.getItemAt(i);
            if (!currencyId.equals(_currencyInfo.getId().toString())) continue;
            this.comCurrency.setSelectedIndex(i);
            break;
        }
    }

    public boolean isPrepareDestoryWindow() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("orgUnit.*");
        sic.add("number");
        sic.add("bgScheme.*");
        sic.add("currency");
        sic.add("bgPeriod.*");
        sic.add("creator.*");
        sic.add("name");
        sic.add("bgTemplate");
        sic.add("bgType.*");
        sic.add("measureUnit");
        sic.add("createTime");
        sic.add("description");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        return sic;
    }
}

