/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.budget.BgFormEntryInfo;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.view.BgBillIntegrateFormInfo;
import com.kingdee.eas.ma.view.BgRollRuleInfo;
import com.kingdee.eas.ma.view.client.AbstractBgReportViewPropertyUI;
import com.kingdee.eas.ma.view.client.IViewDimensionCellChange;
import com.kingdee.eas.ma.view.client.common.BgViewClientHelper;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import com.kingdee.eas.util.client.EASResource;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BgReportViewPropertyUI
extends AbstractBgReportViewPropertyUI
implements IViewDimensionCellChange {
    private static final long serialVersionUID = -7205186800442653375L;
    private static final Logger logger = CoreUIObject.getLogger(BgReportViewPropertyUI.class);

    protected void initSystemInfo() throws Exception {
        super.initSystemInfo();
        this.btnSubmit.setVisible(false);
        this.txtName.setEnabled(false);
        this.getStatusBar().setVisible(false);
        BgViewClientHelper.setEnable((JComponent)this.rowAndColLayoutPanel, false);
        BgViewClientHelper.setEnable((JComponent)this.pageAndViewLayoutPanel, false);
        BgViewClientHelper.setEnable((JComponent)this.rulePanel, false);
    }

    protected void initSystemData() throws Exception {
        super.initSystemData();
        if (this.editData.getEntries().isEmpty()) {
            return;
        }
        this.checkTableParsed();
        IRow row = this.tableView.addRow();
        row.getCell("dimension").setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgViewTemplateResource", (String)"currency"));
        BgFormEntryInfo entry = this.editData.getEntries().get(0);
        this.setPrmtRuleSetValue(entry);
        List dimensionList = BgViewHelper.parseData(entry.getDimensionData());
        Map map = BgViewHelper.parseParamter(entry.getDimensionData());
        BgViewClientHelper.fillDimension(dimensionList, map, false, this.checkBoxRowDisplayCJ, this.checkBoxAllowUserAddRow, this.colLayoutTable, this.rowLayoutTable, this.tableView, this.pageDimensionTable, this);
    }

    private void setPrmtRuleSetValue(BgFormEntryInfo entry) {
        BgRollRuleInfo bgRollRuleInfo = new BgRollRuleInfo();
        bgRollRuleInfo.setRollMethod(entry.getRollMethod());
        bgRollRuleInfo.setRollType(entry.getRollType());
        bgRollRuleInfo.setRollLength(entry.getRollLength());
        bgRollRuleInfo.setRollStep(entry.getRollStep());
        bgRollRuleInfo.setFixedLength(entry.getFixedLength());
        bgRollRuleInfo.setOverFlow(entry.getOverFlow());
        this.prmtRuleSet.setData((Object)bgRollRuleInfo);
        this.loadIntegrate(entry);
        if (!BgNSHelper.isEnableBillIntegrate(null) && (entry.getSchemes() == null || entry.getSchemes().isEmpty())) {
            this.pnlBill.setVisible(false);
        } else {
            this.pnlBill.setVisible(true);
        }
    }

    private void loadIntegrate(BgFormEntryInfo entry) {
        if (entry != null) {
            this.tblBill.checkParsed();
            this.tblBill.removeRows();
            for (int i = 0; i < entry.getSchemes().size(); ++i) {
                BgBillIntegrateFormInfo temp = entry.getSchemes().get(i);
                IRow row = this.tblBill.addRow();
                row.setUserObject((Object)temp);
                row.getCell("formState").setValue((Object)temp.getBgFormState());
                row.getCell("scheme").setValue((Object)temp.getScheme());
                row.getCell("level").setValue((Object)temp.getLevel());
            }
        }
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblBill.checkParsed();
        this.pageDimensionTable.checkParsed();
        this.tableView.checkParsed();
        this.rowLayoutTable.checkParsed();
        this.colLayoutTable.checkParsed();
    }

    @Override
    public void cellValueChangeAfter(KDTable table, int rowIndex, int colIndex) {
        BgViewClientHelper.setCellDisplay(table, rowIndex, colIndex, table.getCell(rowIndex, colIndex).getValue());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("orgUnit.*");
        sic.add("number");
        sic.add("bgScheme.*");
        sic.add("currency");
        sic.add("bgPeriod.*");
        sic.add("creator.*");
        sic.add("name");
        sic.add("bgTemplate");
        sic.add("bgType.*");
        sic.add("measureUnit");
        sic.add("createTime");
        sic.add("description");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        sic.add("entries.id");
        sic.add("entries.dimensionData");
        sic.add("entries.rollMethod");
        sic.add("entries.rollType");
        sic.add("entries.rollStep");
        sic.add("entries.rollLength");
        sic.add("entries.overFlow");
        sic.add("entries.rollLength");
        sic.add("entries.fixedLength");
        sic.add("entries.schemes.id");
        sic.add("entries.schemes.seq");
        sic.add("entries.schemes.bgFormState");
        sic.add("entries.schemes.level");
        sic.add("entries.schemes.scheme.id");
        sic.add("entries.schemes.scheme.number");
        sic.add("entries.schemes.scheme.name");
        return sic;
    }
}

