/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgDataFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.view.client.AbstractBgRollHistoryDataUI;
import com.kingdee.eas.ma.view.client.BgReportViewProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgRollHistoryDataUI
extends AbstractBgRollHistoryDataUI {
    private static final Logger logger = CoreUIObject.getLogger(BgRollHistoryDataUI.class);
    private String formula = null;
    private String bgFormId = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initWidget();
        this.initData();
    }

    private void initWidget() {
        this.txtItemNum.setEditable(false);
        this.txtItemName.setEditable(false);
        this.txtElementName.setEditable(false);
        this.txtPeriodName.setEditable(false);
        this.btnView.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    private void initData() throws EASBizException, BOSException {
        this.formula = (String)this.getUIContext().get("hisFormula");
        this.bgFormId = (String)this.getUIContext().get("bgFormInfoId");
        String[] parameter = BgNFSHelper.parseFormulaPara((String)this.formula);
        Map res = BgDataFacadeFactory.getRemoteInstance().getRollHistoryData(this.bgFormId, this.formula);
        String itemName = (String)res.get("ItemName");
        String elementName = (String)res.get("ElementName");
        List versionData = (List)res.get("VersionData");
        this.txtItemNum.setText(parameter[0]);
        this.txtItemName.setText(itemName);
        this.txtElementName.setText(elementName);
        this.txtPeriodName.setText(parameter[1]);
        Object[] dataObj = null;
        IRow row = null;
        this.kDTable1.checkParsed();
        for (int i = 0; i < versionData.size(); ++i) {
            dataObj = (Object[])versionData.get(i);
            row = this.kDTable1.addRow();
            row.setUserObject(dataObj[0]);
            row.getCell(0).setValue(dataObj[1]);
            row.getCell(1).setValue((Object)((BgFormDataSourceEnum)dataObj[2]).getAlias());
            row.getCell(2).setValue(dataObj[3]);
            row.getCell(3).setValue(dataObj[4]);
        }
    }

    @Override
    protected void kDTable1_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            this.checkSelected();
            int rowIndex = this.kDTable1.getSelectManager().getActiveRowIndex();
            String billId = (String)this.kDTable1.getRow(rowIndex).getUserObject();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)billId);
            uiContext.put((Object)"ViewType", (Object)"history");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BgReportViewProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    @Override
    public void actionViewRollForm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.kDTable1.getSelectManager().getActiveRowIndex();
        String billId = (String)this.kDTable1.getRow(rowIndex).getUserObject();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)billId);
        uiContext.put((Object)"ViewType", (Object)"history");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(BgReportViewProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    public void checkSelected() {
        if (this.kDTable1.getRowCount() == 0 || this.kDTable1.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }
}

