/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.view.client.AbstractBgRulesMultiEditUI;
import com.kingdee.eas.ma.view.client.itemmap.BgEditorGeneratorFactory;
import com.kingdee.eas.ma.view.client.rules.BgRuleDataInfo;
import com.kingdee.eas.ma.view.common.BgDataSelector;
import com.kingdee.eas.ma.view.common.IBgDataSynchSelector;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgRulesMultiEditUI
extends AbstractBgRulesMultiEditUI
implements IBgDataSynchSelector {
    private static final Logger logger = CoreUIObject.getLogger(BgRulesMultiEditUI.class);
    public static final String COL_PROPERTY = "property";
    public static final String COL_PROPERTY_VALUE = "propertyValue";
    private BgRuleDataInfo data = null;
    private Set cuIds = new HashSet();
    private boolean isCanceled = true;

    @Override
    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddLine_actionPerformed(e);
        this.addRow(null, null);
    }

    @Override
    protected void btnDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteLine_actionPerformed(e);
        if (this.tblMain.getRowCount() > 1) {
            int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
            this.tblMain.removeRow(rowIndex);
        }
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        boolean isOk = true;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            if (this.tblMain.getCell(i, COL_PROPERTY).getValue() instanceof BgRuleDataInfo) {
                if (!StringUtils.isEmpty((String)((BgRuleDataInfo)this.tblMain.getCell(i, COL_PROPERTY).getValue()).getExpression())) continue;
                isOk = false;
                break;
            }
            isOk = false;
            break;
        }
        if (isOk) {
            if (this.data != null) {
                BgRuleDataInfo temp = null;
                StringBuffer express = new StringBuffer();
                StringBuffer alias = new StringBuffer();
                for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                    String subOql;
                    if (i != 0) {
                        express.append("@");
                        alias.append("@");
                    }
                    temp = (BgRuleDataInfo)this.tblMain.getCell(i, COL_PROPERTY).getValue();
                    express.append(temp.getExpression());
                    alias.append(temp.getAlias());
                    ICell cell = this.tblMain.getCell(i, COL_PROPERTY_VALUE);
                    if (cell.getValue() instanceof String) {
                        String subAlias = (String)cell.getValue();
                        String subOql2 = (String)cell.getUserObject();
                        if (StringUtils.isEmpty((String)subAlias)) continue;
                        alias.append("|").append(subAlias);
                        if (!StringUtils.isEmpty((String)subOql2)) {
                            express.append("|").append(subOql2);
                            continue;
                        }
                        express.append("|").append(subAlias);
                        continue;
                    }
                    if (!(cell.getValue() instanceof BgRuleDataInfo)) continue;
                    BgRuleDataInfo rd = (BgRuleDataInfo)cell.getValue();
                    String subAlias = rd.getAlias() == null ? "" : rd.getAlias().trim();
                    String string = subOql = rd.getExpression() == null ? "" : rd.getExpression().trim();
                    if (subAlias != null && !subAlias.equals("")) {
                        alias.append("|").append(subAlias);
                    }
                    if (subOql != null && !subOql.equals("")) {
                        express.append("|").append(subOql);
                    }
                    if (rd.getExtendExpression() != null && !rd.getExtendExpression().trim().equals("")) {
                        this.data.setExtendExpression(rd.getExtendExpression().trim());
                        continue;
                    }
                    this.data.setExtendExpression(null);
                }
                this.data = BgRuleDataInfo.clone(this.data, true);
                this.data.setExpression(express.toString());
                this.data.setAlias(alias.toString());
                if (this.data.isSetOrgUnit()) {
                    this.data.getCuIds().clear();
                    if (!this.cuIds.isEmpty()) {
                        this.data.getCuIds().addAll(this.cuIds);
                    }
                }
            }
            this.isCanceled = false;
            this.getUIWindow().close();
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"inputBillProperty"));
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        if (e.isCancel() || this.data == null) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row == null) {
            return;
        }
        if (COL_PROPERTY.equals(this.tblMain.getColumnKey(colIndex))) {
            this.buildPropertyValueF7(row);
        } else if (COL_PROPERTY_VALUE.equals(this.tblMain.getColumnKey(colIndex))) {
            ICell cell = this.tblMain.getRow(rowIndex).getCell(colIndex);
            Object obj = cell.getValue();
            if (obj instanceof BgRuleDataInfo) {
                return;
            }
            StringBuffer express = new StringBuffer();
            StringBuffer alias = new StringBuffer();
            Object[] objs = null;
            if (obj instanceof Object[]) {
                objs = (Object[])obj;
            } else if (obj instanceof IObjectCollection) {
                IObjectCollection temp = (IObjectCollection)obj;
                if (!temp.isEmpty()) {
                    objs = temp.toArray();
                }
            } else if (obj != null) {
                objs = new Object[]{obj};
            }
            if (this.data.isSetOrgUnit()) {
                this.cuIds.clear();
                if (objs != null) {
                    for (int i = 0; i < objs.length; ++i) {
                        if (!(objs[i] instanceof OrgUnitInfo) || ((OrgUnitInfo)objs[i]).getCU() == null) continue;
                        this.cuIds.add(((OrgUnitInfo)objs[i]).getCU().getId().toString());
                    }
                }
            }
            if (objs != null && objs.length > 0) {
                for (int i = 0; i < objs.length; ++i) {
                    if (i != 0) {
                        express.append(",");
                        alias.append(",");
                    }
                    if (objs[i] instanceof IObjectValue) {
                        IObjectValue ov = (IObjectValue)objs[i];
                        if (ov.get("name") != null) {
                            alias.append(ov.get("name"));
                        } else {
                            alias.append(ov.get("number"));
                        }
                        express.append(ov.get("number"));
                        continue;
                    }
                    express.append(objs[i]);
                    alias.append(objs[i]);
                }
            }
            cell.setValue((Object)alias.toString());
            cell.setUserObject((Object)express.toString());
        }
    }

    private void buildPropertyValueF7(IRow row) {
        if (this.data != null && this.data.isExtendProperty()) {
            return;
        }
        ICell cell = row.getCell(COL_PROPERTY);
        row.getCell(COL_PROPERTY_VALUE).setValue(null);
        row.getCell(COL_PROPERTY_VALUE).setUserObject(null);
        if (cell.getValue() == null) {
            row.getCell(COL_PROPERTY_VALUE).getStyleAttributes().setLocked(true);
        } else {
            ICellEditor editor;
            row.getCell(COL_PROPERTY_VALUE).getStyleAttributes().setLocked(false);
            String property = "";
            if (cell.getValue() instanceof String) {
                property = cell.getUserObject().toString();
            } else if (cell.getValue() instanceof BgRuleDataInfo) {
                BgRuleDataInfo rd = (BgRuleDataInfo)cell.getValue();
                property = rd.getExpression();
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (this.data != null) {
                params.put("BILL_META", this.data.getEntity());
                params.put("ENABLE_MULTI_SELECT", Boolean.TRUE);
            }
            if ((editor = BgEditorGeneratorFactory.getEditor(this.data.getEntity().getFullName(), property, params)) != null) {
                row.getCell(COL_PROPERTY_VALUE).setEditor(editor);
            }
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(Object data) {
        if (data instanceof BgRuleDataInfo) {
            this.data = (BgRuleDataInfo)data;
            this.loadDataSet();
        }
    }

    private void loadDataSet() {
        if (this.data != null) {
            this.contMain.setTitle(this.data.getColName());
            this.btnAddLine.setEnabled(this.data.isCanMultiRow());
            this.btnDeleteLine.setEnabled(this.data.isCanMultiRow());
            this.tblMain.checkParsed();
            this.tblMain.getColumn(COL_PROPERTY).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)BgDataSelector.getPromptBox(this, "com.kingdee.eas.ma.view.client.BgRuleSelectUI")));
            if (this.data.isExtendProperty()) {
                this.tblMain.getColumn(COL_PROPERTY_VALUE).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)BgDataSelector.getPromptBox(this, "com.kingdee.eas.ma.view.client.BgFormulaUI")));
            }
            if (StringUtils.isEmpty((String)this.data.getExpression())) {
                this.addRow(null, null);
            } else {
                String[] exprs = this.data.getExpression().split("@");
                String[] aliases = this.data.getAlias().split("@");
                for (int i = 0; i < exprs.length; ++i) {
                    this.addRow(exprs[i], aliases[i]);
                }
            }
        }
    }

    private void addRow(String expr, String alias) {
        if (this.data == null) {
            return;
        }
        String[] subExprs = null;
        String[] subAliases = null;
        if (!StringUtils.isEmpty((String)expr)) {
            subExprs = expr.split("\\|");
        }
        if (!StringUtils.isEmpty((String)alias)) {
            subAliases = alias.split("\\|");
        }
        IRow row = this.tblMain.addRow();
        BgRuleDataInfo info = BgRuleDataInfo.clone(this.data);
        if (subExprs != null) {
            info.setExpression(subExprs[0]);
        }
        if (subAliases != null) {
            info.setAlias(subAliases[0]);
        }
        row.getCell(COL_PROPERTY).setValue((Object)info);
        this.buildPropertyValueF7(row);
        if (this.data.isExtendProperty()) {
            BgRuleDataInfo pv = BgRuleDataInfo.clone(this.data);
            if (subExprs != null && subExprs.length == 2) {
                pv.setExpression(subExprs[1]);
            }
            if (subAliases != null && subAliases.length == 2) {
                pv.setAlias(subAliases[1]);
            }
            pv.setExtendExpression(this.data.getExtendExpression());
            row.getCell(COL_PROPERTY_VALUE).setValue((Object)pv);
        } else {
            if (subAliases != null && subAliases.length == 2) {
                row.getCell(COL_PROPERTY_VALUE).setValue((Object)subAliases[1]);
            }
            if (subExprs != null && subExprs.length == 2) {
                row.getCell(COL_PROPERTY_VALUE).setUserObject((Object)subExprs[1]);
            }
        }
    }

    @Override
    public boolean isCancel() {
        return this.isCanceled;
    }
}

