/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.budget.BgDataFactory;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemGroupCollection;
import com.kingdee.eas.ma.budget.BgItemGroupFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgItemGroup;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.view.client.AbstractEditDimensionMembersUI;
import com.kingdee.eas.ma.view.client.BgReportViewProcessUI;
import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.BgDimensionMember;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class EditDimensionMembersUI
extends AbstractEditDimensionMembersUI {
    private static final Logger logger = CoreUIObject.getLogger(EditDimensionMembersUI.class);
    private IBgDimensionManager dimensionManager;
    private String orgUnitId;
    private BgItemCollection bgItemCollectionForLeft = new BgItemCollection();
    private Map<String, BgItemCollection> bgItemMapForRight = new HashMap<String, BgItemCollection>();
    private Vector<BgItemGroupInfo> bgRowDimensionVector = new Vector();
    private static final String COL_NUMBER = "number";
    private static final String COL_NAME = "name";
    private boolean isCancel = true;
    private static final String EditDimensionMembersResource = "com.kingdee.eas.ma.view.client.EditDimensionMembersResource";
    private Set notEditItem;
    private BigDecimal versionNo;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initStyle();
        this.initData();
        this.deleteTemplateItem();
    }

    private void deleteTemplateItem() {
        if (this.notEditItem == null || this.notEditItem.isEmpty()) {
            return;
        }
        this.deleteNotEditItem(this.leftTable);
        this.deleteNotEditItem(this.rightTable);
    }

    private void deleteNotEditItem(KDTable table) {
        if (table == null) {
            return;
        }
        int rowCount = table.getRowCount();
        if (rowCount == 0) {
            return;
        }
        for (int index = rowCount - 1; index >= 0; --index) {
            IRow row = table.getRow(index);
            if (!this.notEditItem.contains(row.getCell(COL_NUMBER).getValue().toString())) continue;
            table.removeRow(index);
        }
    }

    protected void initStyle() {
        this.leftTable.checkParsed();
        this.rightTable.checkParsed();
        this.leftTable.getStyleAttributes().setLocked(true);
        this.rightTable.getStyleAttributes().setLocked(true);
        this.leftTable.getSelectManager().setSelectMode(10);
        this.rightTable.getSelectManager().setSelectMode(10);
    }

    protected void initData() throws BOSException, EASBizException, SQLException {
        this.dimensionManager = (IBgDimensionManager)this.getUIContext().get("BgDimensionManager");
        this.versionNo = (BigDecimal)this.getUIContext().get("BgFormVersion");
        this.orgUnitId = (String)this.getUIContext().get("ORGUNITID");
        List list = this.dimensionManager.getDimension();
        List rowDimension = this.dimensionManager.getRowDimension();
        IBgItemGroup bgItemGroup = BgItemGroupFactory.getRemoteInstance();
        HashSet<String> itemGroupNums = new HashSet<String>();
        for (BgDimensionInfo obj : rowDimension) {
            if (!"BGITEM".equalsIgnoreCase(obj.getType())) continue;
            itemGroupNums.add(obj.getAttributeNumber());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo(COL_NUMBER, itemGroupNums, CompareType.INCLUDE));
        viewInfo.getSorter().add(new SorterItemInfo(COL_NUMBER));
        BgItemGroupCollection itemGroupCollection = bgItemGroup.getBgItemGroupCollection(viewInfo);
        if (itemGroupCollection.size() == 0) {
            return;
        }
        BgItemGroupInfo itemGroupInfo = null;
        for (int i = 0; i < itemGroupCollection.size(); ++i) {
            itemGroupInfo = itemGroupCollection.get(i);
            this.bgRowDimensionVector.add(itemGroupInfo);
        }
        this.ItemGroupComBox.addItems(this.bgRowDimensionVector);
        HashSet<String> itemNumbers = new HashSet<String>();
        for (BgDimensionInfo obj : rowDimension) {
            for (Object member : obj.getMember()) {
                String itemNumber;
                if (((BgDimensionMember)member).isAllowEdit() && ((BgDimensionMember)member).getVersion().compareTo(this.versionNo) >= 0) {
                    itemNumber = ((BgDimensionMember)member).getNumber();
                    itemNumbers.add(itemNumber);
                    continue;
                }
                if (this.notEditItem == null) {
                    this.notEditItem = new HashSet();
                }
                itemNumber = ((BgDimensionMember)member).getNumber();
                this.notEditItem.add(itemNumber);
            }
        }
        if (itemNumbers.size() > 0) {
            IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.ma.budget.BgItemQuery"));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(COL_NUMBER, itemNumbers, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg((String)this.orgUnitId), CompareType.EQUALS));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo(COL_NUMBER));
            selector.add(new SelectorItemInfo("longNumber"));
            selector.add(new SelectorItemInfo("level"));
            selector.add(new SelectorItemInfo(COL_NAME));
            selector.add(new SelectorItemInfo("refField"));
            selector.add(new SelectorItemInfo("specialNumber"));
            selector.add(new SelectorItemInfo("bgItemGroup.id"));
            selector.add(new SelectorItemInfo("bgItemGroup.number"));
            view.getSelector().addObjectCollection((IObjectCollection)selector);
            view.setFilter(filter);
            queryExecutor.setObjectView(view);
            IRowSet rowSet = queryExecutor.executeQuery();
            while (rowSet.next()) {
                BgItemInfo itemInfo = this.createBgItem(rowSet);
                BgItemCollection itemCollection = this.bgItemMapForRight.get(itemInfo.getBgItemGroup().getNumber());
                if (itemCollection == null) {
                    itemCollection = new BgItemCollection();
                    this.bgItemMapForRight.put(itemInfo.getBgItemGroup().getNumber(), itemCollection);
                }
                itemCollection.add(itemInfo);
            }
            this.refreshRightTable();
        }
        this.leftTable.removeRows();
        this.loadLeftTable();
    }

    protected void loadLeftTable() throws EASBizException, BOSException {
        BgItemInfo itemInfo;
        BgItemGroupInfo itemGroupInfo = (BgItemGroupInfo)this.ItemGroupComBox.getSelectedItem();
        OrgUnitInfo ou = CostCenterOrgUnitFactory.getRemoteInstance().getOrgUnitInfo("select longnumber where id='" + this.orgUnitId + "'");
        String longNumber = ou.getLongNumber();
        IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.ma.budget.BgItemQuery"));
        queryExecutor.setObjectView(" WHERE bgItemGroup.id = '" + itemGroupInfo.getId() + "' and isEffective = 1 order by number");
        EntityViewInfo viewInfo = queryExecutor.getObjectView();
        FilterInfo filter = viewInfo.getFilter();
        int maskSize = filter.getFilterItems().size();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg((String)this.orgUnitId), CompareType.EQUALS));
        if (StringUtils.isEmpty((String)filter.getMaskString())) {
            filter.setMaskString("#0");
        } else {
            filter.setMaskString("(" + filter.getMaskString() + ") and #" + String.valueOf(maskSize));
        }
        if (!BgSHelper.isBgItemIsolate()) {
            filter = BgSHelper.getFilter((FilterInfo)filter, (String)longNumber);
        }
        queryExecutor.setObjectView(viewInfo);
        IRowSet rowSet = queryExecutor.executeQuery();
        this.bgItemCollectionForLeft.clear();
        try {
            while (rowSet.next()) {
                itemInfo = this.createBgItem(rowSet);
                BgItemCollection itemCollection = this.bgItemMapForRight.get(itemInfo.getBgItemGroup().getNumber());
                if (itemCollection != null && itemCollection.contains(itemInfo)) continue;
                this.bgItemCollectionForLeft.add(itemInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        itemInfo = null;
        for (int i = 0; i < this.bgItemCollectionForLeft.size(); ++i) {
            itemInfo = this.bgItemCollectionForLeft.get(i);
            this.addRowToTable(itemInfo, this.leftTable, false);
        }
    }

    protected void refreshRightTable() {
        this.rightTable.removeRows();
        BgItemGroupInfo itemGroupInfo = (BgItemGroupInfo)this.ItemGroupComBox.getSelectedItem();
        BgItemCollection itemCollection = this.bgItemMapForRight.get(itemGroupInfo.getNumber());
        if (itemCollection != null) {
            BgItemInfo info = null;
            for (int i = 0; i < itemCollection.size(); ++i) {
                info = itemCollection.get(i);
                this.addRowToTable(info, this.rightTable, true);
            }
        }
    }

    private void addRowToTable(BgItemInfo info, KDTable table, boolean add) {
        if (info == null || table == null) {
            return;
        }
        if (add) {
            this.bgItemCollectionForLeft.remove(info);
            this.addToLeftMap(info);
        } else {
            this.bgItemCollectionForLeft.add(info);
            this.delFroLeftMap(info);
        }
        IRow row = table.addRow();
        row.setUserObject((Object)info);
        row.getCell(COL_NUMBER, true).setValue((Object)info.getNumber());
        row.getCell(COL_NAME, true).setValue((Object)info.getName());
    }

    private void addToLeftMap(BgItemInfo info) {
        BgItemCollection itemCollection = this.bgItemMapForRight.get(info.getBgItemGroup().getNumber());
        if (itemCollection == null) {
            itemCollection = new BgItemCollection();
            itemCollection.add(info);
            this.bgItemMapForRight.put(info.getBgItemGroup().getNumber(), itemCollection);
        } else if (!itemCollection.contains(info)) {
            itemCollection.add(info);
        }
    }

    private void delFroLeftMap(BgItemInfo info) {
        BgItemCollection itemCollection = this.bgItemMapForRight.get(info.getBgItemGroup().getNumber());
        if (itemCollection != null) {
            itemCollection.remove(info);
        }
    }

    private BgItemInfo createBgItem(IRowSet rowSet) throws SQLException {
        String id = rowSet.getString("id");
        String number = rowSet.getString(COL_NUMBER);
        String longNumber = rowSet.getString("longNumber");
        int level = rowSet.getInt("level");
        String name = rowSet.getString(COL_NAME);
        String refField = rowSet.getString("refField");
        String specialNumber = rowSet.getString("specialNumber");
        String bgItemGroupId = rowSet.getString("bgItemGroup.id");
        String bgItemGroupNumber = rowSet.getString("bgItemGroup.number");
        BgItemInfo item = new BgItemInfo();
        item.setNumber(number);
        item.setLongNumber(longNumber);
        item.setLevel(level);
        item.setName(name);
        item.setRefField(refField);
        item.setSpecialNumber(specialNumber);
        item.setId(BOSUuid.read((String)id));
        BgItemGroupInfo group = new BgItemGroupInfo();
        group.setId(BOSUuid.read((String)bgItemGroupId));
        group.setNumber(bgItemGroupNumber);
        item.setBgItemGroup(group);
        return item;
    }

    protected void initWorkButton() {
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAdd.setEnabled(true);
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnRemove.setEnabled(true);
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnAddAll.setEnabled(true);
        this.btnRemoveAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnRemoveAll.setEnabled(true);
        this.btnOk.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.setCancel(false);
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setCancel(true);
        this.getUIWindow().close();
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        List selectRowIndex = BgViewHelper.getSelectRowIndexes(this.leftTable);
        ArrayList<Integer> needDeleteRowIndex = new ArrayList<Integer>();
        for (int n = 0; n < selectRowIndex.size(); ++n) {
            int rowIndex = Integer.parseInt(selectRowIndex.get(n).toString());
            Object obj = this.leftTable.getRow(rowIndex).getUserObject();
            if (obj == null || !(obj instanceof BgItemInfo)) continue;
            this.addRowToTable((BgItemInfo)obj, this.rightTable, true);
            needDeleteRowIndex.add(rowIndex);
        }
        this.deleteRow(this.leftTable, needDeleteRowIndex);
    }

    private void checkBgItem(KDTable table, List indexList) throws Exception {
        if (indexList == null || indexList.size() == 0) {
            return;
        }
        HashMap<Object, Object> itemMap = new HashMap<Object, Object>();
        int index = 0;
        Object row = null;
        Object itemNumber = null;
        for (int i = 0; i < indexList.size(); ++i) {
            index = Integer.parseInt(indexList.get(i).toString());
            itemNumber = table.getRow(index).getCell(COL_NUMBER).getValue();
            itemMap.put(itemNumber, itemNumber);
        }
        BgReportViewProcessUI ui = (BgReportViewProcessUI)this.getUIContext().get("Owner");
        BgFormInfo info = ui.getEditData();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizActual", (Object)0, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgFormId", (Object)info.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        CoreBaseCollection coll = BgDataFactory.getRemoteInstance().getCollection(view);
        if (coll == null || coll.size() == 0) {
            return;
        }
        String formula = null;
        String[] formulas = null;
        for (int i = 0; i < coll.size(); ++i) {
            BgDataInfo bgData = (BgDataInfo)coll.get(i);
            formula = bgData.getFormula();
            formulas = BgNFSHelper.parseFormulaPara((String)formula);
            if (!itemMap.containsKey(formulas[0])) continue;
            StringBuffer msg = new StringBuffer();
            msg.append(EASResource.getString((String)EditDimensionMembersResource, (String)"title_show_bgitem"));
            msg.append(formulas[0]);
            msg.append(EASResource.getString((String)EditDimensionMembersResource, (String)"title_show_warn1"));
            MsgBox.showError((String)msg.toString());
            SysUtil.abort();
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        Object obj;
        int rowIndex;
        int n;
        List selectRowIndex = BgViewHelper.getSelectRowIndexes(this.rightTable);
        ArrayList<Integer> needDeleteRowIndex = new ArrayList<Integer>();
        for (n = 0; n < selectRowIndex.size(); ++n) {
            rowIndex = Integer.parseInt(selectRowIndex.get(n).toString());
            obj = this.rightTable.getRow(rowIndex).getUserObject();
            if (obj == null || !(obj instanceof BgItemInfo)) continue;
            this.addRowToTable((BgItemInfo)obj, this.leftTable, false);
            needDeleteRowIndex.add(rowIndex);
        }
        this.checkBgItem(this.rightTable, needDeleteRowIndex);
        for (n = 0; n < selectRowIndex.size(); ++n) {
            rowIndex = Integer.parseInt(selectRowIndex.get(n).toString());
            obj = this.rightTable.getRow(rowIndex).getUserObject();
            if (obj == null || !(obj instanceof BgItemInfo)) continue;
            this.addRowToTable((BgItemInfo)obj, this.leftTable, false);
        }
        this.deleteRow(this.rightTable, needDeleteRowIndex);
    }

    @Override
    public void actionRemoveAll_actionPerformed(ActionEvent e) throws Exception {
        Object obj;
        int n;
        ArrayList<Integer> needDeleteRowIndex = new ArrayList<Integer>();
        for (n = 0; n < this.rightTable.getRowCount(); ++n) {
            obj = this.rightTable.getRow(n).getUserObject();
            if (obj == null || !(obj instanceof BgItemInfo)) continue;
            this.addRowToTable((BgItemInfo)obj, this.leftTable, false);
            needDeleteRowIndex.add(n);
        }
        this.checkBgItem(this.rightTable, needDeleteRowIndex);
        for (n = 0; n < this.rightTable.getRowCount(); ++n) {
            obj = this.rightTable.getRow(n).getUserObject();
            if (obj == null || !(obj instanceof BgItemInfo)) continue;
            this.addRowToTable((BgItemInfo)obj, this.leftTable, false);
        }
        this.deleteRow(this.rightTable, needDeleteRowIndex);
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<Integer> needDeleteRowIndex = new ArrayList<Integer>();
        for (int n = 0; n < this.leftTable.getRowCount(); ++n) {
            Object obj = this.leftTable.getRow(n).getUserObject();
            if (obj == null || !(obj instanceof BgItemInfo)) continue;
            this.addRowToTable((BgItemInfo)obj, this.rightTable, true);
            needDeleteRowIndex.add(n);
        }
        this.deleteRow(this.leftTable, needDeleteRowIndex);
    }

    private void deleteRow(KDTable table, List list) {
        if (table == null || list == null || list.isEmpty()) {
            return;
        }
        for (int n = list.size(); n > 0; --n) {
            table.removeRow(Integer.parseInt(list.get(n - 1).toString()));
        }
    }

    @Override
    protected void ItemGroupComBox_actionPerformed(ActionEvent e) throws Exception {
        this.leftTable.removeRows();
        this.loadLeftTable();
        this.refreshRightTable();
        this.deleteTemplateItem();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public BgItemCollection getBgItemCollectionForLeft() {
        return this.bgItemCollectionForLeft;
    }

    public Map<String, BgItemCollection> getBgItemMapForRight() {
        return this.bgItemMapForRight;
    }
}

