/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client;

import com.kingdee.bos.ctrl.analysis.bicomponent.BIComponentResource;
import com.kingdee.bos.ctrl.analysis.bicomponent.layout.ComponentDragSource;
import com.kingdee.bos.ctrl.analysis.bicomponent.layout.DivSpanPanel;
import com.kingdee.bos.ctrl.analysis.bicomponent.layout.PanelDropTarget;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.ma.view.client.DimComponent;
import com.kingdee.eas.ma.view.client.common.BgViewClientHelper;
import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class LayoutDesignerUI
extends KDDialog
implements DragGestureListener {
    private IBgDimensionManager bgDimensionManager;
    private Map dimComponentMap = new HashMap();
    private boolean isOK = false;
    private boolean isTemplate = false;
    private List pageDimensionTemplate;
    BorderLayout borderLayout1 = new BorderLayout();
    KDPanel KDPanel7 = new KDPanel();
    KDPanel KDPanel1 = new KDPanel();
    KDButton jbOK = new KDButton();
    KDButton jbCancel = new KDButton();
    DivSpanPanel jpSpan = new DivSpanPanel();
    KDPanel jpSlicer = new KDPanel();
    KDPanel jpLeft = new KDPanel();
    KDPanel jpTop = new KDPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    KDPanel KDPanel6 = new KDPanel();
    KDPanel KDPanel8 = new KDPanel();
    KDPanel KDPanel9 = new KDPanel();
    KDButton jbTest = new KDButton();
    ContainerListener cl = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            this.fireSpanChanged();
            ((KDPanel)e.getSource()).updateUI();
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            this.fireSpanChanged();
            ((KDPanel)e.getSource()).updateUI();
        }

        private void fireSpanChanged() {
            int r = LayoutDesignerUI.this.jpLeft.getComponentCount();
            int c = LayoutDesignerUI.this.jpTop.getComponentCount();
            String[] rows = new String[r];
            String[] cols = new String[c];
            LayoutDesignerUI.this.jpSpan.setDiv(rows, cols);
            LayoutDesignerUI.this.jpSpan.updateUI();
        }
    };

    public LayoutDesignerUI() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init();
    }

    public LayoutDesignerUI(Dialog owner) throws HeadlessException {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init();
    }

    public LayoutDesignerUI(Frame owner) throws HeadlessException {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init();
    }

    public boolean showDialog() {
        this.dimComponentMap.clear();
        this.jpLeft.removeAll();
        this.jpTop.removeAll();
        this.jpSlicer.removeAll();
        try {
            List rowDimensionList = this.bgDimensionManager.getRowDisplayDimension();
            for (int i = 0; i < rowDimensionList.size(); ++i) {
                BgDimensionInfo dimensionInfo = (BgDimensionInfo)rowDimensionList.get(i);
                this.buildDimComponent(dimensionInfo, this.jpLeft);
            }
            List colDimensionList = this.bgDimensionManager.getColDisplayDimension();
            for (int i = 0; i < colDimensionList.size(); ++i) {
                BgDimensionInfo dimensionInfo = (BgDimensionInfo)colDimensionList.get(i);
                this.buildDimComponent(dimensionInfo, this.jpTop);
            }
            List pageDimensionList = this.bgDimensionManager.getPageDisplayDimension();
            this.setPageDimensionTemplate(pageDimensionList);
            for (int i = 0; i < pageDimensionList.size(); ++i) {
                BgDimensionInfo dimensionInfo = (BgDimensionInfo)pageDimensionList.get(i);
                this.buildDimComponent(dimensionInfo, this.jpSlicer);
            }
            this.setVisible(true);
        }
        catch (Exception e) {
            WindowUtil.alert((Component)((Object)this), (String)e.getMessage());
            return false;
        }
        return this.isOK;
    }

    private String getName(BgDimensionInfo dimensionInfo) {
        String name = null;
        name = "bgitem".equalsIgnoreCase(dimensionInfo.getType()) ? dimensionInfo.getAttribute().split(",")[1] : EASResource.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)dimensionInfo.getType());
        return name;
    }

    private void buildDimComponent(BgDimensionInfo dimensionInfo, KDPanel p) {
        DimComponent dc = new DimComponent(this.getName(dimensionInfo));
        String type = dimensionInfo.getType();
        if (this.isTemplate() && p == this.jpSlicer && ("CURRENCY".equals(type) || "ORGUNIT".equals(type))) {
            new ComponentDragSource((Component)((Object)dc), 0);
        } else {
            new ComponentDragSource((Component)((Object)dc), 2);
        }
        this.dimComponentMap.put(dc, dimensionInfo);
        p.add((Component)((Object)dc), null);
    }

    private void jbInit() throws Exception {
        this.setSize(465, 350);
        this.setTitle(BIComponentResource.getString(BIComponentResource.class, (String)"LayoutDesigner"));
        this.getContentPane().setLayout(this.borderLayout1);
        this.jbOK.setText(BIComponentResource.getString(BIComponentResource.class, (String)"OK"));
        this.jbCancel.setText(BIComponentResource.getString(BIComponentResource.class, (String)"Cancel"));
        this.KDPanel1.setLayout((LayoutManager)this.gridBagLayout1);
        this.jpSpan.setBorder(BorderFactory.createEtchedBorder());
        this.jpTop.setBorder(BorderFactory.createEtchedBorder());
        this.jpTop.setMinimumSize(new Dimension(100, 70));
        this.jpTop.setPreferredSize(new Dimension(100, 70));
        this.jpLeft.setBorder(BorderFactory.createEtchedBorder());
        this.jpLeft.setMinimumSize(new Dimension(100, 14));
        this.jpLeft.setPreferredSize(new Dimension(100, 14));
        this.jpSlicer.setBorder(BorderFactory.createEtchedBorder());
        this.jpSlicer.setMinimumSize(new Dimension(100, 14));
        this.jpSlicer.setPreferredSize(new Dimension(100, 14));
        this.KDPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jbOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutDesignerUI.this.jbOK_actionPerformed(e);
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayoutDesignerUI.this.jbCancel_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.KDPanel7, "South");
        this.KDPanel7.add((Component)this.jbOK, null);
        this.KDPanel7.add((Component)this.jbCancel, null);
        this.KDPanel7.add((Component)this.jbTest, null);
        this.getContentPane().add((Component)this.KDPanel1, "Center");
        this.KDPanel1.add((Component)this.jpSpan, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.KDPanel1.add((Component)this.jpTop, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.KDPanel1.add((Component)this.jpLeft, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.KDPanel1.add((Component)this.jpSlicer, (Object)new GridBagConstraints(1, 1, 1, 1, 10.0, 10.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.getContentPane().add((Component)this.KDPanel6, "West");
        this.getContentPane().add((Component)this.KDPanel8, "East");
        this.getContentPane().add((Component)this.KDPanel9, "North");
    }

    private void init() {
        this.setModal(true);
        this.jbTest.setVisible(false);
        this.enableEvents(64L);
        WindowUtil.makeCneterBounds((Window)((Object)this));
        this.jpTop.setLayout((LayoutManager)new FlowLayout(0));
        this.jpSlicer.setLayout((LayoutManager)new FlowLayout(0));
        new PanelDropTarget((JPanel)this.jpSlicer);
        new PanelDropTarget((JPanel)this.jpLeft);
        new PanelDropTarget((JPanel)this.jpTop);
        this.setDefaultCloseOperation(2);
        this.jpLeft.addContainerListener(this.cl);
        this.jpTop.addContainerListener(this.cl);
        this.jpSlicer.addContainerListener(this.cl);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
    }

    void jbCancel_actionPerformed(ActionEvent e) {
        this.close(false);
    }

    void jbOK_actionPerformed(ActionEvent e) {
        if (this.verify()) {
            this.close(true);
        }
    }

    boolean verify() {
        String errorMsg = null;
        List<BgDimensionInfo> rowDimensionList = this.getRowDimension();
        List<BgDimensionInfo> colDimensionList = this.getColumnDimension();
        if (rowDimensionList.size() == 0 || colDimensionList.size() == 0) {
            errorMsg = BgViewClientHelper.getString("LayoutNullError");
        }
        if (errorMsg != null) {
            MsgBox.showWarning((Component)((Object)this), (String)errorMsg);
            return false;
        }
        return true;
    }

    public List<BgDimensionInfo> getRowDimension() {
        return this.getDimension(this.jpLeft);
    }

    public List<BgDimensionInfo> getColumnDimension() {
        return this.getDimension(this.jpTop);
    }

    public List<BgDimensionInfo> getPageDimension() {
        return this.getDimension(this.jpSlicer);
    }

    private List<BgDimensionInfo> getDimension(KDPanel parent) {
        ArrayList<BgDimensionInfo> hList = new ArrayList<BgDimensionInfo>();
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            if (!this.dimComponentMap.containsKey(c)) continue;
            hList.add((BgDimensionInfo)this.dimComponentMap.get(c));
        }
        return hList;
    }

    private void close(boolean ok) {
        this.isOK = ok;
        this.dispose();
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.close(false);
        } else {
            super.processWindowEvent(e);
        }
    }

    public void setBgDimensionManager(IBgDimensionManager bgDimensionManager) {
        this.bgDimensionManager = bgDimensionManager;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setTemplate(boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    public List getPageDimensionTemplate() {
        return this.pageDimensionTemplate;
    }

    public void setPageDimensionTemplate(List pageDimensionTemplate) {
        this.pageDimensionTemplate = pageDimensionTemplate;
    }
}

