/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.view.BgRollMethodEnum;
import com.kingdee.eas.ma.view.BgRollRuleInfo;
import com.kingdee.eas.ma.view.client.AbstractRollRuleSetUI;
import com.kingdee.eas.ma.view.client.common.BgViewClientHelper;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class RollRuleSetUI
extends AbstractRollRuleSetUI {
    private static final Logger logger = CoreUIObject.getLogger(RollRuleSetUI.class);
    BgRollRuleInfo bgRollRuleInfo = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initData();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnOk.setEnabled(false);
            this.btnCancel.setEnabled(true);
        } else {
            this.btnOk.setEnabled(true);
            this.btnCancel.setEnabled(true);
        }
    }

    private void initData() {
        ((SpinnerNumberModel)this.spinRollStep.getModel()).setMinimum(new Integer(1));
        ((SpinnerNumberModel)this.spinRollLength.getModel()).setMinimum(new Integer(1));
        ((SpinnerNumberModel)this.spinRollOverflow.getModel()).setMinimum(new Integer(1));
        ((SpinnerNumberModel)this.spinFixedLength.getModel()).setMinimum(new Integer(1));
        Map uiContext = this.getUIContext();
        if (uiContext.get("BgRollRuleInfo") != null) {
            this.bgRollRuleInfo = (BgRollRuleInfo)uiContext.get("BgRollRuleInfo");
        }
        if (this.bgRollRuleInfo == null) {
            this.bgRollRuleInfo = new BgRollRuleInfo();
        }
        if (this.bgRollRuleInfo != null && this.bgRollRuleInfo.getRollMethod() != null) {
            this.comboRollMethod.setSelectedItem((Object)this.bgRollRuleInfo.getRollMethod());
            this.comboRollPeriodType.setSelectedItem((Object)this.bgRollRuleInfo.getRollType());
            this.spinRollStep.setValue((Object)this.bgRollRuleInfo.getRollStep());
            this.spinRollLength.setValue((Object)this.bgRollRuleInfo.getRollLength());
            this.spinRollOverflow.setValue((Object)this.bgRollRuleInfo.getOverFlow());
            this.spinFixedLength.setValue((Object)this.bgRollRuleInfo.getFixedLength());
        } else {
            this.reSetValue();
        }
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verify()) {
            return;
        }
        Object selectMethodObj = this.comboRollMethod.getSelectedItem();
        Object selectTypeObj = this.comboRollPeriodType.getSelectedItem();
        this.bgRollRuleInfo.setRollMethod((BgRollMethodEnum)((Object)selectMethodObj));
        this.bgRollRuleInfo.setRollType((BgPeriodEnum)selectTypeObj);
        this.bgRollRuleInfo.setRollStep((Integer)this.spinRollStep.getValue());
        this.bgRollRuleInfo.setRollLength((Integer)this.spinRollLength.getValue());
        if (((BgRollMethodEnum)((Object)selectMethodObj)).getValue() == 1) {
            this.bgRollRuleInfo.setOverFlow(0);
            this.bgRollRuleInfo.setFixedLength(0);
        } else if (((BgRollMethodEnum)((Object)selectMethodObj)).getValue() == 2) {
            this.bgRollRuleInfo.setOverFlow((Integer)this.spinRollOverflow.getValue());
            this.bgRollRuleInfo.setFixedLength((Integer)this.spinFixedLength.getValue());
        }
        this.destroyWindow();
    }

    public boolean verify() throws Exception {
        Object selectMethodObj = this.comboRollMethod.getSelectedItem();
        if (((BgRollMethodEnum)((Object)selectMethodObj)).getValue() != 2 && ((BgRollMethodEnum)((Object)selectMethodObj)).getValue() != 1) {
            return true;
        }
        int rollStep = this.spinRollStep.getIntegerVlaue();
        int rollLength = this.spinRollLength.getIntegerVlaue();
        int rollOverflow = this.spinRollOverflow.getIntegerVlaue();
        int fixedLength = this.spinFixedLength.getIntegerVlaue();
        if (rollLength < rollStep) {
            MsgBox.showWarning((String)BgViewClientHelper.getString("rollStepLargerLengthError"));
            return false;
        }
        if (((BgRollMethodEnum)((Object)selectMethodObj)).getValue() == 2) {
            if (rollOverflow >= rollLength) {
                MsgBox.showWarning((String)BgViewClientHelper.getString("overFlowLargerLengthError"));
                return false;
            }
            if (rollLength > fixedLength) {
                MsgBox.showWarning((String)BgViewClientHelper.getString("rollLengthLargerFixedLengthError"));
                return false;
            }
        }
        return true;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    private void setSpinBoundary(int rollMethod, int periodType) {
        if (1 == rollMethod) {
            if (1 == periodType) {
                ((SpinnerNumberModel)this.spinRollStep.getModel()).setMaximum(new Integer(1));
                ((SpinnerNumberModel)this.spinRollLength.getModel()).setMaximum(new Integer(10));
            } else if (2 == periodType) {
                ((SpinnerNumberModel)this.spinRollStep.getModel()).setMaximum(new Integer(2));
                ((SpinnerNumberModel)this.spinRollLength.getModel()).setMaximum(new Integer(10));
            } else if (3 == periodType) {
                ((SpinnerNumberModel)this.spinRollStep.getModel()).setMaximum(new Integer(4));
                ((SpinnerNumberModel)this.spinRollLength.getModel()).setMaximum(new Integer(12));
            } else if (4 == periodType) {
                ((SpinnerNumberModel)this.spinRollStep.getModel()).setMaximum(new Integer(12));
                ((SpinnerNumberModel)this.spinRollLength.getModel()).setMaximum(new Integer(36));
            } else if (9 == periodType) {
                ((SpinnerNumberModel)this.spinRollStep.getModel()).setMaximum(new Integer(9));
                ((SpinnerNumberModel)this.spinRollLength.getModel()).setMaximum(new Integer(36));
            }
        } else if (2 == rollMethod) {
            if (3 == periodType) {
                ((SpinnerNumberModel)this.spinRollStep.getModel()).setMaximum(new Integer(1));
                if (this.spinRollStep.getIntegerVlaue() > 1) {
                    this.spinRollStep.setValue((Object)1);
                }
                ((SpinnerNumberModel)this.spinRollLength.getModel()).setMaximum(new Integer(4));
                if (this.spinRollLength.getIntegerVlaue() > 4) {
                    this.spinRollLength.setValue((Object)4);
                }
                ((SpinnerNumberModel)this.spinFixedLength.getModel()).setMaximum(new Integer(4));
                if (this.spinFixedLength.getIntegerVlaue() > 4) {
                    this.spinFixedLength.setValue((Object)4);
                }
                ((SpinnerNumberModel)this.spinRollOverflow.getModel()).setMaximum(new Integer(1));
                if (this.spinRollOverflow.getIntegerVlaue() > 1) {
                    this.spinRollOverflow.setValue((Object)1);
                }
            } else if (4 == periodType) {
                ((SpinnerNumberModel)this.spinRollStep.getModel()).setMaximum(new Integer(3));
                if (this.spinRollStep.getIntegerVlaue() > 3) {
                    this.spinRollStep.setValue((Object)3);
                }
                ((SpinnerNumberModel)this.spinRollLength.getModel()).setMaximum(new Integer(12));
                if (this.spinRollLength.getIntegerVlaue() > 12) {
                    this.spinRollLength.setValue((Object)12);
                }
                ((SpinnerNumberModel)this.spinFixedLength.getModel()).setMaximum(new Integer(12));
                if (this.spinFixedLength.getIntegerVlaue() > 12) {
                    this.spinFixedLength.setValue((Object)12);
                }
                ((SpinnerNumberModel)this.spinRollOverflow.getModel()).setMaximum(new Integer(2));
                if (this.spinRollOverflow.getIntegerVlaue() > 2) {
                    this.spinRollOverflow.setValue((Object)2);
                }
            } else if (9 == periodType) {
                ((SpinnerNumberModel)this.spinRollStep.getModel()).setMaximum(new Integer(9));
                if (this.spinRollStep.getIntegerVlaue() > 9) {
                    this.spinRollStep.setValue((Object)9);
                }
                ((SpinnerNumberModel)this.spinRollLength.getModel()).setMaximum(new Integer(36));
                if (this.spinRollLength.getIntegerVlaue() > 36) {
                    this.spinRollLength.setValue((Object)36);
                }
                ((SpinnerNumberModel)this.spinFixedLength.getModel()).setMaximum(new Integer(36));
                if (this.spinFixedLength.getIntegerVlaue() > 36) {
                    this.spinFixedLength.setValue((Object)36);
                }
                ((SpinnerNumberModel)this.spinRollOverflow.getModel()).setMaximum(new Integer(6));
                if (this.spinRollOverflow.getIntegerVlaue() > 6) {
                    this.spinRollOverflow.setValue((Object)6);
                }
            }
        }
    }

    private void loadPeriodType(int rollMethod) {
        this.comboRollPeriodType.removeAllItems();
        ArrayList<BgPeriodEnum> arrayList = new ArrayList<BgPeriodEnum>();
        if (1 == rollMethod) {
            arrayList.add(BgPeriodEnum.YEAR);
            arrayList.add(BgPeriodEnum.HALFYEAR);
            arrayList.add(BgPeriodEnum.QUARTER);
            arrayList.add(BgPeriodEnum.MONTH);
            arrayList.add(BgPeriodEnum.TENDAYS);
        } else if (2 == rollMethod) {
            arrayList.add(BgPeriodEnum.QUARTER);
            arrayList.add(BgPeriodEnum.MONTH);
            arrayList.add(BgPeriodEnum.TENDAYS);
        }
        this.comboRollPeriodType.addItems(arrayList.toArray());
        this.comboRollPeriodType.setSelectedItem((Object)BgPeriodEnum.MONTH);
    }

    private void setDefaultValue(int type) {
        int rollMethod = ((BgRollMethodEnum)((Object)this.comboRollMethod.getSelectedItem())).getValue();
        if (1 == rollMethod) {
            if (type == 1) {
                this.comboRollPeriodType.setSelectedItem((Object)BgPeriodEnum.MONTH);
                this.spinRollStep.setValue((Object)1);
                this.spinRollLength.setValue((Object)12);
            } else if (type == 2) {
                if (this.comboRollPeriodType.getSelectedItem().equals(BgPeriodEnum.MONTH)) {
                    this.spinRollStep.setValue((Object)1);
                    this.spinRollLength.setValue((Object)12);
                } else {
                    this.spinRollStep.setValue((Object)1);
                    this.spinRollLength.setValue((Object)1);
                }
            }
            this.spinRollOverflow.setValue((Object)0);
            this.spinFixedLength.setValue((Object)0);
            this.comboRollPeriodType.setEnabled(true);
            this.spinRollStep.setEnabled(true);
            this.spinRollLength.setEnabled(true);
            this.spinFixedLength.setEnabled(false);
            this.spinRollOverflow.setEnabled(false);
        } else if (2 == rollMethod) {
            if (type == 1) {
                this.comboRollPeriodType.setSelectedItem((Object)BgPeriodEnum.MONTH);
                this.spinRollStep.setValue((Object)1);
                this.spinRollLength.setValue((Object)3);
                this.spinFixedLength.setValue((Object)12);
                this.spinRollOverflow.setValue((Object)2);
            } else if (type == 2) {
                if (this.comboRollPeriodType.getSelectedItem().equals(BgPeriodEnum.MONTH)) {
                    this.spinRollStep.setValue((Object)1);
                    this.spinRollLength.setValue((Object)3);
                    this.spinFixedLength.setValue((Object)12);
                    this.spinRollOverflow.setValue((Object)2);
                } else {
                    this.spinRollStep.setValue((Object)1);
                    this.spinRollLength.setValue((Object)1);
                    this.spinFixedLength.setValue((Object)1);
                    this.spinRollOverflow.setValue((Object)1);
                }
            }
            this.comboRollPeriodType.setEnabled(true);
            this.spinRollStep.setEnabled(true);
            this.spinRollLength.setEnabled(true);
            this.spinFixedLength.setEnabled(true);
            this.spinRollOverflow.setEnabled(true);
        }
        this.setSpinBoundary(((BgRollMethodEnum)((Object)this.comboRollMethod.getSelectedItem())).getValue(), ((BgPeriodEnum)this.comboRollPeriodType.getSelectedItem()).getValue());
    }

    @Override
    protected void comboRollMethod_actionPerformed(ActionEvent e) throws Exception {
        Object selectMethodObj = this.comboRollMethod.getSelectedItem();
        Object selectTypeObj = this.comboRollPeriodType.getSelectedItem();
        if (selectMethodObj == null) {
            return;
        }
        this.loadPeriodType(((BgRollMethodEnum)((Object)selectMethodObj)).getValue());
        this.setDefaultValue(1);
    }

    @Override
    protected void comboRollPeriodType_actionPerformed(ActionEvent e) throws Exception {
        Object selectMethodObj = this.comboRollMethod.getSelectedItem();
        Object selectTypeObj = this.comboRollPeriodType.getSelectedItem();
        if (selectMethodObj == null || selectTypeObj == null) {
            return;
        }
        this.setDefaultValue(2);
    }

    public BgRollRuleInfo getBgRollRuleInfo() {
        return this.bgRollRuleInfo;
    }

    public void reSetValue() {
        this.comboRollMethod.setSelectedItem((Object)BgRollMethodEnum.SERIATEROLLING);
        this.comboRollPeriodType.setSelectedItem((Object)BgPeriodEnum.MONTH);
        this.spinRollStep.setValue((Object)1);
        this.spinRollLength.setValue((Object)12);
        this.spinRollOverflow.setValue((Object)0);
        this.spinRollOverflow.setEnabled(false);
        this.spinFixedLength.setValue((Object)0);
        this.spinFixedLength.setEnabled(false);
    }
}

