/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.action;

import com.kingdee.bos.appframework.uistatemanage.ActionManager;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.ma.view.client.common.BookContextManager;
import com.kingdee.eas.ma.view.client.designer.IActionManager;
import com.kingdee.eas.ma.view.client.designer.IContextManager;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;

public abstract class AbstractActionManager
implements IActionManager {
    private IContextManager contextManager = null;
    private Map actions = new HashMap();

    public AbstractActionManager(IContextManager contextManager) {
        this.contextManager = contextManager;
        this.initToolsAction();
    }

    protected void disableAction(ActionManager manager, String strActionKey) {
        this.disableAction(manager, strActionKey, true, false);
    }

    protected void disableAction(ActionManager manager, String strActionKey, boolean isVisible, boolean isEnable) {
        ItemAction item = null;
        item = manager.getAction(strActionKey);
        if (item != null) {
            item.setEnabled(isEnable);
            item.setVisible(isVisible);
        }
    }

    protected void enableAction(ActionManager manager, String strActionKey) {
        ItemAction item = null;
        item = manager.getAction(strActionKey);
        if (item != null) {
            item.setEnabled(true);
            item.setVisible(true);
        }
    }

    @Override
    public IContextManager getContextManager() {
        return this.contextManager;
    }

    public Map getActionMap() {
        return this.actions;
    }

    protected abstract void initToolsAction();

    protected abstract void initAction();

    @Override
    public void registerActionToFirstToolBar(IItemAction action) {
        this.registerAction(action, true);
        ToolBarManager barManager = this.getToolBarManager();
        if (barManager != null) {
            barManager.addFirstGroupItem((Action)action, "common");
        }
    }

    @Override
    public void registerActionToLastToolBar(IItemAction action) {
        this.registerAction(action, true);
        ToolBarManager barManager = this.getToolBarManager();
        if (barManager != null) {
            barManager.addLastGroupItem((Action)action, "common");
        }
    }

    @Override
    public void registerAction(IItemAction action) {
        this.registerAction(action, false);
    }

    private void registerAction(IItemAction action, boolean hasSynchro) {
        if (action == null) {
            return;
        }
        String _common = action.getClass().getSimpleName();
        if (!this.getActionMap().containsKey(_common)) {
            Class<?> _class = null;
            ItemAction itemAction = null;
            try {
                _class = Class.forName("com.kingdee.eas.ma.view.client.action.actions." + _common);
                itemAction = (ItemAction)_class.newInstance();
                itemAction.setUIObject(action.getUIObject());
                this.getActionMap().put(_common, itemAction);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (hasSynchro) {
                this.synchro(action, (IItemAction)itemAction);
            }
        }
    }

    private void synchro(IItemAction actionTo, IItemAction actionFrom) {
        if (actionTo != null && actionFrom != null) {
            if (actionTo.getValue("SmallIcon") == null || actionTo.getValue("SmallIcon").toString().length() == 0) {
                actionTo.putValue("SmallIcon", actionFrom.getValue("SmallIcon"));
            }
            if (actionTo.getValue("Name") == null || actionTo.getValue("Name").toString().length() == 0) {
                actionTo.putValue("Name", actionFrom.getValue("Name"));
            }
            if (actionTo.getValue("ShortDescription") == null || actionTo.getValue("ShortDescription").toString().length() == 0) {
                actionTo.putValue("ShortDescription", actionFrom.getValue("ShortDescription"));
            }
            if (actionTo.getValue("LongDescription") == null || actionTo.getValue("LongDescription").toString().length() == 0) {
                actionTo.putValue("LongDescription", actionFrom.getValue("LongDescription"));
            }
        }
    }

    @Override
    public void doAction(ActionEvent e) throws Exception {
        String[] _tmpStrs;
        if (e == null) {
            return;
        }
        String _command = e.getActionCommand();
        if (!StringUtils.isEmpty((String)_command) && (_tmpStrs = _command.split("\\$")) != null) {
            ItemAction action;
            int index = _tmpStrs.length - 1;
            String _actionStr = _tmpStrs[index];
            if (this.getActionMap().containsKey(_actionStr) && (action = (ItemAction)this.getActionMap().get(_actionStr)) != null) {
                action.actionPerformed(e);
            }
        }
    }

    protected ToolBarManager getToolBarManager() {
        if (this.getContextManager() instanceof BookContextManager) {
            BookContextManager _manager = (BookContextManager)this.getContextManager();
            return _manager.getSpreadContext().getToolBarManager();
        }
        return null;
    }
}

