/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.action.actions;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgExamineFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.IBgExamineFacade;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.client.BgExamineViewUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.view.client.BgReportViewBaseUI;
import com.kingdee.eas.ma.view.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.view.client.common.BgReportViewContextManager;
import com.kingdee.eas.ma.view.client.common.BgViewClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ActionBgExamineCheck
extends AbstractAction {
    private BgReportViewBaseUI baseUI;
    private static final Logger logger = CoreUIObject.getLogger(ActionBgExamineCheck.class);

    @Override
    protected boolean hasIcon() {
        return true;
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_examinecheck");
    }

    @Override
    protected boolean hasKeyStroke() {
        return false;
    }

    @Override
    protected String getName() {
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        BgFormInfo formInfo;
        IBgExamineFacade bgExamineFacade;
        this.baseUI = (BgReportViewBaseUI)this.uiObj;
        BgReportViewContextManager contextManager = (BgReportViewContextManager)this.baseUI.getContextManager();
        SpreadContext spreadContext = contextManager.getSpreadContext();
        BgFormInfo currentForm = null;
        BgFormInfo _bgFormInfo = (BgFormInfo)contextManager.getProvider().getEditValue();
        if (!OprtState.VIEW.equals(this.baseUI.getOprtState()) && (spreadContext.getSpread().getBook().getUndoManager().canUndo() || OprtState.ADDNEW.equals(this.baseUI.getOprtState()))) {
            try {
                Map result = contextManager.save();
                if (result != null) {
                    boolean isAllSuccess = true;
                    for (Object o : result.keySet()) {
                        String orgId = (String)o;
                        Map orgResult = (Map)result.get(o);
                        boolean isSuccess = (Boolean)orgResult.get("isSuccess");
                        if (isSuccess) continue;
                        isAllSuccess = false;
                    }
                    if (!isAllSuccess) {
                        return;
                    }
                }
            }
            catch (Exception e1) {
                logger.error((Object)e1);
                return;
            }
        }
        try {
            String orgUnitId = contextManager.getOrgUnitId().toString();
            if (contextManager.getBgFormMap().get(orgUnitId) != null) {
                currentForm = contextManager.getBgFormMap().get(orgUnitId);
            } else {
                IBgFormFacade iBgFormFacade = BgFormFacadeFactory.getRemoteInstance();
                Map resultMap = iBgFormFacade.queryBgFormByOrgUnitId(_bgFormInfo, new Object[]{orgUnitId});
                currentForm = (BgFormInfo)resultMap.get(orgUnitId);
                contextManager.getBgFormMap().putAll(resultMap);
            }
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Throwable)e1);
            SysUtil.abort();
        }
        try {
            bgExamineFacade = BgExamineFacadeFactory.getRemoteInstance();
            formInfo = contextManager.getBgFormMap().get(contextManager.getOrgUnitId());
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
            return;
        }
        try {
            if (bgExamineFacade.canExamine(new BOSUuid[]{formInfo.getId()})) {
                final String xNum = BgNFCHelper.returnExamineX((BOSUuid[])new BOSUuid[]{formInfo.getId()}, (Object)((Object)this.baseUI));
                Window win = SwingUtilities.getWindowAncestor((Component)((Object)this.baseUI));
                LongTimeDialog dialog = null;
                if (win instanceof Frame) {
                    dialog = new LongTimeDialog((Frame)win);
                } else if (win instanceof Dialog) {
                    dialog = new LongTimeDialog((Dialog)win);
                }
                if (dialog == null) {
                    return;
                }
                dialog.setLongTimeTask(new ILongTimeTask(){

                    public Object exec() throws Exception {
                        Object[] result = bgExamineFacade.examines(new BOSUuid[]{formInfo.getAdjust().getId()}, xNum);
                        HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                        bgExamineCheckMap.put("BgExamineChecked", result[0]);
                        bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                        return bgExamineCheckMap;
                    }

                    public void afterExec(Object result) throws Exception {
                        if (result != null && result instanceof HashMap) {
                            ActionBgExamineCheck.this.openBgExamineViewUI(result, formInfo);
                        } else {
                            MsgBox.showWarning((String)ActionBgExamineCheck.this.getMessageStr("com.kingdee.eas.ma.budget.client.BgExamineCheckResource", "error"));
                        }
                    }
                });
                dialog.show();
            } else {
                MsgBox.showInfo((String)this.getMessageStr("com.kingdee.eas.ma.budget.client.BgExamineCheckResource", "cantCheckBgExamine"));
            }
        }
        catch (EASBizException e1) {
            logger.error((Object)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
    }

    public void openBgExamineViewUI(Object obj, BgFormInfo info) throws Exception {
        UIContext uiContext = new UIContext((Object)this.baseUI);
        uiContext.put((Object)"EXAMINE_DATA", obj);
        uiContext.put((Object)"BGFORM_ID", (Object)info.getId());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgExamineViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getMessageStr(String sourceStr, String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)sourceStr, (String)key) : "";
    }

    @Override
    protected String getShortDescription() {
        return BgViewClientHelper.getString("ActionBgExamineCheckName");
    }

    @Override
    protected String getLongDescription() {
        return BgViewClientHelper.getString("ActionBgExamineCheckName");
    }
}

