/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.action.actions;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialog;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.view.client.BgReportViewBaseUI;
import com.kingdee.eas.ma.view.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.view.client.common.BgReportRollViewContextManager;
import com.kingdee.eas.ma.view.client.common.BgReportRollViewProvider;
import com.kingdee.eas.ma.view.client.common.BgViewClientHelper;
import com.kingdee.eas.ma.view.client.common.BookContextManager;
import com.kingdee.eas.ma.view.client.designer.IContextManager;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class ActionCalculate
extends AbstractAction {
    private ProgressDialog progressDialog;
    private TimeMark mk = null;

    @Override
    protected boolean hasIcon() {
        return true;
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_autocount");
    }

    @Override
    protected boolean hasKeyStroke() {
        return true;
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke("F9");
    }

    @Override
    protected String getName() {
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        BgReportViewBaseUI processUI = (BgReportViewBaseUI)this.uiObj;
        BookContextManager contextManager = (BookContextManager)processUI.getContextManager();
        Book _book = contextManager.getSpreadContext().getBook();
        boolean oldstate = _book.isAutoCalculate();
        _book.setCalculate(true);
        this.calculate(processUI);
        contextManager.getSpreadContext().getSpread().repaint();
        _book.setCalculate(oldstate);
    }

    private void calculate(final BgReportViewBaseUI processUI) {
        final BookContextManager contextManager = (BookContextManager)processUI.getContextManager();
        if (this.progressDialog == null) {
            this.progressDialog = ProgressDialog.createProgressDialog((Component)((Object)processUI), (boolean)true);
        }
        if (this.progressDialog.isVisible()) {
            return;
        }
        try {
            this.progressDialog.run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    TimeMark mark = ActionCalculate.this.getTimeMark(processUI);
                    try {
                        if (mark != null) {
                            mark.Start();
                        }
                        monitor.beginTask(DesignerResource.getString((String)"calculateBook"), -1);
                        monitor.setTaskName(DesignerResource.getString((String)"calculateBook_PlsWait"));
                        monitor.subTaskBegin(DesignerResource.getString((String)"prepareData"));
                        contextManager.getSpreadContext().getBook().setSkipListeners(true);
                        monitor.subTaskBegin(DesignerResource.getString((String)"calculate"));
                        contextManager.getSpreadContext().getBook().calc();
                        ActionCalculate.this.afterCalculate(processUI.getContextManager());
                        ActionCalculate.this.saveBgValue(contextManager.getSpreadContext().getBook());
                        monitor.subTaskBegin(DesignerResource.getString((String)"calculateComplete"));
                    }
                    finally {
                        monitor.done();
                        contextManager.getSpreadContext().getBook().setSkipListeners(false);
                        contextManager.getSpreadContext().getSpread().repaint();
                        if (mark != null) {
                            mark.Stop();
                        }
                        contextManager.getModifyManager().setModified();
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void afterCalculate(IContextManager contextManager) {
        BgFormInfo form;
        if (contextManager instanceof BgReportRollViewContextManager && (form = (BgFormInfo)((BgReportRollViewProvider)contextManager.getProvider()).getEditValue()).getEntries().get(0).getRollMethod().getValue() == 6) {
            ((BgReportRollViewContextManager)contextManager).updateChangeValueInfo();
        }
    }

    protected void saveBgValue(Book book) {
        Sheet _sheet = null;
        Cell _cell = null;
        int count = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < count; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    this.updateCellChangeValueInfo(_cell);
                }
            }
        }
    }

    private void updateCellChangeValueInfo(Cell cell) {
        if (cell == null) {
            return;
        }
        if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
            Object _obj = null;
            BigDecimal _newValue = null;
            _obj = BgNFSHelper.getValue((Cell)cell);
            if (_obj == null) {
                return;
            }
            if (_obj instanceof BigDecimal) {
                _newValue = (BigDecimal)_obj;
            } else {
                try {
                    _newValue = new BigDecimal(_obj.toString());
                }
                catch (Exception ex) {
                    BgNFSHelper.setValue((Cell)cell, (Object)BgNConstants.ZERO);
                    _newValue = BgNConstants.ZERO;
                }
            }
            BgNFSHelper.setBudgetValue((Cell)cell, (BigDecimal)_newValue);
        }
    }

    protected TimeMark getTimeMark(BgReportViewBaseUI ui) {
        if (this.mk == null) {
            this.mk = new TimeMark(ui);
        }
        if (this.mk.isRuning()) {
            return null;
        }
        return this.mk;
    }

    @Override
    protected String getShortDescription() {
        return BgViewClientHelper.getString("ActionCalculateName");
    }

    @Override
    protected String getLongDescription() {
        return BgViewClientHelper.getString("ActionCalculateName");
    }

    class TimeMark {
        BgReportViewBaseUI ui;
        boolean isRuning = false;
        long time = 0L;

        public TimeMark(BgReportViewBaseUI _ui) {
            this.ui = _ui;
        }

        public boolean isRuning() {
            return this.isRuning;
        }

        public void Start() {
            this.isRuning = true;
            this.time = System.currentTimeMillis();
        }

        public void Stop() {
            this.showSuccessMsg(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.nbudget.BgSpecialFormResource", (String)"calcTime"), Long.toString(System.currentTimeMillis() - this.time)));
            this.isRuning = false;
        }

        public void showSuccessMsg(String msg) {
            this.ui.setMessageIcon(BgReportViewBaseUI.SHOW_MESSAGE_ICON_OK);
            this.ui.setMessageBgcolor(BgReportViewBaseUI.SHOW_MESSAGE_BG_OK);
            this.ui.setMessageText(msg);
            this.ui.showMessage();
        }
    }
}

