/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.action.actions;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.ma.view.client.BgReportViewBaseUI;
import com.kingdee.eas.ma.view.client.BgReportViewProcessUI;
import com.kingdee.eas.ma.view.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.view.client.common.BgViewClientHelper;
import com.kingdee.eas.ma.view.client.common.BookContextManager;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class ActionExport
extends AbstractAction {
    @Override
    protected boolean hasIcon() {
        return true;
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_output");
    }

    @Override
    protected boolean hasKeyStroke() {
        return true;
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke("ctrl shift E");
    }

    @Override
    protected String getName() {
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        BgReportViewBaseUI processUI = (BgReportViewBaseUI)this.uiObj;
        BookContextManager contextManager = (BookContextManager)processUI.getContextManager();
        IObjectValue iObjectValue = contextManager.getProvider().getEditValue();
        KDFileChooser fc = new KDFileChooser();
        fc.setDialogTitle(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"fileExport"));
        fc.setFileFilter((FileFilter)new ExcelFileFilter());
        fc.setAcceptAllFileFilterUsed(false);
        fc.setSelectedFile(new File("C://" + iObjectValue.get("name") + ".xls"));
        if (fc.showSaveDialog((Component)((Object)processUI)) == 0) {
            File file = fc.getSelectedFile();
            if (file.getName().indexOf(".") == -1) {
                file = new File(fc.getSelectedFile() + ".xls");
            }
            if (file != null) {
                if (file.exists()) {
                    int re = MsgBox.showConfirm3((Component)((Object)processUI), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"existsFile"));
                    if (re == 1 || re == 2) {
                        return;
                    }
                    file.delete();
                }
                try {
                    this.exportBookContent(file, processUI);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    protected void exportBookContent(File file, BgReportViewBaseUI processUI) throws Exception {
        BookContextManager contextManager = (BookContextManager)processUI.getContextManager();
        Book _book = contextManager.getSpreadContext().getBook();
        String _filename = file.getPath();
        BigDecimal _coefficient = contextManager.getProvider().getBgDimensionManager().getDefaultMeasureUnit().getCoefficient();
        _book.getProtection().deleteOperations();
        HashMap<String, Object> _parameter = new HashMap<String, Object>();
        _parameter.put("EXPORT_BOOK", _book);
        _parameter.put("EXPORT_COEFFICIENT", _coefficient);
        HashMap newMeasureUnitMap = new HashMap();
        Map measureUnitMap = processUI.getMeasureUnitMap();
        Set keySet = measureUnitMap.keySet();
        for (Object o : keySet) {
            MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)measureUnitMap.get(o);
            newMeasureUnitMap.put(o, measureUnitInfo.getCoefficient());
        }
        _parameter.put("EXPORT_MEASUREUNIT", newMeasureUnitMap);
        _parameter.put("EXPORT_BGFORMULA", null);
        if (processUI instanceof BgReportViewProcessUI) {
            if (((BgReportViewProcessUI)processUI).getMenuItemDealReplace().isSelected()) {
                _parameter.put("EXPORT_DATA", Boolean.FALSE);
            } else if (((BgReportViewProcessUI)processUI).getMenuItemMeasReplace().isSelected()) {
                _parameter.put("EXPORT_DATA", Boolean.TRUE);
            }
        } else {
            _parameter.put("EXPORT_DATA", Boolean.FALSE);
        }
        KDSBook _kdsBook = BgNFCHelper.exportExcel(_parameter);
        ExportManager em = new ExportManager();
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
        em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"false");
        em.exportToExcel(_kdsBook, _filename);
    }

    @Override
    protected String getShortDescription() {
        return BgViewClientHelper.getString("ActionExportName");
    }

    @Override
    protected String getLongDescription() {
        return BgViewClientHelper.getString("ActionExportName");
    }
}

