/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.action.actions;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.ma.view.client.BgReportViewBaseUI;
import com.kingdee.eas.ma.view.client.BgReportViewProcessUI;
import com.kingdee.eas.ma.view.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.view.client.common.BgViewClientHelper;
import com.kingdee.eas.ma.view.client.common.BookContextManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class ActionImport
extends AbstractAction {
    @Override
    protected boolean hasIcon() {
        return true;
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_input");
    }

    @Override
    protected boolean hasKeyStroke() {
        return true;
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(73, 2);
    }

    @Override
    protected String getName() {
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        File file;
        BgReportViewBaseUI processUI = (BgReportViewBaseUI)this.uiObj;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"fileImport"));
        fileChooser.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)((Object)processUI)) == 0 && (file = fileChooser.getSelectedFile()) != null && file.isFile()) {
            String fileName = file.getPath();
            KDSBook books = POIXlsReader.parse((String)fileName);
            try {
                this.importBookContent(books, processUI);
            }
            catch (Exception ex) {
                MsgBox.showWarning((String)ex.getMessage());
            }
        }
    }

    protected void importBookContent(KDSBook kdsBook, BgReportViewBaseUI processUI) throws Exception {
        if (kdsBook == null) {
            MsgBox.showWarning((Component)((Object)processUI), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"openFileError"));
            SysUtil.abort();
        }
        BookContextManager contextManager = (BookContextManager)processUI.getContextManager();
        Book _book = contextManager.getSpreadContext().getBook();
        BigDecimal _coefficient = contextManager.getProvider().getBgDimensionManager().getDefaultMeasureUnit().getCoefficient();
        HashMap<String, Object> _tmpMap = new HashMap<String, Object>();
        _tmpMap.put("IMPORT_BOOK", _book);
        _tmpMap.put("IMPORT_KDSBOOK", kdsBook);
        _tmpMap.put("IMPORT_COEFFICIENT", _coefficient);
        _tmpMap.put("IMPORT_MEASUREUNIT", processUI.getMeasureUnitMap());
        _tmpMap.put("IMPORT_BGFORMULA", processUI.getFormulaMap());
        if (processUI instanceof BgReportViewProcessUI) {
            if (((BgReportViewProcessUI)processUI).getMenuItemDealReplace().isSelected()) {
                _tmpMap.put("IMPORT_DATA", Boolean.FALSE);
            } else if (((BgReportViewProcessUI)processUI).getMenuItemMeasReplace().isSelected()) {
                _tmpMap.put("IMPORT_DATA", Boolean.TRUE);
            }
        } else {
            _tmpMap.put("IMPORT_DATA", Boolean.FALSE);
        }
        BgNFCHelper.importExcel(_tmpMap);
        contextManager.getSpreadContext().getSpread().repaint();
    }

    @Override
    protected String getShortDescription() {
        return BgViewClientHelper.getString("ActionImportName");
    }

    @Override
    protected String getLongDescription() {
        return BgViewClientHelper.getString("ActionImportName");
    }
}

