/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.action.actions;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgExamineFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.IBgExamineFacade;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.client.BgFormExamineResultUI;
import com.kingdee.eas.ma.view.client.BgReportViewBaseUI;
import com.kingdee.eas.ma.view.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.view.client.common.BgReportViewContextManager;
import com.kingdee.eas.ma.view.client.common.BgViewClientHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class ActionOpenExamineReport
extends AbstractAction {
    private BgReportViewBaseUI baseUI;
    private static final Logger logger = CoreUIObject.getLogger(ActionOpenExamineReport.class);

    @Override
    protected boolean hasIcon() {
        return true;
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_descrydispose");
    }

    @Override
    protected boolean hasKeyStroke() {
        return false;
    }

    @Override
    protected String getName() {
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        this.baseUI = (BgReportViewBaseUI)this.uiObj;
        BgReportViewContextManager contextManager = (BgReportViewContextManager)this.baseUI.getContextManager();
        BgFormInfo formInfo = (BgFormInfo)contextManager.getProvider().getEditValue();
        IBgExamineFacade bgExamineFacade = null;
        boolean isCanExamine = false;
        BgFormInfo currentForm = null;
        try {
            String orgUnitId = contextManager.getOrgUnitId().toString();
            if (contextManager.getBgFormMap().get(orgUnitId) != null) {
                currentForm = contextManager.getBgFormMap().get(orgUnitId);
            } else {
                IBgFormFacade iBgFormFacade = BgFormFacadeFactory.getRemoteInstance();
                Map resultMap = iBgFormFacade.queryBgFormByOrgUnitId(formInfo, new Object[]{orgUnitId});
                currentForm = (BgFormInfo)resultMap.get(orgUnitId);
                contextManager.getBgFormMap().putAll(resultMap);
            }
            bgExamineFacade = BgExamineFacadeFactory.getRemoteInstance();
            isCanExamine = bgExamineFacade.canExamine(new BOSUuid[]{currentForm.getId()});
        }
        catch (Exception ee) {
            MsgBox.showInfo((String)this.getMessageStr("com.kingdee.eas.ma.budget.client.BgExamineCheckResource", "examineFirst"));
            return;
        }
        if (isCanExamine) {
            UIContext uiContext = new UIContext((Object)this);
            ArrayList<String> bgFormIds = new ArrayList<String>();
            bgFormIds.add(currentForm.getAdjust().getId().toString());
            uiContext.put((Object)"BG_FORM_IDS", bgFormIds);
            uiContext.put((Object)"BG_EXAMINE_IDS", null);
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgFormExamineResultUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            }
            catch (UIException e1) {
                logger.error((Object)e1);
            }
        } else {
            MsgBox.showInfo((String)this.getMessageStr("com.kingdee.eas.ma.budget.client.BgExamineCheckResource", "cantCheckBgExamine"));
        }
    }

    @Override
    protected String getShortDescription() {
        return BgViewClientHelper.getString("ActionOpenExamineReportName");
    }

    @Override
    protected String getLongDescription() {
        return BgViewClientHelper.getString("ActionOpenExamineReportName");
    }

    protected String getMessageStr(String sourceStr, String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)sourceStr, (String)key) : "";
    }
}

