/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.action.actions;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.client.BgDecomposerFormDataUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.view.BgViewFacadeFactory;
import com.kingdee.eas.ma.view.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.view.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.view.client.action.actions.ActionSetLayout;
import com.kingdee.eas.ma.view.client.common.BookContextManager;
import com.kingdee.eas.ma.view.client.common.BudgetViewProvider;
import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.BgDimensionMember;
import com.kingdee.eas.ma.view.common.BgNViewDataInfo;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class ActionOrgunitDecomposer
extends AbstractAction {
    private static final String RES = "com.kingdee.eas.ma.view.client.BgViewClientResource";

    @Override
    protected boolean hasIcon() {
        return true;
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_definedistributeratio");
    }

    @Override
    protected boolean hasKeyStroke() {
        return false;
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return null;
    }

    @Override
    protected String getLongDescription() {
        return this.getName();
    }

    @Override
    protected String getShortDescription() {
        return this.getName();
    }

    @Override
    protected String getName() {
        return EASResource.getString((String)RES, (String)"setDecomposerCof");
    }

    public void actionPerformed(ActionEvent e) {
        IUIObject obj = this.getUIObject();
        BgSpreadCoreViewUI ui = null;
        ui = (BgSpreadCoreViewUI)obj;
        BookContextManager context = (BookContextManager)ui.getContextManager();
        if (!(context.getProvider().getEditValue() instanceof BgFormInfo)) {
            return;
        }
        BgFormInfo editDate = (BgFormInfo)context.getProvider().getEditValue();
        Book book = context.getSpreadContext().getBook();
        Sheet sheet = book.getActiveSheet();
        Range range = sheet.getSelectionRange();
        int maxRow = sheet.getMaxRowIndex();
        int maxCol = sheet.getMaxColIndex();
        Cell cell = null;
        String formula = null;
        HashMap<String, Variant> valueMap = new HashMap<String, Variant>();
        for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(i);
            int rowBegin = block.getRow();
            int rowEnd = block.getRow2();
            int colBegin = block.getCol();
            int colEnd = block.getCol2();
            for (int j = rowBegin; j <= rowEnd; ++j) {
                for (int k = colBegin; k <= colEnd; ++k) {
                    cell = sheet.getCell(j, k, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell) || cell.getValue() == null || !(cell.getValue().getValue() instanceof BigDecimal)) continue;
                    formula = BgNFSHelper.getFormulaOfCell((Cell)cell);
                    valueMap.put(formula, cell.getValue());
                }
            }
        }
        if (valueMap.isEmpty()) {
            MsgBox.showInfo((Component)((Object)ui), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"notDec"));
            return;
        }
        String currencySelectOrgID = context.getProvider().getOrgUnitId();
        try {
            Map map = BgViewFacadeFactory.getRemoteInstance().getDecSchemeCostCenterByBgViewForm((IObjectValue)editDate, currencySelectOrgID);
            if (map == null) {
                MsgBox.showInfo((Component)((Object)ui), (String)EASResource.getString((String)RES, (String)"notDecomposer"));
                return;
            }
            BgSchemeCollection childScheme = (BgSchemeCollection)map.get("BgScheme");
            CostCenterOrgUnitCollection childOrg = (CostCenterOrgUnitCollection)map.get("BgOrgUnit");
            BgTemplateCollection childTems = (BgTemplateCollection)map.get("BGTEMPLATE_INFO");
            BgFormCollection bgFormColl = (BgFormCollection)map.get("BG_COLLECT");
            if (childOrg == null || childOrg.isEmpty()) {
                MsgBox.showInfo((Component)((Object)ui), (String)EASResource.getString((String)RES, (String)"notDecomposer"));
                return;
            }
            HashMap<String, FullOrgUnitInfo> notBgFormOrgID = new HashMap<String, FullOrgUnitInfo>();
            ArrayList<String> havaBgFormOrgId = null;
            if (bgFormColl != null && !bgFormColl.isEmpty()) {
                havaBgFormOrgId = new ArrayList<String>();
                for (int index = 0; index < bgFormColl.size(); ++index) {
                    havaBgFormOrgId.add(bgFormColl.get(index).getOrgUnit().getId().toString());
                }
            }
            ObjectUuidPK[] orgIds = new ObjectUuidPK[childOrg.size()];
            CostCenterOrgUnitInfo costCenter = null;
            for (int index = 0; index < childOrg.size(); ++index) {
                orgIds[index] = new ObjectUuidPK(childOrg.get(index).getId().toString());
            }
            Set pOrgIds = PermissionFactory.getRemoteInstance().checkBatchPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK[])orgIds, "bg_form02_addNew");
            for (int index = childOrg.size() - 1; index >= 0; --index) {
                if (pOrgIds.contains(childOrg.get(index).getId().toString())) continue;
                childOrg.remove(childOrg.get(index));
            }
            CostCenterOrgUnitCollection refOrgUnitCol = new CostCenterOrgUnitCollection();
            String perantLNum = null;
            Vector<CostCenterOrgUnitInfo> orgUnits = new Vector<CostCenterOrgUnitInfo>();
            CostCenterOrgUnitInfo currSelectCostCenterOrg = null;
            for (int index = 0; index < childOrg.size(); ++index) {
                costCenter = childOrg.get(index);
                if (!currencySelectOrgID.equals(costCenter.getId().toString())) {
                    refOrgUnitCol.add(costCenter);
                } else {
                    perantLNum = costCenter.getLongNumber();
                    currSelectCostCenterOrg = costCenter;
                }
                orgUnits.add(costCenter);
                orgIds[index] = new ObjectUuidPK(costCenter.getId().toString());
            }
            HashMap<String, BgTemplateInfo> haveDataOrg = new HashMap<String, BgTemplateInfo>();
            HashMap<String, BgTemplateInfo> havaDataOrgParam = new HashMap<String, BgTemplateInfo>();
            String orgId = null;
            for (int index = 0; index < childTems.size(); ++index) {
                orgId = childTems.get(index).getOrgUnit().getId().toString();
                haveDataOrg.put(orgId, childTems.get(index));
                havaDataOrgParam.put(orgId, childTems.get(index));
                if (havaBgFormOrgId != null && havaBgFormOrgId.contains(orgId)) continue;
                notBgFormOrgID.put(orgId, childTems.get(index).getOrgUnit());
            }
            if (havaDataOrgParam.isEmpty()) {
                MsgBox.showInfo((Component)((Object)ui), (String)EASResource.getString((String)RES, (String)"notDecomposer"));
                return;
            }
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"UI_Title", (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"224_BgDecomposerFormEditUI"));
            uiContext.put((Object)"bgScheme", (Object)editDate.getBgScheme());
            uiContext.put((Object)"bgForm", (Object)editDate);
            uiContext.put((Object)"orgUnits", orgUnits);
            uiContext.put((Object)"perantLNum", (Object)perantLNum);
            uiContext.put((Object)"refOrgUnitCol", (Object)refOrgUnitCol);
            uiContext.put((Object)"haveDataOrg", havaDataOrgParam);
            uiContext.put((Object)"isViewForm", (Object)true);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.budget.client.BgDecomposerFormDataUI", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
            BgDecomposerFormDataUI decoUI = (BgDecomposerFormDataUI)uiWindow.getUIObject();
            if (decoUI.isCancel()) {
                return;
            }
            Map result = decoUI.getData();
            if (result == null || result.isEmpty()) {
                return;
            }
            context.save();
            CostCenterOrgUnitInfo tempInfo = null;
            Object fatherOrgInfo = null;
            HashMap returnMap = new HashMap();
            String key = null;
            BigDecimal curCo = null;
            Iterator it = result.keySet().iterator();
            while (it.hasNext()) {
                key = it.next().toString();
                tempInfo = this.getCostCenterById(childOrg, key);
                if (tempInfo == null) continue;
                curCo = (BigDecimal)result.get(key);
                this.getFatherCostValue(tempInfo, result, childOrg, currSelectCostCenterOrg, valueMap, returnMap, curCo, tempInfo.getId().toString());
            }
            if (returnMap != null && !returnMap.isEmpty()) {
                Set set = haveDataOrg.keySet();
                Object[] objKey = returnMap.keySet().toArray();
                for (int index = objKey.length - 1; index >= 0; --index) {
                    key = objKey[index].toString();
                    if (haveDataOrg.containsKey(key)) continue;
                    returnMap.remove(key);
                }
                this.openProgress(ui, context, editDate, currencySelectOrgID, childScheme, childOrg, notBgFormOrgID, haveDataOrg, returnMap);
            }
            ui.getUIContentPane().repaint();
            ui.getUIContext().put("isDecompose", true);
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Component)((Object)ui), (Throwable)ex);
        }
    }

    private void openProgress(BgSpreadCoreViewUI ui, BookContextManager context, BgFormInfo editDate, String currencySelectOrgID, BgSchemeCollection childScheme, CostCenterOrgUnitCollection childOrg, Map notBgFormOrgID, Map haveDataOrg, Map returnMap) throws EASBizException, BOSException, Exception {
        this.dealResult(ui, context, editDate, currencySelectOrgID, childScheme, childOrg, notBgFormOrgID, haveDataOrg, returnMap);
    }

    private void dealResult(BgSpreadCoreViewUI ui, BookContextManager context, BgFormInfo editDate, String currencySelectOrgID, BgSchemeCollection childScheme, CostCenterOrgUnitCollection childOrg, Map notBgFormOrgID, Map haveDataOrg, Map returnMap) throws Exception, EASBizException, BOSException {
        if (ui == null || context == null || editDate == null || StringUtils.isEmpty((String)currencySelectOrgID) || childScheme == null || childScheme.isEmpty() || childOrg == null || childOrg.isEmpty() || notBgFormOrgID == null) {
            return;
        }
        Set needAddViewFormOrgUnit = this.dealDimensionDisplay(ui, context, returnMap, notBgFormOrgID, currencySelectOrgID, childOrg);
        HashMap<String, BgSchemeInfo> schemeMap = new HashMap<String, BgSchemeInfo>();
        BgSchemeInfo bgSchemeInfo = null;
        for (int n = 0; n < childScheme.size(); ++n) {
            bgSchemeInfo = childScheme.get(n);
            String key = bgSchemeInfo.getOrgUnit().getId().toString();
            schemeMap.put(key, bgSchemeInfo);
        }
        this.addNewBgViewForm(schemeMap, haveDataOrg, editDate, needAddViewFormOrgUnit);
        this.setValueToBgDataMap((IUIObject)ui, returnMap, context, editDate.getBgScheme().getRootId().toString(), childOrg);
    }

    private void addNewBgViewForm(Map schemeMap, Map templatgeMap, BgFormInfo editDate, Set needAddViewFormOrgUnit) throws EASBizException, BOSException {
        if (schemeMap == null || schemeMap.isEmpty() || templatgeMap == null || templatgeMap.isEmpty() || editDate == null || needAddViewFormOrgUnit == null || needAddViewFormOrgUnit.isEmpty()) {
            return;
        }
        String key = null;
        FullOrgUnitInfo addOrgInfo2 = null;
        BgFormInfo info = null;
        ArrayList<BgFormInfo> formList = new ArrayList<BgFormInfo>();
        for (FullOrgUnitInfo addOrgInfo2 : needAddViewFormOrgUnit) {
            key = addOrgInfo2.getId().toString();
            info = (BgFormInfo)editDate.clone();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setOrgUnit(addOrgInfo2);
            info.setBgTemplate((BgTemplateInfo)templatgeMap.get(key));
            info.setBgScheme((BgSchemeInfo)schemeMap.get(key));
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            formList.add(info);
        }
        BgViewFacadeFactory.getRemoteInstance().batchAddForm(formList, editDate);
    }

    private Set dealDimensionDisplay(BgSpreadCoreViewUI ui, BookContextManager context, Map returnMap, Map notBgFormOrgID, String currencySelectOrgID, CostCenterOrgUnitCollection childOrg) throws Exception {
        if (returnMap == null || returnMap.isEmpty() || context == null) {
            return null;
        }
        String key = null;
        HashSet orgUnits = new HashSet();
        if (notBgFormOrgID != null && !notBgFormOrgID.isEmpty()) {
            Iterator it = notBgFormOrgID.keySet().iterator();
            while (it.hasNext()) {
                key = it.next().toString();
                if (!returnMap.containsKey(key)) continue;
                orgUnits.add(notBgFormOrgID.get(key));
            }
        }
        IBgDimensionManager bgDimensionManager = context.getProvider().getBgDimensionManager();
        List colDimensionStyle = bgDimensionManager.getColDisplayDimension();
        List rowDimensionStyle = bgDimensionManager.getRowDisplayDimension();
        List pageDimensionStyle = bgDimensionManager.getPageDisplayDimension();
        ArrayList allDimension = new ArrayList();
        allDimension.addAll(pageDimensionStyle);
        allDimension.addAll(rowDimensionStyle);
        allDimension.addAll(colDimensionStyle);
        BgDimensionInfo dimensionInfo = null;
        HashSet<String> includeOrgId = new HashSet<String>();
        HashMap<String, BgDimensionInfo> elementDimension = new HashMap<String, BgDimensionInfo>();
        for (int n = 0; n < allDimension.size(); ++n) {
            dimensionInfo = (BgDimensionInfo)allDimension.get(n);
            if ("ORGUNIT".equals(dimensionInfo.getType())) {
                List memberList = dimensionInfo.getMember();
                for (int index = 0; index < memberList.size(); ++index) {
                    includeOrgId.add(((BgDimensionMember)memberList.get(index)).getAttribute());
                }
                continue;
            }
            if (!"BGELEMENT".equals(dimensionInfo.getType())) continue;
            elementDimension.put(dimensionInfo.getLayout(), dimensionInfo);
        }
        String orgId = null;
        CostCenterOrgUnitInfo orgInfo = null;
        BgDimensionMember member = null;
        ArrayList<BgDimensionMember> needAddOrgMember = new ArrayList<BgDimensionMember>();
        for (int index = 0; index < childOrg.size(); ++index) {
            orgInfo = childOrg.get(index);
            orgId = orgInfo.getId().toString();
            if (!returnMap.containsKey(orgId) || currencySelectOrgID.equals(orgId) || includeOrgId.contains(orgId)) continue;
            member = new BgDimensionMember("ORGUNIT", orgInfo.getId().toString(), orgInfo.getName(), orgInfo.getNumber());
            member.setLevel(orgInfo.getLongNumber().split("!").length);
            member.setSortValue((Comparable)((Object)orgInfo.getLongNumber()));
            member.setAllowEdit(false);
            needAddOrgMember.add(member);
        }
        ArrayList moveOrgDimension = new ArrayList();
        this.filterOrgDimension(orgUnits, pageDimensionStyle, includeOrgId, moveOrgDimension, needAddOrgMember);
        this.filterOrgDimension(orgUnits, colDimensionStyle, includeOrgId, moveOrgDimension, needAddOrgMember);
        this.filterOrgDimension(orgUnits, rowDimensionStyle, includeOrgId, moveOrgDimension, needAddOrgMember);
        if (colDimensionStyle.isEmpty()) {
            String layout = null;
            BgDimensionInfo info = null;
            Iterator it = elementDimension.keySet().iterator();
            while (it.hasNext()) {
                layout = it.next().toString();
                info = (BgDimensionInfo)elementDimension.get(layout);
                this.deleteElementDimension(pageDimensionStyle);
                this.deleteElementDimension(rowDimensionStyle);
                this.deleteElementDimension(colDimensionStyle);
                colDimensionStyle.add(info);
            }
        }
        if (moveOrgDimension != null && !moveOrgDimension.isEmpty()) {
            rowDimensionStyle.addAll(0, moveOrgDimension);
        }
        HashMap<String, List<BgDimensionInfo>> dimensionMap = new HashMap<String, List<BgDimensionInfo>>();
        ArrayList pageParamter = new ArrayList();
        ArrayList colParamter = new ArrayList();
        ArrayList rowParamter = new ArrayList();
        pageParamter.addAll(pageDimensionStyle);
        colParamter.addAll(colDimensionStyle);
        rowParamter.addAll(rowDimensionStyle);
        dimensionMap.put("page", pageParamter);
        dimensionMap.put("col", colParamter);
        dimensionMap.put("row", rowParamter);
        ActionSetLayout actionSetLayout = new ActionSetLayout();
        actionSetLayout.setDecomposer(true);
        actionSetLayout.setNewLayout(ui, dimensionMap, true);
        return orgUnits;
    }

    private void deleteElementDimension(List dimension) {
        if (dimension == null || dimension.isEmpty()) {
            return;
        }
        BgDimensionInfo dimensionInfo = null;
        for (int n = dimension.size() - 1; n >= 0; --n) {
            dimensionInfo = (BgDimensionInfo)dimension.get(n);
            if (!"BGELEMENT".equals(dimensionInfo.getType())) continue;
            dimension.remove(dimensionInfo);
        }
    }

    private void filterOrgDimension(Set orgUnits, List dimensionStyle, Set includeOrgId, List moveOrgDimension, List needAddOrgMember) {
        if (orgUnits == null || dimensionStyle == null) {
            return;
        }
        if (moveOrgDimension == null) {
            moveOrgDimension = new ArrayList<BgDimensionInfo>();
        }
        for (int index = dimensionStyle.size() - 1; index >= 0; --index) {
            BgDimensionInfo dimensionInfo = (BgDimensionInfo)dimensionStyle.get(index);
            if (!dimensionInfo.getType().equals("ORGUNIT")) continue;
            dimensionStyle.remove(dimensionInfo);
            dimensionInfo.setLayout("row");
            if (needAddOrgMember != null && !needAddOrgMember.isEmpty()) {
                dimensionInfo.getMember().addAll(needAddOrgMember);
            }
            Collections.sort(dimensionInfo.getMember());
            moveOrgDimension.add(dimensionInfo);
        }
    }

    private void setValueToBgDataMap(IUIObject ui, Map returnMap, BookContextManager context, String bgSchemeRootId, CostCenterOrgUnitCollection allChildOrg) throws Exception {
        if (returnMap == null || returnMap.isEmpty() || context == null || StringUtils.isEmpty((String)bgSchemeRootId)) {
            return;
        }
        StringBuffer message = new StringBuffer();
        StringBuffer orgMess = new StringBuffer();
        CostCenterOrgUnitInfo orgInfo = null;
        BudgetViewProvider viewProvider = (BudgetViewProvider)context.getProvider();
        String key = null;
        HashMap<String, Map> bgDataMap = viewProvider.getBgDataMap();
        if (bgDataMap == null) {
            bgDataMap = new HashMap<String, Map>();
        }
        bgDataMap.clear();
        String bgFormula = null;
        String orgUnitId = null;
        BigDecimal value = null;
        Map tempMap = null;
        HashMap<String, BgNViewDataInfo> dataValue = null;
        BgNViewDataInfo dataInfo = null;
        String dateKey = null;
        Iterator it = returnMap.keySet().iterator();
        while (it.hasNext()) {
            key = it.next().toString();
            tempMap = (Map)returnMap.get(key);
            dataValue = new HashMap<String, BgNViewDataInfo>();
            Iterator it1 = tempMap.keySet().iterator();
            while (it1.hasNext()) {
                dateKey = it1.next().toString();
                value = (BigDecimal)tempMap.get(dateKey);
                bgFormula = dateKey.substring(0, dateKey.lastIndexOf("!"));
                orgUnitId = dateKey.substring(dateKey.lastIndexOf("!") + 1, dateKey.length());
                dataInfo = new BgNViewDataInfo(null);
                dataInfo.setBudgetValue(value);
                dataInfo.setOrgUnitId(orgUnitId);
                dataInfo.setFormula(bgFormula);
                dataValue.put(bgFormula, dataInfo);
            }
            bgDataMap.put(key, dataValue);
        }
        if (bgDataMap == null || bgDataMap.isEmpty()) {
            return;
        }
        Map bgData = BgViewFacadeFactory.getRemoteInstance().queryBgData(bgDataMap, bgSchemeRootId);
        Map bgDataMapTemp = null;
        Map bgDataTemp = null;
        String keyTem = null;
        HashMap noDecomp = new HashMap();
        ArrayList<String> noDecompValue = null;
        boolean isSuccess = true;
        BgNViewDataInfo bgDataMapTempInfo = null;
        BgNViewDataInfo bgDataTempInfo = null;
        Iterator it2 = bgData.keySet().iterator();
        while (it2.hasNext()) {
            key = it2.next().toString();
            isSuccess = true;
            if (bgDataMap.containsKey(key)) {
                bgDataTemp = (Map)bgData.get(key);
                bgDataMapTemp = (Map)bgDataMap.get(key);
                Iterator it22 = bgDataMapTemp.keySet().iterator();
                while (it22.hasNext()) {
                    keyTem = it22.next().toString();
                    if (!bgDataTemp.containsKey(keyTem)) continue;
                    bgDataTempInfo = (BgNViewDataInfo)((Object)bgDataTemp.get(keyTem));
                    bgDataMapTempInfo = (BgNViewDataInfo)((Object)bgDataMapTemp.get(keyTem));
                    if (bgDataTempInfo.getState() != 1) {
                        if (noDecompValue == null) {
                            noDecompValue = new ArrayList<String>();
                        }
                        noDecompValue.add(keyTem);
                        isSuccess = false;
                    }
                    bgDataTempInfo.setBudgetValue(bgDataMapTempInfo.getBudgetValue());
                    bgDataMapTemp.put(keyTem, bgDataTempInfo);
                }
                orgInfo = this.getCostCenterById(allChildOrg, key);
                if (isSuccess) {
                    orgMess.append(orgInfo.getNumber() + "_" + orgInfo.getName()).append("\uff0c");
                }
                bgDataMap.put(key, bgDataMapTemp);
            }
            if (noDecompValue != null) {
                noDecomp.put(key, noDecompValue);
            }
            noDecompValue = null;
        }
        boolean isAllSuccess = true;
        if (noDecomp.isEmpty()) {
            orgMess.deleteCharAt(orgMess.length() - 1);
            viewProvider.getBgDataMap().putAll(bgDataMap);
            isAllSuccess = true;
        } else {
            if (orgMess.length() > 0) {
                orgMess = new StringBuffer(EASResource.getString((String)RES, (String)"orgSuccess", (Object[])new Object[]{orgMess}) + "\n");
            }
            isAllSuccess = false;
            String temMess = null;
            List list = null;
            Map map = null;
            String[] temp = null;
            String formula = null;
            Iterator it3 = noDecomp.keySet().iterator();
            while (it3.hasNext()) {
                key = it3.next().toString();
                map = (Map)bgDataMap.get(key);
                orgInfo = this.getCostCenterById(allChildOrg, key);
                list = (List)noDecomp.get(key);
                message.append(EASResource.getString((String)RES, (String)"decOrgMessInfo", (Object[])new Object[]{orgInfo.getNumber() + "_" + orgInfo.getName()})).append("\n");
                Iterator it23 = list.iterator();
                while (it23.hasNext()) {
                    temMess = it23.next().toString();
                    temp = temMess.substring(1, temMess.length()).split(",");
                    if (temp.length >= 6) {
                        formula = this.dealFormula(temMess);
                    }
                    message.append(formula).append("\uff0c\n");
                    if (!map.containsKey(temMess)) continue;
                    map.remove(temMess);
                }
                message.deleteCharAt(message.length() - 1);
                message.append("\n");
            }
        }
        viewProvider.fillData(context.getSpreadContext().getBook(), bgDataMap);
        if (isAllSuccess) {
            MsgBox.showDetailAndOK((Component)ui.getUIContentPane(), (String)EASResource.getString((String)RES, (String)"success"), (String)EASResource.getString((String)RES, (String)"orgSuccess", (Object[])new Object[]{orgMess}), (int)1);
        } else {
            MsgBox.showDetailAndOK((Component)ui.getUIContentPane(), (String)EASResource.getString((String)RES, (String)"failSame"), (String)(orgMess.toString() + message.toString()), (int)1);
        }
    }

    private String dealFormula(String temMess) {
        int n;
        if (StringUtils.isEmpty((String)temMess)) {
            return null;
        }
        String formula = "";
        String[] temp = temMess.split(",");
        String[] newT = new String[temp.length - 2];
        int index = 0;
        for (n = 0; n < temp.length; ++n) {
            if (temp[n].equals("\"BgData\"") || temp[n].equals("true")) continue;
            newT[index] = temp[n];
            ++index;
        }
        for (n = 0; n < newT.length - 1; ++n) {
            formula = formula + newT[n] + ",";
        }
        formula = formula + newT[newT.length - 1];
        return formula;
    }

    private void getFatherCostValue(CostCenterOrgUnitInfo currOrg, Map decompResult, CostCenterOrgUnitCollection allOrg, CostCenterOrgUnitInfo rootOrg, Map value, Map returnMap, BigDecimal currCo, String currencyOrgID) {
        if (currOrg == null || decompResult == null || decompResult.isEmpty() || allOrg == null || allOrg.isEmpty() || rootOrg == null || value == null || value.isEmpty() || returnMap == null || StringUtils.isEmpty((String)currencyOrgID)) {
            return;
        }
        HashMap fatheValue = new HashMap();
        String key = null;
        Object obj = null;
        CostCenterOrgUnitInfo fatherOrgInfo = this.getFatherCostCenter(allOrg, currOrg, rootOrg.getId().toString());
        if (!fatherOrgInfo.getId().toString().equals(rootOrg.getId().toString())) {
            key = fatherOrgInfo.getId().toString();
            if (!decompResult.containsKey(fatherOrgInfo.getId().toString())) {
                returnMap.put(currencyOrgID, this.getValueMap(value, currencyOrgID, BgConstants.BIGZERO));
            } else {
                BigDecimal father = (BigDecimal)decompResult.get(fatherOrgInfo.getId().toString());
                currCo = currCo.multiply(father).divide(new BigDecimal(100));
                this.getFatherCostValue(fatherOrgInfo, decompResult, allOrg, rootOrg, value, returnMap, currCo, currencyOrgID);
            }
        } else {
            obj = decompResult.get(currOrg.getId().toString());
            if (obj instanceof BigDecimal) {
                returnMap.put(currencyOrgID, this.getValueMap(value, currencyOrgID, currCo.divide(new BigDecimal(100))));
            } else {
                returnMap.put(currencyOrgID, this.getValueMap(value, currencyOrgID, BgConstants.BIGZERO));
            }
        }
    }

    private Object getValueMap(Map value, String currOrgId, BigDecimal bigzero) {
        if (value == null || value.isEmpty() || bigzero == null) {
            return null;
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        Variant var = null;
        BigDecimal bValue = null;
        String key = null;
        Iterator it = value.keySet().iterator();
        while (it.hasNext()) {
            key = it.next().toString();
            var = (Variant)value.get(key);
            bValue = (BigDecimal)var.getValue();
            map.put(key + "!" + currOrgId, bValue.multiply(bigzero));
        }
        return map;
    }

    private CostCenterOrgUnitInfo getFatherCostCenter(CostCenterOrgUnitCollection allOrg, CostCenterOrgUnitInfo nowOrg, String rootOrgId) {
        if (allOrg == null || allOrg.isEmpty() || nowOrg == null || StringUtils.isEmpty((String)rootOrgId)) {
            return null;
        }
        CostCenterOrgUnitInfo info = null;
        String superLongNumner = nowOrg.getLongNumber().substring(0, nowOrg.getLongNumber().lastIndexOf("!"));
        for (int index = 0; index < allOrg.size(); ++index) {
            if (!allOrg.get(index).getLongNumber().equals(superLongNumner)) continue;
            info = allOrg.get(index);
            break;
        }
        return info;
    }

    private CostCenterOrgUnitInfo getCostCenterById(CostCenterOrgUnitCollection allOrg, String id) {
        if (allOrg == null || allOrg.isEmpty() || StringUtils.isEmpty((String)id)) {
            return null;
        }
        CostCenterOrgUnitInfo info = null;
        for (int index = 0; index < allOrg.size(); ++index) {
            if (!id.equals(allOrg.get(index).getId().toString())) continue;
            info = allOrg.get(index);
            break;
        }
        return info;
    }
}

