/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgBudgetFacadeFactory;
import com.kingdee.eas.ma.budget.BgControlFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormulaFacadeFactory;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgItemObject;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.client.BgTemplatePromptDialog;
import com.kingdee.eas.ma.budget.client.NewBgItemGroupListF7UI;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.BgNTemplateProcessUI;
import com.kingdee.eas.ma.nbudget.client.IBgTemplateSelectItem;
import com.kingdee.eas.ma.view.BgBillIntegrateItemMapCollection;
import com.kingdee.eas.ma.view.BgBillIntegrateItemMapInfo;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeInfo;
import com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeEditUI;
import com.kingdee.eas.ma.view.client.BgViewTemplateItemSelectUI;
import com.kingdee.eas.ma.view.client.common.BgBillIntegrateClientHelper;
import com.kingdee.eas.ma.view.client.common.BgBillIntegrateRuleHelper;
import com.kingdee.eas.ma.view.client.itemmap.BgEditorGeneratorFactory;
import com.kingdee.eas.ma.view.client.itemmap.BgItemDialogGenerator;
import com.kingdee.eas.ma.view.common.BgBillIntegrateCommonHelper;
import com.kingdee.eas.ma.view.common.BgRuleField;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgBillIntegrateItemMapHelper {
    private static Logger logger = Logger.getLogger((String)BgBillIntegrateItemMapHelper.class.getName());
    private static Map acctAsst = null;
    public static final String ROW_INDEX = "ROW_INDEX";
    public static final String COL_BGITEM = "bgItem";
    public static final String COL_BUSIPROPERTY = "busiProperty";
    public static final String COL_NUMBER = "_number";

    public static void resetItemMap(KDTable tblRules, KDTable tblItemMap, EntityObjectInfo entity, boolean isShowNumber) throws EASBizException, BOSException {
        List props = BgBillIntegrateRuleHelper.getRuleProperties(tblRules);
        BgBillIntegrateItemMapHelper.setItemMapTableColumnAndEditor(tblItemMap, entity, props, isShowNumber);
        BgBillIntegrateItemMapHelper.setColumnShow(tblItemMap, isShowNumber);
        BgBillIntegrateItemMapHelper.clearItemMapRow(tblItemMap, props);
    }

    public static void setItemMapTableColumnAndEditor(KDTable tblItemMap, EntityObjectInfo entity, List props, boolean isShowNumber) throws EASBizException, BOSException {
        if (tblItemMap == null || entity == null) {
            return;
        }
        Set propSet = BgBillIntegrateItemMapHelper.getAllProperties(props);
        HashSet needAdd = new HashSet(propSet);
        for (int i = tblItemMap.getColumnCount() - 1; i >= 0; --i) {
            String colKey = BgBillIntegrateItemMapHelper.getNumberColumnSourceName(tblItemMap.getColumnKey(i));
            if (COL_BGITEM.equals(colKey) || COL_BUSIPROPERTY.equals(colKey)) continue;
            if (propSet.contains(colKey)) {
                needAdd.remove(colKey);
                continue;
            }
            tblItemMap.removeColumn(i);
        }
        IColumn col = tblItemMap.getColumn(BgBillIntegrateItemMapHelper.getNumberColumnKey(COL_BGITEM));
        HashMap<String, EntityObjectInfo> params = new HashMap<String, EntityObjectInfo>();
        params.put("BILL_META", entity);
        for (String colKey : needAdd) {
            String colName = BgBillIntegrateItemMapHelper.getPropertyName(entity, colKey);
            col = tblItemMap.addColumn(col.getColumnIndex());
            col.setWidth(150);
            col.setKey(colKey);
            tblItemMap.getHeadRow(1).getCell(col.getColumnIndex()).setValue((Object)colName);
            col.setEditor(BgEditorGeneratorFactory.getEditor(entity.getFullName(), colKey, new HashMap(params)));
            col = tblItemMap.addColumn(col.getColumnIndex());
            col.setKey(BgBillIntegrateItemMapHelper.getNumberColumnKey(colKey));
            col.setWidth(120);
            col.getStyleAttributes().setLocked(true);
            tblItemMap.getHeadRow(1).getCell(col.getColumnIndex()).setValue((Object)(colName + BgBillIntegrateItemMapHelper.getNumberString()));
        }
    }

    public static boolean isNumberColumn(String colKey) {
        return !StringUtils.isEmpty((String)colKey) && colKey.endsWith(COL_NUMBER);
    }

    public static String getNumberColumnSourceName(String colKey) {
        if (BgBillIntegrateItemMapHelper.isNumberColumn(colKey)) {
            return colKey.substring(0, colKey.length() - COL_NUMBER.length());
        }
        return colKey;
    }

    public static String getNumberColumnKey(String colKey) {
        if (StringUtils.isEmpty((String)colKey) || BgBillIntegrateItemMapHelper.isNumberColumn(colKey)) {
            return colKey;
        }
        return colKey + COL_NUMBER;
    }

    public static void setColumnShow(KDTable tblItemMap, boolean isShowNumber) {
        if (tblItemMap != null) {
            tblItemMap.checkParsed();
            Set props = BgBillIntegrateItemMapHelper.getAllProperties(BgBillIntegrateItemMapHelper.getCurrPropertyFromItemMap(tblItemMap));
            props.add(COL_BGITEM);
            for (int i = 0; i < tblItemMap.getColumnCount(); ++i) {
                boolean isHided = false;
                String colKey = tblItemMap.getColumnKey(i);
                String sourceKey = BgBillIntegrateItemMapHelper.getNumberColumnSourceName(colKey);
                isHided = !props.contains(sourceKey) ? true : (BgBillIntegrateItemMapHelper.isNumberColumn(colKey) ? !isShowNumber : false);
                tblItemMap.getColumn(i).getStyleAttributes().setHided(isHided);
            }
            IColumn col = tblItemMap.getColumn(BgBillIntegrateItemMapHelper.getNumberColumnKey(COL_BGITEM));
            tblItemMap.getHeadMergeManager().removeAllMergeBlock();
            tblItemMap.getHeadMergeManager().mergeBlock(0, 0, 0, col.getColumnIndex() - 1);
            if (isShowNumber) {
                tblItemMap.getHeadMergeManager().mergeBlock(0, col.getColumnIndex(), 0, col.getColumnIndex() + 1);
            } else {
                tblItemMap.getHeadMergeManager().mergeBlock(0, col.getColumnIndex() + 1, 1, col.getColumnIndex() + 1);
            }
        }
    }

    private static Set getAllProperties(String property) {
        if (StringUtils.isEmpty((String)property)) {
            return new HashSet();
        }
        ArrayList<String> props = new ArrayList<String>();
        props.add(property);
        return BgBillIntegrateItemMapHelper.getAllProperties(props);
    }

    private static Set getAllProperties(List props) {
        Set<String> propSet = new HashSet();
        if (props != null) {
            for (int i = 0; i < props.size(); ++i) {
                if (StringUtils.isEmpty((String)((String)props.get(i)))) continue;
                propSet.addAll(Arrays.asList(((String)props.get(i)).split("@")));
            }
        }
        propSet = BgBillIntegrateCommonHelper.getSortSet(propSet);
        return propSet;
    }

    private static String getPropertyName(EntityObjectInfo entity, String property) throws EASBizException, BOSException {
        String name = "";
        if (entity != null && !StringUtils.isEmpty((String)property)) {
            if (BgItemDialogGenerator.isShowBgItemDialog(entity.getFullName(), entity.getFullName(), property)) {
                PropertyInfo prop = BgRuleField.getProperty(entity, property, false);
                name = prop != null ? prop.getAlias() : "";
                if (name.toLowerCase(Locale.ENGLISH).endsWith(BgBillIntegrateItemMapHelper.getNumberString())) {
                    name = name.substring(0, name.length() - BgBillIntegrateItemMapHelper.getNumberString().length());
                }
            } else {
                PropertyInfo prop = BgRuleField.getProperty(entity, property, true);
                if (prop != null) {
                    EntityObjectInfo subEntity;
                    if (prop instanceof LinkPropertyInfo && (subEntity = BgRuleField.getPropertyEntity(entity, property)) != null) {
                        BgBillIntegrateItemMapHelper.setAcctAsstName((LinkPropertyInfo)prop, subEntity.getFullName());
                    }
                    name = prop.getAlias();
                } else {
                    name = BgRuleField.getProperty(entity, property, false).getAlias();
                }
            }
        }
        return name;
    }

    private static final String getNumberString() {
        return EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"number");
    }

    private static void setAcctAsstName(LinkPropertyInfo prop, String entityName) throws EASBizException, BOSException {
        if (prop != null && "com.kingdee.eas.basedata.master.auxacct.app.GeneralAsstActType".equals(entityName)) {
            if (acctAsst == null) {
                acctAsst = BgControlFacadeFactory.getRemoteInstance().getGeneralAssActType();
            }
            if (acctAsst != null && acctAsst.containsKey(prop.getName())) {
                prop.setAlias(acctAsst.get(prop.getName()).toString());
            }
        }
    }

    private static void clearItemMapRow(KDTable tblItemMap, List props) {
        if (tblItemMap != null) {
            int i;
            HashSet<String> propSet = new HashSet<String>();
            if (props != null && !props.isEmpty()) {
                for (i = 0; i < props.size(); ++i) {
                    propSet.add(BgBillIntegrateItemMapHelper.getHashProperty((String)props.get(i)));
                }
            }
            for (i = tblItemMap.getRowCount() - 1; i >= 0; --i) {
                if (propSet.contains(tblItemMap.getRow(i).getCell(COL_BUSIPROPERTY).getValue())) continue;
                tblItemMap.removeRow(i);
            }
        }
    }

    private static String getHashProperty(String property) {
        return BgBillIntegrateCommonHelper.getBillProperty(BgBillIntegrateItemMapHelper.getAllProperties(property));
    }

    public static void initBgItemColF7(KDTable tblItemMap, String orgUnitId, Object ownUi) {
        if (tblItemMap != null) {
            tblItemMap.checkParsed();
            if (tblItemMap.getColumn(COL_BGITEM) != null) {
                tblItemMap.getColumn(BgBillIntegrateItemMapHelper.getNumberColumnKey(COL_BGITEM)).getStyleAttributes().setLocked(true);
                tblItemMap.getColumn(COL_BGITEM).setEditor(BgItemDialogGenerator.getEditor(orgUnitId, ownUi, false, null));
            }
        }
    }

    public static void loadItemMap(BgBillIntegrateItemMapCollection col, KDTable tblItemMap) {
        if (col == null || col.size() == 0 || tblItemMap == null) {
            return;
        }
        Object[] maps = col.toArray();
        for (int i = 0; i < maps.length; ++i) {
            BgBillIntegrateItemMapHelper.loadItemMap((BgBillIntegrateItemMapInfo)maps[i], tblItemMap);
        }
    }

    private static void loadItemMap(BgBillIntegrateItemMapInfo info, KDTable tblItemMap) {
        if (tblItemMap == null || info == null) {
            return;
        }
        Map billNumbers = BgBillIntegrateCommonHelper.getBillProperty(info.getBillItemNumber());
        Map billAlias = BgBillIntegrateCommonHelper.getBillProperty(info.getBillItemAlias());
        if (billNumbers.isEmpty()) {
            return;
        }
        IRow row = BgBillIntegrateItemMapHelper.addRow(tblItemMap);
        row.setUserObject((Object)info);
        String colKey2 = null;
        String number = null;
        String alias = null;
        for (String colKey2 : billNumbers.keySet()) {
            number = (String)billNumbers.get(colKey2);
            alias = (String)billAlias.get(colKey2);
            if (StringUtils.isEmpty((String)number) || "%".equals(number)) {
                number = "";
            }
            if (StringUtils.isEmpty((String)alias) || "%".equals(alias)) {
                alias = "";
            }
            if (row.getCell(colKey2) != null) {
                row.getCell(colKey2).setValue((Object)alias);
            }
            if (row.getCell(BgBillIntegrateItemMapHelper.getNumberColumnKey(colKey2)) == null) continue;
            row.getCell(BgBillIntegrateItemMapHelper.getNumberColumnKey(colKey2)).setValue((Object)number);
        }
        row.getCell(COL_BGITEM).setValue((Object)info.getBgItemAlias());
        row.getCell(BgBillIntegrateItemMapHelper.getNumberColumnKey(COL_BGITEM)).setValue((Object)info.getBgItemNumber());
        row.getCell(COL_BUSIPROPERTY).setValue((Object)BgBillIntegrateCommonHelper.getBillProperty(billNumbers.keySet()));
    }

    public static void setCurrPropertyToRow(IRow row, String property) {
        if (row != null && row.getCell(COL_BUSIPROPERTY) != null) {
            row.getCell(COL_BUSIPROPERTY).setValue((Object)property);
        }
    }

    private static String getCurrPropertyFromItemMap(KDTable tblItemMap) {
        if (tblItemMap != null) {
            return (String)tblItemMap.getUserObject();
        }
        return null;
    }

    public static final void storeItemMap(BgBillIntegrateSchemeInfo scheme, KDTable tblItemMap) {
        if (scheme == null || tblItemMap == null) {
            return;
        }
        BgBillIntegrateItemMapCollection col = new BgBillIntegrateItemMapCollection();
        for (int r = 0; r < tblItemMap.getRowCount(); ++r) {
            String billNumber;
            BgBillIntegrateItemMapInfo map = BgBillIntegrateItemMapHelper.getMapInfo(tblItemMap, r);
            if (map == null || !StringUtils.isEmpty((String)(billNumber = map.getBillItemNumber())) && billNumber.indexOf("|") <= 0 && billNumber.indexOf(":") > 0 && billNumber.substring(billNumber.indexOf(":") + 1).equals(map.getBgItemNumber())) continue;
            map.setScheme(scheme);
            col.add(map);
        }
        BgBillIntegrateCommonHelper.sortItemMap(col);
        scheme.getItemMap().clear();
        scheme.getItemMap().addCollection(col);
    }

    private static BgBillIntegrateItemMapInfo getMapInfo(KDTable tblItemMap, int rowIndex) {
        if (tblItemMap == null || tblItemMap.getRow(rowIndex) == null) {
            return null;
        }
        IRow row = tblItemMap.getRow(rowIndex);
        Set props = BgBillIntegrateItemMapHelper.getAllProperties(BgBillIntegrateItemMapHelper.getCurrPropertyFromRow(row));
        if (props == null || props.isEmpty()) {
            return null;
        }
        BgBillIntegrateItemMapInfo map = null;
        if (row.getUserObject() instanceof BgBillIntegrateItemMapInfo) {
            map = (BgBillIntegrateItemMapInfo)row.getUserObject();
        } else {
            map = new BgBillIntegrateItemMapInfo();
            row.setUserObject((Object)map);
        }
        String itemNumber = (String)row.getCell(BgBillIntegrateItemMapHelper.getNumberColumnKey(COL_BGITEM)).getValue();
        String itemAlias = (String)row.getCell(COL_BGITEM).getValue();
        StringBuffer billNumber = new StringBuffer();
        StringBuffer billAlias = new StringBuffer();
        String colKey2 = null;
        String number = null;
        String alias = null;
        for (String colKey2 : props) {
            if (billNumber.length() > 0) {
                billNumber.append("|");
            }
            if (billAlias.length() > 0) {
                billAlias.append("|");
            }
            number = (String)row.getCell(BgBillIntegrateItemMapHelper.getNumberColumnKey(colKey2)).getValue();
            alias = (String)row.getCell(colKey2).getValue();
            if (StringUtils.isEmpty((String)number)) {
                number = "%";
                alias = "";
            }
            billNumber.append(colKey2).append(":").append(number);
            billAlias.append(colKey2).append(":").append(alias);
        }
        map.setBgItemNumber(itemNumber);
        map.setBgItemAlias(itemAlias);
        map.setBillItemNumber(billNumber.toString());
        map.setBillItemAlias(billAlias.toString());
        return map;
    }

    public static String getCurrPropertyFromRow(IRow row) {
        if (row != null && row.getCell(COL_BUSIPROPERTY) != null) {
            return (String)row.getCell(COL_BUSIPROPERTY).getValue();
        }
        return null;
    }

    public static void deleteCellContent(KDTable tblItemMap) {
        if (tblItemMap == null || tblItemMap.getRowCount() == 0) {
            return;
        }
        KDTRange range = tblItemMap.getSelectManager().toRange();
        if (range == null || range.isEmpty()) {
            return;
        }
        for (int i = 0; i < range.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(i);
            int beginRow = BgBillIntegrateClientHelper.getBeginRow(block, tblItemMap);
            int endRow = BgBillIntegrateClientHelper.getEndRow(block, tblItemMap);
            for (int row = beginRow; row <= endRow; ++row) {
                for (int col = block.getBeginCol(); col <= block.getEndCol(); ++col) {
                    KDTEditEvent e = new KDTEditEvent((Object)tblItemMap, null, tblItemMap.getCell(row, col).getValue(), row, col, false, 14);
                    BgBillIntegrateItemMapHelper.cellDataChanged(e);
                }
            }
        }
    }

    public static void cellDataChanged(KDTEditEvent e) {
        if (e == null || !(e.getSource() instanceof KDTable)) {
            return;
        }
        KDTable tblItemMap = (KDTable)e.getSource();
        String colKey = tblItemMap.getColumnKey(e.getColIndex());
        if (StringUtils.isEmpty((String)colKey) || BgBillIntegrateItemMapHelper.isNumberColumn(colKey)) {
            return;
        }
        if (e.getValue() == null) {
            tblItemMap.getCell(e.getRowIndex(), BgBillIntegrateItemMapHelper.getNumberColumnKey(colKey)).setValue(null);
        } else if (e.getValue() instanceof IObjectValue) {
            IObjectValue value = (IObjectValue)e.getValue();
            String number = null;
            String name = null;
            number = value instanceof GeneralAsstActTypeInfo && colKey.endsWith("longNumber") ? value.getString("longNumber") : value.getString("number");
            name = value.get("name") instanceof String ? value.getString("name") : number;
            tblItemMap.getCell(e.getRowIndex(), colKey).setValue((Object)name);
            tblItemMap.getCell(e.getRowIndex(), BgBillIntegrateItemMapHelper.getNumberColumnKey(colKey)).setValue((Object)number);
        }
    }

    public static final void verifyItemMap(BgBillIntegrateSchemeEditUI editUi, BgBillIntegrateItemMapCollection col, String orgUnitId) throws BOSException, EASBizException {
        if (editUi == null || col == null || col.isEmpty()) {
            return;
        }
        HashSet<String> billNumbers = new HashSet<String>();
        HashMap<String, String> nullProperty = new HashMap<String, String>();
        HashMap bgItems = new HashMap();
        BgBillIntegrateItemMapInfo info = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            int row = i;
            if (info.get(ROW_INDEX) instanceof Integer) {
                row = (Integer)info.get(ROW_INDEX);
            }
            if (StringUtils.isEmpty((String)info.getBillItemNumber())) {
                editUi.showItemMapMsgAndAbort(row, "inputBillItem");
            }
            Map value = BgBillIntegrateCommonHelper.getBillProperty(info.getBillItemNumber());
            String property = BgBillIntegrateCommonHelper.getBillProperty(value.keySet());
            for (String k : value.keySet()) {
                String v = (String)value.get(k);
                if (!StringUtil.isEmpty((String)v) && !"%".equals(v)) continue;
                if (value.size() <= 1) {
                    editUi.showItemMapMsgAndAbort(row, "inputBillItem");
                    continue;
                }
                if (nullProperty.get(property) instanceof String && !((String)nullProperty.get(property)).equals(k)) {
                    editUi.showItemMapMsgAndAbort(row, "cannotMultiNull");
                    continue;
                }
                nullProperty.put(property, k);
            }
            if (billNumbers.contains(info.getBillItemNumber())) {
                editUi.showItemMapMsgAndAbort(row, "dumpBillItem");
            } else {
                billNumbers.add(info.getBillItemNumber());
            }
            if (StringUtils.isEmpty((String)info.getBgItemNumber())) {
                editUi.showItemMapMsgAndAbort(row, "inputBgItem1");
                continue;
            }
            bgItems.put(info.getBgItemNumber().replaceAll("_", ","), null);
        }
        bgItems = BgFormulaFacadeFactory.getRemoteInstance().batchParseBgItemCombi(bgItems, orgUnitId);
        String rpNumber = null;
        String newNumber = null;
        Object[] objs = null;
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            int row = i;
            if (info.get(ROW_INDEX) instanceof Integer) {
                row = (Integer)info.get(ROW_INDEX);
            }
            boolean isValid = false;
            rpNumber = info.getBgItemNumber().replaceAll("_", ",");
            if (bgItems.get(rpNumber) instanceof Object[] && (objs = (Object[])bgItems.get(rpNumber)).length >= 2 && objs[1] instanceof Boolean && objs[0] instanceof String && !((Boolean)objs[1]).booleanValue()) {
                isValid = true;
                newNumber = ((String)objs[0]).replaceAll(",", "_");
                info.setBgItemAlias(BgBillIntegrateCommonHelper.getNewCombinName(info.getBgItemNumber(), info.getBgItemAlias(), newNumber));
                info.setBgItemNumber(newNumber);
            }
            if (!isValid) {
                editUi.showItemMapMsgAndAbort(row, "ExistSameItemGroup");
            }
            info.remove(ROW_INDEX);
        }
    }

    public static void batchAddBgItemFromBgTemplate(KDTable tblItemMap, CoreUI ui, String orgUnitId) throws BOSException, EASBizException {
        Object[] result;
        Window parent;
        List rows = BgBillIntegrateItemMapHelper.getSelectBgItemRows(tblItemMap);
        if (rows == null || rows.isEmpty()) {
            return;
        }
        BgTemplatePromptDialog dlg = null;
        KDBizPromptBox box = new KDBizPromptBox();
        box.setQueryInfo("com.kingdee.eas.ma.budget.BgTemplateF7Query");
        if (dlg == null && (dlg = (parent = SwingUtilities.getWindowAncestor((Component)tblItemMap)) instanceof Dialog ? new BgTemplatePromptDialog((Dialog)parent) : (parent instanceof Frame ? new BgTemplatePromptDialog((Frame)parent) : new BgTemplatePromptDialog())).getQueryInfo() == null) {
            dlg.setQueryInfo(box.getQueryAgent().getQueryInfo());
            dlg.setSelectorCollection(dlg.getEntityViewInfo().getSelector());
            dlg.setQueryExecutor(box.getQueryAgent().getQueryExecutor());
            dlg.setEnabledMultiSelection(box.getQueryAgent().isEnabledMultiSelection());
            dlg.setReturnValueType(box.getQueryAgent().getReturnValueType());
            dlg.setIsShowAllTemp(true);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (BgSHelper.isBgPermissionUsed()) {
                HashSet<String> orgSet = new HashSet<String>();
                String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                orgSet.add(orgUnitId);
                filter = BgPermissionHelper.addBgTemplatePermission((String)userId, orgSet, (FilterInfo)filter);
            }
            view.setFilter(filter);
            dlg.setEntityViewInfo(view);
        }
        dlg.show();
        if (!dlg.isCanceled() && (result = (Object[])dlg.getData()) != null && result.length == 1 && result[0] instanceof BgTemplateInfo) {
            BgTemplateInfo bgTemplate = (BgTemplateInfo)result[0];
            String bgTemId = bgTemplate.getId().toString();
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"ID", (Object)bgTemId);
            uiContext.put((Object)"systime", (Object)("" + System.currentTimeMillis()));
            uiContext.put((Object)"isView", (Object)Boolean.TRUE);
            uiContext.put((Object)"OpenTemplate", (Object)new Boolean(true));
            uiContext.put((Object)"openType", (Object)"report");
            uiContext.put((Object)"isShowFormat", (Object)Boolean.TRUE);
            uiContext.put((Object)"isSelectItemCombin", (Object)Boolean.TRUE);
            uiContext.put((Object)BgNTemplateProcessUI.getCHOOSE_ITEM(), (Object)"true");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTemFormTypeEnum.VIEWFORM.equals((Object)bgTemplate.getFormType()) ? BgViewTemplateItemSelectUI.class.getName() : BgNTemplateProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            if (uiWindow.getUIObject() != null && uiWindow.getUIObject() instanceof IBgTemplateSelectItem) {
                IBgTemplateSelectItem processui = (IBgTemplateSelectItem)uiWindow.getUIObject();
                uiWindow.show();
                if (processui.getItemCombinNumberList() != null && processui.getItemCombinNumberList().size() != 0) {
                    String number;
                    int i;
                    BgItemCollection coll = new BgItemCollection();
                    List bgItemCombinList = processui.getItemCombinNumberList();
                    Map<String, Object> bgItemCombinMap = new HashMap();
                    for (i = 0; i < bgItemCombinList.size(); ++i) {
                        number = (String)bgItemCombinList.get(i);
                        bgItemCombinMap.put(number.replaceAll(",", "_"), null);
                    }
                    bgItemCombinMap = BgBudgetFacadeFactory.getRemoteInstance().getSelectBgItemCombinName(bgItemCombinMap, orgUnitId);
                    for (i = 0; i < bgItemCombinList.size(); ++i) {
                        number = (String)bgItemCombinList.get(i);
                        BgItemInfo info = new BgItemInfo();
                        String name = (String)bgItemCombinMap.get(number.replaceAll(",", "_"));
                        if (name == null || name.equals("null")) continue;
                        info.setNumber(number.replaceAll(",", "_"));
                        info.setName(name);
                        coll.add(info);
                    }
                    BgBillIntegrateItemMapHelper.fillBgItem(coll, tblItemMap, rows, false);
                }
            }
        }
    }

    private static List getSelectBgItemRows(KDTable tblItemMap) {
        if (tblItemMap == null || tblItemMap.getRowCount() == 0) {
            MsgBox.showInfo((Component)tblItemMap, (String)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"selectBgItemCol"));
            return null;
        }
        int bgItemColIndex = tblItemMap.getColumnIndex(COL_BGITEM);
        KDTRange range = tblItemMap.getSelectManager().toRange();
        if (range == null || range.size() == 0) {
            MsgBox.showInfo((Component)tblItemMap, (String)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"selectBgItemCol"));
            return null;
        }
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int i = 0; i < range.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(i);
            if (block.getBeginCol() != bgItemColIndex || block.getEndCol() != bgItemColIndex) {
                MsgBox.showInfo((Component)tblItemMap, (String)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"selectBgItemCol"));
                return null;
            }
            int beginRow = BgBillIntegrateClientHelper.getBeginRow(block, tblItemMap);
            int endRow = BgBillIntegrateClientHelper.getEndRow(block, tblItemMap);
            for (int row = beginRow; row <= endRow; ++row) {
                if (tblItemMap.getRow(row) != null && tblItemMap.getRow(row).getStyleAttributes().isHided()) continue;
                rows.add(new Integer(row));
            }
        }
        return rows;
    }

    private static void fillBgItem(BgItemCollection coll, KDTable tblMap, List rows, boolean isAppend) {
        if (coll == null || coll.isEmpty() || tblMap == null || rows == null || rows.isEmpty()) {
            return;
        }
        int count = coll.size() - rows.size();
        int rowIndex = (Integer)rows.get(rows.size() - 1);
        for (int i = 0; i < count; ++i) {
            if (tblMap.getRow(++rowIndex) == null) {
                rows.add(new Integer(BgBillIntegrateItemMapHelper.addRow(tblMap).getRowIndex()));
                continue;
            }
            if (tblMap.getRow(rowIndex).getStyleAttributes().isHided()) {
                --i;
                continue;
            }
            rows.add(new Integer(rowIndex));
        }
        int index = 0;
        for (int i = 0; i < rows.size(); ++i) {
            ICell cellNumber = tblMap.getCell(((Integer)rows.get(i)).intValue(), BgBillIntegrateItemMapHelper.getNumberColumnKey(COL_BGITEM));
            ICell cellName = tblMap.getCell(((Integer)rows.get(i)).intValue(), COL_BGITEM);
            if (cellNumber == null || cellName == null) continue;
            BgItemInfo item = coll.get(index);
            if (isAppend && cellNumber.getValue() instanceof String && !StringUtils.isEmpty((String)((String)cellNumber.getValue()))) {
                cellNumber.setValue((Object)(cellNumber.getValue() + "_" + item.getNumber()));
                cellName.setValue((Object)(cellName.getValue() + "_" + item.getName()));
            } else {
                cellNumber.setValue((Object)item.getNumber());
                cellName.setValue((Object)item.getName());
            }
            if (index == coll.size() - 1) {
                index = 0;
                continue;
            }
            ++index;
        }
    }

    public static void batchAddBillItem(KDTable tblItemMap, EntityObjectInfo bill) {
        if (tblItemMap == null || tblItemMap.getRowCount() == 0 || bill == null) {
            MsgBox.showInfo((Component)tblItemMap, (String)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"selectBillItemCol"));
            return;
        }
        KDTRange range = tblItemMap.getSelectManager().toRange();
        if (range == null || range.isEmpty()) {
            MsgBox.showInfo((Component)tblItemMap, (String)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"selectBillItemCol"));
            return;
        }
        ArrayList<Integer> rows = new ArrayList<Integer>();
        String colKey = null;
        for (int i = 0; i < range.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(i);
            if (block.getBeginCol() != block.getEndCol() || block.getBeginCol() == 0 || block.getBeginCol() >= tblItemMap.getColumnIndex(BgBillIntegrateItemMapHelper.getNumberColumnKey(COL_BGITEM))) {
                MsgBox.showInfo((Component)tblItemMap, (String)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"selectBillItemCol"));
                return;
            }
            String ck = tblItemMap.getColumnKey(block.getBeginCol());
            if (StringUtils.isEmpty((String)ck) || BgBillIntegrateItemMapHelper.isNumberColumn(ck) || colKey != null && !colKey.equals(ck)) {
                MsgBox.showInfo((Component)tblItemMap, (String)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"selectBillItemCol"));
                return;
            }
            colKey = ck;
            int beginRow = BgBillIntegrateClientHelper.getBeginRow(block, tblItemMap);
            int endRow = BgBillIntegrateClientHelper.getEndRow(block, tblItemMap);
            for (int row = beginRow; row <= endRow; ++row) {
                if (tblItemMap.getRow(row) != null && tblItemMap.getRow(row).getStyleAttributes().isHided()) continue;
                rows.add(new Integer(row));
            }
        }
        if (rows.isEmpty() || StringUtils.isEmpty(colKey)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("BILL_META", bill);
        params.put("ENABLE_MULTI_SELECT", Boolean.TRUE);
        ICellEditor editor = BgEditorGeneratorFactory.getEditor(bill.getFullName(), colKey, params);
        if (editor == null || !(editor.getComponent() instanceof KDBizPromptBox)) {
            return;
        }
        KDBizPromptBox box = (KDBizPromptBox)editor.getComponent();
        KDCommonPromptDialog dlg = null;
        Window parent = SwingUtilities.getWindowAncestor((Component)tblItemMap);
        dlg = parent instanceof Dialog ? new KDCommonPromptDialog((Dialog)parent) : (parent instanceof Frame ? new KDCommonPromptDialog((Frame)parent) : new KDCommonPromptDialog());
        if (dlg.getQueryInfo() == null) {
            dlg.setQueryInfo(box.getQueryAgent().getQueryInfo());
            dlg.setEntityViewInfo(box.getEntityViewInfo());
            SelectorItemCollection itemColl = dlg.getEntityViewInfo().getSelector();
            itemColl.add(new SelectorItemInfo("name"));
            itemColl.add(new SelectorItemInfo("number"));
            itemColl.add(new SelectorItemInfo("longNumber"));
            dlg.setSelectorCollection(itemColl);
            dlg.setQueryExecutor(box.getQueryAgent().getQueryExecutor());
            dlg.setEnabledMultiSelection(box.getQueryAgent().isEnabledMultiSelection());
            dlg.setReturnValueType(box.getQueryAgent().getReturnValueType());
        }
        dlg.show();
        if (dlg.isCanceled()) {
            return;
        }
        Object[] result = (Object[])dlg.getData();
        if (result != null && result.length > 0) {
            HashMap<Object, IObjectValue> number2ValueMap = new HashMap<Object, IObjectValue>();
            ArrayList<Object> numberList = new ArrayList<Object>();
            for (int i = 0; i < result.length; ++i) {
                IObjectValue val;
                Object number;
                if (!(result[i] instanceof IObjectValue) || (number = (val = (IObjectValue)result[i]).get("number")) == null) continue;
                number2ValueMap.put(number, val);
                numberList.add(number);
            }
            if (!numberList.isEmpty() && numberList.size() == result.length) {
                Collections.sort(numberList);
                for (int j = 0; j < numberList.size(); ++j) {
                    result[j] = number2ValueMap.get(numberList.get(j));
                }
            }
        }
        BgBillIntegrateItemMapHelper.fillBillItemColl(result, tblItemMap, colKey, rows);
    }

    private static void fillBillItemColl(Object[] result, KDTable tblItemMap, String colKey, List rows) {
        if (result == null || result.length == 0 || tblItemMap == null || rows == null || rows.isEmpty() || StringUtils.isEmpty((String)colKey)) {
            return;
        }
        int count = result.length - rows.size();
        int rowIndex = (Integer)rows.get(rows.size() - 1);
        for (int i = 0; i < count; ++i) {
            if (tblItemMap.getRow(++rowIndex) == null) {
                rows.add(new Integer(BgBillIntegrateItemMapHelper.addRow(tblItemMap).getRowIndex()));
                continue;
            }
            if (tblItemMap.getRow(rowIndex).getStyleAttributes().isHided()) {
                --i;
                continue;
            }
            rows.add(new Integer(rowIndex));
        }
        IObjectValue info = null;
        int index = 0;
        for (int i = 0; i < rows.size(); ++i) {
            int row = (Integer)rows.get(i);
            ICell cell = tblItemMap.getCell(row, colKey);
            if (cell == null) continue;
            info = (IObjectValue)result[index];
            cell.setValue(info.get("name"));
            tblItemMap.getCell(row, BgBillIntegrateItemMapHelper.getNumberColumnKey(colKey)).setValue(info.get("number"));
            if (index == result.length - 1) {
                index = 0;
                continue;
            }
            ++index;
        }
    }

    public static void batchAddBgItem(KDTable tblItemMap, CoreUI ui, String orgUnitId) {
        List rows = BgBillIntegrateItemMapHelper.getSelectBgItemRows(tblItemMap);
        if (rows == null || rows.isEmpty()) {
            return;
        }
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"isSelectCombinItem", (Object)Boolean.FALSE);
        uiContext.put((Object)"ORGUNITID", (Object)orgUnitId);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.budget.client.NewBgItemGroupListF7UI", (Map)uiContext);
        }
        catch (UIException e1) {
            logger.error((Object)e1);
            ExceptionHandler.handle((Component)ui, (Throwable)e1);
            SysUtil.abort();
        }
        uiWindow.show();
        NewBgItemGroupListF7UI f7ui = (NewBgItemGroupListF7UI)uiWindow.getUIObject();
        if (f7ui.getResult() != null && ((BgItemObject)f7ui.getResult()).getResult().size() != 0) {
            BgItemCollection coll = ((BgItemObject)f7ui.getResult()).getResult();
            BgBillIntegrateItemMapHelper.fillBgItem(coll, tblItemMap, rows, true);
        }
    }

    public static void setWilDard(KDTable tblItemMap) {
        String colKey;
        Object[] res = BgBillIntegrateItemMapHelper.getSelectBillItemCol(tblItemMap);
        if (res == null) {
            return;
        }
        int rowIndex = (Integer)res[0];
        if (tblItemMap.getCell(rowIndex, BgBillIntegrateItemMapHelper.getNumberColumnKey(colKey = (String)res[1])).getValue() instanceof String) {
            String number = (String)tblItemMap.getCell(rowIndex, BgBillIntegrateItemMapHelper.getNumberColumnKey(colKey)).getValue();
            String name = (String)tblItemMap.getCell(rowIndex, colKey).getValue();
            if (!StringUtils.isEmpty((String)number)) {
                if (number.endsWith("%")) {
                    number = number.substring(0, number.length() - 1);
                    if (!StringUtils.isEmpty((String)name) && name.endsWith("%")) {
                        name = name.substring(0, name.length() - 1);
                    }
                } else {
                    number = number + "%";
                    if (!StringUtils.isEmpty((String)name) && !name.endsWith("%")) {
                        name = name + "%";
                    }
                }
                tblItemMap.getCell(rowIndex, colKey).setValue((Object)name);
                tblItemMap.getCell(rowIndex, BgBillIntegrateItemMapHelper.getNumberColumnKey(colKey)).setValue((Object)number);
            }
        }
    }

    private static Object[] getSelectBillItemCol(KDTable tblItemMap) {
        if (tblItemMap == null || tblItemMap.getRowCount() == 0) {
            MsgBox.showInfo((Component)tblItemMap, (String)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"selectOneBillItem"));
            return null;
        }
        KDTRange range = tblItemMap.getSelectManager().toRange();
        if (range == null || range.size() != 1 || ((KDTSelectBlock)range.get(0)).getMode() != 1 || ((KDTSelectBlock)range.get(0)).size() != 1) {
            MsgBox.showInfo((Component)tblItemMap, (String)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"selectOneBillItem"));
            return null;
        }
        KDTSelectBlock block = (KDTSelectBlock)range.get(0);
        int rowIndex = block.getBeginRow();
        int colIndex = block.getBeginCol();
        String colKey = BgBillIntegrateItemMapHelper.getNumberColumnSourceName(tblItemMap.getColumnKey(colIndex));
        if (rowIndex < 0 || colIndex <= 0 || StringUtils.isEmpty((String)colKey) || COL_BGITEM.equals(colKey)) {
            MsgBox.showInfo((Component)tblItemMap, (String)EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"selectOneBillItem"));
            return null;
        }
        return new Object[]{new Integer(rowIndex), colKey};
    }

    public static void move(KDTable tblItemMap, boolean isUp) {
        if (tblItemMap == null || tblItemMap.getSelectManager().size() == 0) {
            return;
        }
        int rowIndex = tblItemMap.getSelectManager().get(0).getTop();
        int colIndex = tblItemMap.getSelectManager().get(0).getLeft();
        String colKey = BgBillIntegrateItemMapHelper.getNumberColumnSourceName(tblItemMap.getColumnKey(colIndex));
        int targetRow = -1;
        int step = isUp ? -1 : 1;
        for (int i = rowIndex + step; i >= 0 && i < tblItemMap.getRowCount(); i += step) {
            if (tblItemMap.getRow(i).getStyleAttributes().isHided()) continue;
            targetRow = i;
            break;
        }
        if (targetRow < 0) {
            return;
        }
        BgBillIntegrateItemMapHelper.swap(rowIndex, targetRow, colKey, tblItemMap);
        colKey = BgBillIntegrateItemMapHelper.getNumberColumnKey(colKey);
        BgBillIntegrateItemMapHelper.swap(rowIndex, targetRow, colKey, tblItemMap);
        tblItemMap.getSelectManager().set(targetRow, colIndex);
    }

    private static void swap(int row1, int row2, String colKey, KDTable table) {
        if (table != null && table.getCell(row1, colKey) != null && table.getCell(row2, colKey) != null) {
            Object temp = table.getCell(row1, colKey).getValue();
            table.getCell(row1, colKey).setValue(table.getCell(row2, colKey).getValue());
            table.getCell(row2, colKey).setValue(temp);
        }
    }

    public static IRow addRow(KDTable tblItemMap) {
        if (tblItemMap != null) {
            IRow row = tblItemMap.addRow();
            BgBillIntegrateItemMapInfo map = new BgBillIntegrateItemMapInfo();
            row.setUserObject((Object)map);
            BgBillIntegrateItemMapHelper.setCurrPropertyToRow(row, BgBillIntegrateItemMapHelper.getCurrPropertyFromItemMap(tblItemMap));
            return row;
        }
        return null;
    }

    public static void removeRow(KDTable tblItemMap) {
        BgBillIntegrateClientHelper.removeRows(tblItemMap);
    }

    public static void setCurrentBgItemSource(String property, KDTable tblItemMap, BgBillIntegrateSchemeEditUI ui, boolean isShowNumber) {
        property = BgBillIntegrateItemMapHelper.getHashProperty(property);
        BgBillIntegrateItemMapHelper.setCurrPropertyToItemMap(tblItemMap, ui, property);
        BgBillIntegrateItemMapHelper.setColumnShow(tblItemMap, isShowNumber);
        if (tblItemMap != null) {
            for (int i = 0; i < tblItemMap.getRowCount(); ++i) {
                IRow row = tblItemMap.getRow(i);
                if (StringUtils.isEmpty((String)property)) {
                    row.getStyleAttributes().setHided(true);
                    continue;
                }
                row.getStyleAttributes().setHided(!property.equals(BgBillIntegrateItemMapHelper.getCurrPropertyFromRow(row)));
            }
        }
    }

    private static void setCurrPropertyToItemMap(KDTable tblItemMap, BgBillIntegrateSchemeEditUI ui, String property) {
        if (tblItemMap != null) {
            tblItemMap.setUserObject((Object)property);
        }
        if (ui != null) {
            ui.setEnableAddItemMap(!StringUtils.isEmpty((String)property));
        }
    }
}

