/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.common;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.view.BgBillIntegrateRuleCollection;
import com.kingdee.eas.ma.view.BgBillIntegrateRuleInfo;
import com.kingdee.eas.ma.view.client.common.BgBillIntegrateClientHelper;
import com.kingdee.eas.ma.view.client.rules.BgRuleDataInfo;
import com.kingdee.eas.ma.view.client.rules.IBgCellConvertor;
import com.kingdee.eas.ma.view.common.BgRuleField;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BgBillIntegrateRuleHelper {
    private static Logger logger = Logger.getLogger((String)BgBillIntegrateRuleHelper.class.getName());
    public static final String COL_ORG = "orgUnit";
    public static final String COL_BGITEM = "dimension";
    public static final String COL_CURRENCY = "currency";
    public static final String COL_BGELEMENT = "element";
    public static final String COL_PERIODTYPE = "periodType";
    public static final String COL_BIZDATE = "bizDate";
    public static final String COL_BIZPROPERTY = "request";
    public static final String COL_CONDINATION = "ruleCondition";
    public static final String[] COLS = new String[]{"orgUnit", "dimension", "currency", "element", "periodType", "bizDate", "request", "ruleCondition"};

    public static void loadRule(IRow row, BgBillIntegrateRuleInfo rule, EntityObjectInfo entity, KDTable tblRules) throws Exception {
        if (row == null || rule == null || entity == null) {
            return;
        }
        row.setUserObject((Object)rule);
        for (int i = 0; i < COLS.length; ++i) {
            BgBillIntegrateRuleHelper.getInstance(COLS[i]).loadToCell(row, (IObjectValue)rule, entity, BgBillIntegrateRuleHelper.getColName(tblRules, COLS[i]));
        }
    }

    public static void storeRule(IRow row, BgBillIntegrateRuleInfo rule) throws Exception {
        if (row == null || rule == null) {
            return;
        }
        for (int i = 0; i < COLS.length; ++i) {
            BgBillIntegrateRuleHelper.getInstance(COLS[i]).storeFromCell(row, (IObjectValue)rule);
        }
    }

    public static void verifyRules(KDTable tblRules, BgBillIntegrateRuleCollection ruleCol) throws Exception {
        if (ruleCol != null && !ruleCol.isEmpty()) {
            HashMap<String, Integer> rules = new HashMap<String, Integer>();
            for (int rIndex = 0; rIndex < ruleCol.size(); ++rIndex) {
                StringBuffer ruleString = new StringBuffer();
                for (int i = 0; i < COLS.length; ++i) {
                    Object obj = BgBillIntegrateRuleHelper.getInstance(COLS[i]).verify((IObjectValue)ruleCol.get(rIndex), BgBillIntegrateRuleHelper.getColName(tblRules, COLS[i]));
                    if (ruleString.length() > 0) {
                        ruleString.append(",");
                    }
                    ruleString.append(obj);
                }
                if (rules.containsKey(ruleString.toString())) {
                    MsgBox.showInfo((Component)tblRules, (String)MessageFormat.format(BgBillIntegrateClientHelper.getResource("ctrlRuleDup"), rules.get(ruleString.toString()), new Integer(rIndex + 1)));
                    SysUtil.abort();
                    continue;
                }
                rules.put(ruleString.toString(), new Integer(rIndex + 1));
            }
        } else {
            MsgBox.showInfo((Component)tblRules, (String)BgBillIntegrateClientHelper.getResource("controlRuleNull"));
            SysUtil.abort();
        }
    }

    private static String getColName(KDTable tblRules, String colKey) {
        if (tblRules == null || StringUtils.isEmpty((String)colKey)) {
            return null;
        }
        tblRules.checkParsed();
        if (tblRules.getHeadRow(0).getCell(colKey) != null) {
            return (String)tblRules.getHeadRow(0).getCell(colKey).getValue();
        }
        return null;
    }

    public static void initRulesTableF7(CoreUI ui, KDTable tblRules) {
        if (tblRules == null) {
            return;
        }
        tblRules.checkParsed();
        for (int i = 0; i < tblRules.getColumnCount(); ++i) {
            IColumn col = tblRules.getColumn(i);
            if (col == null) continue;
            col.setEditor(BgBillIntegrateRuleHelper.getCellEditor(ui, col.getKey()));
        }
    }

    private static ICellEditor getCellEditor(CoreUI ui, String columnKey) {
        if (!StringUtils.isEmpty((String)columnKey)) {
            try {
                return BgBillIntegrateRuleHelper.getInstance(columnKey).getCellEditor(ui);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)("ClassNotFound :" + e));
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return null;
    }

    private static IBgCellConvertor getInstance(String colKey) throws Exception {
        if (StringUtils.isEmpty((String)colKey)) {
            return null;
        }
        String className = "com.kingdee.eas.ma.view.client.rules." + colKey.substring(0, 1).toUpperCase() + colKey.substring(1) + "RuleCellConvertor";
        return (IBgCellConvertor)Class.forName(className).newInstance();
    }

    public static List getRuleProperties(KDTable tblRules) {
        ArrayList<String> res = new ArrayList<String>();
        if (tblRules != null) {
            for (int i = 0; i < tblRules.getRowCount(); ++i) {
                String prop = BgBillIntegrateRuleHelper.getRuleProperty(tblRules, i);
                if (StringUtils.isEmpty((String)prop)) continue;
                res.add(prop);
            }
        }
        return res;
    }

    public static String getRuleProperty(KDTable tblRules, int rowIndex) {
        String expression = null;
        if (tblRules != null && tblRules.getCell(rowIndex, COL_BGITEM) != null && tblRules.getCell(rowIndex, COL_BGITEM).getValue() instanceof BgRuleDataInfo) {
            expression = ((BgRuleDataInfo)tblRules.getCell(rowIndex, COL_BGITEM).getValue()).getExpression();
        }
        if (StringUtils.isEmpty(expression)) {
            return null;
        }
        if (expression != null) {
            StringBuffer res = new StringBuffer();
            String[] exprs = expression.split("@");
            for (int i = 0; i < exprs.length; ++i) {
                if (i > 0) {
                    res.append("@");
                }
                res.append(BgRuleField.parseField(exprs[i]).getName());
            }
            if (res.length() > 0) {
                return res.toString();
            }
            return null;
        }
        return null;
    }
}

