/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.common;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.view.client.action.actions.ActionDimensionChange;
import com.kingdee.eas.ma.view.client.common.BgDimensionPromptBox;
import com.kingdee.eas.ma.view.client.common.BgItemDimensionDiaolg;
import com.kingdee.eas.ma.view.client.common.BgViewClientHelper;
import com.kingdee.eas.ma.view.client.common.BgViewOrgDimensionF7;
import com.kingdee.eas.ma.view.client.common.LineFlowLayout;
import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.BgDimensionMember;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.util.BgViewCommonHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public final class BgDimensionParseHelper {
    public static final String RES_VIEWTEMP = "com.kingdee.eas.ma.view.client.BgViewTemplateResource";
    public static final String DIMENSION = "DIMENSION";
    public static final String DIMENSION_ORGUNIT = "orgunit";
    public static final String DIMENSION_BGITEM = "bgitem";
    public static final String DIMENSION_BGPERIOD = "bgperiod";
    public static final String DIMENSION_BGELEMENT = "bgelement";
    public static final String DIMENSION_CURRENCY = "currency";

    public static Component parsePageBgDimension(IUIObject owner, String orgUnitId, IBgDimensionManager bgDimensionManager, boolean isEnable, List f7List) {
        KDPanel page = new KDPanel();
        page.setLayout((LayoutManager)new LineFlowLayout(0));
        page.setEnabled(isEnable);
        BgDimensionInfo dimensionInfo = null;
        int in = bgDimensionManager.getPageDisplayDimension().size();
        for (int i = 0; i < in; ++i) {
            dimensionInfo = (BgDimensionInfo)bgDimensionManager.getPageDisplayDimension().get(i);
            if (DIMENSION_ORGUNIT.equalsIgnoreCase(dimensionInfo.getType())) {
                BgDimensionParseHelper.parseOrgUnitDimension(owner, page, dimensionInfo, isEnable, f7List);
                continue;
            }
            if (DIMENSION_BGITEM.equalsIgnoreCase(dimensionInfo.getType())) {
                BgDimensionParseHelper.parseBgItemDimension(owner, page, orgUnitId, dimensionInfo, isEnable, f7List);
                continue;
            }
            if (DIMENSION_BGPERIOD.equalsIgnoreCase(dimensionInfo.getType())) {
                BgDimensionParseHelper.parseBgPeriodDimension(owner, page, dimensionInfo, isEnable, f7List);
                continue;
            }
            if (DIMENSION_BGELEMENT.equalsIgnoreCase(dimensionInfo.getType())) {
                BgDimensionParseHelper.parseBgElementDimension(owner, page, dimensionInfo, isEnable, f7List);
                continue;
            }
            if (!DIMENSION_CURRENCY.equalsIgnoreCase(dimensionInfo.getType())) continue;
            BgDimensionParseHelper.parseCurrencyDimension(owner, page, dimensionInfo, false, f7List);
        }
        return page;
    }

    private static KDLabelContainer createContainer() {
        KDLabelContainer cont = new KDLabelContainer();
        cont.setBounds(new Rectangle(240, 19));
        cont.setBoundLabelLength(80);
        cont.setBoundLabelUnderline(true);
        cont.setPreferredSize(new Dimension(240, 19));
        cont.setMinimumSize(new Dimension(240, 19));
        return cont;
    }

    private static KDBizPromptBox createBizPrmt(IUIObject owner) {
        BgDimensionPromptBox prmt = new BgDimensionPromptBox();
        prmt.setBounds(new Rectangle(150, 19));
        prmt.setEditable(false);
        prmt.setCommitFormat("$number$");
        prmt.setEditFormat("$number$");
        prmt.setDisplayFormat("$name$");
        prmt.setEnabledMultiSelection(false);
        prmt.addDataChangeListener(new ActionDimensionChange(owner));
        return prmt;
    }

    private static void parseOrgUnitDimension(IUIObject owner, KDPanel panel, BgDimensionInfo dimensionInfo, boolean isEnable, List f7List) {
        KDLabelContainer contOrgUnit = BgDimensionParseHelper.createContainer();
        contOrgUnit.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)dimensionInfo.getType()));
        KDBizPromptBox prmtOrgUnit = BgDimensionParseHelper.createBizPrmt(owner);
        prmtOrgUnit.setName(dimensionInfo.getAttributeNumber());
        BgViewOrgDimensionF7 f7 = new BgViewOrgDimensionF7(owner);
        f7.setPermissionItem("bg_form04_update");
        f7.setMembers(dimensionInfo.getMember());
        prmtOrgUnit.setSelector((KDPromptSelector)f7);
        contOrgUnit.setBoundEditor((JComponent)prmtOrgUnit);
        prmtOrgUnit.setEnabled(isEnable);
        if (dimensionInfo.getMember().isEmpty()) {
            prmtOrgUnit.setEnabled(false);
        }
        f7List.add(prmtOrgUnit);
        panel.add((Component)contOrgUnit);
    }

    private static void parseBgItemDimension(IUIObject owner, KDPanel panel, String orgUnitId, BgDimensionInfo dimensionInfo, boolean isEnable, List f7List) {
        KDLabelContainer contBgItem = BgDimensionParseHelper.createContainer();
        panel.add((Component)contBgItem);
        String[] group = dimensionInfo.getAttribute().split(",");
        String groupNumber = group[0];
        if (group.length == 2) {
            contBgItem.setBoundLabelText(group[1]);
            contBgItem.setToolTipText(group[1]);
        } else {
            contBgItem.setBoundLabelText(group[0]);
            contBgItem.setToolTipText(group[0]);
        }
        KDBizPromptBox prmtBgItem = BgDimensionParseHelper.createBizPrmt(owner);
        prmtBgItem.setName(dimensionInfo.getAttributeNumber());
        prmtBgItem.setEnabled(isEnable);
        BgItemDimensionDiaolg dialog = new BgItemDimensionDiaolg(owner, dimensionInfo);
        dialog.setOrgUnitId(orgUnitId);
        prmtBgItem.setSelector((KDPromptSelector)dialog);
        BgDimensionParseHelper.setDefault(prmtBgItem, dimensionInfo);
        contBgItem.setBoundEditor((JComponent)prmtBgItem);
        f7List.add(prmtBgItem);
    }

    private static void parseBgPeriodDimension(IUIObject owner, KDPanel panel, BgDimensionInfo dimensionInfo, boolean isEnable, List f7List) {
        KDLabelContainer contBgPeriod = BgDimensionParseHelper.createContainer();
        contBgPeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)dimensionInfo.getType()));
        panel.add((Component)contBgPeriod);
        KDBizPromptBox prmtBgPeriod = BgDimensionParseHelper.createBizPrmt(owner);
        prmtBgPeriod.setName(dimensionInfo.getAttributeNumber());
        prmtBgPeriod.setEnabled(isEnable);
        prmtBgPeriod.setQueryInfo("com.kingdee.eas.ma.budget.BgPeriodQuery");
        BgDimensionParseHelper.setNumberFilter(prmtBgPeriod, dimensionInfo);
        contBgPeriod.setBoundEditor((JComponent)prmtBgPeriod);
        f7List.add(prmtBgPeriod);
    }

    private static void parseBgElementDimension(IUIObject owner, KDPanel panel, BgDimensionInfo dimensionInfo, boolean isEnable, List f7List) {
        KDLabelContainer contBgElement = BgDimensionParseHelper.createContainer();
        contBgElement.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)dimensionInfo.getType()));
        panel.add((Component)contBgElement);
        KDBizPromptBox prmtElement = BgDimensionParseHelper.createBizPrmt(owner);
        prmtElement.setName(dimensionInfo.getAttributeNumber());
        prmtElement.setEnabled(isEnable);
        prmtElement.setQueryInfo("com.kingdee.eas.ma.budget.BgElementQuery");
        BgDimensionParseHelper.setNumberFilter(prmtElement, dimensionInfo);
        contBgElement.setBoundEditor((JComponent)prmtElement);
        f7List.add(prmtElement);
    }

    private static void setNumberFilter(KDBizPromptBox prmt, BgDimensionInfo dimensionInfo) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        if (dimensionInfo.getMember().isEmpty()) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)"number", CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)"number", CompareType.NOTEQUALS));
        } else {
            HashSet<String> numbers = new HashSet<String>();
            for (int i = 0; i < dimensionInfo.getMember().size(); ++i) {
                numbers.add(((BgDimensionMember)dimensionInfo.getMember().get(i)).getNumber());
            }
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
        }
        prmt.setEntityViewInfo(evi);
        BgDimensionParseHelper.setDefault(prmt, dimensionInfo);
    }

    private static void setDefault(KDBizPromptBox prmt, BgDimensionInfo dimensionInfo) {
        if (!dimensionInfo.getMember().isEmpty()) {
            prmt.setDataNoNotify(dimensionInfo.getMember().get(0));
        }
    }

    private static void parseCurrencyDimension(IUIObject owner, KDPanel panel, BgDimensionInfo dimensionInfo, boolean isEnable, List f7List) {
        KDLabelContainer contCurrency = BgDimensionParseHelper.createContainer();
        contCurrency.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)dimensionInfo.getType()));
        panel.add((Component)contCurrency);
        KDBizPromptBox prmtCurrency = BgDimensionParseHelper.createBizPrmt(owner);
        prmtCurrency.setName(dimensionInfo.getAttributeNumber());
        prmtCurrency.setEnabled(isEnable);
        prmtCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CurrencyQuery");
        BgDimensionParseHelper.setNumberFilter(prmtCurrency, dimensionInfo);
        contCurrency.setBoundEditor((JComponent)prmtCurrency);
        f7List.add(prmtCurrency);
    }

    public static Book parseRowAndColDimension(IBgDimensionManager bgDimensionManager) {
        Book book = Book.Manager.getNewBook(null, (int)1);
        if (bgDimensionManager == null) {
            return book;
        }
        BgDimensionParseHelper.setBookStyle(book, bgDimensionManager);
        Sheet sheet = null;
        int in = book.getSheetCount();
        for (int i = 0; i < in; ++i) {
            sheet = book.getSheet(i);
            sheet = BgDimensionParseHelper.parseSheetView(bgDimensionManager, sheet, null);
        }
        return book;
    }

    public static void parseRowAndColDimension(IBgDimensionManager bgDimensionManager, Book book) {
        if (bgDimensionManager == null || book == null) {
            return;
        }
        BgDimensionParseHelper.setBookStyle(book, bgDimensionManager);
        Sheet sheet = null;
        int in = book.getSheetCount();
        for (int i = 0; i < in; ++i) {
            sheet = book.getSheet(i);
            sheet = BgDimensionParseHelper.parseSheetView(bgDimensionManager, sheet, null);
        }
    }

    public static Book parseRowAndColDimension(IBgDimensionManager bgDimensionManager, List pageDimensionMember) {
        Book book = Book.Manager.getNewBook(null, (int)1);
        if (bgDimensionManager == null) {
            return book;
        }
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        BgDimensionParseHelper.setBookStyle(book, bgDimensionManager);
        Sheet sheet = null;
        int in = book.getSheetCount();
        for (int i = 0; i < in; ++i) {
            sheet = book.getSheet(i);
            sheet = BgDimensionParseHelper.parseSheetView(bgDimensionManager, sheet, pageDimensionMember);
        }
        return book;
    }

    private static Sheet parseSheetView(IBgDimensionManager bgDimensionManager, Sheet sheet, List pageDimensionMember) {
        if (bgDimensionManager == null) {
            return sheet;
        }
        BgDimensionParseHelper.setSheetStyle(sheet, bgDimensionManager);
        BgDimensionParseHelper.parseNoMeasureMap(bgDimensionManager, sheet);
        BgDimensionParseHelper.parseColDimension(bgDimensionManager, sheet);
        BgDimensionParseHelper.parseRowDimension(bgDimensionManager, sheet);
        BgNFSHelper.setSheetProtection((Sheet)sheet, (boolean)true, (List)bgDimensionManager.getSheetOperation());
        return sheet;
    }

    private static void parseNoMeasureMap(IBgDimensionManager bgDimensionManager, Sheet sheet) {
        if (sheet != null && BgViewCommonHelper.isShowMeasure(bgDimensionManager)) {
            Row r = sheet.getRow(0, true);
            r.getCell(0, true).setValue(new Variant((Object)BgViewClientHelper.getString("measureUnit")));
            r.getCell(1, true).setValue(new Variant((Object)bgDimensionManager.getDefaultMeasureUnit().getName()));
            BgViewCommonHelper.setLocked(true, sheet.getRange(0, 0, 0, 1));
        }
    }

    private static void setBookStyle(Book book, IBgDimensionManager bgDimensionManager) {
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        BgNFSHelper.setBookProtection((Book)book, (boolean)true, (List)bgDimensionManager.getBookOperation());
    }

    public static void parsePageDimension(IBgDimensionManager bgDimensionManager) {
    }

    private static void parseColDimension(IBgDimensionManager bgDimensionManager, Sheet sheet) {
        if (bgDimensionManager == null || sheet == null) {
            return;
        }
        Cell cell = null;
        BgDimensionInfo dimensionInfo = null;
        BgDimensionInfo _tmpInfo = null;
        BgDimensionMember member = null;
        List colDimension = bgDimensionManager.getColDisplayDimension();
        int rowDimensionSize = bgDimensionManager.getRowDisplayDimension().size();
        int colDimensionSize = colDimension.size();
        int startIndex = BgViewCommonHelper.getBeginRowIndex(bgDimensionManager);
        int maxCol = rowDimensionSize;
        for (int rowIndex = 0; rowIndex < colDimensionSize; ++rowIndex) {
            dimensionInfo = (BgDimensionInfo)colDimension.get(rowIndex);
            boolean isShowLevel = BgViewCommonHelper.isShowLevel(bgDimensionManager, dimensionInfo);
            int colIndex = rowDimensionSize;
            int count = 1;
            int size = 1;
            for (int i = 0; i < colDimensionSize; ++i) {
                _tmpInfo = (BgDimensionInfo)colDimension.get(i);
                if (i < rowIndex) {
                    count *= _tmpInfo.getMember().size();
                }
                if (i <= rowIndex) continue;
                size *= _tmpInfo.getMember().size();
            }
            int xn = count;
            for (int x = 0; x < xn; ++x) {
                int jn = dimensionInfo.getMember().size();
                for (int j = 0; j < jn; ++j) {
                    member = (BgDimensionMember)dimensionInfo.getMember().get(j);
                    int beginCol = colIndex;
                    for (int z = 0; z < size; ++z) {
                        if (member != null) {
                            cell = sheet.getCell(rowIndex + startIndex, colIndex, true);
                            BgDimensionParseHelper.setValue(cell, member, dimensionInfo.getShowType(), bgDimensionManager, isShowLevel);
                            maxCol = Math.max(maxCol, colIndex);
                            cell.setUserObject(DIMENSION, (Object)member);
                            BgDimensionParseHelper.addDimensionInfo(sheet.getColumn(colIndex, true), member);
                        }
                        ++colIndex;
                    }
                    if (size <= 1) continue;
                    Range r = sheet.getRange(rowIndex + startIndex, beginCol, rowIndex + startIndex, colIndex - 1);
                    r.setIgnoreProtected(true);
                    r.merge();
                }
            }
        }
        BgViewCommonHelper.setLocked(true, sheet.getRange(startIndex, rowDimensionSize, startIndex + colDimensionSize - 1, maxCol));
    }

    private static void setValue(Cell cell, BgDimensionMember member, String showType, IBgDimensionManager bgDimensionManager, boolean isShowLevel) {
        if (cell != null && member != null && bgDimensionManager != null) {
            String text = null;
            text = "NUMBER".equalsIgnoreCase(showType) ? member.getNumber() : ("NAMEANDNUMBER".equalsIgnoreCase(showType) ? member.getNumber() + " " + member.getName() : member.getName());
            if (isShowLevel) {
                for (int i = 1; i < member.getLevel(); ++i) {
                    text = " " + text;
                }
            }
            if (!bgDimensionManager.getMeasureMap().isEmpty() && "BGELEMENT".equalsIgnoreCase(member.getType())) {
                MeasureUnitInfo mu = bgDimensionManager.getDefaultMeasureUnit();
                if (bgDimensionManager.getMeasureMap().containsKey(member.getNumber())) {
                    mu = (MeasureUnitInfo)bgDimensionManager.getMeasureMap().get(member.getNumber());
                }
                text = text + "(" + mu.getName() + ")";
            }
            BgNFSHelper.setValue((Cell)cell, (Object)text);
        }
    }

    private static void parseRowDimension(IBgDimensionManager bgDimensionManager, Sheet sheet) {
        int startRowIndex;
        if (bgDimensionManager == null || sheet == null) {
            return;
        }
        Cell cell = null;
        BgDimensionInfo dimensionInfo = null;
        BgDimensionInfo _tmpInfo = null;
        BgDimensionMember member = null;
        List rowDimension = bgDimensionManager.getRowDisplayDimension();
        int rowDimensionSize = rowDimension.size();
        int colDimensionSize = bgDimensionManager.getColDisplayDimension().size();
        int maxRow = startRowIndex = BgViewCommonHelper.getBeginRowIndex(bgDimensionManager);
        for (int colIndex = 0; colIndex < rowDimensionSize; ++colIndex) {
            dimensionInfo = (BgDimensionInfo)rowDimension.get(colIndex);
            boolean isShowLevel = BgViewCommonHelper.isShowLevel(bgDimensionManager, dimensionInfo);
            int rowIndex = colDimensionSize + startRowIndex;
            int count = 1;
            int size = 1;
            for (int i = 0; i < rowDimensionSize; ++i) {
                _tmpInfo = (BgDimensionInfo)rowDimension.get(i);
                if (i < colIndex) {
                    count *= _tmpInfo.getMember().size();
                }
                if (i <= colIndex) continue;
                size *= _tmpInfo.getMember().size();
            }
            int xn = count;
            for (int x = 0; x < xn; ++x) {
                int jn = dimensionInfo.getMember().size();
                for (int j = 0; j < jn; ++j) {
                    member = (BgDimensionMember)dimensionInfo.getMember().get(j);
                    int beginRow = rowIndex;
                    for (int z = 0; z < size; ++z) {
                        if (member != null) {
                            cell = sheet.getCell(rowIndex, colIndex, true);
                            maxRow = Math.max(maxRow, rowIndex);
                            BgDimensionParseHelper.setValue(cell, member, dimensionInfo.getShowType(), bgDimensionManager, isShowLevel);
                            cell.setUserObject(DIMENSION, (Object)member);
                            BgDimensionParseHelper.addDimensionInfo(sheet.getRow(rowIndex, true), member);
                        }
                        ++rowIndex;
                    }
                    if (size <= 1) continue;
                    Range r = sheet.getRange(beginRow, colIndex, rowIndex - 1, colIndex);
                    r.setIgnoreProtected(true);
                    r.merge();
                }
            }
            sheet.getCell(startRowIndex, colIndex, true).setValue(new Variant((Object)dimensionInfo.getAttributeName()));
            Range r = sheet.getRange(startRowIndex, colIndex, startRowIndex + colDimensionSize - 1, colIndex);
            r.setIgnoreProtected(true);
            r.merge();
        }
        BgViewCommonHelper.setLocked(true, sheet.getRange(startRowIndex, 0, maxRow, rowDimensionSize - 1));
    }

    public static void parseBgItem(IBgDimensionManager bgDimensionManager, Sheet sheet, List pageDimensionMember, Map bgDataMap) {
        int i;
        if (sheet == null) {
            return;
        }
        BgNFSHelper.disableCal((Book)sheet.getBook());
        BgNFSHelper.disableUndo((Book)sheet.getBook());
        sheet.getBook().getUndoManager().discardAllEdits();
        ArrayList lockedCell = new ArrayList();
        ArrayList unLockedCell = new ArrayList();
        List _rowObj = null;
        List _colObj = null;
        ArrayList _tmp = new ArrayList();
        ArrayList _page = null;
        Row row = null;
        Column col = null;
        Cell cell = null;
        Object dimensionInfo = null;
        Object member = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        int startRowIndex = BgViewCommonHelper.getBeginRowIndex(bgDimensionManager);
        _page = pageDimensionMember != null ? pageDimensionMember : new ArrayList();
        for (int rowIndex = startRowIndex; rowIndex <= rowCount; ++rowIndex) {
            row = sheet.getRow(rowIndex, false);
            if (row == null || (_rowObj = (List)row.getUserObjectValue(DIMENSION)) == null || _rowObj.isEmpty()) continue;
            for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                col = sheet.getColumn(colIndex, false);
                _colObj = (List)col.getUserObjectValue(DIMENSION);
                if (_colObj == null || _colObj.isEmpty()) continue;
                cell = sheet.getCell(rowIndex, colIndex, true);
                _tmp.clear();
                _tmp.addAll(_page);
                _tmp.addAll(_rowObj);
                _tmp.addAll(_colObj);
                BgDimensionParseHelper.builderBgFormula(cell, _tmp, false, bgDataMap);
            }
        }
        StyleAttributes sa = Styles.getEmptySA();
        if (!lockedCell.isEmpty()) {
            Range lock = null;
            for (i = 0; i < lockedCell.size(); ++i) {
                if (lock == null) {
                    lock = sheet.getRange((Cell)lockedCell.get(i));
                    continue;
                }
                lock.addAll((SortedCellBlockArray)sheet.getRange((Cell)lockedCell.get(i)));
            }
            sa.setLocked(true);
            if (lock != null) {
                lock.setStyle(sa, Styles.getEmptySA());
            }
        }
        if (!unLockedCell.isEmpty()) {
            Range unLock = null;
            for (i = 0; i < unLockedCell.size(); ++i) {
                if (unLock == null) {
                    unLock = sheet.getRange((Cell)unLockedCell.get(i));
                    continue;
                }
                unLock.addAll((SortedCellBlockArray)sheet.getRange((Cell)unLockedCell.get(i)));
            }
            sa.setLocked(false);
            if (unLock != null) {
                unLock.setStyle(sa, Styles.getEmptySA());
            }
        }
        BgNFSHelper.enableCal((Book)sheet.getBook());
        BgNFSHelper.enableUndo((Book)sheet.getBook());
    }

    private static void setSheetStyle(Sheet sheet, IBgDimensionManager bgDimensionManager) {
        if (sheet == null) {
            return;
        }
        StyleAttributes sa = Styles.getEmptySA();
        sa.setFontSize(10);
        sheet.getSheetRange().setStyle(sa, Styles.getEmptySA());
        if (sheet.getSheetOption().getMerger(false) != null) {
            sheet.getSheetOption().getMerger(false).clear();
        }
        if (bgDimensionManager.isLockSheet()) {
            BgNFSHelper.setSheetLocked((Sheet)sheet, (boolean)true);
        }
    }

    private static void addDimensionInfo(Row row, BgDimensionMember dimensionMember) {
        if (row == null || dimensionMember == null) {
            return;
        }
        ArrayList _obj = row.getUserObjectValue(DIMENSION);
        if (_obj instanceof List) {
            ((List)_obj).add(dimensionMember);
        } else {
            _obj = new ArrayList();
            ((List)_obj).add(dimensionMember);
            row.setUserObject(DIMENSION, _obj);
        }
    }

    private static void addDimensionInfo(Column column, BgDimensionMember dimensionMember) {
        if (column == null || dimensionMember == null) {
            return;
        }
        ArrayList _obj = column.getUserObjectValue(DIMENSION);
        if (_obj instanceof List) {
            ((List)_obj).add(dimensionMember);
        } else {
            _obj = new ArrayList();
            ((List)_obj).add(dimensionMember);
            column.setUserObject(DIMENSION, _obj);
        }
    }

    private static void builderBgFormula(Cell cell, List bgDimensions, boolean isCheckFull, Map bgDataMap) {
        if (bgDimensions == null || bgDimensions.isEmpty() || cell == null) {
            return;
        }
        HashMap<Integer, String> _item = new HashMap<Integer, String>();
        String _element = null;
        String _period = null;
        String _currency = null;
        BgDimensionMember _org = null;
        BgDimensionMember member = null;
        int in = bgDimensions.size();
        for (int i = 0; i < in; ++i) {
            member = (BgDimensionMember)bgDimensions.get(i);
            if (DIMENSION_BGITEM.equalsIgnoreCase(member.getType())) {
                _item.put(new Integer(member.getAttribute().toUpperCase().replaceAll("F", "")), member.getNumber());
                continue;
            }
            if (DIMENSION_BGPERIOD.equalsIgnoreCase(member.getType())) {
                if ("BGPERIOD".equals(member.getNumber())) {
                    _period = "";
                    continue;
                }
                _period = member.getNumber();
                continue;
            }
            if (DIMENSION_BGELEMENT.equalsIgnoreCase(member.getType())) {
                _element = member.getNumber();
                continue;
            }
            if (DIMENSION_CURRENCY.equalsIgnoreCase(member.getType())) {
                _currency = member.getNumber();
                continue;
            }
            if (!DIMENSION_ORGUNIT.equalsIgnoreCase(member.getType())) continue;
            _org = member;
        }
        if (isCheckFull && (_item.isEmpty() || _period == null || _element == null || _currency == null)) {
            return;
        }
        String _bgFormula = BgViewCommonHelper.parseItemFormula(_element, _currency, _period, _item);
        if (!StringUtils.isEmpty((String)_bgFormula) && cell != null) {
            ItemFormula itemFormula = null;
            if (cell.getUserObjectValue("ITEM") instanceof ItemFormula) {
                itemFormula = (ItemFormula)cell.getUserObjectValue("ITEM");
                itemFormula.putExt("13", _bgFormula);
            } else {
                itemFormula = new ItemFormula(_bgFormula);
                cell.setUserObject("ITEM", (Object)itemFormula);
            }
            itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.FALSE_UPDATE);
            if (_org != null) {
                itemFormula.putExt("ORGUNITID", _org.getAttribute());
                itemFormula.putExt("ORGUNIT", _org.getNumber());
                if (bgDataMap != null) {
                    if (!bgDataMap.containsKey(_org.getAttribute())) {
                        bgDataMap.put(_org.getAttribute(), new HashMap());
                    }
                    Map subMap = (Map)bgDataMap.get(_org.getAttribute());
                    subMap.put(_bgFormula, _bgFormula);
                }
            }
        }
    }
}

