/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.core.ICellEditorProvider;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.impl.facade.editor.ICellEditor;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.NewOrgUnitHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.view.BgReportActualFacadeFactory;
import com.kingdee.eas.ma.view.client.BgReportViewAddActualProcessUI;
import com.kingdee.eas.ma.view.client.common.BgReportAddActualProvider;
import com.kingdee.eas.ma.view.client.common.BookContextManager;
import com.kingdee.eas.ma.view.client.common.BudgetProvider;
import com.kingdee.eas.ma.view.client.designer.IProvider;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BgReportAddActualContextManager
extends BookContextManager
implements ICellEditorProvider {
    private static final Logger logger = CoreUIObject.getLogger(BgReportAddActualContextManager.class);

    public BgReportAddActualContextManager(Map uiContext, CoreUI owner) {
        super(uiContext, owner);
    }

    @Override
    public IProvider createProviderImpl() {
        BgReportAddActualProvider provider = new BgReportAddActualProvider();
        provider.getBgDimensionManager().setOprtState(this.getOwnerUI().getOprtState());
        return provider;
    }

    @Override
    public void initListener() {
        super.initListener();
        this.getSpreadContext().getEditManager().setEditorProvider((ICellEditorProvider)this);
    }

    public ICellEditor getEditor(Sheet sheet, int row, int col) {
        if (this.getOwnerUI() instanceof BgReportViewAddActualProcessUI) {
            return ((BgReportViewAddActualProcessUI)this.getOwnerUI()).getCellEditor(sheet, row, col);
        }
        return null;
    }

    @Override
    public void initData() throws Exception {
        super.initData();
        if (this.getProvider().getEditValue() == null) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        Object isAudit = this.getOwnerUI().getUIContext().get("isWillAudit");
        Object isAntiAudit = this.getOwnerUI().getUIContext().get("isWillUnAudit");
        String state = null;
        state = isAudit instanceof Boolean && (Boolean)isAudit != false ? "AUDIT" : (isAntiAudit instanceof Boolean && (Boolean)isAntiAudit != false ? "ANTIAUDIT" : this.getOwnerUI().getOprtState());
        if (this.getOwnerUI() != null) {
            this.getOwnerUI().setUITitle(this.getOwnerUI().getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgNFormResource", (String)state) + " - " + this.getProvider().getEditValue().get("name"));
        }
    }

    @Override
    public Component getPageDimensionPanel(IBgDimensionManager dimensionManager) {
        Component c = super.getPageDimensionPanel(dimensionManager);
        for (int i = 0; i < this.getProvider().getF7List().size(); ++i) {
            if (!"ORGUNIT".equalsIgnoreCase(((JComponent)this.getProvider().getF7List().get(i)).getName())) continue;
            ((KDBizPromptBox)this.getProvider().getF7List().get(i)).setDataNoNotify((Object)((BgActualRecordInfo)this.getProvider().getEditValue()).getBgForm().getOrgUnit());
            ((KDBizPromptBox)this.getProvider().getF7List().get(i)).setEnabled(false);
        }
        return c;
    }

    @Override
    public Map save() throws Exception {
        if (this.getProvider().getEditValue() instanceof BgActualRecordInfo) {
            HashMap extMap = new HashMap();
            this.beforeSave(extMap);
            BgReportActualFacadeFactory.getRemoteInstance().saveActual((BgActualRecordInfo)this.getProvider().getEditValue(), ((BudgetProvider)this.getProvider()).getBgDataMap(), ((BudgetProvider)this.getProvider()).getDeleteMap(), extMap);
            if (this.getProvider().getBgDimensionManager().getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
                this.getProvider().getBgDimensionManager().setOprtState(OprtState.EDIT);
                this.getOwnerUI().setOprtState(OprtState.EDIT);
                this.getOwnerUI().setUITitle(this.getOwnerUI().getUITitle().split("-")[0] + " - " + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgNFormResource", (String)this.getOwnerUI().getOprtState()) + " - " + this.getProvider().getEditValue().get("name"));
            }
            this.afterSave();
        }
        return null;
    }

    private void afterSave() throws Exception {
        if (this.getOwnerUI() != null) {
            this.showSuccessMsg(EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgViewTemplateResource", (String)"saveSuccess"));
        }
        this.getProvider().fillData(this.getSpreadContext().getBook());
        this.getBgGatherInfo().clear();
    }

    private void beforeSave(Map extMap) throws Exception {
        BgActualRecordInfo record = (BgActualRecordInfo)this.getProvider().getEditValue();
        try {
            String companyId = null;
            if (record.getCompany() != null && record.getCompany().getId() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("isCompanyOrgUnit"));
                sic.add(new SelectorItemInfo("parent"));
                String ccid = record.getCompany().getId().toString();
                while (true) {
                    OrgUnitInfo org = null;
                    try {
                        org = NewOrgUnitHelper.getTypedOrgUnit((String)ccid, (SelectorItemCollection)sic, (OrgType)OrgType.CostCenter);
                    }
                    catch (ObjectNotFoundException ex) {
                        logger.error((Object)ex);
                    }
                    if (org == null || org.get("parent") == null) break;
                    if (org.isIsCompanyOrgUnit()) {
                        companyId = org.getId().toString();
                        break;
                    }
                    ccid = ((OrgUnitInfo)org.get("parent")).getId().toString();
                }
                if (!StringUtils.isEmpty(companyId)) {
                    record.getCompany().setId(BOSUuid.read(companyId));
                }
            }
            if (record.getBgForm() != null) {
                record.setSourceType(record.getBgForm().getSourceType());
            }
            extMap.put("GatherInfo", this.getBgGatherInfo());
            this.getProvider().store(this.getSpreadContext().getBook());
        }
        catch (ObjectNotFoundException ex) {
            logger.error((Object)ex);
        }
    }

    @Override
    public boolean checkBefore() throws Exception {
        String oprt = this.getOwnerUI().getOprtState();
        if (!OprtState.EDIT.equals(oprt) && !OprtState.ADDNEW.equals(oprt)) {
            return true;
        }
        this.getProvider().store(this.getSpreadContext().getBook());
        boolean isModifyData = ((BudgetProvider)this.getProvider()).isModifyBgData();
        if (isModifyData) {
            String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit");
            int flag = MsgBox.showConfirm3((Component)this.getOwnerUI(), (String)message);
            if (0 == flag) {
                this.save();
            } else if (1 != flag) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void beforeDimensionChange_dataChanged(DataChangeEvent eventObj) throws Exception {
        this.getProvider().store(this.getSpreadContext().getBook());
    }

    @Override
    protected boolean isNeedSaveForDimensionChange(DataChangeEvent eventObj) {
        return ((BudgetProvider)this.getProvider()).isModifyBgData();
    }

    @Override
    protected void saveForDimensionChange(DataChangeEvent eventObj) throws Exception, BOSException, EASBizException {
        this.save();
    }

    @Override
    protected void initToolBar(IUIObject ui) {
        super.initToolBar(ui);
        ToolBarManager toolBarManager = this.getSpreadContext().getToolBarManager();
        toolBarManager.setItemVisible("ToolItem_Merger", false);
        toolBarManager.setItemVisible("ToolItem_Sum", false);
        toolBarManager.setItemVisible("ToolItem_Cut", false);
        toolBarManager.setItemVisible("ToolItem_Hyperlink", false);
        toolBarManager.setItemVisible("ToolItem_Diagonal", false);
        toolBarManager.setItemVisible("ToolItem_SortAscend", false);
        toolBarManager.setItemVisible("ToolItem_SortDecsend", false);
        toolBarManager.setItemVisible("ToolItem_Comment", false);
        toolBarManager.setItemVisible("ToolItem_Locked", false);
    }

    @Override
    public Map<String, Map> getBgGatherInfo() {
        return ((BudgetProvider)this.getProvider()).getBgGatherInfo();
    }

    @Override
    public BgFormInfo getCurrGatherForm() throws BOSException, EASBizException {
        return ((BgActualRecordInfo)this.getProvider().getEditValue()).getBgForm();
    }
}

