/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.command.ICommand;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.nbudget.BgNDataInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.view.BgReportActualFacadeFactory;
import com.kingdee.eas.ma.view.BgViewFacadeFactory;
import com.kingdee.eas.ma.view.client.common.BudgetProvider;
import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.BgNViewDataInfo;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.util.BgViewCommonHelper;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class BgReportAddActualProvider
extends BudgetProvider
implements ICommand {
    private static final long serialVersionUID = 7061889342549869706L;
    protected Map cacheMap = new HashMap();

    @Override
    public void fillData(Book book) throws Exception {
        this.fillData(book, null);
    }

    @Override
    public void fillData(Book book, Map dataMap) throws Exception {
        HashMap queryMap = new HashMap();
        this.getHelper().parseBgItem(book, BgViewHelper.getCurrPageMember(this.getF7List(), this.getBgDimensionManager().getPageDisplayDimension()), queryMap);
        this.bgDataMap = BgReportActualFacadeFactory.getRemoteInstance().queryAddActualByRecordId(((BgActualRecordInfo)this.getEditValue()).getBgForm().getId().toString(), queryMap, ((BgActualRecordInfo)this.getEditValue()).getBgPeriod().getNumber());
        this.fillData(book, this.bgDataMap, dataMap);
    }

    public void fillData(Book book, Map bgDataMap, Map newDataMap) {
        if (book == null) {
            return;
        }
        if (newDataMap == null) {
            newDataMap = new HashMap();
        }
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        book.getUndoManager().discardAllEdits();
        Range locked = null;
        Range unLocked = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            Sheet sheet = book.getSheet(s);
            int maxRow = sheet.getMaxRowIndex();
            int maxCol = sheet.getMaxColIndex();
            for (int r = 0; r <= maxRow; ++r) {
                for (int c = 0; c <= maxCol; ++c) {
                    Map subMap;
                    Cell cell = sheet.getCell(r, c, false);
                    ItemFormula formula = BgNFSHelper.getItemFormula((Cell)cell);
                    if (formula == null) continue;
                    BgNViewDataInfo data = null;
                    String orgId = formula.getExt("ORGUNITID");
                    if (bgDataMap.containsKey(orgId)) {
                        subMap = (Map)bgDataMap.get(orgId);
                        data = (BgNViewDataInfo)((Object)subMap.get(formula.getFormula()));
                    }
                    if (newDataMap.containsKey(orgId) && (subMap = (Map)newDataMap.get(orgId)).get(formula.getFormula()) != null) {
                        data = (BgNViewDataInfo)((Object)subMap.get(formula.getFormula()));
                    }
                    boolean isLocked = this.isLocked(data);
                    if (data != null) {
                        if (data.getAddActualNoDef() != null) {
                            cell.setValue(new Variant((Object)data.getAddActualNoDef()));
                        }
                    } else {
                        cell.setValue(Variant.emptyVariant);
                    }
                    Range range = sheet.getRange(cell);
                    if (isLocked == cell.isLocked()) continue;
                    if (isLocked) {
                        if (locked == null) {
                            locked = range;
                            continue;
                        }
                        locked.addAll((SortedCellBlockArray)range);
                        continue;
                    }
                    if (unLocked == null) {
                        unLocked = range;
                        continue;
                    }
                    unLocked.addAll((SortedCellBlockArray)range);
                }
            }
        }
        StyleAttributes sa = Styles.getEmptySA();
        if (locked != null) {
            sa.setLocked(true);
            locked.setStyle(sa, Styles.getEmptySA());
        }
        if (unLocked != null) {
            sa.setLocked(false);
            unLocked.setStyle(sa, Styles.getEmptySA());
        }
        BgNFSHelper.enableCal((Book)book);
        BgNFSHelper.enableUndo((Book)book);
    }

    @Override
    public boolean isLocked(BgNDataInfo bgData) {
        return bgData == null || bgData.getState() != 9;
    }

    @Override
    public void store(Object obj) throws Exception {
        if (obj instanceof Book) {
            Book book = (Book)obj;
            for (int s = 0; s < book.getSheetCount(); ++s) {
                Sheet sheet = book.getSheet(s);
                int maxRow = sheet.getMaxRowIndex();
                int maxCol = sheet.getMaxColIndex();
                for (int r = 0; r <= maxRow; ++r) {
                    for (int c = 0; c <= maxCol; ++c) {
                        Cell cell = sheet.getCell(r, c, false);
                        ItemFormula formula = BgNFSHelper.getItemFormula((Cell)cell);
                        if (formula == null) continue;
                        String orgId = formula.getExt("ORGUNITID");
                        BigDecimal value = BgViewHelper.getNumeric(cell, null);
                        BgNViewDataInfo data = this.getData(this.bgDataMap, orgId, formula.getFormula(), true);
                        data.setAddActualValue(value);
                    }
                }
            }
        }
    }

    @Override
    protected boolean isModify(BgNViewDataInfo data) {
        if (data != null) {
            if (data.getAddActualNoDef() == null) {
                return data.getOldValue() != null;
            }
            if (data.getOldValue() == null) {
                return data.getAddActualNoDef() != null;
            }
            return data.getOldValue().compareTo(data.getAddActualNoDef()) != 0;
        }
        return false;
    }

    @Override
    public Object load() throws Exception {
        byte[] bytes = ((BgActualRecordInfo)this.getEditValue()).getBgForm().getEntries().get(0).getDimensionData();
        byte[] bytesStyle = ((BgActualRecordInfo)this.getEditValue()).getBgForm().getEntries().get(0).getDimensionStyle();
        this.setOrgUnitId(((BgActualRecordInfo)this.getEditValue()).getBgForm().getOrgUnit().getId().toString());
        this.getHelper().setAfterLoad(this);
        Book book = this.getHelper().getViewDimensionBook(bytes, bytesStyle);
        this.getHelper().setAfterLoad(null);
        return book;
    }

    public Object execute(Context ctx) throws BOSException {
        try {
            Map currMap;
            this.cacheMap = this.getInitBgViewDimensionInfo();
            IBgDimensionManager bm = this.getBgDimensionManager();
            BgActualRecordInfo actualRecordInfo = (BgActualRecordInfo)this.getEditValue();
            BgDimensionInfo dimen = null;
            for (int i = 0; i < bm.getDimension().size(); ++i) {
                dimen = (BgDimensionInfo)bm.getDimension().get(i);
                if (!"BGPERIOD".equalsIgnoreCase(dimen.getType())) continue;
                dimen.getMember().clear();
                dimen.setValue(null);
                break;
            }
            bm.setDefaultMeasureUnit(actualRecordInfo.getMeasureUnit());
            bm.getMeasureMap().clear();
            BgFormInfo bgForm = actualRecordInfo.getBgForm();
            if (!bgForm.getBgMeasureUnit().isEmpty()) {
                for (int i = 0; i < bgForm.getBgMeasureUnit().size(); ++i) {
                    bm.getMeasureMap().put(bgForm.getBgMeasureUnit().get(i).getBgElement().getNumber(), bgForm.getBgMeasureUnit().get(i).getMeasureUnit());
                }
            }
            if ((currMap = (Map)this.cacheMap.get("CURRENCY")) != null) {
                bm.getCurrencyMap().putAll(currMap);
            }
            BgViewCommonHelper.fillDimensionMember(this.getBgDimensionManager(), this.cacheMap, BgSHelper.isBgItemIsolate(), this.getOrgUnitId(), actualRecordInfo.getBgPeriod(), bgForm.getCurrency(), this.isCurrOrg());
            if (dimen != null) {
                dimen.unParseBgPeriod();
            }
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return null;
    }

    private boolean isCurrOrg() {
        return true;
    }

    protected Map getInitBgViewDimensionInfo() throws BOSException, EASBizException {
        return BgViewFacadeFactory.getRemoteInstance().getInitBgViewDimensionInfo(this.getBgDimensionManager(), ((BgActualRecordInfo)this.getEditValue()).getBgForm().get("id").toString());
    }

    @Override
    public ICoreBase getBizInterface() throws Exception {
        return BgActualRecordFactory.getRemoteInstance();
    }

    @Override
    public IObjectValue queryEditValue(IObjectPK pk) throws Exception {
        BgActualRecordInfo actualInfo = (BgActualRecordInfo)this.getBizInterface().getValue(pk, this.getSelectors());
        actualInfo.setBgForm((BgFormInfo)BgFormFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(actualInfo.getBgForm().getId().toString()), this.getBgFormSelectors()));
        return actualInfo;
    }

    protected SelectorItemCollection getBgFormSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgTemplate.bgFormType");
        sic.add("id");
        sic.add("state");
        sic.add("measureUnit.id");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        sic.add("bgPeriod.id");
        sic.add("sheetParam.*");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("currency.precision");
        sic.add("bgScheme.id");
        sic.add("bgScheme.number");
        sic.add("bgScheme.name");
        sic.add("bgScheme.rootId");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.rootId");
        sic.add("bgTemplate.formType");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("periodType");
        sic.add("year");
        sic.add("period");
        sic.add("startDate");
        sic.add("endDate");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("lastUpdateUser.number");
        sic.add("name");
        sic.add("sourceType");
        sic.add("CU.id");
        sic.add("creator.id");
        sic.add("creator.number");
        sic.add("creator.name");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.periodType");
        sic.add("bgPeriod.name");
        sic.add("entries.id");
        sic.add("entries.bgformid");
        sic.add("entries.dimensionData");
        sic.add("entries.dimensionStyle");
        sic.add("entries.rollMethod");
        sic.add("entries.rollType");
        sic.add("entries.rollStep");
        sic.add("entries.rollLength");
        sic.add("entries.overFlow");
        sic.add("entries.scheme.id");
        return sic;
    }

    @Override
    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("data");
        sic.add("isEditByPeriod");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.periodType");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgForm.bgTemplate.bgFormType");
        sic.add("bgForm.id");
        return sic;
    }

    @Override
    public Book pageChangeLoadBook() throws Exception {
        throw new Exception("Need to implement ...!!");
    }
}

