/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.budget.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodException;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNDataInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.view.BgRollHandler;
import com.kingdee.eas.ma.view.BgRollHelper;
import com.kingdee.eas.ma.view.BgRollInterface;
import com.kingdee.eas.ma.view.BgViewFacadeFactory;
import com.kingdee.eas.ma.view.client.common.BudgetViewProvider;
import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.BgDimensionMember;
import com.kingdee.eas.ma.view.common.BgNViewDataInfo;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgReportRollViewProvider
extends BudgetViewProvider {
    private Map adjustMap = new HashMap();
    public static final String ADJUSTBUDGET = "AdjustBudget";
    private BgRollHandler rollHandler = null;
    private int historyNum = 0;
    private int historyLevel = 0;
    private String ViewType = null;
    private boolean isNeedReCalculate = false;
    protected Set<BgDimensionMember> addMembers = new HashSet<BgDimensionMember>();

    @Override
    public Set<BgDimensionMember> getAddMembers() {
        return this.addMembers;
    }

    public BgRollHandler getBgRollHandler() {
        if (this.rollHandler == null) {
            this.rollHandler = new BgRollHandler(this);
        }
        return this.rollHandler;
    }

    public void setHistoryNum(Component comp, int historyNum) throws BgPeriodException {
        List dimensionList;
        if (this.getHistoryNum() == historyNum) {
            return;
        }
        BgDimensionInfo bgPeriodDimensionInfo = null;
        if (this.getBgDimensionManager() != null && this.getBgDimensionManager().getDimension() != null && (dimensionList = this.getBgDimensionManager().getDimension()).size() > 0) {
            int i;
            for (BgDimensionInfo dimensionInfo : dimensionList) {
                if (!"BGPERIOD".equalsIgnoreCase(dimensionInfo.getType())) continue;
                bgPeriodDimensionInfo = dimensionInfo;
                break;
            }
            if (bgPeriodDimensionInfo == null) {
                return;
            }
            for (int i2 = 0; i2 < this.getHistoryNum(); ++i2) {
                bgPeriodDimensionInfo.getMember().remove(0);
            }
            ArrayList<String> newPeriodNumList = new ArrayList<String>();
            String currentPeriodNum = ((BgDimensionMember)bgPeriodDimensionInfo.getMember().get(0)).getNumber();
            for (int i3 = 0; i3 < historyNum; ++i3) {
                currentPeriodNum = BgNPeriodHelper.getOffsetBgPeriodNumber((String)currentPeriodNum, (int)-1);
                newPeriodNumList.add(0, currentPeriodNum);
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.getSelector().add("longNumber");
            evi.getSelector().add("periodType");
            evi.getSelector().add("showlevel");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet(newPeriodNumList), CompareType.INCLUDE));
            evi.getSorter().add(new SorterItemInfo("number"));
            BgPeriodCollection col = null;
            try {
                col = BgPeriodFactory.getRemoteInstance().getBgPeriodCollection(evi);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            BgPeriodInfo bgPeriodInfo = null;
            BgDimensionMember member = null;
            for (i = col.size() - 1; i >= 0; --i) {
                bgPeriodInfo = col.get(i);
                newPeriodNumList.remove(bgPeriodInfo.getNumber());
            }
            if (newPeriodNumList.size() > 0) {
                MsgBox.showWarning((Component)comp, (String)EASResource.getString((String)"com.kingdee.eas.ma.view.BgViewCommonResource", (String)"noPeriod", (Object[])new Object[]{((Object)newPeriodNumList).toString()}));
            }
            for (i = col.size() - 1; i >= 0; --i) {
                bgPeriodInfo = col.get(i);
                member = new BgDimensionMember(bgPeriodDimensionInfo.getType(), bgPeriodInfo.getId().toString(), bgPeriodInfo.getName(), bgPeriodInfo.getNumber());
                member.setLevel(bgPeriodInfo.getLevel());
                member.setSortValue(Integer.valueOf(bgPeriodInfo.getShowLevel()));
                bgPeriodDimensionInfo.getMember().add(0, member);
            }
            bgPeriodDimensionInfo.unParseBgPeriod();
            this.historyNum = historyNum - newPeriodNumList.size();
            this.historyLevel = historyNum;
        }
    }

    @Override
    public Map filterValueMap(Map valueMap) {
        if (valueMap == null) {
            return null;
        }
        HashMap res = new HashMap();
        String orgUnitId2 = null;
        Map formulaMap = null;
        String formulaStr = null;
        BgRollInterface rollImpl = null;
        for (String orgUnitId2 : valueMap.keySet()) {
            if (valueMap.get(orgUnitId2) == null) continue;
            formulaMap = (Map)valueMap.get(orgUnitId2);
            Iterator formulaIterator = formulaMap.keySet().iterator();
            while (formulaIterator.hasNext()) {
                formulaStr = (String)formulaIterator.next();
                if (!this.getBgRollHandler().getOrgIds().contains(orgUnitId2)) continue;
                rollImpl = this.getBgRollHandler().getRollMap().get(orgUnitId2);
                if (!rollImpl.getLegalPeriodSet().contains(BgRollHelper.getPeriodNum(formulaStr))) {
                    if (!res.containsKey(orgUnitId2)) {
                        res.put(orgUnitId2, new HashMap());
                    }
                    ((Map)res.get(orgUnitId2)).put(formulaStr, formulaMap.get(formulaStr));
                    formulaIterator.remove();
                    continue;
                }
                if (rollImpl.isAdjustForm() || this.getBgDataMap().get(orgUnitId2) == null || ((Map)this.getBgDataMap().get(orgUnitId2)).get(formulaStr) == null || !this.getBgRollHandler().isLockedForBudgetForm((BgNDataInfo)((Map)this.getBgDataMap().get(orgUnitId2)).get(formulaStr))) continue;
                if (!res.containsKey(orgUnitId2)) {
                    res.put(orgUnitId2, new HashMap());
                }
                ((Map)res.get(orgUnitId2)).put(formulaStr, formulaMap.get(formulaStr));
                formulaIterator.remove();
            }
        }
        return res;
    }

    @Override
    protected void afterFillDimensionMember() throws BOSException, BgPeriodException {
        if (this.initDataType == 1) {
            this.setHistoryNum(0);
            this.setHistoryNum(null, this.getHistoryLevel());
        }
    }

    public void setHistoryNum(int historyNum) {
        this.historyNum = historyNum;
    }

    @Override
    public void store(Object obj) throws Exception {
        if (obj instanceof Book) {
            Book book = (Book)obj;
            for (int s = 0; s < book.getSheetCount(); ++s) {
                Sheet sheet = book.getSheet(s);
                int maxRow = sheet.getMaxRowIndex();
                int maxCol = sheet.getMaxColIndex();
                for (int r = 0; r <= maxRow; ++r) {
                    for (int c = 0; c <= maxCol; ++c) {
                        Cell cell = sheet.getCell(r, c, false);
                        ItemFormula formula = BgNFSHelper.getItemFormula((Cell)cell);
                        if (formula == null) continue;
                        String orgId = formula.getExt("ORGUNITID");
                        if (this.getBgRollHandler().getRollMap() == null || this.getBgRollHandler().getRollMap().get(orgId) == null || this.getBgRollHandler().getRollMap().get(orgId).isAdjustForm()) continue;
                        BigDecimal value = BgViewHelper.getNumeric(cell, null);
                        BgNViewDataInfo data = this.getData(this.bgDataMap, orgId, formula.getFormula(), true);
                        data.setBudgetValue(value);
                    }
                }
            }
        }
    }

    @Override
    public boolean isLocked(BgNDataInfo bgData) {
        return false;
    }

    @Override
    public void fillData(Book book) throws Exception {
        this.fillData(book, null, null);
    }

    public void fillData(Book book, Map newBgDataMap, Map newAdjustMap) throws Exception {
        if ("history".equalsIgnoreCase(this.getViewType())) {
            HashMap queryMap = new HashMap();
            this.getHelper().parseBgItem(book, BgViewHelper.getCurrPageMember(this.getF7List(), this.getBgDimensionManager().getPageDisplayDimension()), queryMap);
            this.getBgRollHandler().loadData(this.getBgDimensionManager(), queryMap.keySet(), (BgFormInfo)this.getEditValue(), true);
            this.bgDataMap = BgViewFacadeFactory.getRemoteInstance().queryHistoryBgDataAndActual(queryMap, ((BgFormInfo)this.getEditValue()).getId().toString());
            this.deleteMap.clear();
            this.getBgRollHandler().fillData(book, this, this.bgDataMap, null, null, null);
        } else {
            HashMap queryMap = new HashMap();
            this.getHelper().parseBgItem(book, BgViewHelper.getCurrPageMember(this.getF7List(), this.getBgDimensionManager().getPageDisplayDimension()), queryMap);
            this.getBgRollHandler().loadData(this.getBgDimensionManager(), queryMap.keySet(), (BgFormInfo)this.getEditValue(), false);
            Map partResult = this.getBgRollHandler().pickAdjustFormula(queryMap);
            Map adjustBudgetMap = (Map)partResult.get(ADJUSTBUDGET);
            this.bgDataMap = BgViewFacadeFactory.getRemoteInstance().queryWithBgActual(queryMap, ((BgFormInfo)this.getEditValue()).getBgScheme().getRootId().toString());
            this.adjustMap = BgViewFacadeFactory.getRemoteInstance().queryAdjustBgData(adjustBudgetMap, ((BgFormInfo)this.getEditValue()).getBgScheme().getRootId().toString());
            this.deleteMap.clear();
            this.setNeedReCalculate(false);
            this.getBgRollHandler().fillData(book, this, this.bgDataMap, this.adjustMap, newBgDataMap, newAdjustMap);
        }
    }

    public void updateCellChangeValueInfo(Cell cell) {
        if (cell == null) {
            return;
        }
        if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
            Object obj = cell.getUserObjectValue("ITEM");
            String orgUnitId = ((ItemFormula)obj).getExt("ORGUNITID");
            Object _obj = null;
            BigDecimal _newValue = null;
            BigDecimal _oldValue = null;
            String _formulaStr = null;
            String _orgUnitId = null;
            _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
            if (this.getBgRollHandler().getRollMap().get(orgUnitId) == null || !this.getBgRollHandler().getRollMap().get(orgUnitId).isAdjustForm() || !this.getBgRollHandler().getRollMap().get(orgUnitId).getLegalPeriodSet().contains(BgRollHelper.getPeriodNum(_formulaStr))) {
                return;
            }
            _obj = BgNFSHelper.getValue((Cell)cell);
            if (_obj instanceof BigDecimal) {
                _newValue = (BigDecimal)_obj;
            } else {
                try {
                    _newValue = new BigDecimal(_obj.toString());
                }
                catch (Exception ex) {
                    BgNFSHelper.setValue((Cell)cell, (Object)BgNConstants.ZERO);
                    _newValue = BgNConstants.ZERO;
                }
            }
            _obj = cell.getUserObjectValue("ITEM");
            _orgUnitId = ((ItemFormula)_obj).getExt("ORGUNITID");
            Map _map = (Map)this.getBgDataMap().get(_orgUnitId);
            if (_map.get(_formulaStr) != null) {
                _oldValue = ((BgNViewDataInfo)((Object)_map.get(_formulaStr))).getBudgetValue();
            }
            if (!BgViewHelper.compareDivValue(_newValue, _oldValue)) {
                if (this.getAdjustMap().get(orgUnitId) != null && ((Map)this.getAdjustMap().get(orgUnitId)).containsKey(_formulaStr)) {
                    this.updateDivInfo(cell, _formulaStr, _newValue, _oldValue);
                } else {
                    this.createDivInfo(cell, _formulaStr, _newValue, _oldValue);
                }
            } else if (this.getAdjustMap().get(orgUnitId) != null && ((Map)this.getAdjustMap().get(orgUnitId)).containsKey(_formulaStr)) {
                this.updateDivInfo(cell, _formulaStr, _newValue, _oldValue);
            }
        }
    }

    public void createDivInfo(Cell cell, String formulaStr, BigDecimal newValue, BigDecimal oldValue) {
        BgAdjustFormDiversityData divData = new BgAdjustFormDiversityData();
        divData.setFormula(formulaStr);
        divData.setNewValue(newValue);
        divData.setOldValue(oldValue);
        divData.setAdjustor(this.getUserPk().toString());
        divData.setAdjustTime((Date)new Timestamp(System.currentTimeMillis()));
        Object obj = cell.getUserObjectValue("ITEM");
        String orgUnitId = ((ItemFormula)obj).getExt("ORGUNITID");
        if (this.getAdjustMap().get(orgUnitId) == null) {
            this.getAdjustMap().put(orgUnitId, new HashMap());
        }
        ((Map)this.getAdjustMap().get(orgUnitId)).put(formulaStr, divData);
        BgNFSHelper.setBackGroup((Cell)cell, (Color)BgNConstants.EDIT_COLOR);
    }

    public void updateDivInfo(Cell cell, String formulaStr, BigDecimal newValue, BigDecimal oldValue) {
        Object obj = cell.getUserObjectValue("ITEM");
        String orgUnitId = ((ItemFormula)obj).getExt("ORGUNITID");
        BgAdjustFormDiversityData divData = (BgAdjustFormDiversityData)((Map)this.getAdjustMap().get(orgUnitId)).get(formulaStr);
        if (divData != null) {
            if (BgViewHelper.compareDivValue(newValue, oldValue)) {
                BgNFSHelper.setBackGroup((Cell)cell, (Color)BgNConstants.BASE_COLOR);
            } else {
                BgNFSHelper.setBackGroup((Cell)cell, (Color)BgNConstants.EDIT_COLOR);
            }
            divData.setNewValue(newValue);
            divData.setAdjustor(this.getUserPk().toString());
            divData.setAdjustTime((Date)new Timestamp(System.currentTimeMillis()));
        }
    }

    protected IObjectPK getUserPk() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        return userPK;
    }

    private void addToSet(Map map, String orgUnitId, String periodNum) {
        if (map.get(orgUnitId) == null) {
            map.put(orgUnitId, new HashSet());
        }
        ((Set)map.get(orgUnitId)).add(periodNum);
    }

    private void addToMap(Map map, String orgUnitId, String formulaStr) {
        if (map.get(orgUnitId) == null) {
            map.put(orgUnitId, new HashMap());
        }
        ((Map)map.get(orgUnitId)).put(formulaStr, null);
    }

    public String getPeriodNum(String fomulaStr) {
        String[] parameter = BgNFSHelper.parseFormulaPara((String)fomulaStr);
        return parameter[1];
    }

    @Override
    public Map getAdjustMap() {
        return this.adjustMap;
    }

    public int getHistoryNum() {
        return this.historyNum;
    }

    public void setViewType(String viewType) {
        this.ViewType = viewType;
    }

    public String getViewType() {
        return this.ViewType;
    }

    public boolean isNeedReCalculate() {
        return this.isNeedReCalculate;
    }

    public void setNeedReCalculate(boolean isNeedReCalculate) {
        this.isNeedReCalculate = isNeedReCalculate;
    }

    public int getHistoryLevel() {
        return this.historyLevel;
    }

    public void setHistoryLevel(int historyLevel) {
        this.historyLevel = historyLevel;
    }
}

