/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.budget.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNDataInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.view.BgViewFacadeFactory;
import com.kingdee.eas.ma.view.client.common.BudgetViewProvider;
import com.kingdee.eas.ma.view.client.designer.IProvider;
import com.kingdee.eas.ma.view.common.BgNViewDataInfo;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class BgReportViewAdjustProvider
extends BudgetViewProvider {
    private Map adjustMap = new HashMap();

    @Override
    public boolean isLocked(BgNDataInfo bgData) {
        return bgData != null && bgData.getState() != 9;
    }

    @Override
    public void fillData(Book book) throws Exception {
        HashMap queryMap = new HashMap();
        this.getHelper().parseBgItem(book, BgViewHelper.getCurrPageMember(this.getF7List(), this.getBgDimensionManager().getPageDisplayDimension()), queryMap);
        this.bgDataMap = BgViewFacadeFactory.getRemoteInstance().queryBgData(queryMap, ((BgFormInfo)this.getEditValue()).getBgScheme().getRootId().toString());
        this.adjustMap = BgViewFacadeFactory.getRemoteInstance().queryAdjustBgData(queryMap, ((BgFormInfo)this.getEditValue()).getBgScheme().getRootId().toString());
        this.deleteMap.clear();
        this.fillData(book, this, this.bgDataMap, this.adjustMap, null);
    }

    @Override
    public void fillData(Book book, Map newAdjustMap) throws Exception {
        HashMap queryMap = new HashMap();
        this.getHelper().parseBgItem(book, BgViewHelper.getCurrPageMember(this.getF7List(), this.getBgDimensionManager().getPageDisplayDimension()), queryMap);
        this.bgDataMap = BgViewFacadeFactory.getRemoteInstance().queryBgData(queryMap, ((BgFormInfo)this.getEditValue()).getBgScheme().getRootId().toString());
        this.adjustMap = BgViewFacadeFactory.getRemoteInstance().queryAdjustBgData(queryMap, ((BgFormInfo)this.getEditValue()).getBgScheme().getRootId().toString());
        this.deleteMap.clear();
        this.fillData(book, this, this.bgDataMap, this.adjustMap, newAdjustMap);
    }

    @Override
    public Map getAdjustMap() {
        return this.adjustMap;
    }

    @Override
    public void store(Object obj) throws Exception {
    }

    @Override
    public void fillData(Book book, IProvider provider, Map bgDataMap, Map adjustMap, Map newAdjustMap) {
        if (book == null) {
            return;
        }
        if (bgDataMap == null) {
            bgDataMap = new HashMap();
        }
        if (adjustMap == null) {
            adjustMap = new HashMap();
        }
        if (newAdjustMap == null) {
            newAdjustMap = new HashMap();
        }
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        book.getUndoManager().discardAllEdits();
        BgNViewDataInfo data = null;
        BgAdjustFormDiversityData adjustData = null;
        Map subMap = null;
        Range locked = null;
        Range unLocked = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            Sheet sheet = book.getSheet(s);
            int maxRow = sheet.getMaxRowIndex();
            int maxCol = sheet.getMaxColIndex();
            for (int r = 0; r <= maxRow; ++r) {
                for (int c = 0; c <= maxCol; ++c) {
                    Cell cell = sheet.getCell(r, c, false);
                    ItemFormula formula = BgNFSHelper.getItemFormula((Cell)cell);
                    if (formula == null) continue;
                    BigDecimal newValue = null;
                    BigDecimal oldValue = null;
                    BgNFSHelper.setBackGroup((Cell)cell, (Color)BgNConstants.BASE_COLOR);
                    String orgId = formula.getExt("ORGUNITID");
                    if (bgDataMap.containsKey(orgId)) {
                        subMap = (Map)bgDataMap.get(orgId);
                        data = (BgNViewDataInfo)((Object)subMap.get(formula.getFormula()));
                    }
                    if (data != null) {
                        cell.setValue(new Variant((Object)data.getBudgetValue()));
                        oldValue = data.getBudgetValue();
                    } else {
                        cell.setValue(Variant.emptyVariant);
                        oldValue = null;
                    }
                    if (adjustMap.containsKey(orgId) && (subMap = (Map)adjustMap.get(orgId)).get(formula.getFormula()) != null) {
                        adjustData = (BgAdjustFormDiversityData)subMap.get(formula.getFormula());
                    }
                    if (newAdjustMap.containsKey(orgId) && (subMap = (Map)newAdjustMap.get(orgId)).get(formula.getFormula()) != null && (adjustData = (BgAdjustFormDiversityData)subMap.get(formula.getFormula())) != null) {
                        if (this.getAdjustMap().get(orgId) == null) {
                            this.getAdjustMap().put(orgId, new HashMap());
                        }
                        if (!((Map)this.getAdjustMap().get(orgId)).containsKey(formula.getFormula())) {
                            ((Map)this.getAdjustMap().get(orgId)).put(formula.getFormula(), adjustData);
                        }
                    }
                    if (adjustData != null) {
                        cell.setValue(new Variant((Object)adjustData.getNewValue()));
                        newValue = adjustData.getNewValue();
                        if (!BgViewHelper.compareDivValue(newValue, oldValue)) {
                            BgNFSHelper.setBackGroup((Cell)cell, (Color)BgNConstants.EDIT_COLOR);
                        }
                    }
                    adjustData = null;
                    boolean isLocked = provider.isLocked(data);
                    Range range = sheet.getRange(cell);
                    if (isLocked == cell.isLocked()) continue;
                    if (isLocked) {
                        if (locked == null) {
                            locked = range;
                            continue;
                        }
                        locked.addAll((SortedCellBlockArray)range);
                        continue;
                    }
                    if (unLocked == null) {
                        unLocked = range;
                        continue;
                    }
                    unLocked.addAll((SortedCellBlockArray)range);
                }
            }
        }
        StyleAttributes sa = Styles.getEmptySA();
        if (locked != null) {
            sa.setLocked(true);
            locked.setStyle(sa, Styles.getEmptySA());
        }
        if (unLocked != null) {
            sa.setLocked(false);
            unLocked.setStyle(sa, Styles.getEmptySA());
        }
        BgNFSHelper.enableUndo((Book)book);
    }

    @Override
    protected Map getInitBgViewDimensionInfo() throws BOSException, EASBizException {
        return BgViewFacadeFactory.getRemoteInstance().getInitBgAdjustViewDimensionInfo(this.getBgDimensionManager(), this.getEditValue().get("id").toString());
    }
}

