/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.core.ICellEditorProvider;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.impl.facade.editor.ICellEditor;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUI;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgExamineFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.budget.BgFormEntryFactory;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.IBgExamineFacade;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.client.BgExamineViewUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgNFormFacadeFactory;
import com.kingdee.eas.ma.nbudget.client.BgNCWfHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.view.client.BgReportViewProcessUI;
import com.kingdee.eas.ma.view.client.common.BgViewClientHelper;
import com.kingdee.eas.ma.view.client.common.BookContextManager;
import com.kingdee.eas.ma.view.client.common.BudgetViewProvider;
import com.kingdee.eas.ma.view.client.designer.IProvider;
import com.kingdee.eas.ma.view.common.BgDimensionMember;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class BgReportViewContextManager
extends BookContextManager
implements ICellEditorProvider {
    Map<String, BgFormInfo> bgFormMap = new HashMap<String, BgFormInfo>();
    Map<String, Map> bgGatherInfo = new HashMap<String, Map>();
    private Set<BgDimensionMember> addMembers = new HashSet<BgDimensionMember>();
    private Set<BgDimensionMember> removeMembers = new HashSet<BgDimensionMember>();

    public BgReportViewContextManager(Map uiContext, CoreUI owner) {
        super(uiContext, owner);
    }

    @Override
    public void initListener() {
        super.initListener();
        this.getSpreadContext().getEditManager().setEditorProvider((ICellEditorProvider)this);
    }

    public ICellEditor getEditor(Sheet sheet, int row, int col) {
        if (this.getOwnerUI() instanceof BgReportViewProcessUI) {
            return ((BgReportViewProcessUI)this.getOwnerUI()).getCellEditor(sheet, row, col);
        }
        return null;
    }

    @Override
    public void initData() throws Exception {
        super.initData();
        if (this.getProvider().getEditValue() == null) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        if (this.getOwnerUI() != null) {
            this.getOwnerUI().setUITitle(BgViewClientHelper.getString("view") + " - " + EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgNFormResource", (String)this.getOwnerUI().getOprtState()) + " - " + this.getProvider().getEditValue().get("name"));
        }
    }

    @Override
    public IProvider createProviderImpl() {
        BudgetViewProvider provider = new BudgetViewProvider();
        provider.getBgDimensionManager().setOprtState(this.getOwnerUI().getOprtState());
        return provider;
    }

    @Override
    protected void initToolBar(IUIObject ui) {
        super.initToolBar(ui);
        ToolBarManager toolBarManager = this.getSpreadContext().getToolBarManager();
        toolBarManager.setItemVisible("ToolItem_Merger", false);
        toolBarManager.setItemVisible("ToolItem_Sum", false);
        toolBarManager.setItemVisible("ToolItem_Cut", false);
        toolBarManager.setItemVisible("ToolItem_Hyperlink", false);
        toolBarManager.setItemVisible("ToolItem_Diagonal", false);
        toolBarManager.setItemVisible("ToolItem_SortAscend", false);
        toolBarManager.setItemVisible("ToolItem_SortDecsend", false);
        toolBarManager.setItemVisible("ToolItem_Comment", false);
        toolBarManager.setItemVisible("ToolItem_Locked", false);
    }

    @Override
    public Component getPageDimensionPanel(IBgDimensionManager dimensionManager) {
        Component c = super.getPageDimensionPanel(dimensionManager);
        for (int i = 0; i < this.getProvider().getF7List().size(); ++i) {
            if (!"ORGUNIT".equalsIgnoreCase(((JComponent)this.getProvider().getF7List().get(i)).getName())) continue;
            ((KDBizPromptBox)this.getProvider().getF7List().get(i)).setDataNoNotify((Object)((BgFormInfo)this.getProvider().getEditValue()).getOrgUnit());
        }
        return c;
    }

    @Override
    public void afterInit() throws Exception {
        super.afterInit();
        this.getProvider().fillData(this.getSpreadContext().getBook());
        BgViewClientHelper.checkItemDimeinsionEmpty(this.getOwnerUI(), this.getProvider().getBgDimensionManager());
    }

    @Override
    public void actionDimensionChange_dataChanged(DataChangeEvent eventObj) throws Exception {
        String num2;
        String num1;
        if (eventObj == null) {
            return;
        }
        KDBizPromptBox prmt = (KDBizPromptBox)eventObj.getSource();
        if (prmt.getData() == null) {
            prmt.setData(eventObj.getOldValue());
        }
        if (StringUtils.equals((String)(num1 = BgViewHelper.getNumber(eventObj.getNewValue())), (String)(num2 = BgViewHelper.getNumber(eventObj.getOldValue())))) {
            return;
        }
        this.storeFields();
        boolean isModifyMembers = this.isModifyMembers();
        boolean isModifyBgData = this.isModifyBgData();
        if (this.getBgGatherInfo().size() > 0 || this.isModifyBgData() || "ORGUNIT".equalsIgnoreCase(prmt.getName()) && isModifyMembers) {
            String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit");
            int flag = MsgBox.showConfirm3((Component)this.getOwnerUI(), (String)message);
            if (0 == flag) {
                try {
                    this.saveForDimensionChange(prmt, isModifyMembers, isModifyBgData);
                }
                catch (Exception e) {
                    prmt.setDataNoNotify(eventObj.getOldValue());
                    throw e;
                }
            } else if (1 != flag) {
                prmt.setDataNoNotify(eventObj.getOldValue());
                return;
            }
        }
        if ("ORGUNIT".equalsIgnoreCase(prmt.getName())) {
            this.getProvider().setOrgUnitId(((OrgUnitInfo)prmt.getData()).getId().toString());
            try {
                Book book = this.getProvider().pageChangeLoadBook();
                if (book != null) {
                    this.getSpreadContext().setBook(book);
                } else {
                    SysUtil.abort();
                }
            }
            catch (Exception e) {
                prmt.setDataNoNotify(eventObj.getOldValue());
                this.getProvider().setOrgUnitId(((OrgUnitInfo)prmt.getData()).getId().toString());
                throw e;
            }
            this.getProvider().fillData(this.getSpreadContext().getBook());
            BgViewClientHelper.checkItemDimeinsionEmpty(this.getOwnerUI(), this.getProvider().getBgDimensionManager());
        } else {
            this.getProvider().fillData(this.getSpreadContext().getBook());
        }
        this.getSpreadContext().getBook().getUndoManager().discardAllEdits();
        this.getSpreadContext().repaint();
    }

    protected void saveForDimensionChange(KDBizPromptBox prmt, boolean isModifyMembers, boolean isModifyData) throws Exception, BOSException, EASBizException {
        if (isModifyData) {
            this.saveData();
        }
        if ("ORGUNIT".equalsIgnoreCase(prmt.getName())) {
            if (isModifyMembers) {
                BgFormEntryFactory.getRemoteInstance().saveDimensionData(this.getProvider().getEditValue().get("id").toString(), this.getProvider().getBgDimensionManager(), this.getOrgUnitId());
            }
            if (this.getBgGatherInfo().size() > 0) {
                CoreBaseCollection baseCollection = new CoreBaseCollection();
                Collection<BgFormInfo> collections = this.getBgFormMap().values();
                for (BgFormInfo info : collections) {
                    if (this.getBgGatherInfo().get(info.getOrgUnit().getId().toString()) == null) continue;
                    baseCollection.add((CoreBaseInfo)info);
                }
                if (baseCollection.size() > 0) {
                    BgFormFactory.getRemoteInstance().save(baseCollection);
                    this.getBgFormMap().clear();
                }
            }
        }
    }

    protected Map saveData() throws Exception {
        this.getProvider().save((CoreBaseInfo)this.getProvider().getEditValue());
        return null;
    }

    public void storeFields() throws Exception {
        this.getProvider().store(this.getSpreadContext().getBook());
    }

    public boolean isModifyBgData() {
        return ((BudgetViewProvider)this.getProvider()).isModifyBgData();
    }

    @Override
    public void refer() throws Exception {
        final BgFormInfo bgForm = (BgFormInfo)this.getProvider().getEditValue();
        boolean isInProc = BgFormHelper.checkInProInst((String)bgForm.getId().toString());
        if (!isInProc) {
            boolean result = false;
            String sql = "select a.FIsSubmitByScheme from T_BG_BgScheme a, T_BG_BgForm b  where a.FID = b.FBgSchemeId and b.fid = '" + bgForm.getId() + "'";
            ISQLExecutor iSql = SQLExecutorFactory.getRemoteInstance((String)sql);
            IRowSet rs = iSql.executeSQL();
            if (rs.next()) {
                result = rs.getBoolean(1);
            }
            if (result) {
                MsgBox.showInfo((Component)this.getOwnerUI(), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSubmitBySchemeResource", (String)"formOnlySubmitByScheme"));
                return;
            }
        } else {
            Object obj = this.getOwnerUI().getUIContext().get("Owner");
            if (obj != null && !(obj instanceof MessageCenterUI) && !(obj instanceof MultiApproveUI)) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"bgFormInWorkNoSubmit"));
                return;
            }
        }
        this.save();
        int re = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"submitFormWork"));
        if (re == 1 || re == 2) {
            return;
        }
        if (this.getExamineInterface().canExamine(new BOSUuid[]{bgForm.getAdjust().getId()})) {
            final String xNum = BgNFCHelper.returnExamineX((BOSUuid[])new BOSUuid[]{bgForm.getAdjust().getId()}, (Object)this);
            LongTimeDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)this.getOwnerUI());
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
            if (dialog == null) {
                return;
            }
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    Object[] result = BgReportViewContextManager.this.getExamineInterface().examines(new BOSUuid[]{bgForm.getAdjust().getId()}, xNum);
                    HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                    bgExamineCheckMap.put("BgExamineChecked", result[0]);
                    bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                    return bgExamineCheckMap;
                }

                public void afterExec(Object result) throws Exception {
                    if (result != null && result instanceof HashMap) {
                        BgReportViewContextManager.this.openBgExamineViewUI(bgForm, result);
                        Map bgExamineCheckMap = (Map)result;
                        Boolean bgExCheck = (Boolean)bgExamineCheckMap.get("BgExamineChecked");
                        if (bgExCheck.booleanValue()) {
                            BgReportViewContextManager.this.runRefer(bgForm, xNum);
                        } else {
                            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"cantsubmit"));
                        }
                    } else {
                        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"error"));
                    }
                }
            });
            dialog.show();
        } else {
            this.runRefer(bgForm, null);
        }
    }

    protected void openBgExamineViewUI(BgFormInfo bgForm, Object obj) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"EXAMINE_DATA", obj);
        if (bgForm.getState().getValue() != 1) {
            uiContext.put((Object)"BGFORM_ID", (Object)bgForm.getId());
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgExamineViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public IBgExamineFacade getExamineInterface() throws Exception {
        return BgExamineFacadeFactory.getRemoteInstance();
    }

    private void runRefer(BgFormInfo bgForm, String xNum) throws BOSException, EASBizException, Exception {
        boolean flag = false;
        flag = !BgNCWfHelper.isNextPersonSubmit() ? BgFormFacadeFactory.getRemoteInstance().submitFormWork(bgForm.getId()) : BgNCWfHelper.submitFormWork((BOSUuid)bgForm.getId(), (CoreUI)this.getOwnerUI(), (IBgFormFacade)BgFormFacadeFactory.getRemoteInstance(), (ICoreBase)BgFormFactory.getRemoteInstance());
        if (flag) {
            if (xNum != null) {
                BgFormFactory.getRemoteInstance().saveXNum(new BOSUuid[]{bgForm.getId()}, xNum);
            }
            this.getOwnerUI().setMessageText(bgForm.getName() + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"submitFormSucceed"));
        } else {
            this.getOwnerUI().setMessageText(bgForm.getName() + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"submitFormDefeat"));
        }
        this.getOwnerUI().showMessage();
        this.getOwnerUI().destroyWindow();
    }

    @Override
    public Map save() throws Exception {
        this.getProvider().store(this.getSpreadContext().getBook());
        boolean isModifyData = this.isModifyBgData();
        boolean isModifyStyle = this.isModifyStyle();
        boolean isModifyMembers = this.isModifyMembers();
        this.getProvider().save((CoreBaseInfo)this.getProvider().getEditValue());
        if (this.getBgGatherInfo().size() > 0) {
            Map resultMap = null;
            HashSet<String> orgIdSet = new HashSet<String>();
            orgIdSet.addAll(this.getBgGatherInfo().keySet());
            orgIdSet.removeAll(this.getBgFormMap().keySet());
            resultMap = BgFormFacadeFactory.getRemoteInstance().queryBgFormByOrgUnitId((BgFormInfo)this.getProvider().getEditValue(), orgIdSet.toArray());
            this.getBgFormMap().putAll(resultMap);
            CoreBaseCollection baseCollection = new CoreBaseCollection();
            Collection<BgFormInfo> collections = this.getBgFormMap().values();
            for (BgFormInfo info : collections) {
                Map currentOrgGahterInfo;
                Book currentBook = info.getBook();
                if (currentBook == null) {
                    currentBook = Book.Manager.getNewBook();
                }
                if ((currentOrgGahterInfo = this.getBgGatherInfo().get(info.getOrgUnit().getId().toString())) == null) continue;
                currentBook.setUserObject("GATHER_ORGUNIT", currentOrgGahterInfo.get("GATHER_ORGUNIT"));
                currentBook.setUserObject("GATHER_ORGUNIT_SORT", currentOrgGahterInfo.get("GATHER_ORGUNIT_SORT"));
                currentBook.setUserObject("GATHER_SCHEME", currentOrgGahterInfo.get("GATHER_SCHEME"));
                currentBook.setUserObject("GATHER_BGFORM", currentOrgGahterInfo.get("GATHER_BGFORM"));
                currentBook.setUserObject("IS_GATHER_ADJUST", currentOrgGahterInfo.get("IS_GATHER_ADJUST"));
                info.setBook(currentBook);
                if (info.getState().getValue() != 4) {
                    info.setDataSource(BgFormDataSourceEnum.FORMCOLLECT);
                }
                info.put("CELL_DATA", currentOrgGahterInfo.get("CELL_DATA"));
                baseCollection.add((CoreBaseInfo)info);
            }
            BgNFormFacadeFactory.getRemoteInstance().batchSaveGatherForView(baseCollection);
        }
        this.getBgFormMap().clear();
        this.getBgGatherInfo().clear();
        if (isModifyStyle) {
            BgFormEntryFactory.getRemoteInstance().saveStyle(this.getProvider().getEditValue().get("id").toString(), this.getProvider().getBgDimensionManager());
        }
        if (isModifyMembers) {
            BgFormEntryFactory.getRemoteInstance().saveDimensionData(this.getProvider().getEditValue().get("id").toString(), this.getProvider().getBgDimensionManager(), this.getOrgUnitId());
        }
        if (this.getOwnerUI() != null) {
            this.showSuccessMsg(EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgViewTemplateResource", (String)"saveSuccess"));
        }
        this.getProvider().fillData(this.getSpreadContext().getBook());
        if (isModifyStyle) {
            this.getProvider().getBgDimensionManager().copyStyleToOld();
        }
        if (isModifyMembers) {
            this.getProvider().getBgDimensionManager().copyAllowEditDimension();
        }
        this.getSpreadContext().repaint();
        this.getRemoveMembers().clear();
        this.getAddMembers().clear();
        this.getBgFormMap().clear();
        this.getBgGatherInfo().clear();
        return null;
    }

    @Override
    public boolean checkBefore() throws Exception {
        String oprt;
        boolean isDecomposer = false;
        Object obj = this.getOwnerUI().getUIContext().get("isDecompose");
        if (obj instanceof Boolean) {
            isDecomposer = Boolean.parseBoolean(obj.toString());
        }
        if (!(OprtState.EDIT.equals(oprt = this.getOwnerUI().getOprtState()) || OprtState.ADDNEW.equals(oprt) || isDecomposer)) {
            return true;
        }
        this.getProvider().store(this.getSpreadContext().getBook());
        boolean isModifyData = this.isModifyBgData();
        boolean isModifyStyle = this.isModifyStyle();
        boolean isModifyMembers = this.isModifyMembers();
        if (isModifyData || isModifyStyle || isModifyMembers) {
            String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit");
            int flag = MsgBox.showConfirm3((Component)this.getOwnerUI(), (String)message);
            if (0 == flag) {
                if (isModifyData) {
                    this.getProvider().save((CoreBaseInfo)this.getProvider().getEditValue());
                }
                if (isModifyStyle) {
                    BgFormEntryFactory.getRemoteInstance().saveStyle(this.getProvider().getEditValue().get("id").toString(), this.getProvider().getBgDimensionManager());
                }
                if (isModifyMembers) {
                    BgFormEntryFactory.getRemoteInstance().saveDimensionData(this.getProvider().getEditValue().get("id").toString(), this.getProvider().getBgDimensionManager(), this.getOrgUnitId());
                }
            } else if (1 != flag) {
                return false;
            }
        }
        return true;
    }

    public boolean isModifyStyle() {
        return this.getProvider().getBgDimensionManager().isModifyStyle();
    }

    public boolean isModifyMembers() {
        return this.getProvider().getBgDimensionManager().isModifyMembers();
    }

    public Map<String, BgFormInfo> getBgFormMap() {
        return this.bgFormMap;
    }

    @Override
    public Map<String, Map> getBgGatherInfo() {
        return this.bgGatherInfo;
    }

    public Set<BgDimensionMember> getAddMembers() {
        return this.addMembers;
    }

    public Set<BgDimensionMember> getRemoveMembers() {
        return this.removeMembers;
    }
}

