/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.common;

import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.cp.ba.RptReleaseManager;
import com.kingdee.eas.cp.ba.RptTypeEnum;
import com.kingdee.eas.cp.ba.SourceTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgElementCollObject;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.view.client.BgReportViewBaseUI;
import com.kingdee.eas.ma.view.client.BgViewDimensionInfo2;
import com.kingdee.eas.ma.view.client.IViewDimensionCellChange;
import com.kingdee.eas.ma.view.client.common.BgReportViewContextManager;
import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.util.BgItemViewObject;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class BgViewClientHelper {
    public static final String RES_CLIENT = "com.kingdee.eas.ma.view.client.BgViewClientResource";
    public static final String VIEW_TEMPLATE_RES = "com.kingdee.eas.ma.view.client.BgViewTemplateResource";
    public static final Color REQUESTCOLOR = new Color(252, 251, 223);
    public static final String COL_DIMENSION = "dimension";
    public static final String COL_DIMENSIONCHILD = "dimensionChild";

    public static String getString(String key) {
        return EASResource.getString((String)RES_CLIENT, (String)key);
    }

    public static void publishRPTUI(File file, RptTypeEnum typeEnum, CoreUI ui) throws Exception {
        SystemEnum sys = SystemEnum.BASICSYSTEM;
        RptReleaseManager rpt = new RptReleaseManager(ui.getUITitle(), new File[]{file}, sys, typeEnum);
        rpt.showReleaseUI((Component)ui);
    }

    public static void publishLink2OA(CoreUI ui) throws Exception {
        BgReportViewBaseUI baseUI = (BgReportViewBaseUI)ui;
        BgReportViewContextManager contexManager = (BgReportViewContextManager)baseUI.getContextManager();
        String editName = ui.getMetaDataPK().getFullName();
        RptReleaseManager m = new RptReleaseManager(RptSrcTypeEnum.BGFORMREPORT.getAlias(), null, SystemEnum.BASICSYSTEM, (Object)contexManager.getProvider().getEditValue().get("ID").toString(), RptTypeEnum.SNAP_LINK_MODE, SourceTypeEnum.USER_DEFINED_TYPE, editName);
        m.showReleaseUI((Component)ui);
    }

    public static void removeAction(ToolBarManager toolBarManager) {
        if (toolBarManager != null) {
            toolBarManager.getToolBar("style").setVisible(false);
            KDToolBar commonToolBar = toolBarManager.getToolBar("common");
            for (Component comp : commonToolBar.getComponents()) {
                if (!BgViewClientHelper.isVisible(comp)) {
                    BgViewClientHelper.setBtnUnVisbile(comp);
                    continue;
                }
                comp.setEnabled(true);
            }
        }
    }

    private static boolean isVisible(Component comp) {
        String ac;
        if (comp instanceof JButton && (ac = ((JButton)comp).getActionCommand()) != null) {
            if ("com.kingdee.eas.ma.view.client.AbstractBgSpreadViewUI$ActionRefer".equalsIgnoreCase(ac)) {
                return true;
            }
            if ("com.kingdee.eas.ma.view.client.AbstractBgReportViewProcessUI$ActionSetLayout".equalsIgnoreCase(ac)) {
                return true;
            }
            if ("com.kingdee.eas.ma.view.client.AbstractBgReportViewProcessUI$ActionSwapAxes".equalsIgnoreCase(ac)) {
                return true;
            }
        }
        return false;
    }

    private static void setBtnUnVisbile(Component comp) {
        comp.setVisible(false);
    }

    public static Dimension getScreenSize(CoreUI ui) {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getSize();
    }

    public static void showLongTimeDialog(CoreUI owner, ILongTimeTask timeTask) {
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)owner);
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(timeTask);
        dialog.show();
    }

    public static void setEnable(JComponent comp, boolean enable) {
        if (comp != null) {
            comp.setEnabled(enable);
            if (comp instanceof KDBizPromptBox) {
                ((KDBizPromptBox)comp).setEditable(false);
            }
            for (int i = 0; i < comp.getComponentCount(); ++i) {
                if (!(comp.getComponent(i) instanceof JComponent)) continue;
                BgViewClientHelper.setEnable((JComponent)comp.getComponent(i), enable);
            }
        }
    }

    private static void fillTable(KDTable table, BgDimensionInfo info, boolean isChildTemplate, IViewDimensionCellChange cellChange) {
        if (table == null || info == null) {
            return;
        }
        IRow row = table.addRow();
        row.getStyleAttributes().setBackground(REQUESTCOLOR);
        String type = info.getType();
        Object obj = info.unParse();
        if (StringUtils.isEmpty((String)info.getAttribute())) {
            return;
        }
        String[] attribute = info.getAttribute().split(",");
        if ("BGITEM".equals(type)) {
            BgViewDimensionInfo2 viewInfo = new BgViewDimensionInfo2();
            viewInfo.setType(EASResource.getString((String)VIEW_TEMPLATE_RES, (String)"bgItemGroup"));
            viewInfo.setNumber(attribute[0]);
            viewInfo.setName(attribute[1]);
            viewInfo.setShowType(info.getShowType());
            viewInfo.setXMLType("BGITEM");
            row.getCell(COL_DIMENSION, true).setValue((Object)viewInfo);
            if (obj instanceof BgItemViewObject) {
                row.getCell(COL_DIMENSIONCHILD, true).setValue(obj);
            } else if (obj == null) {
                row.getCell(COL_DIMENSIONCHILD, true).setValue((Object)EASResource.getString((String)VIEW_TEMPLATE_RES, (String)"all"));
            }
        } else if ("BGELEMENT".equals(type)) {
            BgViewDimensionInfo2 viewInfo = new BgViewDimensionInfo2();
            viewInfo.setType(EASResource.getString((String)VIEW_TEMPLATE_RES, (String)"bgElement"));
            viewInfo.setNumber(attribute[0]);
            viewInfo.setName(attribute[1]);
            viewInfo.setShowType(info.getShowType());
            viewInfo.setXMLType("BGELEMENT");
            row.getCell(COL_DIMENSION, true).setValue((Object)viewInfo);
            if (obj instanceof BgElementCollObject) {
                row.getCell(COL_DIMENSIONCHILD, true).setValue(obj);
            }
        } else if ("BGPERIOD".equals(type)) {
            BgViewDimensionInfo2 viewInfo = new BgViewDimensionInfo2();
            viewInfo.setType(EASResource.getString((String)VIEW_TEMPLATE_RES, (String)"bizPeriod"));
            viewInfo.setNumber(attribute[0]);
            viewInfo.setName(attribute[1]);
            viewInfo.setXMLType("BGPERIOD");
            viewInfo.setShowType(info.getShowType());
            row.getCell(COL_DIMENSION, true).setValue((Object)viewInfo);
            row.getCell(COL_DIMENSIONCHILD, true).setValue(obj);
        } else if ("ORGUNIT".equals(type) || "CURRENCY".equals(type)) {
            // empty if block
        }
        if (cellChange != null) {
            cellChange.cellValueChangeAfter(table, row.getRowIndex(), row.getCell(COL_DIMENSION).getColumnIndex());
            cellChange.cellValueChangeAfter(table, row.getRowIndex(), row.getCell(COL_DIMENSIONCHILD).getColumnIndex());
        }
        if (isChildTemplate) {
            row.getCell(COL_DIMENSION).getStyleAttributes().setLocked(true);
        }
    }

    public static void fillDimension(List dimensionList, Map map, boolean isChildTemplate, KDCheckBox checkBoxRowDisplayCJ, KDCheckBox checkBoxAllowUserAddRow, KDTable colLayoutTable, KDTable rowLayoutTable, KDTable tableView, KDTable pageDimensionTable, IViewDimensionCellChange cellChange) throws Exception {
        if (dimensionList == null || dimensionList.isEmpty() || map == null) {
            return;
        }
        if (map.get("displayCJ") instanceof Boolean) {
            checkBoxRowDisplayCJ.setSelected(Boolean.parseBoolean(map.get("displayCJ").toString()));
        }
        if (map.get("allowUserAddDimension") instanceof Boolean) {
            checkBoxAllowUserAddRow.setSelected(Boolean.parseBoolean(map.get("allowUserAddDimension").toString()));
        }
        BgDimensionInfo dimensionInfo = null;
        for (int index = 0; index < dimensionList.size(); ++index) {
            dimensionInfo = (BgDimensionInfo)dimensionList.get(index);
            String layout = dimensionInfo.getLayout();
            if ("col".equals(layout)) {
                BgViewClientHelper.fillTable(colLayoutTable, dimensionInfo, isChildTemplate, cellChange);
                continue;
            }
            if ("row".equals(layout)) {
                BgViewClientHelper.fillTable(rowLayoutTable, dimensionInfo, isChildTemplate, cellChange);
                continue;
            }
            if (!"page".equals(layout)) continue;
            if ("CURRENCY".equals(dimensionInfo.getType())) {
                Object obj = dimensionInfo.unParse();
                if (!(obj instanceof CurrencyInfo)) continue;
                tableView.getCell(0, COL_DIMENSIONCHILD).setValue(obj);
                continue;
            }
            if ("ORGUNIT".equals(dimensionInfo.getType())) continue;
            BgViewClientHelper.fillTable(pageDimensionTable, dimensionInfo, isChildTemplate, cellChange);
        }
    }

    public static void setCellDisplay(KDTable table, int rowIndex, int colIndex, Object obj) {
        ICell cell = table.getCell(rowIndex, colIndex);
        if (obj == null) {
            cell.setUserObject(null);
            return;
        }
        if (obj instanceof BgElementCollObject) {
            BgElementCollObject elements = (BgElementCollObject)obj;
            cell.setUserObject(obj);
            BgElementCollection es = elements.getResult();
            cell.setValue((Object)es);
            BgViewClientHelper.setCellDisplay(cell);
        } else if (obj instanceof BgItemViewObject) {
            BgItemViewObject items = (BgItemViewObject)((Object)obj);
            BgItemCollection bs = items.getResult();
            cell.setUserObject(obj);
            if (bs == null || bs.isEmpty()) {
                cell.setValue((Object)items.toString());
            } else {
                cell.setValue((Object)bs);
            }
            BgViewClientHelper.setCellDisplay(cell);
            if (table.getCell(rowIndex, COL_DIMENSION).getUserObject() instanceof BgViewDimensionInfo2) {
                ((BgViewDimensionInfo2)table.getCell(rowIndex, COL_DIMENSION).getUserObject()).setShowType(items.getShowType());
            }
        } else if (obj instanceof BgPeriodInfo[]) {
            BgPeriodInfo[] pers = (BgPeriodInfo[])obj;
            if (pers.length < 1) {
                return;
            }
            cell.setUserObject(obj);
            StringBuffer value = new StringBuffer();
            for (int n = 0; n < pers.length; ++n) {
                value.append(pers[n].getName()).append(",");
            }
            value.deleteCharAt(value.length() - 1);
            cell.setValue((Object)value.toString());
        } else if (obj instanceof List) {
            cell.setUserObject(obj);
            ArrayList list = (ArrayList)obj;
            StringBuffer value = new StringBuffer();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                value.append(it.next().toString()).append(",");
            }
            value.deleteCharAt(value.length() - 1);
            cell.setValue((Object)value.toString());
        } else if (obj instanceof String && !(cell.getUserObject() instanceof BgViewDimensionInfo2) && EASResource.getString((String)VIEW_TEMPLATE_RES, (String)"all").equals(obj)) {
            cell.setValue(obj);
            cell.setUserObject(obj);
        }
    }

    private static void setCellDisplay(ICell cell) {
        if (cell == null || cell.getValue() == null || !(cell.getValue() instanceof AbstractObjectCollection)) {
            return;
        }
        AbstractObjectCollection collect = (AbstractObjectCollection)cell.getValue();
        int size = collect.size();
        StringBuffer dis = new StringBuffer();
        for (int n = 0; n < size; ++n) {
            dis.append(collect.getObject(n).get("name")).append(",");
        }
        dis.deleteCharAt(dis.length() - 1);
        cell.setValue((Object)dis.toString());
    }

    public static void checkItemDimeinsionEmpty(CoreUI ui, IBgDimensionManager bm) {
        if (ui != null && bm != null) {
            for (int i = 0; i < bm.getDimension().size(); ++i) {
                BgDimensionInfo dimen = (BgDimensionInfo)bm.getDimension().get(i);
                if (!"BGITEM".equalsIgnoreCase(dimen.getType()) || !dimen.getMember().isEmpty()) continue;
                String msg = dimen.getAttribute();
                if (dimen.getAttribute().indexOf(",") > 0) {
                    msg = msg.substring(msg.lastIndexOf(",") + 1);
                }
                msg = MessageFormat.format(BgViewClientHelper.getString("noBgItemMember"), msg);
                MsgBox.showInfo((Component)ui, (String)msg);
            }
        }
    }
}

