/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.command.ICommand;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.nbudget.BgNDataInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.view.BgViewDimensionFactory;
import com.kingdee.eas.ma.view.BgViewDimensionInfo;
import com.kingdee.eas.ma.view.BgViewFacadeFactory;
import com.kingdee.eas.ma.view.client.common.BudgetProvider;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.util.BgViewCommonHelper;
import com.kingdee.eas.ma.view.util.BookParseHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgViewTemplateProvider
extends BudgetProvider
implements ICommand {
    private static Logger logger = Logger.getLogger((String)BgViewTemplateProvider.class.getName());
    private BgViewDimensionInfo bgViewDimensionInfo;
    private BookParseHelper helper = null;

    @Override
    public BookParseHelper getHelper() {
        if (this.helper == null) {
            this.helper = new BookParseHelper(this.getBgDimensionManager());
        }
        return this.helper;
    }

    @Override
    public ICoreBase getBizInterface() throws Exception {
        return BgTemplateFactory.getRemoteInstance();
    }

    @Override
    protected SelectorItemCollection getSelectors() {
        return BgNFSHelper.getTemplateSelectors();
    }

    @Override
    public Object load() throws Exception {
        byte[] bytes = null;
        BgTemplateInfo tempInfo = null;
        if (this.getEditValue() instanceof BgTemplateInfo) {
            tempInfo = (BgTemplateInfo)this.getEditValue();
            IObjectValue obj = BgViewDimensionFactory.getRemoteInstance().getDimensionByTemplate(tempInfo.getId().toString());
            if (obj instanceof BgViewDimensionInfo) {
                this.bgViewDimensionInfo = (BgViewDimensionInfo)obj;
                this.bgViewDimensionInfo.setTemplate(tempInfo);
                bytes = this.bgViewDimensionInfo.getData();
            }
        }
        return this.returnBook(bytes);
    }

    private Object returnBook(byte[] bytes) throws Exception {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        this.getHelper().setAfterLoad(this);
        Book book = this.getHelper().getViewDimensionBook(bytes, null);
        this.getHelper().setAfterLoad(null);
        return book;
    }

    @Override
    public void store(Object obj) throws Exception {
        if (obj instanceof Book) {
            this.getEditValue().setBytes("data", this.getHelper().setBook((Book)obj));
        }
    }

    public BgViewDimensionInfo getBgViewDimensionInfo() {
        return this.bgViewDimensionInfo;
    }

    public void setBgViewDimensionInfo(BgViewDimensionInfo bgViewDimensionInfo) {
        this.bgViewDimensionInfo = bgViewDimensionInfo;
    }

    public Object execute(Context ctx) throws BOSException {
        IBgDimensionManager bm = this.getBgDimensionManager();
        if (bm.isVerify() && this.getEditValue() != null) {
            BgTemplateInfo bgTemplate = (BgTemplateInfo)this.getEditValue();
            bm.setDefaultMeasureUnit(bgTemplate.getDefaultMeasureUnit());
            if (!bgTemplate.getBgMeasureUnit().isEmpty()) {
                for (int i = 0; i < bgTemplate.getBgMeasureUnit().size(); ++i) {
                    bm.getMeasureMap().put(bgTemplate.getBgMeasureUnit().get(i).getBgElement().getNumber(), bgTemplate.getBgMeasureUnit().get(i).getMeasureUnit());
                }
            }
            Map initData = null;
            try {
                initData = BgViewFacadeFactory.getRemoteInstance().getInitBgTemplateDimensionInfo(bm, String.valueOf(this.getEditValue().get(this.getEditValue().getPKField())));
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
            BgViewCommonHelper.processTemplateDimension(ctx, bm, initData, bgTemplate.getOrgUnit().getId().toString());
        }
        return null;
    }

    @Override
    public Book pageChangeLoadBook() throws Exception {
        return null;
    }

    @Override
    public boolean isLocked(BgNDataInfo bgData) {
        return false;
    }
}

