/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.impl.FacadeManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.UserCellDisplayProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BudgetDisplayValueProvider;
import com.kingdee.eas.ma.nbudget.client.UserItemRenderProvider;
import com.kingdee.eas.ma.view.client.action.actions.ActionGather;
import com.kingdee.eas.ma.view.client.common.BgDimensionParseHelper;
import com.kingdee.eas.ma.view.client.common.BgViewClientHelper;
import com.kingdee.eas.ma.view.client.common.ContextManager;
import com.kingdee.eas.ma.view.client.common.FormulaManager;
import com.kingdee.eas.ma.view.client.common.ItemFormulaHelper;
import com.kingdee.eas.ma.view.client.common.ModifyManager;
import com.kingdee.eas.ma.view.client.designer.IFormulaManager;
import com.kingdee.eas.ma.view.client.designer.IModifyManager;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BookContextManager
extends ContextManager {
    private static final Logger logger = CoreUIObject.getLogger(BookContextManager.class);
    private SpreadContext sc = null;
    KDPanel mainPanel = null;
    public BudgetDisplayValueProvider displayProvider = null;
    private IFormulaManager formulaManager = null;
    private boolean isEditableItemToolBar = true;

    public BookContextManager(Map uiContext, CoreUI owner) {
        super(uiContext, owner);
    }

    public BudgetDisplayValueProvider getDisplayProvider() {
        if (this.displayProvider == null) {
            this.displayProvider = new BudgetDisplayValueProvider((Component)this.getOwnerUI());
        }
        return this.displayProvider;
    }

    public SpreadContext getSpreadContext() {
        if (this.sc == null) {
            this.sc = new SpreadContext();
        }
        this.sc.getSpread().getTabbedBar().setVisible(false);
        return this.sc;
    }

    public void createSpreadContextImpl(Book book) {
        this.sc = new SpreadContext(book);
    }

    @Override
    protected IModifyManager createModifyManager() {
        return new ModifyManager(this.getSpreadContext());
    }

    public IFormulaManager createFormulaManagerImpl() {
        return new FormulaManager(this.getSpreadContext());
    }

    public void setFormulaManager(IFormulaManager formulaManager) {
        this.formulaManager = formulaManager;
    }

    public IFormulaManager getFormulaManager() {
        if (this.formulaManager == null) {
            this.setFormulaManager(this.createFormulaManagerImpl());
        }
        return this.formulaManager;
    }

    @Override
    public void doInit() throws Exception {
        super.doInit();
        this.setModifyManager(this.createModifyManager());
    }

    @Override
    public void initLayout(IUIObject ui) {
        super.initLayout(ui);
        if (ui == null) {
            return;
        }
        ui.getUIContentPane().setPreferredSize(null);
        ui.getUIContentPane().setLayout(new BorderLayout());
        this.initToolBar(ui);
        this.initContext(ui);
        this.getFormulaManager().doInit();
        try {
            FormulaDefinition.registerFormulaToBook((Book)this.getSpreadContext().getBook(), (ICalculateContextProvider)new CalculateContext());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    public void initListener() {
        super.initListener();
        this.registerCellDisplayProvider();
        this.getSpreadContext().addSheetChangeListener(new SheetChangeListener(){

            public void changed(SheetChangeEvent e) {
                if (e.hasState(SheetChangeEvent.Changed_Selection) || e.hasState(SheetChangeEvent.Changed_SelectionActive)) {
                    try {
                        BookContextManager.this.cell_Selection_Changed(e);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                }
            }
        });
        this.getSpreadContext().getFacadeManager().setErrorMessageBox(new FacadeManager.IErrorMessageBox(){

            public boolean show(Component parent, String title, String msg, int msgType) {
                if (msgType == 2) {
                    BookContextManager.this.showWarningMsg(msg);
                } else if (msgType == 0) {
                    BookContextManager.this.showErrorMsg(msg);
                } else {
                    BookContextManager.this.showWarningMsg(msg);
                }
                return false;
            }
        });
    }

    public void showSuccessMsg(String msg) {
        if (this.getOwnerUI() != null) {
            this.getOwnerUI().setMessageIcon(CoreUI.SHOW_MESSAGE_ICON_OK);
            this.getOwnerUI().setMessageBgcolor(CoreUI.SHOW_MESSAGE_BG_OK);
            this.getOwnerUI().setMessageText(msg);
            this.getOwnerUI().showMessage();
        }
    }

    public void showWarningMsg(String msg) {
        if (this.getOwnerUI() != null) {
            this.getOwnerUI().setMessageIcon(CoreUI.SHOW_MESSAGE_ICON_ERROR);
            this.getOwnerUI().setMessageBgcolor(Color.yellow);
            this.getOwnerUI().setMessageText(msg);
            this.getOwnerUI().showMessage();
        }
    }

    public void showErrorMsg(String msg) {
        if (this.getOwnerUI() != null) {
            this.getOwnerUI().setMessageIcon(CoreUI.SHOW_MESSAGE_ICON_ERROR);
            this.getOwnerUI().setMessageBgcolor(CoreUI.SHOW_MESSAGE_BG_ERROR);
            this.getOwnerUI().setMessageText(msg);
            this.getOwnerUI().showMessage();
        }
    }

    @Override
    public void show() {
        super.show();
        this.getFormulaManager().setItemFormulaProvider(new IItemFormulaProvider(){

            public String getDisplayingItemFormula(Range range, int viewMode) {
                Object obj = range.getUserObject("ITEM");
                if (obj != null && obj instanceof ItemFormula) {
                    return BookContextManager.this.getShowBgFormula(((ItemFormula)obj).getFormula());
                }
                return null;
            }

            public String defaultItemFormula() {
                return "=BgItem()";
            }

            public boolean editable() {
                return BookContextManager.this.isEditableItemToolBar();
            }
        });
        this.getSpreadContext().getBook().getUndoManager().enable(true);
    }

    protected void initToolBar(IUIObject ui) {
        KDToolBar toolBar = this.getSpreadContext().getToolBarManager().getToolBar("common");
        toolBar.setIsControlByParent(false);
        toolBar.setTextIconDisStyle((short)2);
        toolBar.setPopupMenuShowable(false);
        ui.getUIContentPane().add((Component)toolBar, "North");
        ui.setUIToolBar(toolBar);
        toolBar = this.getSpreadContext().getToolBarManager().getToolBar("style");
        toolBar.setIsControlByParent(false);
        toolBar.setTextIconDisStyle((short)2);
        toolBar.setPopupMenuShowable(false);
        ui.getUIContentPane().add((Component)toolBar, "North");
    }

    protected void initContext(IUIObject ui) {
        ui.getUIContentPane().add(this.getPageDimensionPanel(this.getProvider().getBgDimensionManager()), "Center");
    }

    protected boolean isEnablePage() {
        return true;
    }

    protected String getShowBgFormula(String formulaStr) {
        return ItemFormulaHelper.showItemFormula(formulaStr);
    }

    public boolean isEditableItemToolBar() {
        return this.isEditableItemToolBar;
    }

    public void setEditableItemToolBar(boolean isEditableItemToolBar) {
        this.isEditableItemToolBar = isEditableItemToolBar;
    }

    @Override
    public void initData() throws Exception {
        Object _obj;
        super.initData();
        if (this.getProvider().getEditValue() != null && (_obj = this.getProvider().load()) instanceof Book) {
            Book _book = (Book)_obj;
            this.createSpreadContextImpl(_book);
        }
    }

    public void registerCellDisplayProvider() {
        this.getSpreadContext().getRenderManager().setUserCellDisplayProvider(this.getCellDisplayProvider());
    }

    public ICellDisplayProvider getCellDisplayProvider() {
        UserCellDisplayProvider userCellDisplayProvider = new UserCellDisplayProvider();
        userCellDisplayProvider.setDisplayValueProvider((IDisplayValueProvider)this.getDisplayProvider());
        UserCellDisplayProvider.addRenderProvider((IRenderProvider)new UserItemRenderProvider());
        return userCellDisplayProvider;
    }

    public void cell_Selection_Changed(SheetChangeEvent e) throws Exception {
        boolean _enabled = false;
        if (e.getChangedBlocks() != null && e.getSheet() != null) {
            Sheet _sheet = e.getSheet();
            Cell _cell = _sheet.getActiveCell();
            _enabled = BgNFSHelper.checkCanEditFormulaOfCell((Cell)_cell);
        }
        this.getFormulaManager().setItemFormulaEnable(_enabled);
    }

    public boolean hasPageDimension(IBgDimensionManager dimensionManager) {
        if (dimensionManager == null) {
            return false;
        }
        return !dimensionManager.getPageDisplayDimension().isEmpty();
    }

    public Component getPageDimensionPanel(IBgDimensionManager dimensionManager) {
        KDPanel kdPanel = this.getMainPanel();
        kdPanel.removeAll();
        this.getProvider().getF7List().clear();
        if (this.hasPageDimension(dimensionManager)) {
            kdPanel.add(BgDimensionParseHelper.parsePageBgDimension((IUIObject)this.getOwnerUI(), this.getOrgUnitId(), dimensionManager, this.isEnablePage(), this.getProvider().getF7List()), (Object)"North");
        }
        this.mainPanel.add((Component)this.getSpreadContext(), (Object)"Center");
        this.mainPanel.revalidate();
        return kdPanel;
    }

    public KDPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new KDPanel();
            this.mainPanel.setLayout((LayoutManager)new BorderLayout());
        }
        return this.mainPanel;
    }

    public String getOrgUnitId() {
        return this.getProvider().getOrgUnitId();
    }

    @Override
    public void close() {
        super.close();
        this.sc = null;
        this.getFormulaManager().clear();
    }

    @Override
    public void afterInit() throws Exception {
        super.afterInit();
        this.getProvider().fillData(this.getSpreadContext().getBook());
        Object obj = this.getOwnerUI().getUIContext().get("IS_GATHER");
        if (obj instanceof Boolean) {
            this.getOwnerUI().getUIContext().remove("IS_GATHER");
            Map _gatherOrgUnitMap = null;
            Map _gatherBgSchemeIdMap = null;
            Map _gatherBgFormIdsMap = null;
            Map _patameterMap = null;
            List _gatherOrgUnitList = null;
            obj = this.getOwnerUI().getUIContext().get("GATHER_CHECK_ORGUNIT");
            if (obj instanceof Map) {
                _gatherOrgUnitMap = (Map)obj;
            }
            if ((obj = this.getOwnerUI().getUIContext().get("GATHER_CHECK_BGSCHEME_ID")) instanceof Map) {
                _gatherBgSchemeIdMap = (Map)obj;
            }
            if ((obj = this.getOwnerUI().getUIContext().get("GATHER_CHECK_BGFORM_ID")) instanceof Map) {
                _gatherBgFormIdsMap = (Map)obj;
            }
            if ((obj = this.getOwnerUI().getUIContext().get("GATHER_PARAMETER")) instanceof Map) {
                _patameterMap = (Map)obj;
            }
            if ((obj = this.getOwnerUI().getUIContext().get("GATHER_SORT")) instanceof List) {
                _gatherOrgUnitList = (List)obj;
            }
            if (_gatherOrgUnitMap != null && !_gatherOrgUnitMap.isEmpty() && _gatherBgSchemeIdMap != null && _patameterMap != null) {
                ActionGather actionGather = new ActionGather();
                actionGather.setUIObject((IUIObject)this.getOwnerUI());
                boolean isGatherTmpData = Boolean.TRUE.equals(_patameterMap.get("GATHER_TMPDATA"));
                actionGather.executeGather(_patameterMap, this.getCurrGatherForm(), _gatherOrgUnitMap, _gatherOrgUnitList, _gatherBgSchemeIdMap, _gatherBgFormIdsMap, isGatherTmpData);
            }
        }
    }

    public Map<String, Map> getBgGatherInfo() {
        return null;
    }

    @Override
    public void actionDimensionChange_dataChanged(DataChangeEvent eventObj) throws Exception {
        String num2;
        if (eventObj == null) {
            return;
        }
        KDBizPromptBox prmt = (KDBizPromptBox)eventObj.getSource();
        String num1 = BgViewHelper.getNumber(eventObj.getNewValue());
        if (StringUtils.equals((String)num1, (String)(num2 = BgViewHelper.getNumber(eventObj.getOldValue())))) {
            return;
        }
        this.beforeDimensionChange_dataChanged(eventObj);
        if (this.isNeedSaveForDimensionChange(eventObj)) {
            String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit");
            int flag = MsgBox.showConfirm3((Component)this.getOwnerUI(), (String)message);
            if (0 == flag) {
                try {
                    this.saveForDimensionChange(eventObj);
                }
                catch (Exception e) {
                    prmt.setDataNoNotify(eventObj.getOldValue());
                    throw e;
                }
            } else if (1 != flag) {
                prmt.setDataNoNotify(eventObj.getOldValue());
                return;
            }
        }
        if ("ORGUNIT".equalsIgnoreCase(prmt.getName())) {
            this.getProvider().setOrgUnitId(((OrgUnitInfo)prmt.getData()).getId().toString());
            try {
                Book book = this.getProvider().pageChangeLoadBook();
                if (book != null) {
                    this.getSpreadContext().setBook(book);
                } else {
                    SysUtil.abort();
                }
            }
            catch (Exception e) {
                prmt.setDataNoNotify(eventObj.getOldValue());
                this.getProvider().setOrgUnitId(((OrgUnitInfo)prmt.getData()).getId().toString());
                throw e;
            }
            this.getProvider().fillData(this.getSpreadContext().getBook());
            BgViewClientHelper.checkItemDimeinsionEmpty(this.getOwnerUI(), this.getProvider().getBgDimensionManager());
        } else {
            this.getProvider().fillData(this.getSpreadContext().getBook());
        }
        this.getSpreadContext().getBook().getUndoManager().discardAllEdits();
        this.getSpreadContext().repaint();
    }

    protected void beforeDimensionChange_dataChanged(DataChangeEvent eventObj) throws Exception {
    }

    protected boolean isNeedSaveForDimensionChange(DataChangeEvent eventObj) {
        return false;
    }

    protected void saveForDimensionChange(DataChangeEvent eventObj) throws Exception, BOSException, EASBizException {
    }

    public BgFormInfo getCurrGatherForm() throws BOSException, EASBizException {
        return null;
    }

    protected final class CalculateContext
    implements ICalculateContextProvider {
        private static final long serialVersionUID = -2732525885313221629L;
        private IErrorResultProvider resultProvider = null;
        private Book book;

        public CalculateContext() {
            try {
                this.book = BookContextManager.this.getSpreadContext().getBook();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            if (this.book != null) {
                this.book.getUndoManager().enable(true);
            }
        }

        public Context getServerContext() {
            return null;
        }

        public IReportPropertyAdapter getReportAdapter() {
            return new BgRptReportPropertyAdapter((BgFormInfo)BookContextManager.this.getProvider().getEditValue());
        }

        public ReportVariables getReportVariables() {
            ReportVariables reportVariables = ReportVariables.loadFromBook((Book)this.book);
            if (reportVariables == null) {
                reportVariables = new ReportVariables();
            }
            return reportVariables;
        }

        public IErrorProvider getErrorProvider() {
            return this.getBookProperties().getErrorProvider();
        }

        public IErrorResultProvider getErrorResultProvider() {
            if (this.resultProvider == null) {
                this.resultProvider = new IErrorResultProvider(){

                    public String getText(long errorCode) {
                        ReportCalculateErrorProvider errorProvider = CalculateContext.this.getBookProperties().getErrorProvider();
                        if (errorProvider != null && errorCode == 128L) {
                            return errorProvider.getExceptionReplacer().toString();
                        }
                        if (errorProvider != null && errorCode == 2L) {
                            return errorProvider.getZeroDivDisplayAs();
                        }
                        return null;
                    }
                };
            }
            return this.resultProvider;
        }

        protected BookProperties getBookProperties() {
            BookProperties p = BookProperties.loadFromBook((Book)this.book);
            if (p == null) {
                p = new BookProperties();
                p.restoreToBook(this.book);
            }
            return p;
        }
    }
}

