/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.framework.command.ICommand;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodException;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNDataInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.view.BgViewFacadeFactory;
import com.kingdee.eas.ma.view.client.common.BudgetProvider;
import com.kingdee.eas.ma.view.client.designer.IProvider;
import com.kingdee.eas.ma.view.common.BgDimensionMember;
import com.kingdee.eas.ma.view.common.BgNViewDataInfo;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.util.BgViewCommonHelper;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import com.kingdee.eas.ma.view.util.BookParseHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BudgetViewProvider
extends BudgetProvider
implements ICommand {
    private static final long serialVersionUID = 821029495413357721L;
    private Map adjustMap = new HashMap();
    public static final int DATA_INIT = 0;
    public static final int DATA_ORG = 1;
    protected int initDataType = 0;
    private boolean isCurrOrg = false;
    protected Map cacheMap = new HashMap();
    protected Map bgDataMap = new HashMap();
    protected final Map deleteMap = new HashMap();
    protected Set<BgDimensionMember> addMembers = new HashSet<BgDimensionMember>();
    protected Set<BgDimensionMember> removeMembers = new HashSet<BgDimensionMember>();

    public Set<BgDimensionMember> getAddMembers() {
        return this.addMembers;
    }

    public Set<BgDimensionMember> getRemoveMembers() {
        return this.removeMembers;
    }

    public Map getCacheMap() {
        return this.cacheMap;
    }

    public void setAdjustMap(Map adjustMap) {
        this.adjustMap = adjustMap;
    }

    @Override
    public Map getBgDataMap() {
        return this.bgDataMap;
    }

    @Override
    public Map getDeleteMap() {
        return this.deleteMap;
    }

    @Override
    public BookParseHelper getHelper() {
        if (this.helper == null) {
            this.helper = new BookParseHelper(this.getBgDimensionManager());
        }
        return this.helper;
    }

    @Override
    public Object load() throws Exception {
        byte[] bytes = ((BgFormInfo)this.getEditValue()).getEntries().get(0).getDimensionData();
        byte[] bytesStyle = ((BgFormInfo)this.getEditValue()).getEntries().get(0).getDimensionStyle();
        this.initDataType = 0;
        this.setOrgUnitId(((BgFormInfo)this.getEditValue()).getOrgUnit().getId().toString());
        this.getHelper().setAfterLoad(this);
        Book book = this.getHelper().getViewDimensionBook(bytes, bytesStyle);
        this.getHelper().setAfterLoad(null);
        return book;
    }

    @Override
    public void save(CoreBaseInfo model) throws Exception {
        BgViewFacadeFactory.getRemoteInstance().saveBudget((BgFormInfo)this.getEditValue(), this.bgDataMap, this.deleteMap);
    }

    @Override
    public Book pageChangeLoadBook() throws Exception {
        BgFormInfo _bgForm = (BgFormInfo)this.getEditValue();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("entries.id");
        evi.getSelector().add("entries.dimensionData");
        evi.setFilter(new FilterInfo());
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(15));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("state", state, CompareType.NOTINCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from t_bg_bgform where fstate in ( 4 , 35 , 6 , 101 ) and fid <> fadjustid", CompareType.NOTINNER));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.rootId", (Object)_bgForm.getBgScheme().getRootId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgTemplate.rootId", (Object)_bgForm.getBgTemplate().getRootId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)_bgForm.getBgPeriod().getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("currency.id", (Object)_bgForm.getCurrency().getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getOrgUnitId()));
        BgFormCollection col = BgFormFactory.getRemoteInstance().getBgFormCollection(evi);
        if (col != null && !col.isEmpty()) {
            byte[] bytes = col.get(0).getEntries().get(0).getDimensionData();
            byte[] bytesStyle = _bgForm.getEntries().get(0).getDimensionStyle();
            this.initDataType = 1;
            this.getHelper().setAfterLoad(this);
            Book book = this.getHelper().getViewDimensionBookNoChangeStyle(bytes);
            this.getHelper().setAfterLoad(null);
            return book;
        }
        return null;
    }

    @Override
    public void fillData(Book book) throws Exception {
        BgFormInfo info = (BgFormInfo)this.getEditValue();
        int _state = info.getState().getValue();
        if (info.getAdjust() != null) {
            HashMap queryMap = new HashMap();
            this.getHelper().parseBgItem(book, BgViewHelper.getCurrPageMember(this.getF7List(), this.getBgDimensionManager().getPageDisplayDimension()), queryMap);
            this.bgDataMap = BgViewFacadeFactory.getRemoteInstance().queryBgData(queryMap, ((BgFormInfo)this.getEditValue()).getBgScheme().getRootId().toString());
            this.adjustMap = BgViewFacadeFactory.getRemoteInstance().queryAdjustBgData(queryMap, ((BgFormInfo)this.getEditValue()).getBgScheme().getRootId().toString());
            this.deleteMap.clear();
            this.fillData(book, this, this.bgDataMap, this.adjustMap, null);
        } else {
            super.fillData(book);
            HashMap queryMap = new HashMap();
            this.getHelper().parseBgItem(book, BgViewHelper.getCurrPageMember(this.getF7List(), this.getBgDimensionManager().getPageDisplayDimension()), queryMap);
            this.bgDataMap = BgViewFacadeFactory.getRemoteInstance().queryBgData(queryMap, ((BgFormInfo)this.getEditValue()).getBgScheme().getRootId().toString());
            this.deleteMap.clear();
            this.getHelper().fillData(book, this, this.bgDataMap);
        }
    }

    @Override
    public void fillData(Book book, Map dataMap) throws Exception {
        super.fillData(book);
        HashMap queryMap = new HashMap();
        this.getHelper().parseBgItem(book, BgViewHelper.getCurrPageMember(this.getF7List(), this.getBgDimensionManager().getPageDisplayDimension()), queryMap);
        this.bgDataMap = BgViewFacadeFactory.getRemoteInstance().queryBgData(queryMap, ((BgFormInfo)this.getEditValue()).getBgScheme().getRootId().toString());
        this.deleteMap.clear();
        this.getHelper().fillData(book, this, this.bgDataMap, dataMap);
    }

    public void fillData(Book book, IProvider provider, Map bgDataMap, Map adjustMap, Map newAdjustMap) {
        if (book == null) {
            return;
        }
        if (bgDataMap == null) {
            bgDataMap = new HashMap();
        }
        if (adjustMap == null) {
            adjustMap = new HashMap();
        }
        if (newAdjustMap == null) {
            newAdjustMap = new HashMap();
        }
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        book.getUndoManager().discardAllEdits();
        BgNViewDataInfo data = null;
        BgAdjustFormDiversityData adjustData = null;
        Map subMap = null;
        Range locked = null;
        Range unLocked = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            Sheet sheet = book.getSheet(s);
            int maxRow = sheet.getMaxRowIndex();
            int maxCol = sheet.getMaxColIndex();
            for (int r = 0; r <= maxRow; ++r) {
                for (int c = 0; c <= maxCol; ++c) {
                    Cell cell = sheet.getCell(r, c, false);
                    ItemFormula formula = BgNFSHelper.getItemFormula((Cell)cell);
                    if (formula == null) continue;
                    BgNFSHelper.setBackGroup((Cell)cell, (Color)BgNConstants.BASE_COLOR);
                    String orgId = formula.getExt("ORGUNITID");
                    if (bgDataMap.containsKey(orgId)) {
                        subMap = (Map)bgDataMap.get(orgId);
                        data = (BgNViewDataInfo)((Object)subMap.get(formula.getFormula()));
                    }
                    if (data != null) {
                        cell.setValue(new Variant((Object)data.getBudgetValue()));
                    } else {
                        cell.setValue(Variant.emptyVariant);
                    }
                    if (adjustMap.containsKey(orgId) && (subMap = (Map)adjustMap.get(orgId)).get(formula.getFormula()) != null) {
                        adjustData = (BgAdjustFormDiversityData)subMap.get(formula.getFormula());
                    }
                    if (newAdjustMap.containsKey(orgId) && (subMap = (Map)newAdjustMap.get(orgId)).get(formula.getFormula()) != null) {
                        adjustData = (BgAdjustFormDiversityData)subMap.get(formula.getFormula());
                    }
                    if (adjustData != null) {
                        cell.setValue(new Variant((Object)adjustData.getNewValue()));
                        BgNFSHelper.setBackGroup((Cell)cell, (Color)BgNConstants.EDIT_COLOR);
                    }
                    adjustData = null;
                    boolean isLocked = provider.isLocked(data);
                    Range range = sheet.getRange(cell);
                    if (isLocked == cell.isLocked()) continue;
                    if (isLocked) {
                        if (locked == null) {
                            locked = range;
                            continue;
                        }
                        locked.addAll((SortedCellBlockArray)range);
                        continue;
                    }
                    if (unLocked == null) {
                        unLocked = range;
                        continue;
                    }
                    unLocked.addAll((SortedCellBlockArray)range);
                }
            }
        }
        StyleAttributes sa = Styles.getEmptySA();
        if (locked != null) {
            sa.setLocked(true);
            locked.setStyle(sa, Styles.getEmptySA());
        }
        if (unLocked != null) {
            sa.setLocked(false);
            unLocked.setStyle(sa, Styles.getEmptySA());
        }
        BgNFSHelper.enableUndo((Book)book);
    }

    @Override
    public void store(Object obj) throws Exception {
        if (obj instanceof Book) {
            Book book = (Book)obj;
            for (int s = 0; s < book.getSheetCount(); ++s) {
                Sheet sheet = book.getSheet(s);
                int maxRow = sheet.getMaxRowIndex();
                int maxCol = sheet.getMaxColIndex();
                for (int r = 0; r <= maxRow; ++r) {
                    for (int c = 0; c <= maxCol; ++c) {
                        BgNViewDataInfo data;
                        Cell cell = sheet.getCell(r, c, false);
                        ItemFormula formula = BgNFSHelper.getItemFormula((Cell)cell);
                        if (formula == null) continue;
                        String orgId = formula.getExt("ORGUNITID");
                        BigDecimal value = BgViewHelper.getNumeric(cell, null);
                        if (value != null) {
                            data = this.getData(this.bgDataMap, orgId, formula.getFormula(), true);
                            data.setBudgetValue(value);
                            continue;
                        }
                        data = this.getData(this.bgDataMap, orgId, formula.getFormula(), false);
                        if (data == null) continue;
                        data.setBudgetValue(value);
                    }
                }
            }
        }
    }

    @Override
    public BgNViewDataInfo getData(Map bgDataMap, String orgId, String formula, boolean isCreate) {
        if (bgDataMap == null) {
            return null;
        }
        HashMap<String, BgNViewDataInfo> subMap = null;
        if (bgDataMap.containsKey(orgId)) {
            subMap = (HashMap<String, BgNViewDataInfo>)bgDataMap.get(orgId);
        } else if (isCreate) {
            subMap = new HashMap<String, BgNViewDataInfo>();
            bgDataMap.put(orgId, subMap);
        }
        if (subMap == null) {
            return null;
        }
        BgNViewDataInfo data = null;
        if (subMap.containsKey(formula)) {
            data = (BgNViewDataInfo)((Object)subMap.get(formula));
        } else if (isCreate) {
            data = new BgNViewDataInfo(null);
            data.setFormula(formula);
            data.setOrgUnitId(orgId);
            subMap.put(formula, data);
        }
        return data;
    }

    @Override
    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = BgNFSHelper.getSelectors();
        sic.add("entries.id");
        sic.add("entries.bgformid");
        sic.add("entries.dimensionData");
        sic.add("entries.dimensionStyle");
        sic.add("entries.rollMethod");
        sic.add("entries.rollType");
        sic.add("entries.rollStep");
        sic.add("entries.rollLength");
        sic.add("entries.overFlow");
        sic.add("entries.scheme.id");
        return sic;
    }

    @Override
    public boolean isModifyBgData() {
        if (!this.deleteMap.isEmpty()) {
            return true;
        }
        if (this.bgDataMap != null) {
            for (Map subMap : this.bgDataMap.values()) {
                if (subMap == null || subMap.isEmpty()) continue;
                for (BgNViewDataInfo data : subMap.values()) {
                    if (!this.isModify(data)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected boolean isModify(BgNViewDataInfo data) {
        if (data != null) {
            if (data.getBudgetValueNoDef() == null) {
                return data.getOldValue() != null;
            }
            if (data.getOldValue() == null) {
                return data.getBudgetValueNoDef() != null;
            }
            return data.getOldValue().compareTo(data.getBudgetValueNoDef()) != 0;
        }
        return false;
    }

    @Override
    public ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected Map getInitBgViewDimensionInfo() throws BOSException, EASBizException {
        return BgViewFacadeFactory.getRemoteInstance().getInitBgViewDimensionInfo(this.getBgDimensionManager(), this.getEditValue().get("id").toString());
    }

    public Object execute(Context ctx) throws BOSException {
        try {
            switch (this.initDataType) {
                case 0: {
                    this.cacheMap = this.getInitBgViewDimensionInfo();
                    break;
                }
                case 1: {
                    Map tempMap;
                    if (this.cacheMap == null || (tempMap = BgViewFacadeFactory.getRemoteInstance().getDataChangeViewDimensionInfo(this.getBgDimensionManager(), this.getEditValue().get("id").toString(), this.getOrgUnitId())) == null) break;
                    this.cacheMap.putAll(tempMap);
                }
            }
            if (this.initDataType == 0) {
                Map currMap;
                IBgDimensionManager bm = this.getBgDimensionManager();
                BgFormInfo bgForm = (BgFormInfo)this.getEditValue();
                bm.setDefaultMeasureUnit(bgForm.getMeasureUnit());
                bm.getMeasureMap().clear();
                if (!bgForm.getBgMeasureUnit().isEmpty()) {
                    for (int i = 0; i < bgForm.getBgMeasureUnit().size(); ++i) {
                        bm.getMeasureMap().put(bgForm.getBgMeasureUnit().get(i).getBgElement().getNumber(), bgForm.getBgMeasureUnit().get(i).getMeasureUnit());
                    }
                }
                if ((currMap = (Map)this.cacheMap.get("CURRENCY")) != null) {
                    bm.getCurrencyMap().putAll(currMap);
                }
            }
            BgFormInfo bgForm = (BgFormInfo)this.getEditValue();
            BgViewCommonHelper.fillDimensionMember(this.getBgDimensionManager(), this.cacheMap, BgSHelper.isBgItemIsolate(), this.getOrgUnitId(), bgForm.getBgPeriod(), bgForm.getCurrency(), this.isCurrOrg());
            this.afterFillDimensionMember();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        return null;
    }

    protected void afterFillDimensionMember() throws BOSException, BgPeriodException {
    }

    protected boolean isCurrOrg() {
        return this.isCurrOrg;
    }

    public void setCurrOrg(boolean isCurrOrg) {
        this.isCurrOrg = isCurrOrg;
    }

    @Override
    public boolean isLocked(BgNDataInfo bgData) {
        return bgData != null && bgData.getState() != 1;
    }

    public Map getAdjustMap() {
        return null;
    }
}

