/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.common;

import com.kingdee.bos.ctrl.excel.impl.FacadeManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.PromptPanel;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.client.designer.FormulaPicker;
import com.kingdee.eas.fi.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.ItemFormulaChangeEvent;
import com.kingdee.eas.fi.newrpt.client.designer.ItemFormulaPanel;
import com.kingdee.eas.fi.newrpt.client.designer.event.FormulaPickListener;
import com.kingdee.eas.fi.newrpt.client.designer.event.ItemFormulaChangeListener;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.NewRptContextManager;
import com.kingdee.eas.fi.rpt.RptContextManager;
import com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter;
import com.kingdee.eas.ma.view.client.common.AbstractFormulaManager;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;

public class FormulaManager
extends AbstractFormulaManager {
    private BgRptReportPropertyAdapter propertyAdapter;

    public FormulaManager(SpreadContext spreadContext) {
        super(spreadContext);
    }

    @Override
    public void doInit() {
        this.registerDefaultFormulaWizard();
        this.registerDefaultItemFormulaWizard();
    }

    @Override
    public void registerDefaultFormulaWizard() {
        FormulaPicker wizzard = null;
        try {
            wizzard = new FormulaPicker((Component)this.getSpreadContext());
        }
        catch (Exception exception) {
            // empty catch block
        }
        wizzard.setRptContextManager((RptContextManager)this.getRptContext());
        this.getSpreadContext().getFacadeManager().putWizzard(FacadeManager.WIZZARD_Formula, (ISpreadWizzard)wizzard);
        wizzard.setFormulaPickListener(new FormulaPickListener(){

            public String pickFormulaLine() {
                Range range = FormulaManager.this.getSpreadContext().getBook().getActiveCellRange();
                return range.getFormula();
            }

            public void setFormulaLine(String line) {
                FormulaManager.this.getSpreadContext().getRangeManager().getActiveCellRange().setFormula('=' + line);
            }
        });
    }

    protected NewRptContextManager getRptContext() {
        NewRptContextManager ctx = new NewRptContextManager();
        ctx.setPropertyAdapter(this.getReportAdapter());
        return ctx;
    }

    public IReportPropertyAdapter getReportAdapter() {
        if (this.propertyAdapter == null) {
            this.propertyAdapter = new BgRptReportPropertyAdapter();
        }
        return this.propertyAdapter;
    }

    @Override
    public void registerDefaultItemFormulaWizard() {
        this.setItemFormulaPanel(new ItemFormulaPanel(this.getSpreadContext()));
        this.setItemFormulaLayout((JComponent)this.getItemFormulaPanel());
        this.getItemFormulaPanel().setStateChangeListener(new ItemFormulaPanel.ItemPanelStateChangeListener(){

            public void changeWidth(int newWidth) {
                FormulaManager.this.setItemFormulaPanelWidth(newWidth);
            }
        });
        this.getItemFormulaPanel().addItemFormulaChangeListener(new ItemFormulaChangeListener(){

            public void formulaChanged(ItemFormulaChangeEvent e) {
                Range range = FormulaManager.this.getSpreadContext().getRangeManager().getActiveCellRange();
                if (StringUtils.isEmpty((String)e.getNewFormula())) {
                    range.setUserObject("ITEM", null);
                } else {
                    ItemFormula formula = new ItemFormula();
                    formula.FormulaToObject(e.getNewFormula());
                    range.setUserObject("ITEM", (Object)formula);
                }
            }
        });
        this.getSpreadContext().addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                if (e.isSheetActive()) {
                    FormulaManager.this.getItemFormulaPanel().refreshItemFormula(e.getSheet().getActiveCellRange(), e.getSheet().getSheetOption().getCellDisplayMode());
                }
            }
        });
        this.getSpreadContext().addSheetChangeListener(new SheetChangeListener(){

            public void changed(SheetChangeEvent e) {
                if (FormulaManager.this.getSpreadContext().getBook().getActiveSheet() != e.getSheet()) {
                    return;
                }
                FormulaManager.this.getItemFormulaPanel().refreshItemFormula(e.getSheet().getActiveCellRange(), e.getSheet().getSheetOption().getCellDisplayMode());
            }
        });
    }

    private void setItemFormulaLayout(JComponent component) {
        PromptPanel pp = this.getSpreadContext().getFacadeManager().getPromptPanel();
        pp.setRightComponent(component);
        pp.setAdjustable(this.isAdjustPanel());
        pp.setDependSecondSize(true);
    }

    protected boolean isAdjustPanel() {
        return true;
    }

    protected void setItemFormulaPanelWidth(int width) {
        PromptPanel pp = this.getSpreadContext().getFacadeManager().getPromptPanel();
        pp.getRightComponent().setPreferredSize(new Dimension(width, 10));
        pp.getRightComponent().invalidate();
        pp.validate();
        pp.repaint();
    }

    @Override
    public void setItemFormulaEnable(boolean enabled) {
        this.getItemFormulaPanel().setEnabled(enabled);
    }

    @Override
    public void setItemFormulaProvider(IItemFormulaProvider formulaProvider) {
        this.getItemFormulaPanel().setFormulaProvider(formulaProvider);
    }
}

