/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.itemmap;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.ma.view.client.itemmap.BgCuFilter;
import com.kingdee.eas.ma.view.client.itemmap.BgEditorGeneratorFactory;
import com.kingdee.eas.ma.view.client.itemmap.IBgEditorGenerator;
import com.kingdee.eas.ma.view.client.itemmap.IBgEditorOrgViewFilter;
import com.kingdee.eas.ma.view.common.BgFilterProducer;
import com.kingdee.eas.ma.view.common.BgRuleField;
import com.kingdee.eas.ma.view.util.BgViewCommonHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class BgEditorGenerator
implements IBgEditorGenerator {
    private static final Logger logger = Logger.getLogger(BgEditorGenerator.class);
    public static final String QUERY = "query";
    public static final String ENTITY = "entity";
    private static boolean isLoaded = false;
    private static Map queries = null;
    private static Map entities = null;
    private static Map orgFilters = null;

    protected BgEditorGenerator() {
    }

    @Override
    public ICellEditor getEditor(Map params) {
        BgEditorGenerator.load();
        String query = this.getQuery(params);
        query = this.replaceQuery(query);
        return this.getEditor(params, query);
    }

    private ICellEditor getEditor(Map params, String query) {
        if (params == null || params.get("FIELD_NAME") == null || StringUtils.isEmpty((String)query)) {
            return null;
        }
        QueryInfo qObject = null;
        try {
            qObject = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)MetaDataPK.create((String)query));
        }
        catch (Exception e) {
            logger.error((Object)("query load error:" + query), (Throwable)e);
        }
        if (qObject == null) {
            logger.error((Object)("query not exist:" + query));
            return null;
        }
        String fieldName = (String)params.get("FIELD_NAME");
        BgRuleField field = BgRuleField.parseField(fieldName);
        if (field == null) {
            return null;
        }
        Set filterSet = field.getFilterSet();
        boolean isEnableMultiSelect = false;
        if (params.get("ENABLE_MULTI_SELECT") instanceof Boolean) {
            isEnableMultiSelect = (Boolean)params.get("ENABLE_MULTI_SELECT");
        }
        KDBizPromptBox prmtBox = new KDBizPromptBox();
        prmtBox.setQueryInfo(query);
        prmtBox.setCommitFormat("$number$");
        prmtBox.setEditFormat("$number$");
        prmtBox.setDisplayFormat("$name$");
        prmtBox.setEnabledMultiSelection(isEnableMultiSelect);
        boolean editable = false;
        if (params.get("CAN_EDITABLE") instanceof Boolean) {
            editable = (Boolean)params.get("CAN_EDITABLE");
        }
        if (params.get("DISABLE_AUTO_POPO") instanceof Boolean && ((Boolean)params.get("DISABLE_AUTO_POPO")).booleanValue()) {
            prmtBox.setCommitParser(null);
        }
        prmtBox.setEditable(editable);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (filterSet != null && !filterSet.isEmpty()) {
            BgViewCommonHelper.addFilterItem(filter, new FilterItemInfo("number", (Object)filterSet, CompareType.INCLUDE));
        }
        this.setOrgFilter(query, filter, params);
        prmtBox.setFilterInfoProducer((IFilterInfoProducer)new BgFilterProducer(filter));
        prmtBox.setEntityViewInfo(view);
        return new KDTDefaultCellEditor((IKDEditor)prmtBox);
    }

    private void setOrgFilter(String queryName, FilterInfo filter, Map params) {
        if (filter == null) {
            return;
        }
        this.getOrgFilter(queryName).addOrgViewFilter(filter, params);
    }

    private String replaceQuery(String query) {
        if (queries.containsKey(query)) {
            return (String)queries.get(query);
        }
        if (entities.containsKey(query)) {
            return (String)entities.get(query);
        }
        return query;
    }

    protected String getQuery(Map params) {
        EntityObjectInfo field;
        EntityObjectInfo entityObjectInfo = field = params == null ? null : (EntityObjectInfo)params.get("FIELD_META");
        if (field != null) {
            return field.getExtendedProperty("defaultF7Query");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load() {
        if (isLoaded) {
            return;
        }
        queries = new HashMap();
        entities = new HashMap();
        orgFilters = new HashMap();
        logger.info((Object)"----- begin load Bill F7 Set File:com/kingdee/eas/ma/view/client/itemmap/billItemF7.xml -----");
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.push((Object)new BgEditorGenerator());
        digester.addCallMethod("billItemF7/defaultEditGaerator/querys/query", "addConfig", 3);
        digester.addCallParam("billItemF7/defaultEditGaerator/querys/query/type", 0);
        digester.addCallParam("billItemF7/defaultEditGaerator/querys/query/source", 1);
        digester.addCallParam("billItemF7/defaultEditGaerator/querys/query/target", 2);
        InputStream is = null;
        try {
            is = BgEditorGeneratorFactory.class.getClassLoader().getResourceAsStream("com/kingdee/eas/ma/view/client/itemmap/billItemF7.xml");
            digester.parse(is);
        }
        catch (IOException e) {
            logger.error((Object)"load Bill F7 Error:", (Throwable)e);
            return;
        }
        catch (SAXException e) {
            logger.error((Object)"load Bill F7 Error:", (Throwable)e);
            return;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)"load Bill F7 Error:", (Throwable)e);
                }
            }
        }
        digester = new Digester();
        digester.setValidating(false);
        digester.push((Object)new BgEditorGenerator());
        digester.addCallMethod("billItemF7/defaultEditGaerator/orgfilter/query", "addOrgFilter", 2);
        digester.addCallParam("billItemF7/defaultEditGaerator/orgfilter/query/queryname", 0);
        digester.addCallParam("billItemF7/defaultEditGaerator/orgfilter/query/filterclassname", 1);
        try {
            is = BgEditorGeneratorFactory.class.getClassLoader().getResourceAsStream("com/kingdee/eas/ma/view/client/itemmap/billItemF7.xml");
            digester.parse(is);
        }
        catch (IOException e) {
            logger.error((Object)"load Bill F7 Error:", (Throwable)e);
            return;
        }
        catch (SAXException e) {
            logger.error((Object)"load Bill F7 Error:", (Throwable)e);
            return;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)"load Bill F7 Error:", (Throwable)e);
                }
            }
        }
        logger.info((Object)"----- end load file ------");
        isLoaded = true;
    }

    public void addConfig(String type, String source, String target) {
        if (StringUtils.isEmpty((String)target) || StringUtils.isEmpty((String)source) || StringUtils.isEmpty((String)type) || queries == null) {
            return;
        }
        if (QUERY.equalsIgnoreCase(type)) {
            queries.put(source, target);
        } else if (ENTITY.equalsIgnoreCase(type)) {
            entities.put(source, target);
        }
    }

    public void addOrgFilter(String queryName, String filterClassName) {
        if (orgFilters == null || StringUtils.isEmpty((String)queryName) || StringUtils.isEmpty((String)filterClassName)) {
            return;
        }
        orgFilters.put(queryName, filterClassName);
    }

    protected IBgEditorOrgViewFilter getOrgFilter(String queryName) {
        IBgEditorOrgViewFilter filter = new BgCuFilter();
        String filterName = null;
        if (orgFilters != null) {
            if (orgFilters.get(queryName) instanceof String) {
                filterName = (String)orgFilters.get(queryName);
            } else if (orgFilters.get("default") instanceof String) {
                filterName = (String)orgFilters.get("default");
            }
        }
        if (!StringUtils.isEmpty(filterName)) {
            try {
                filter = (IBgEditorOrgViewFilter)Class.forName(filterName).newInstance();
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return filter;
    }
}

