/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.itemmap;

import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.eas.ma.view.client.itemmap.BgEditorGenerator;
import com.kingdee.eas.ma.view.client.itemmap.BgItemDialogGenerator;
import com.kingdee.eas.ma.view.client.itemmap.IBgEditorGenerator;
import com.kingdee.eas.ma.view.common.BgRuleField;
import com.kingdee.eas.ma.view.util.BgViewCommonHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class BgEditorGeneratorFactory {
    private static final Logger logger = Logger.getLogger(BgEditorGeneratorFactory.class);
    private static boolean isLoaded = false;
    private static Map cellEditorGenerators = null;
    private static final String EDITOR_GENERATOR = "EDITOR_GENERATOR";
    public static final String CONFILE_FILE = "com/kingdee/eas/ma/view/client/itemmap/billItemF7.xml";

    private BgEditorGeneratorFactory() {
    }

    public static ICellEditor getEditor(String billName, String fieldName, Map params) {
        if (StringUtils.isEmpty((String)billName) || StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        fieldName = fieldName.trim();
        BgEditorGeneratorFactory.load();
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("BILL_NAME", billName);
        params.put("FIELD_NAME", fieldName);
        EntityObjectInfo bill = null;
        bill = params.get("BILL_META") instanceof EntityObjectInfo ? (EntityObjectInfo)params.get("BILL_META") : BgEditorGeneratorFactory.loadMetaData(billName);
        EntityObjectInfo field = BgRuleField.getPropertyEntity(bill, fieldName);
        params.put("FIELD_META", (String)field);
        String entityName = field == null ? null : field.getFullName();
        return BgEditorGeneratorFactory.getGenerator(entityName, billName, fieldName).getEditor(params);
    }

    public static EntityObjectInfo loadMetaData(String billName) {
        return MetaDataLoader.getEntity(null, (IMetaDataPK)MetaDataPK.create((String)billName));
    }

    private static IBgEditorGenerator getGenerator(String entityName, String billName, String fieldName) {
        if (StringUtils.isEmpty((String)billName) || StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        IBgEditorGenerator generator = new BgEditorGenerator();
        if (BgItemDialogGenerator.isShowBgItemDialog(entityName, billName, fieldName)) {
            return new BgItemDialogGenerator();
        }
        Map map = null;
        map = BgViewCommonHelper.getSubMap(cellEditorGenerators, entityName, false, "default");
        map = BgViewCommonHelper.getSubMap(map, billName, false, "default");
        if ((map = BgViewCommonHelper.getSubMap(map, fieldName, false, "default")) != null && map.get(EDITOR_GENERATOR) instanceof String) {
            try {
                generator = (IBgEditorGenerator)Class.forName((String)map.get(EDITOR_GENERATOR)).newInstance();
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return generator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load() {
        if (isLoaded) {
            return;
        }
        cellEditorGenerators = new HashMap();
        logger.info((Object)"----- begin load Bill F7 Set File:com/kingdee/eas/ma/view/client/itemmap/billItemF7.xml -----");
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.push((Object)new BgEditorGeneratorFactory());
        digester.addCallMethod("billItemF7/cellEditorGenerator", "addCellEditorGenerator", 4);
        digester.addCallParam("billItemF7/cellEditorGenerator/entity/entityname", 0);
        digester.addCallParam("billItemF7/cellEditorGenerator/entity/bill/billname", 1);
        digester.addCallParam("billItemF7/cellEditorGenerator/entity/bill/field/fieldname", 2);
        digester.addCallParam("billItemF7/cellEditorGenerator/entity/bill/field/cellEditor", 3);
        InputStream is = null;
        try {
            is = BgEditorGeneratorFactory.class.getClassLoader().getResourceAsStream(CONFILE_FILE);
            digester.parse(is);
        }
        catch (IOException e) {
            logger.error((Object)"load Bill F7 Error:", (Throwable)e);
            return;
        }
        catch (SAXException e) {
            logger.error((Object)"load Bill F7 Error:", (Throwable)e);
            return;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)"load Bill F7 Error:", (Throwable)e);
                }
            }
        }
        logger.info((Object)"----- end load file ------");
        isLoaded = true;
    }

    public void addCellEditorGenerator(String entityName, String billName, String fieldName, String cellEditor) {
        if (StringUtils.isEmpty((String)entityName) || StringUtils.isEmpty((String)billName) || StringUtils.isEmpty((String)fieldName) || StringUtils.isEmpty((String)cellEditor)) {
            return;
        }
        if (cellEditorGenerators == null) {
            cellEditorGenerators = new HashMap();
        }
        Map temp = null;
        temp = BgViewCommonHelper.getSubMap(cellEditorGenerators, entityName, true, null);
        temp = BgViewCommonHelper.getSubMap(temp, billName, true, null);
        if ((temp = BgViewCommonHelper.getSubMap(temp, fieldName, true, null)) != null) {
            temp.put(EDITOR_GENERATOR, cellEditor);
        }
    }
}

