/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.itemmap;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.ma.budget.client.BgItemForFpDialog;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.view.client.itemmap.IBgEditorGenerator;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class BgItemDialogGenerator
implements IBgEditorGenerator {
    public static final String BGITEM_ENTITY_NAME = "com.kingdee.eas.ma.budget.app.BgItem";

    @Override
    public ICellEditor getEditor(Map params) {
        String entityName = (String)params.get("ENTITY_NAME");
        String billName = (String)params.get("BILL_NAME");
        String fieldName = (String)params.get("FIELD_NAME");
        String orgUnitId = (String)params.get("ORG_ID");
        Object ownUi = params.get("OWN_UI");
        boolean isMultiSelect = false;
        if (params.get("ENABLE_MULTI_SELECT") instanceof Boolean) {
            isMultiSelect = (Boolean)params.get("ENABLE_MULTI_SELECT");
        }
        if (BgItemDialogGenerator.isFpBgItem(entityName, billName, fieldName)) {
            return this.getFpEditor(billName, fieldName, ownUi, isMultiSelect);
        }
        if (BgItemDialogGenerator.isNormalBgItem(entityName, billName, fieldName)) {
            return this.getNormalEditor(orgUnitId, ownUi, isMultiSelect);
        }
        return null;
    }

    public static ICellEditor getEditor(String orgUnitId, Object ownUi, boolean isMultiSelect, Map params) {
        if (StringUtils.isEmpty((String)orgUnitId)) {
            orgUnitId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        }
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("ENTITY_NAME", BGITEM_ENTITY_NAME);
        params.put("BILL_NAME", BGITEM_ENTITY_NAME);
        params.put("FIELD_NAME", "number");
        params.put("ORG_ID", orgUnitId);
        params.put("OWN_UI", (String)ownUi);
        params.put("ENABLE_MULTI_SELECT", (String)((Object)new Boolean(isMultiSelect)));
        return new BgItemDialogGenerator().getEditor(params);
    }

    public static boolean isShowBgItemDialog(String entityName, String billName, String fieldName) {
        if (StringUtils.isEmpty((String)billName) || StringUtils.isEmpty((String)fieldName)) {
            return false;
        }
        return BgItemDialogGenerator.isFpBgItem(entityName, billName, fieldName) || BgItemDialogGenerator.isNormalBgItem(entityName, billName, fieldName);
    }

    protected static boolean isFpBgItem(String entityName, String billName, String fieldName) {
        return BgItemDialogGenerator.isOutFpBgItem(billName, fieldName) || BgItemDialogGenerator.isInputFpBgItem(billName, fieldName);
    }

    protected static boolean isNormalBgItem(String entityName, String billName, String fieldName) {
        if (StringUtils.isEmpty((String)billName) || StringUtils.isEmpty((String)fieldName)) {
            return false;
        }
        if (fieldName.toLowerCase(Locale.ENGLISH).endsWith("outBgItemNumber")) {
            return true;
        }
        return BGITEM_ENTITY_NAME.equals(entityName);
    }

    private static boolean isOutFpBgItem(String billName, String fieldName) {
        if ("com.kingdee.eas.fi.cas.app.ReceivingBill".equals(billName) || "com.kingdee.eas.fi.cas.app.PaymentBill".equals(billName)) {
            int lastDot = fieldName.lastIndexOf(46);
            if (fieldName.lastIndexOf("outBgItem") > lastDot) {
                return true;
            }
        }
        return false;
    }

    private static boolean isInputFpBgItem(String billName, String fieldName) {
        if ("com.kingdee.eas.fi.cas.app.ReceivingBill".equals(billName) || "com.kingdee.eas.fi.cas.app.PaymentBill".equals(billName)) {
            int lastDot = fieldName.lastIndexOf(46);
            if (fieldName.lastIndexOf("oppBgItem") > lastDot) {
                return true;
            }
        }
        return false;
    }

    protected ICellEditor getNormalEditor(String orgUnitId, Object ownUi, boolean isMultiSelect) {
        NewBgItemDialog box = null;
        box = ownUi instanceof Frame ? new NewBgItemDialog((Frame)ownUi) : (ownUi instanceof Dialog ? new NewBgItemDialog((Dialog)ownUi) : (ownUi instanceof IUIObject ? new NewBgItemDialog((IUIObject)ownUi) : new NewBgItemDialog()));
        box.setSelectCombinItem(!isMultiSelect);
        box.setMulSelect(isMultiSelect);
        box.setOrgUnitId(orgUnitId);
        KDBizPromptBox prmtBox = new KDBizPromptBox();
        prmtBox.setSelector((KDPromptSelector)box);
        prmtBox.setEditable(false);
        return new KDTDefaultCellEditor((IKDEditor)prmtBox);
    }

    protected ICellEditor getFpEditor(String billName, String fieldName, Object ownUi, boolean isMultiSelect) {
        FpCashDirectionEnum fce = null;
        if (BgItemDialogGenerator.isOutFpBgItem(billName, fieldName)) {
            fce = FpCashDirectionEnum.output;
        } else if (BgItemDialogGenerator.isInputFpBgItem(billName, fieldName)) {
            fce = FpCashDirectionEnum.input;
        } else {
            return null;
        }
        BgItemForFpDialog bgItemSelect = new BgItemForFpDialog();
        bgItemSelect.setSelectCombinItem(!isMultiSelect);
        bgItemSelect.setMulSelect(isMultiSelect);
        bgItemSelect.setShowLeafOnly(true);
        bgItemSelect.setCashDirection(new FpCashDirectionEnum[]{fce, FpCashDirectionEnum.other});
        KDBizPromptBox prmtBox = new KDBizPromptBox();
        prmtBox.setSelector((KDPromptSelector)bgItemSelect);
        prmtBox.setDisplayFormat("$name$");
        prmtBox.setEditFormat("$number$");
        prmtBox.setCommitFormat("$number$;$name$");
        return new KDTDefaultCellEditor((IKDEditor)prmtBox);
    }
}

