/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.rules;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.ma.view.client.BgBillVerifyException;
import com.kingdee.eas.ma.view.client.rules.IBgCellConvertor;

public abstract class AbstractBaseConvertor
implements IBgCellConvertor {
    protected void setValue(IRow row, Object info) {
        if (this.getCell(row) != null) {
            this.getCell(row).setValue(info);
        }
    }

    protected Object getValue(IRow row) {
        if (this.getCell(row) != null) {
            return this.getCell(row).getValue();
        }
        return null;
    }

    protected ICell getCell(IRow row) {
        if (row != null) {
            return row.getCell(this.getColumnKey());
        }
        return null;
    }

    @Override
    public Object verify(IObjectValue rule, String colName) throws BgBillVerifyException {
        if (!this.isValidate(rule)) {
            this.throwVerifyException(colName);
        }
        if (this.isOverLong(rule)) {
            this.throwOverLongException(colName);
        }
        return this.getVerifyData(rule, colName);
    }

    public abstract Object getVerifyData(IObjectValue var1, String var2);

    protected abstract boolean isValidate(IObjectValue var1);

    protected abstract boolean isOverLong(IObjectValue var1);

    protected void throwVerifyException(String colName) throws BgBillVerifyException {
        if (colName == null) {
            colName = this.getColumnKey();
        }
        throw new BgBillVerifyException(BgBillVerifyException.PLEASEINPUT, new String[]{colName});
    }

    protected void throwOverLongException(String colName) throws BgBillVerifyException {
        if (colName == null) {
            colName = this.getColumnKey();
        }
        throw new BgBillVerifyException(BgBillVerifyException.INPUTLONG, new String[]{colName});
    }
}

