/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.rules;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.eas.base.commonquery.CompareSignDateEnum;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.LeftBracketSignEnum;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.commonquery.RightBracketSignEnum;
import com.kingdee.eas.base.commonquery.RowObject;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.view.client.BgEntityFilterPanel;
import com.kingdee.eas.ma.view.client.itemmap.BgEditorGeneratorFactory;
import com.kingdee.eas.ma.view.client.rules.BgCompareBox;
import com.kingdee.eas.ma.view.client.rules.BgRuleDataInfo;
import com.kingdee.eas.ma.view.common.BgCompareSelectItemInfo;
import com.kingdee.eas.ma.view.common.BgDataSelector;
import com.kingdee.eas.ma.view.common.BgRuleField;
import com.kingdee.eas.ma.view.util.BgViewCommonHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BgConditionHelper {
    private static final Logger logger = Logger.getLogger((String)BgConditionHelper.class.getName());
    public static final String commonEntityFilterRes = "com.kingdee.eas.base.commonquery.client.CommonEntityFilter";
    public static final String entityTreePromptDialogRes = "com.kingdee.eas.base.commonquery.client.EntityTreePromptDialog";
    public static final String EXTEND_CONDITION_SIGN = "%";
    public static final String FILTER_LFET_BRACKET_SIGN = "leftBracketSign";
    public static final String FILTER_CONDITION = "condition";
    public static final String FILTER_COMPARE_SIGN = "compareSign";
    public static final String FILTER_COMPARE_VALUE = "compareValue";
    public static final String FILTER_RIGHT_BRACKET_SIGN = "rightBracketSign";
    public static final String FILTER_LOGIC_SIGN = "loginSign";
    public static final String[] FILTER_COLUMN_KEYS = new String[]{"leftBracketSign", "condition", "compareSign", "compareValue", "rightBracketSign", "loginSign"};

    public static ArrayList getRowInfos(EntityObjectInfo entity, FilterInfo filterInfo) {
        int size;
        char[] exp;
        int i;
        int size2;
        ArrayList<RowObject> target = new ArrayList<RowObject>();
        if (filterInfo == null || entity == null || filterInfo.getFilterItems().size() == 0) {
            return target;
        }
        String expression = filterInfo.getMaskString();
        if (StringUtils.isEmpty((String)expression) && (size2 = filterInfo.getFilterItems().size()) > 0) {
            StringBuffer buffer = new StringBuffer();
            for (i = 0; i < size2; ++i) {
                if (i == size2 - 1) {
                    buffer.append("#").append(i);
                    continue;
                }
                buffer.append("#").append(i).append(" AND ");
            }
            expression = buffer.toString();
        }
        if ((exp = (expression = expression + " AND ").toLowerCase().toCharArray()) != null) {
            int length = exp.length;
            StringBuffer leftBracket = new StringBuffer();
            StringBuffer rightBracket = new StringBuffer();
            for (int i2 = 0; i2 < length; ++i2) {
                RowObject rowObject;
                char c = exp[i2];
                if ("(".equalsIgnoreCase(String.valueOf(c))) {
                    leftBracket.append(String.valueOf(c));
                    continue;
                }
                if (")".equalsIgnoreCase(String.valueOf(c))) {
                    rightBracket.append(String.valueOf(c));
                    continue;
                }
                if ("A".equalsIgnoreCase(String.valueOf(c))) {
                    rowObject = new RowObject();
                    rowObject.setLeftBracket(leftBracket.toString());
                    rowObject.setRightBracket(rightBracket.toString());
                    rowObject.setLogic("AND");
                    target.add(rowObject);
                    leftBracket = new StringBuffer();
                    rightBracket = new StringBuffer();
                    continue;
                }
                if (!"O".equalsIgnoreCase(String.valueOf(c))) continue;
                rowObject = new RowObject();
                rowObject.setLeftBracket(leftBracket.toString());
                rowObject.setRightBracket(rightBracket.toString());
                rowObject.setLogic("OR");
                target.add(rowObject);
                leftBracket = new StringBuffer();
                rightBracket = new StringBuffer();
            }
        }
        if ((size = target.size()) > 0) {
            ((RowObject)target.get(size - 1)).setLogic("");
        }
        for (i = 0; i < filterInfo.getFilterItems().size(); ++i) {
            if (i >= target.size()) continue;
            FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
            RowObject ro = (RowObject)target.get(i);
            ro.setCondition(filterItemInfo.getPropertyName());
            if (filterItemInfo.getCompareValue() != null) {
                ro.setCompare(filterItemInfo.getCompareType().getName());
                EntityObjectInfo targetEntity = BgRuleField.getPropertyEntity(entity, filterItemInfo.getPropertyName());
                if (BgConditionHelper.isDate(targetEntity, BgConditionHelper.getPropertyName(filterItemInfo.getPropertyName()))) {
                    if (filterItemInfo.getCompareValue() instanceof Date) {
                        ro.setCompareValue(filterItemInfo.getCompareValue());
                    } else {
                        try {
                            ro.setCompareValue((Object)DateTimeUtils.parseDate((String)filterItemInfo.getCompareValue().toString()));
                        }
                        catch (ParseException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                    }
                } else {
                    ro.setCompareValue(filterItemInfo.getCompareValue());
                }
                if (ro.getCompareValue() == null) continue;
                String cv = ro.getCompareValue().toString();
                if (CompareType.LIKE.getName().equalsIgnoreCase(ro.getCompare())) {
                    if (cv.startsWith(EXTEND_CONDITION_SIGN) && cv.endsWith(EXTEND_CONDITION_SIGN)) {
                        ro.setCompare("LIKE");
                    } else if (cv.startsWith(EXTEND_CONDITION_SIGN)) {
                        ro.setCompare("RIGHT LIKE");
                    } else if (cv.endsWith(EXTEND_CONDITION_SIGN)) {
                        ro.setCompare("LEFT LIKE");
                    }
                    ro.setCompareValue((Object)cv.replaceAll(EXTEND_CONDITION_SIGN, ""));
                    continue;
                }
                if (!CompareType.NOTLIKE.getName().equalsIgnoreCase(ro.getCompare())) continue;
                if (cv.startsWith(EXTEND_CONDITION_SIGN) && cv.endsWith(EXTEND_CONDITION_SIGN)) {
                    ro.setCompare("NOT LIKE");
                } else if (cv.startsWith(EXTEND_CONDITION_SIGN)) {
                    ro.setCompare("NOT LIKE");
                } else if (cv.endsWith(EXTEND_CONDITION_SIGN)) {
                    ro.setCompare("NOT LEFT LIKE");
                }
                ro.setCompareValue((Object)cv.replaceAll(EXTEND_CONDITION_SIGN, ""));
                continue;
            }
            if ((filterItemInfo.getCompareValue() != null || !filterItemInfo.getCompareType().equals((Object)CompareType.NOTEQUALS)) && !filterItemInfo.getCompareType().equals((Object)CompareType.EQUALS)) continue;
            String compare = filterItemInfo.getCompareType().getName();
            if (compare.equalsIgnoreCase("=")) {
                compare = "IS";
            } else if (compare.equalsIgnoreCase("<>")) {
                compare = "IS NOT";
            }
            ro.setCompare(compare);
            ro.setCompareValue(null);
        }
        return target;
    }

    public static RowObject getDefaultRow() {
        RowObject ro = new RowObject();
        ro.setCompare(CompareSignEnum.EQUALSSIGN.getName());
        return ro;
    }

    public static boolean isDate(EntityObjectInfo entity, String propertiyName) {
        DataObject dateType = BgConditionHelper.getRefMetaData(entity, propertiyName);
        return dateType != null && (DataType.DATE.getName().equals(dateType.getName()) || DataType.TIMESTAMP.getName().equals(dateType.getName()) || DataType.TIME.getName().equals(dateType.getName()));
    }

    public static DataObject getRefMetaData(EntityObjectInfo entity, String propertiyName) {
        DataObject dataObject = null;
        PropertyInfo propertyInfo = BgRuleField.getProperty(entity, propertiyName, false);
        if (propertyInfo != null) {
            if (propertyInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)propertyInfo;
                if (ownPropertyInfo.getDataType().equals((Object)DataType.ENUM)) {
                    dataObject = new DataObject();
                    dataObject.setName(ownPropertyInfo.getDataType().getName());
                    String enumName = ownPropertyInfo.getMetaDataRef();
                    BizEnumInfo _enum = BgConditionHelper.getEnum(enumName);
                    dataObject.setValue(_enum.getClassName());
                    return dataObject;
                }
                if (ownPropertyInfo.getDataType().equals((Object)DataType.BOOLEAN)) {
                    dataObject = new DataObject();
                    dataObject.setName(ownPropertyInfo.getDataType().getName());
                    dataObject.setValue(BooleanEnum.class.getName());
                    return dataObject;
                }
                if (ownPropertyInfo.getDataType().equals((Object)DataType.DATE) || ownPropertyInfo.getDataType().equals((Object)DataType.TIMESTAMP) || ownPropertyInfo.getDataType().equals((Object)DataType.TIME)) {
                    dataObject = new DataObject();
                    dataObject.setName(ownPropertyInfo.getDataType().getName());
                    dataObject.setValue(null);
                    return dataObject;
                }
                dataObject = new DataObject();
                dataObject.setName(ownPropertyInfo.getDataType().getName());
                dataObject.setValue(entity.getFullName());
                return dataObject;
            }
            if (propertyInfo instanceof LinkPropertyInfo) {
                // empty if block
            }
        }
        return dataObject;
    }

    public static BizEnumInfo getEnum(String enumName) {
        MetaDataPK enumPK = MetaDataPK.create((String)enumName);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getEnum((IMetaDataPK)enumPK);
    }

    public static String getPropertyName(String str) {
        int index = str.lastIndexOf(".");
        if (index != 0) {
            str = str.substring(index + 1);
        }
        return str;
    }

    public static void setComboBoxField(IColumn column, Object[] objs, boolean isAddNull) {
        if (column == null) {
            return;
        }
        column.setEditor(BgConditionHelper.getComboCellEditor(objs, isAddNull));
    }

    public static void setComboBoxField(ICell cell, Object[] objs, boolean isAddNull) {
        if (cell == null) {
            return;
        }
        cell.setEditor(BgConditionHelper.getComboCellEditor(objs, isAddNull));
    }

    public static ICellEditor getComboCellEditor(Object[] objs, boolean isAddNull) {
        if (objs == null) {
            return null;
        }
        if (isAddNull) {
            Object[] temp = objs;
            objs = new Object[objs.length + 1];
            objs[0] = null;
            System.arraycopy(temp, 0, objs, 1, temp.length);
        }
        KDComboBox kdComboBox = new KDComboBox(objs);
        kdComboBox.setMaximumRowCount(10);
        return new KDTDefaultCellEditor((JComboBox)kdComboBox);
    }

    public boolean isNeedSetEditor(ICell cell) {
        return cell != null && cell.getEditor() == null;
    }

    private CoreUI getParentUI(KDTable table) {
        CoreUI parent = null;
        if (table != null && table.getParent() instanceof BgEntityFilterPanel) {
            parent = ((BgEntityFilterPanel)((Object)table.getParent())).getParentUI();
        }
        return parent;
    }

    public static Object getValue(Object object) {
        Object value = "";
        if (object != null) {
            if (object instanceof Date) {
                value = object;
            } else {
                try {
                    Method method = object.getClass().getMethod("getValue", null);
                    value = method.invoke(object, null);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    value = object.toString();
                }
            }
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            value = ((String)value).trim();
        }
        return value;
    }

    public static Object getAlias(Object obj) {
        Object alias = "";
        if (obj != null) {
            if (obj instanceof Date) {
                alias = obj;
            } else if (obj instanceof DataObject) {
                alias = ((DataObject)obj).getName();
            } else {
                try {
                    Method method = obj.getClass().getMethod("getAlias", null);
                    alias = method.invoke(obj, null);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    alias = obj.toString();
                }
            }
        }
        if (alias == null) {
            return "";
        }
        if (alias instanceof String) {
            alias = ((String)alias).trim() + " ";
        }
        return alias;
    }

    protected static boolean isIncludeCompare(CompareSignEnum compareSignEnum) {
        if (compareSignEnum != null) {
            if (compareSignEnum.equals((Object)CompareSignEnum.INCLUDESIGN)) {
                return true;
            }
            if (compareSignEnum.equals((Object)CompareSignEnum.NOTINCLUDESIGN)) {
                return true;
            }
        }
        return false;
    }

    public static void setColumnF7(KDTable table, IColumn column) {
        if (table == null || column == null) {
            return;
        }
        String colKey = column.getKey();
        if (!StringUtils.isEmpty((String)colKey)) {
            String methodName = "set" + colKey.substring(0, 1).toUpperCase() + colKey.substring(1) + "Column";
            try {
                Method method = BgConditionHelper.class.getMethod(methodName, KDTable.class, IColumn.class);
                method.invoke((Object)new BgConditionHelper(), table, column);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void setLeftBracketSignColumn(KDTable table, IColumn column) {
        BgConditionHelper.setComboBoxField(column, LeftBracketSignEnum.getEnumList().toArray(), true);
    }

    public void setConditionColumn(KDTable table, IColumn column) {
        if (column == null) {
            return;
        }
        column.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)BgDataSelector.getPromptBox(this.getParentUI(table), "com.kingdee.eas.ma.view.client.BgRuleSelectUI")));
    }

    public void setCompareSignColumn(KDTable table, IColumn column) {
        if (table != null && column != null) {
            ArrayList items = new ArrayList();
            items.addAll(CompareSignEnum.getEnumList());
            items.removeAll(Arrays.asList(BgConditionHelper.getRemoveItems()));
            BgCompareBox kdComboBox = new BgCompareBox();
            kdComboBox.addItems(items.toArray());
            kdComboBox.setMaximumRowCount(10);
            column.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)((Object)kdComboBox)));
        }
    }

    private static CompareSignEnum[] getRemoveItems() {
        return new CompareSignEnum[]{CompareSignEnum.FIELDEQUAL, CompareSignEnum.FIELDLARGE, CompareSignEnum.FIELDLARGEEQUAL, CompareSignEnum.FIELDLESS, CompareSignEnum.FIELDLESSEQUAL, CompareSignEnum.FIELDNOTEQUAL, CompareSignEnum.YESTERDAY, CompareSignEnum.TODAY, CompareSignEnum.TOMORROW, CompareSignEnum.LASTWEEK, CompareSignEnum.THISWEEK, CompareSignEnum.NEXTWEEK, CompareSignEnum.LASTMONTH, CompareSignEnum.THISMONTH, CompareSignEnum.NEXTMONTH, CompareSignEnum.BEFORETODAY, CompareSignEnum.AFTERTODAY, CompareSignEnum.INCLUDESIGN, CompareSignEnum.NOTINCLUDESIGN};
    }

    public void setCompareValueColumn(KDTable table, IColumn column) throws Exception {
        if (table == null || column == null) {
            return;
        }
    }

    public void setCompareValueCell(IRow row) throws Exception {
    }

    private static void setNullSignLocked(KDTable table, int rowIndex) {
        ICell iCell = table.getRow(rowIndex).getCell(FILTER_COMPARE_VALUE);
        if (table.getRow(rowIndex).getCell(FILTER_COMPARE_SIGN).getValue() != null) {
            String filter_compare_sign = table.getRow(rowIndex).getCell(FILTER_COMPARE_SIGN).getValue().toString();
            if (BgConditionHelper.isNotCompareValue(filter_compare_sign)) {
                iCell.getStyleAttributes().setLocked(true);
                iCell.setValue(null);
            } else {
                iCell.getStyleAttributes().setLocked(false);
            }
        } else {
            iCell.getStyleAttributes().setLocked(true);
        }
    }

    public static boolean isNotCompareValue(String compareSign) {
        return CompareSignDateEnum.NULLSIGN.toString().equals(compareSign) || CompareSignDateEnum.NOTNULLSIGN.toString().equals(compareSign);
    }

    public void setRightBracketSignColumn(KDTable table, IColumn column) {
        BgConditionHelper.setComboBoxField(column, RightBracketSignEnum.getEnumList().toArray(), true);
    }

    public void setLoginSignColumn(KDTable table, IColumn column) {
        BgConditionHelper.setComboBoxField(column, LogicSignEnum.getEnumList().toArray(), true);
    }

    public static void loadFilter(EntityObjectInfo entity, IRow row, RowObject rowObject) {
        int length = FILTER_COLUMN_KEYS.length;
        for (int i = 0; i < length; ++i) {
            String methodName = "load" + FILTER_COLUMN_KEYS[i].substring(0, 1).toUpperCase() + FILTER_COLUMN_KEYS[i].substring(1);
            try {
                Method method = BgConditionHelper.class.getMethod(methodName, EntityObjectInfo.class, IRow.class, RowObject.class);
                method.invoke((Object)new BgConditionHelper(), entity, row, rowObject);
                continue;
            }
            catch (Exception e) {
                logger.info((Object)"", (Throwable)e);
            }
        }
    }

    public void loadLeftBracketSign(EntityObjectInfo entity, IRow row, RowObject rowObject) {
        if (row != null && rowObject != null) {
            row.getCell(FILTER_LFET_BRACKET_SIGN).setValue((Object)LeftBracketSignEnum.getEnum((String)rowObject.getLeftBracket()));
        }
    }

    public void loadCondition(EntityObjectInfo entity, IRow row, RowObject rowObject) {
        if (entity == null || row == null || rowObject == null) {
            return;
        }
        BgRuleDataInfo data = new BgRuleDataInfo(entity, FILTER_CONDITION, null);
        data.setExpression(rowObject.getCondition());
        data.setAlias(BgConditionHelper.getEntityPropertyAlias(entity, rowObject.getCondition()));
        row.getCell(FILTER_CONDITION).setValue((Object)data);
        BgConditionHelper.processCompareSignCell(row, data);
        BgConditionHelper.processCompareValueCell(row, data);
    }

    public void loadCompareSign(EntityObjectInfo entity, IRow row, RowObject rowObject) {
        if (row != null && rowObject != null) {
            row.getCell(FILTER_COMPARE_SIGN).setValue((Object)CompareSignEnum.getEnum((String)rowObject.getCompare().toUpperCase()));
        }
    }

    public void loadCompareValue(EntityObjectInfo entity, IRow row, RowObject rowObject) {
        if (row != null && rowObject != null) {
            Object value = rowObject.getCompareValue();
            if (row.getCell(FILTER_COMPARE_VALUE).getEditor() != null && row.getCell(FILTER_COMPARE_VALUE).getEditor().getComponent() instanceof KDComboBox && value != null) {
                KDComboBox box = (KDComboBox)row.getCell(FILTER_COMPARE_VALUE).getEditor().getComponent();
                for (int i = 0; i < box.getItemCount(); ++i) {
                    Object subObj = BgConditionHelper.getValue(box.getItemAt(i));
                    if (subObj == null || !subObj.toString().equalsIgnoreCase(value.toString())) continue;
                    value = box.getItemAt(i);
                    break;
                }
            }
            row.getCell(FILTER_COMPARE_VALUE).setValue(value);
        }
    }

    public void loadRightBracketSign(EntityObjectInfo entity, IRow row, RowObject rowObject) {
        if (row != null && rowObject != null) {
            row.getCell(FILTER_RIGHT_BRACKET_SIGN).setValue((Object)RightBracketSignEnum.getEnum((String)rowObject.getLeftBracket()));
        }
    }

    public void loadLoginSign(EntityObjectInfo entity, IRow row, RowObject rowObject) {
        if (row != null && rowObject != null) {
            if (StringUtils.isEmpty((String)rowObject.getLogic())) {
                row.getCell(FILTER_LOGIC_SIGN).setValue(null);
            } else {
                row.getCell(FILTER_LOGIC_SIGN).setValue((Object)LogicSignEnum.getEnum((String)rowObject.getLogic()));
            }
        }
    }

    public static void editedCellAfter(KDTEditEvent e) throws Exception {
        if (e.getSource() instanceof KDTable) {
            int colIndex = e.getColIndex();
            KDTable table = (KDTable)e.getSource();
            String colKey = table.getColumnKey(colIndex);
            IRow row = table.getRow(e.getRowIndex());
            if (row == null || StringUtils.isEmpty((String)colKey)) {
                return;
            }
            Object object = e.getValue();
            if (FILTER_CONDITION.equals(colKey)) {
                if (!(object instanceof BgRuleDataInfo) || StringUtils.isEmpty((String)((BgRuleDataInfo)object).getExpression())) {
                    row.getCell(FILTER_COMPARE_SIGN).getStyleAttributes().setLocked(true);
                    row.getCell(FILTER_COMPARE_VALUE).getStyleAttributes().setLocked(true);
                } else {
                    row.getCell(FILTER_COMPARE_SIGN).getStyleAttributes().setLocked(false);
                    BgConditionHelper.processCompareSignCell(row, (BgRuleDataInfo)object);
                    BgConditionHelper.processCompareValueCell(row, (BgRuleDataInfo)object);
                }
            } else if (FILTER_COMPARE_SIGN.equals(colKey)) {
                BgConditionHelper.setNullSignLocked(table, e.getRowIndex());
            } else if (FILTER_COMPARE_VALUE.equals(colKey)) {
                BgConditionHelper.editedCompareValueCellAfter(e);
            }
        }
    }

    private static void editedCompareValueCellAfter(KDTEditEvent e) {
        if (e.getValue() == null || !(e.getSource() instanceof KDTable)) {
            return;
        }
        IRow row = ((KDTable)e.getSource()).getRow(e.getRowIndex());
        if (row == null || row.getCell(FILTER_CONDITION) == null || !(row.getCell(FILTER_CONDITION).getValue() instanceof BgRuleDataInfo)) {
            return;
        }
        BgRuleDataInfo dataInfo = (BgRuleDataInfo)row.getCell(FILTER_CONDITION).getValue();
        if (StringUtils.isEmpty((String)dataInfo.getExpression())) {
            return;
        }
        DataObject dataType = BgConditionHelper.getDataObject(dataInfo.getEntity(), dataInfo.getExpression());
        String targetProperty = BgConditionHelper.getPropertyName(dataInfo.getExpression());
        if (dataType != null) {
            if (DataType.ENUM.getName().equals(dataType.getName()) || DataType.DATE.getName().equalsIgnoreCase(dataType.getName()) || DataType.TIME.getName().equalsIgnoreCase(dataType.getName()) || DataType.TIMESTAMP.getName().equalsIgnoreCase(dataType.getName()) || DataType.BOOLEAN.getName().equalsIgnoreCase(dataType.getName())) {
                return;
            }
            if (DataType.SHORT.getName().equalsIgnoreCase(dataType.getName()) || DataType.INTEGER.getName().equalsIgnoreCase(dataType.getName()) || DataType.LONG.getName().equalsIgnoreCase(dataType.getName()) || DataType.FLOAT.getName().equalsIgnoreCase(dataType.getName()) || DataType.DOUBLE.getName().equalsIgnoreCase(dataType.getName()) || DataType.DECIMAL.getName().equalsIgnoreCase(dataType.getName())) {
                String numberValue = null;
                if (row.getCell(FILTER_COMPARE_VALUE).getEditor() != null) {
                    Object value = row.getCell(FILTER_COMPARE_VALUE).getValue();
                    if (value == null) {
                        return;
                    }
                    if (value instanceof String) {
                        numberValue = (String)value;
                    } else if (value instanceof DataObject) {
                        numberValue = ((DataObject)value).getValue();
                    } else if (value instanceof IObjectValue && ((IObjectValue)value).get(targetProperty) != null) {
                        numberValue = ((IObjectValue)value).get(targetProperty).toString();
                    } else if (value instanceof Float) {
                        numberValue = value.toString();
                    } else if (value instanceof Integer) {
                        numberValue = value.toString();
                    }
                    if (BgConditionHelper.checkFilterData(numberValue, dataType.getName())) {
                        row.getCell(FILTER_COMPARE_VALUE).setValue(null);
                        MsgBox.showWarning((Component)((KDTable)e.getSource()), (String)EASResource.getString((String)commonEntityFilterRes, (String)"compareValueWarning"));
                        return;
                    }
                    row.getCell(FILTER_COMPARE_VALUE).setValue((Object)numberValue);
                }
            } else if (row.getCell(FILTER_COMPARE_VALUE).getEditor() != null) {
                Object objData = row.getCell(FILTER_COMPARE_VALUE).getValue();
                if (objData == null || objData instanceof String) {
                    return;
                }
                if (objData instanceof DataObject) {
                    row.getCell(FILTER_COMPARE_VALUE).setValue((Object)((DataObject)objData).getValue());
                } else if (objData instanceof IObjectValue) {
                    IObjectValue ov = (IObjectValue)objData;
                    if (ov.get(targetProperty) == null) {
                        row.getCell(FILTER_COMPARE_VALUE).setValue(null);
                    } else {
                        row.getCell(FILTER_COMPARE_VALUE).setValue((Object)ov.get(targetProperty).toString());
                    }
                }
            }
        }
    }

    private static boolean checkFilterData(String value, String dataType) {
        boolean flag = false;
        try {
            if (DataType.SHORT.getName().equalsIgnoreCase(dataType)) {
                new Short(value);
            } else if (DataType.INTEGER.getName().equalsIgnoreCase(dataType)) {
                new Integer(value);
            } else if (DataType.LONG.getName().equalsIgnoreCase(dataType)) {
                new Long(value);
            } else if (DataType.FLOAT.getName().equalsIgnoreCase(dataType)) {
                new Short(value);
            } else if (DataType.DOUBLE.getName().equalsIgnoreCase(dataType)) {
                new Double(value);
            } else if (DataType.DECIMAL.getName().equalsIgnoreCase(dataType)) {
                new BigDecimal(value);
            }
        }
        catch (NumberFormatException e) {
            flag = true;
        }
        return flag;
    }

    public static void processCompareSignCell(IRow row, BgRuleDataInfo dataInfo) {
        if (row == null) {
            return;
        }
        if (dataInfo == null || StringUtils.isEmpty((String)dataInfo.getExpression())) {
            row.getCell(FILTER_COMPARE_SIGN).getStyleAttributes().setLocked(true);
            row.getCell(FILTER_COMPARE_VALUE).getStyleAttributes().setLocked(true);
            row.getCell(FILTER_COMPARE_VALUE).setValue(null);
            return;
        }
        row.getCell(FILTER_COMPARE_SIGN).getStyleAttributes().setLocked(false);
        PropertyInfo property = BgRuleField.getProperty(dataInfo.getEntity(), dataInfo.getExpression(), false);
        BgCompareSelectItemInfo selectItem = new BgCompareSelectItemInfo();
        ArrayList items = new ArrayList();
        items.addAll(CompareSignEnum.getEnumList());
        items.removeAll(Arrays.asList(BgConditionHelper.getRemoveItems()));
        if (property instanceof OwnPropertyInfo && !BgConditionHelper.isStringType((OwnPropertyInfo)property)) {
            items.remove(CompareSignEnum.LIKESIGN);
            items.remove(CompareSignEnum.NOTLIKESIGN);
            items.remove(CompareSignEnum.LEFTLIKESIGN);
            items.remove(CompareSignEnum.RIGHTLIKESIGN);
            items.remove(CompareSignEnum.NOTLEFTLIKESIGN);
        }
        selectItem.setAllItems(items.toArray());
        selectItem.setCurrentItem(CompareSignEnum.EQUALSSIGN);
        row.getCell(FILTER_COMPARE_SIGN).setValue((Object)selectItem);
    }

    public static void processCompareValueCell(IRow row, BgRuleDataInfo dataInfo) {
        if (row == null) {
            return;
        }
        ICell cell = row.getCell(FILTER_COMPARE_VALUE);
        if (dataInfo == null || StringUtils.isEmpty((String)dataInfo.getExpression())) {
            cell.getStyleAttributes().setLocked(true);
            return;
        }
        cell.getStyleAttributes().setLocked(false);
        DataObject dataObject = BgConditionHelper.getDataObject(dataInfo.getEntity(), dataInfo.getExpression());
        if (dataObject != null) {
            String type = dataObject.getName();
            if (type.equalsIgnoreCase(DataType.ENUM.getName())) {
                String enumClassName = dataObject.getValue();
                Object[] _enum = EnumUtils.getEnumList((String)enumClassName).toArray();
                BgConditionHelper.setComboBoxField(cell, _enum, false);
                cell.setValue(null);
            } else if (type.equalsIgnoreCase(DataType.BOOLEAN.getName())) {
                String enumClassName = dataObject.getValue();
                Object[] _enum = EnumUtils.getEnumList((String)enumClassName).toArray();
                BgConditionHelper.setComboBoxField(cell, _enum, false);
                cell.setValue(null);
            } else if (type.equalsIgnoreCase(DataType.DATE.getName()) || type.equalsIgnoreCase(DataType.TIME.getName()) || type.equalsIgnoreCase(DataType.TIMESTAMP.getName())) {
                String format = BgConditionHelper.getTimeFormat(type);
                cell.setEditor(BgConditionHelper.getDateCtrl(type));
                cell.getStyleAttributes().setNumberFormat(format);
                cell.setValue(null);
            } else if (dataInfo.getExpression().indexOf(".") == -1) {
                BgConditionHelper.resetCell(cell);
            } else {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("BILL_META", dataInfo.getEntity());
                params.put("CAN_EDITABLE", Boolean.TRUE);
                params.put("DISABLE_AUTO_POPO", Boolean.TRUE);
                ICellEditor editor = BgEditorGeneratorFactory.getEditor(dataInfo.getEntity().getFullName(), dataInfo.getExpression(), params);
                cell.setEditor(editor);
            }
        } else {
            BgConditionHelper.resetCell(cell);
        }
    }

    public static DataObject getDataObject(EntityObjectInfo entity, String property) {
        if (entity == null || StringUtils.isEmpty((String)property)) {
            return null;
        }
        EntityObjectInfo targetEntity = BgRuleField.getPropertyEntity(entity, property);
        if (targetEntity == null && property.indexOf(".") < 0) {
            targetEntity = entity;
        }
        String targetProperty = BgConditionHelper.getPropertyName(property);
        DataObject dataObject = BgConditionHelper.getRefMetaData(targetEntity, targetProperty);
        return dataObject;
    }

    public static String getTimeFormat(String dateType) {
        String format = BgNationalFormatUIUtil.getNationalDateFormatString();
        if (dateType.equalsIgnoreCase(DataType.TIME.getName())) {
            format = BgNationalFormatUIUtil.getNationalDateTimeFormatString();
        } else if (dateType.equalsIgnoreCase(DataType.TIMESTAMP.getName())) {
            format = BgNationalFormatUIUtil.getNationalDateTimeFormatString();
        }
        return format;
    }

    public static ICellEditor getDateCtrl(String dateType) {
        KDDatePicker datePicker = new KDDatePicker();
        if (DataType.TIMESTAMP.getName().equalsIgnoreCase(dateType)) {
            datePicker.setTimeEnabled(true);
        } else if (DataType.TIME.getName().equalsIgnoreCase(dateType)) {
            datePicker.setTimeEnabled(true);
        }
        datePicker.setValue((Object)new Date());
        return new KDTDefaultCellEditor(datePicker);
    }

    private static void resetCell(ICell cell) {
        if (cell != null) {
            cell.setEditor(null);
            cell.setValue(null);
            if (cell.getStyleAttributes() != null) {
                cell.getStyleAttributes().setNumberFormat("");
            }
        }
    }

    public static boolean isStringType(OwnPropertyInfo property) {
        return property != null && DataType.STRING.equals((Object)property.getDataType());
    }

    public static boolean isBlankRow(IRow row) {
        int columnSize = FILTER_COLUMN_KEYS.length;
        for (int i = 0; i < columnSize; ++i) {
            if (row.getCell(FILTER_COLUMN_KEYS[i]).getValue() == null || StringUtils.isEmpty((String)row.getCell(FILTER_COLUMN_KEYS[i]).getValue().toString())) continue;
            return false;
        }
        return true;
    }

    public static String getEntityPropertyAlias(EntityObjectInfo entity, String propertyValue) {
        if (entity == null || StringUtils.isEmpty((String)propertyValue)) {
            return null;
        }
        StringBuffer alias = new StringBuffer();
        String[] props = BgViewCommonHelper.splitField(propertyValue);
        for (int i = 0; i < props.length; ++i) {
            PropertyInfo prop = entity.getPropertyByName(props[i]);
            if (i != 0) {
                alias.append(".");
            }
            alias.append(prop.getAlias());
            if (!(prop instanceof LinkPropertyInfo)) break;
            LinkPropertyInfo lp = (LinkPropertyInfo)prop;
            entity = lp.getRelationship().getSupplierObject() != null && !entity.getFullName().equals(lp.getRelationship().getSupplierObject().getFullName()) ? lp.getRelationship().getSupplierObject() : lp.getRelationship().getClientObject();
        }
        return alias.toString();
    }
}

