/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.rules;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.ma.view.BgBillIntegrateRuleInfo;
import com.kingdee.eas.ma.view.client.rules.AbstractSinglePropertyConvertor;
import com.kingdee.eas.ma.view.client.rules.BgRuleDataInfo;
import com.kingdee.eas.ma.view.common.BgRuleField;
import org.apache.commons.lang.StringUtils;

public class BizDateRuleCellConvertor
extends AbstractSinglePropertyConvertor {
    @Override
    public void loadToCell(IRow row, IObjectValue rule, EntityObjectInfo entity, String colName) {
        if (row != null && rule != null && entity != null) {
            BgBillIntegrateRuleInfo r = (BgBillIntegrateRuleInfo)rule;
            BgRuleDataInfo info = new BgRuleDataInfo(entity, colName, r.getCuSet());
            if (BgRuleField.isExist(entity, r.getOqlBizDate())) {
                info.setExpression(r.getOqlBizDate());
                info.setAlias(r.getAliasBizDate());
            }
            info.setTargetClazzName("java.util.Date");
            this.setValue(row, info);
        }
    }

    @Override
    public void storeFromCell(IRow row, IObjectValue rule) {
        if (rule instanceof BgBillIntegrateRuleInfo) {
            BgBillIntegrateRuleInfo r = (BgBillIntegrateRuleInfo)rule;
            if (this.getValue(row) instanceof BgRuleDataInfo) {
                BgRuleDataInfo di = (BgRuleDataInfo)this.getValue(row);
                r.setOqlBizDate(di.getExpression());
                r.setAliasBizDate(di.getAlias());
            } else {
                r.setOqlBizDate(null);
                r.setAliasBizDate(null);
            }
        }
    }

    @Override
    public String getColumnKey() {
        return "bizDate";
    }

    @Override
    protected boolean isValidate(IObjectValue rule) {
        return !(rule instanceof BgBillIntegrateRuleInfo) || !StringUtils.isEmpty((String)((BgBillIntegrateRuleInfo)rule).getOqlBizDate());
    }

    @Override
    protected boolean isOverLong(IObjectValue rule) {
        boolean flag = false;
        if (rule instanceof BgBillIntegrateRuleInfo) {
            BgBillIntegrateRuleInfo r = (BgBillIntegrateRuleInfo)rule;
            if (r.getOqlBizDate() != null && r.getOqlBizDate().length() >= 100) {
                flag = true;
            }
            if (r.getAliasBizDate() != null && r.getAliasBizDate().length() >= 50) {
                flag = true;
            }
        }
        return flag;
    }

    @Override
    public Object getVerifyData(IObjectValue rule, String colName) {
        return rule instanceof BgBillIntegrateRuleInfo ? ((BgBillIntegrateRuleInfo)rule).getOqlBizDate() : null;
    }
}

