/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.rules;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.ma.view.BgBillIntegrateRuleInfo;
import com.kingdee.eas.ma.view.client.rules.AbstractSinglePropertyConvertor;
import com.kingdee.eas.ma.view.client.rules.BgRuleDataInfo;
import com.kingdee.eas.ma.view.common.BgRuleField;
import org.apache.commons.lang.StringUtils;

public class CurrencyRuleCellConvertor
extends AbstractSinglePropertyConvertor {
    @Override
    public void loadToCell(IRow row, IObjectValue rule, EntityObjectInfo entity, String colName) {
        if (row != null && rule != null && entity != null) {
            BgBillIntegrateRuleInfo r = (BgBillIntegrateRuleInfo)rule;
            BgRuleDataInfo info = new BgRuleDataInfo(entity, colName, r.getCuSet());
            if (BgRuleField.isExist(entity, r.getOqlCurrency())) {
                info.setExpression(r.getOqlCurrency());
                info.setAlias(r.getAliasCurrency());
            }
            info.setTargetClazzName("java.lang.String");
            this.setValue(row, info);
        }
    }

    @Override
    public void storeFromCell(IRow row, IObjectValue rule) {
        if (rule instanceof BgBillIntegrateRuleInfo) {
            BgBillIntegrateRuleInfo r = (BgBillIntegrateRuleInfo)rule;
            if (this.getValue(row) instanceof BgRuleDataInfo) {
                BgRuleDataInfo di = (BgRuleDataInfo)this.getValue(row);
                r.setOqlCurrency(di.getExpression());
                r.setAliasCurrency(di.getAlias());
            } else {
                r.setOqlCurrency(null);
                r.setAliasCurrency(null);
            }
        }
    }

    @Override
    public String getColumnKey() {
        return "currency";
    }

    @Override
    protected boolean isValidate(IObjectValue rule) {
        return !(rule instanceof BgBillIntegrateRuleInfo) || !StringUtils.isEmpty((String)((BgBillIntegrateRuleInfo)rule).getOqlCurrency());
    }

    @Override
    protected boolean isOverLong(IObjectValue rule) {
        if (rule instanceof BgBillIntegrateRuleInfo) {
            BgBillIntegrateRuleInfo r = (BgBillIntegrateRuleInfo)rule;
            if (r.getOqlCurrency() != null && r.getOqlCurrency().length() >= 100) {
                return true;
            }
            if (r.getAliasCurrency() != null && r.getAliasCurrency().length() >= 50) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getVerifyData(IObjectValue rule, String colName) {
        return rule instanceof BgBillIntegrateRuleInfo ? ((BgBillIntegrateRuleInfo)rule).getOqlCurrency() : null;
    }
}

