/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.rules;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.ma.view.BgBillIntegrateRuleInfo;
import com.kingdee.eas.ma.view.client.rules.AbstractDefaultConvertor;
import com.kingdee.eas.ma.view.client.rules.BgRuleDataInfo;
import com.kingdee.eas.ma.view.client.rules.IBgCellConvertor;
import com.kingdee.eas.ma.view.common.BgRuleField;
import org.apache.commons.lang.StringUtils;

public class DimensionRuleCellConvertor
extends AbstractDefaultConvertor
implements IBgCellConvertor {
    @Override
    public void loadToCell(IRow row, IObjectValue rule, EntityObjectInfo entity, String colName) {
        if (row != null && rule != null && entity != null) {
            BgBillIntegrateRuleInfo r = (BgBillIntegrateRuleInfo)rule;
            BgRuleDataInfo info = new BgRuleDataInfo(entity, colName, r.getCuSet());
            info.setCanMultiRow(true);
            if (BgRuleField.isExist(entity, r.getOqlDimension())) {
                info.setExpression(r.getOqlDimension());
                info.setAlias(r.getAliasDimension());
            }
            info.setTargetClazzName("java.lang.String");
            this.setValue(row, info);
        }
    }

    @Override
    public void storeFromCell(IRow row, IObjectValue rule) {
        if (rule instanceof BgBillIntegrateRuleInfo) {
            BgBillIntegrateRuleInfo r = (BgBillIntegrateRuleInfo)rule;
            if (this.getValue(row) instanceof BgRuleDataInfo) {
                BgRuleDataInfo di = (BgRuleDataInfo)this.getValue(row);
                r.setOqlDimension(di.getExpression());
                r.setAliasDimension(di.getAlias());
            } else {
                r.setOqlDimension(null);
                r.setAliasDimension(null);
            }
        }
    }

    @Override
    public String getColumnKey() {
        return "dimension";
    }

    @Override
    protected boolean isValidate(IObjectValue rule) {
        return !(rule instanceof BgBillIntegrateRuleInfo) || !StringUtils.isEmpty((String)((BgBillIntegrateRuleInfo)rule).getOqlDimension());
    }

    @Override
    protected boolean isOverLong(IObjectValue rule) {
        if (rule != null) {
            BgBillIntegrateRuleInfo r = (BgBillIntegrateRuleInfo)rule;
            if (r.getOqlDimension() != null && r.getOqlDimension().length() >= 1000) {
                return true;
            }
            if (r.getAliasDimension() != null && r.getAliasDimension().length() >= 1000) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getVerifyData(IObjectValue rule, String colName) {
        return rule instanceof BgBillIntegrateRuleInfo ? ((BgBillIntegrateRuleInfo)rule).getOqlDimension() : null;
    }
}

