/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.client.rules;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.ma.view.BgBillIntegrateRuleInfo;
import com.kingdee.eas.ma.view.client.rules.AbstractDefaultConvertor;
import com.kingdee.eas.ma.view.client.rules.BgRuleDataInfo;
import com.kingdee.eas.ma.view.common.BgRuleField;
import org.apache.commons.lang.StringUtils;

public class OrgUnitRuleCellConvertor
extends AbstractDefaultConvertor {
    @Override
    public void loadToCell(IRow row, IObjectValue rule, EntityObjectInfo entity, String colName) {
        if (row != null && rule != null && entity != null) {
            BgBillIntegrateRuleInfo r = (BgBillIntegrateRuleInfo)rule;
            BgRuleDataInfo info = new BgRuleDataInfo(entity, colName, r.getCuSet());
            info.setCanMultiRow(false);
            if (BgRuleField.isExist(entity, r.getOqlOrgUnit())) {
                info.setExpression(r.getOqlOrgUnit());
                info.setAlias(r.getAliasOrgUnit());
            }
            info.setTargetClazzName("java.lang.String");
            info.setSetOrgUnit(true);
            this.setValue(row, info);
        }
    }

    @Override
    public void storeFromCell(IRow row, IObjectValue rule) {
        if (rule instanceof BgBillIntegrateRuleInfo) {
            BgBillIntegrateRuleInfo r = (BgBillIntegrateRuleInfo)rule;
            if (this.getValue(row) instanceof BgRuleDataInfo) {
                BgRuleDataInfo di = (BgRuleDataInfo)this.getValue(row);
                r.setOqlOrgUnit(di.getExpression());
                r.setAliasOrgUnit(di.getAlias());
            } else {
                r.setOqlOrgUnit(null);
                r.setAliasOrgUnit(null);
            }
        }
    }

    @Override
    public String getColumnKey() {
        return "orgUnit";
    }

    @Override
    protected boolean isValidate(IObjectValue rule) {
        return !(rule instanceof BgBillIntegrateRuleInfo) || !StringUtils.isEmpty((String)((BgBillIntegrateRuleInfo)rule).getOqlOrgUnit());
    }

    @Override
    protected boolean isOverLong(IObjectValue rule) {
        if (rule instanceof BgBillIntegrateRuleInfo) {
            BgBillIntegrateRuleInfo r = (BgBillIntegrateRuleInfo)rule;
            if (r.getOqlOrgUnit() != null && r.getOqlOrgUnit().length() >= 256) {
                return true;
            }
            if (r.getAliasOrgUnit() != null && r.getAliasOrgUnit().length() >= 128) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getVerifyData(IObjectValue rule, String colName) {
        return rule instanceof BgBillIntegrateRuleInfo ? ((BgBillIntegrateRuleInfo)rule).getOqlOrgUnit() : null;
    }
}

