/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BudgetCtrlUtil;
import com.kingdee.eas.ma.view.BgBillIntegrateCommonException;
import com.kingdee.eas.ma.view.BgBillIntegrateItemMapCollection;
import com.kingdee.eas.ma.view.BgBillIntegrateItemMapInfo;
import com.kingdee.eas.ma.view.BgBillIntegrateRuleInfo;
import com.kingdee.eas.ma.view.BgBillIntegrateSchemeInfo;
import com.kingdee.eas.ma.view.common.BgBillIntegrateCommonHelper;
import com.kingdee.eas.ma.view.common.BgBillIntegrateConstants;
import com.kingdee.eas.ma.view.common.BgBillIntegrateParam;
import com.kingdee.eas.ma.view.common.BgRuleField;
import com.kingdee.eas.ma.view.common.DefaultBgBillIntegrate;
import com.kingdee.eas.ma.view.common.IBgBillIntegrateInterface;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractBgBillIntegrate
implements IBgBillIntegrateInterface {
    private static Logger logger = Logger.getLogger((String)AbstractBgBillIntegrate.class.getName());
    protected Connection conn = null;
    protected Statement stmt = null;
    private int operator = 0;
    protected Map fieldIndex = new HashMap();

    @Override
    public int getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(int operator) {
        this.operator = operator;
    }

    @Override
    public List extractData(Context ctx, BgBillIntegrateSchemeInfo scheme, BgBillIntegrateRuleInfo rule, Map bgPeriodMap, Map bgDataMap, Map orgMap) throws EASBizException, BOSException {
        if (ctx == null || scheme == null || rule == null || bgDataMap == null || bgDataMap.isEmpty() || bgPeriodMap == null || bgPeriodMap.isEmpty()) {
            return null;
        }
        if (!this.isNeedExtractData(ctx, scheme, rule.getOqlPeriodType())) {
            return null;
        }
        ArrayList<BgBillIntegrateParam> params = new ArrayList<BgBillIntegrateParam>();
        ResultSet rs = null;
        try {
            rs = this.buildRowSet(ctx, scheme, rule, bgPeriodMap, bgDataMap);
            while (rs != null && rs.next()) {
                BgBillIntegrateParam param = this.extractData(ctx, scheme, rule, bgDataMap, rs);
                if (param == null) continue;
                params.add(param);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                this.clean();
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        this.clean();
        return params;
    }

    @Override
    public void checkAfterExtract(Context ctx, BgBillIntegrateSchemeInfo scheme, List params) throws BOSException, EASBizException {
    }

    @Override
    public void checkBeforeExtract(Context ctx, BgBillIntegrateSchemeInfo scheme, Map bgPeriodMap, Map bgDataMap, Map orgMap) throws BOSException, EASBizException {
    }

    protected BgBillIntegrateParam extractData(Context ctx, BgBillIntegrateSchemeInfo scheme, BgBillIntegrateRuleInfo rule, Map bgDataMap, ResultSet rs) throws BOSException, EASBizException, SQLException {
        String entryIdField;
        if (ctx == null || scheme == null || rule == null || bgDataMap == null) {
            return null;
        }
        BgBillIntegrateParam param = new BgBillIntegrateParam();
        param.boName = scheme.getBoName();
        param.schemeId = scheme.getId().toString();
        String billIdField = this.getBillIdField(ctx, scheme, rule);
        if (!StringUtils.isEmpty((String)billIdField)) {
            param.billId = rs.getString(this.getColIndex(billIdField));
        }
        param.entryField = entryIdField = this.getEntryIdField(ctx, scheme, rule);
        if (!StringUtils.isEmpty((String)entryIdField)) {
            param.entryId = rs.getString(this.getColIndex(entryIdField));
        }
        param.orgNumber = rs.getString(this.getColIndex(rule.getOqlOrgUnit()));
        if (BudgetCtrlUtil.isEmpty((Object)param.orgNumber)) {
            return null;
        }
        param.bizDate = rs.getDate(this.getColIndex(rule.getOqlBizDate()));
        if (param.bizDate == null) {
            return null;
        }
        param.periodType = rule.getOqlPeriodType().getValue();
        param.amountField = rule.getOqlRequest();
        param.value = rs.getBigDecimal(this.getColIndex(rule.getOqlRequest().split("\\|")[0]));
        param.value = this.calcuRequestAmount(param.value, rule.getOqlRequest(), rs, rule.getOqlRequestExt());
        if (param.value == null) {
            return null;
        }
        if (!StringUtils.isEmpty((String)rule.getOqlCurrency())) {
            param.currencyNumber = rs.getString(this.getColIndex(rule.getOqlCurrency()));
            param.currencyNumber = this.convertCurrencyNumber(ctx, scheme, rule, param.currencyNumber);
            if (StringUtils.isEmpty((String)param.currencyNumber)) {
                return null;
            }
        }
        param.bgElementNumber = rule.getOqlElement();
        param.bgItemNumber = this.parseBillItemNumber(rule.getOqlDimension(), rs);
        param.bgItemNumber = this.mappingBgItem(ctx, param.bgItemNumber, scheme, rule);
        if (StringUtils.isEmpty((String)param.bgItemNumber)) {
            return null;
        }
        return param;
    }

    protected String convertCurrencyNumber(Context ctx, BgBillIntegrateSchemeInfo scheme, BgBillIntegrateRuleInfo rule, String currencyNumber) throws BOSException, EASBizException {
        return currencyNumber;
    }

    protected BigDecimal calcuRequestAmount(BigDecimal value, String oqlRequest, ResultSet rs, String oqlExtendExpr) throws BOSException, SQLException {
        String oqlRequestExp;
        String expression;
        Object resultVal;
        String[] extendExpr;
        BigDecimal result = value;
        String[] oqlRequestSplited = oqlRequest.split("\\|");
        if (oqlRequestSplited.length < 2) {
            return result;
        }
        HashMap<String, Object> paramValMap = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)oqlExtendExpr) && (extendExpr = oqlExtendExpr.split("\\,")) != null && extendExpr.length > 0) {
            for (int j = 0; j < extendExpr.length; ++j) {
                if (StringUtils.isEmpty((String)extendExpr[j]) || this.fieldIndex.get(extendExpr[j]) == null) continue;
                paramValMap.put(extendExpr[j].replaceAll("\\.", "\\_"), rs.getObject(this.getColIndex(extendExpr[j])));
            }
        }
        if ((resultVal = new Interpreter().evalExpr(expression = (oqlRequestExp = oqlRequestSplited[1]).replaceAll("\\.", "\\_"), paramValMap)) instanceof BigDecimal) {
            result = result.multiply((BigDecimal)resultVal);
        } else {
            try {
                result = result.multiply(new BigDecimal(String.valueOf(resultVal)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected String mappingBgItem(Context ctx, String billItemExp, BgBillIntegrateSchemeInfo scheme, BgBillIntegrateRuleInfo rule) throws BOSException, EASBizException {
        int i;
        if (StringUtils.isEmpty((String)billItemExp)) {
            return null;
        }
        String bgItemCombinNumber = null;
        if (scheme != null && !scheme.getItemMap().isEmpty()) {
            BgBillIntegrateItemMapCollection mapCol = scheme.getItemMap();
            for (i = 0; i < mapCol.size(); ++i) {
                String[] paramKeys;
                String[] dbKeys;
                BgBillIntegrateItemMapInfo mapInfo = mapCol.get(i);
                String key = mapInfo.getBillItemNumber();
                if (key.equals(billItemExp)) {
                    bgItemCombinNumber = mapInfo.getBgItemNumber();
                    return bgItemCombinNumber;
                }
                if (key.indexOf("%") < 0 || (dbKeys = key.split("\\|")).length != (paramKeys = billItemExp.split("\\|")).length) continue;
                boolean notHit = false;
                StringBuffer numbers = new StringBuffer();
                for (int j = 0; j < dbKeys.length; ++j) {
                    String dbKey = dbKeys[j];
                    String paramKey = paramKeys[j];
                    if (dbKey.indexOf("%") < 0) {
                        if (dbKey.equals(paramKey)) continue;
                        notHit = true;
                        break;
                    }
                    String temp = dbKey.replaceAll("\\%", "");
                    if (!paramKey.startsWith(temp)) {
                        notHit = true;
                        break;
                    }
                    if (!temp.endsWith(":")) continue;
                    numbers.append(",").append(paramKey.substring(paramKey.indexOf(58) + 1));
                }
                if (notHit) continue;
                bgItemCombinNumber = mapInfo.getBgItemNumber();
                if (numbers.length() <= 0) break;
                bgItemCombinNumber = bgItemCombinNumber + numbers;
                break;
            }
        }
        if (StringUtils.isEmpty(bgItemCombinNumber)) {
            bgItemCombinNumber = null;
            String[] billSplit = billItemExp.split("\\|");
            for (i = 0; i < billSplit.length; ++i) {
                bgItemCombinNumber = bgItemCombinNumber == null ? this.convertBgItemNumber(ctx, scheme, rule, billSplit[i].split(":")[1]) : bgItemCombinNumber + "," + this.convertBgItemNumber(ctx, scheme, rule, billSplit[i].split(":")[1]);
            }
        }
        return bgItemCombinNumber;
    }

    protected String convertBgItemNumber(Context ctx, BgBillIntegrateSchemeInfo scheme, BgBillIntegrateRuleInfo rule, String billNumber) throws BOSException, EASBizException {
        return billNumber;
    }

    protected String parseBillItemNumber(String oqlItemCombination, ResultSet rs) throws SQLException {
        if (StringUtils.isEmpty((String)oqlItemCombination) || rs == null) {
            return null;
        }
        String itemCombinationAndPropNumber = "";
        Object[] oqlItemCombinationTemp = oqlItemCombination.split("\\@");
        if (oqlItemCombinationTemp != null) {
            Arrays.sort(oqlItemCombinationTemp);
        }
        String itemField = null;
        String itemValue = null;
        for (int k = 0; k < oqlItemCombinationTemp.length; ++k) {
            String[] oqlItemCombinationTempSub = ((String)oqlItemCombinationTemp[k]).split("\\|");
            itemField = oqlItemCombinationTempSub[0];
            itemValue = rs.getString(this.getColIndex(itemField));
            if (StringUtils.isEmpty((String)itemValue)) {
                return null;
            }
            itemCombinationAndPropNumber = itemCombinationAndPropNumber + itemField + ":" + itemValue.replaceAll("!", ".") + "|";
        }
        if (itemCombinationAndPropNumber.lastIndexOf(",") != -1) {
            itemCombinationAndPropNumber = itemCombinationAndPropNumber.substring(0, itemCombinationAndPropNumber.length() - 1);
        }
        if (itemCombinationAndPropNumber.lastIndexOf("|") != -1) {
            itemCombinationAndPropNumber = itemCombinationAndPropNumber.substring(0, itemCombinationAndPropNumber.length() - 1);
        }
        return itemCombinationAndPropNumber;
    }

    protected int getColIndex(String oql) {
        return (Integer)this.fieldIndex.get(BgRuleField.parseField(oql).getName()) + 1;
    }

    protected void clean() {
        this.fieldIndex.clear();
        SQLUtils.cleanup((Statement)this.stmt, (Connection)this.conn);
        this.conn = null;
        this.stmt = null;
    }

    protected ResultSet buildRowSet(Context ctx, BgBillIntegrateSchemeInfo scheme, BgBillIntegrateRuleInfo rule, Map bgPeriodMap, Map bgDataMap) throws EASBizException, BOSException {
        FilterInfo filter = this.buildDefaultFilter(ctx, (IObjectValue)scheme, (IObjectValue)rule);
        filter = this.addOrgFilter(ctx, (IObjectValue)scheme, (IObjectValue)rule, filter, bgDataMap);
        filter = this.addPeriodFilter(ctx, (IObjectValue)scheme, (IObjectValue)rule, filter, bgPeriodMap);
        String sql = this.buildSql(ctx, scheme, rule, filter);
        try {
            this.conn = this.getConnection(ctx);
            this.stmt = this.conn.createStatement();
            return this.stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected Connection getConnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection((Context)ctx);
    }

    protected String buildSql(Context ctx, BgBillIntegrateSchemeInfo scheme, BgBillIntegrateRuleInfo rule, FilterInfo filter) throws BOSException, EASBizException {
        int i;
        String entryIdField;
        EntityObjectInfo entity = MetaDataLoader.getEntity((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)scheme.getBoName()));
        String[] oqlOrgTemp = rule.getOqlOrgUnit().split("\\|");
        String oqlOrgField = oqlOrgTemp[0];
        String[] oqlOrgFieldWhere = null;
        if (oqlOrgTemp.length == 2) {
            oqlOrgFieldWhere = oqlOrgTemp[1].split("\\,");
        }
        String[] oqlItemCombinationTemp = rule.getOqlDimension().split("\\@");
        String[] oqlItemCombinationField = new String[oqlItemCombinationTemp.length];
        String[][] oqlItemCombinationFieldWhere = new String[oqlItemCombinationTemp.length][];
        for (int i2 = 0; i2 < oqlItemCombinationTemp.length; ++i2) {
            String[] oqlItemCombinationTmpSub = oqlItemCombinationTemp[i2].split("\\|");
            oqlItemCombinationField[i2] = oqlItemCombinationTmpSub[0];
            if (oqlItemCombinationTmpSub.length != 2) continue;
            oqlItemCombinationFieldWhere[i2] = oqlItemCombinationTmpSub[1].split("\\,");
        }
        String oqlCurrencyField = null;
        if (!StringUtils.isEmpty((String)rule.getOqlCurrency())) {
            oqlCurrencyField = rule.getOqlCurrency().split("\\|")[0];
        }
        String[] oqlBizDateTemp = rule.getOqlBizDate().split("\\|");
        String oqlBizDateField = oqlBizDateTemp[0];
        String[] oqlRequestTemp = rule.getOqlRequest().split("\\|");
        String oqlRequestField = oqlRequestTemp[0];
        String[] oqlRequestExpTemp = null;
        if (!BudgetCtrlUtil.isEmpty((Object)rule.getOqlRequestExt())) {
            oqlRequestExpTemp = rule.getOqlRequestExt().split("\\,");
        }
        this.fieldIndex.clear();
        int index = 0;
        StringBuffer oqlSelect = new StringBuffer("select ");
        String billIdField = this.getBillIdField(ctx, scheme, rule);
        if (!StringUtils.isEmpty((String)billIdField)) {
            index = this.appendSelectField(index, oqlSelect, billIdField, this.fieldIndex);
        }
        if (!StringUtils.isEmpty((String)(entryIdField = this.getEntryIdField(ctx, scheme, rule)))) {
            index = this.appendSelectField(index, oqlSelect, entryIdField, this.fieldIndex);
        }
        index = this.appendSelectField(index, oqlSelect, oqlOrgField, this.fieldIndex);
        for (i = 0; i < oqlItemCombinationField.length; ++i) {
            index = this.appendSelectField(index, oqlSelect, oqlItemCombinationField[i], this.fieldIndex);
        }
        index = this.appendSelectField(index, oqlSelect, oqlCurrencyField, this.fieldIndex);
        index = this.appendSelectField(index, oqlSelect, oqlBizDateField, this.fieldIndex);
        index = this.appendSelectField(index, oqlSelect, oqlRequestField, this.fieldIndex);
        for (i = 0; oqlRequestExpTemp != null && i < oqlRequestExpTemp.length; ++i) {
            index = this.appendSelectField(index, oqlSelect, oqlRequestExpTemp[i], this.fieldIndex);
        }
        StringBuffer oqlWhere = new StringBuffer();
        StringBuffer subOqlEntryWhere = new StringBuffer();
        int x = 0;
        int y = 0;
        for (int j = 0; oqlOrgFieldWhere != null && j < oqlOrgFieldWhere.length; ++j) {
            boolean isComposion = BgBillIntegrateCommonHelper.isComposion(entity, oqlOrgField);
            if (isComposion) {
                if (x == 0) {
                    subOqlEntryWhere.append(" ( ").append(oqlOrgField).append(" ='").append(oqlOrgFieldWhere[j]).append("' ");
                } else {
                    subOqlEntryWhere.append(" or ").append(oqlOrgField).append(" ='").append(oqlOrgFieldWhere[j]).append("' ");
                }
                ++x;
            } else {
                if (y == 0) {
                    oqlWhere.append(" and ( ").append(oqlOrgField).append(" ='").append(oqlOrgFieldWhere[j]).append("' ");
                } else {
                    oqlWhere.append(" or ").append(oqlOrgField).append(" ='").append(oqlOrgFieldWhere[j]).append("' ");
                }
                ++y;
            }
            if (x >= 1 && j == oqlOrgFieldWhere.length - 1) {
                subOqlEntryWhere.append(" ) ");
            }
            if (y < 1 || j != oqlOrgFieldWhere.length - 1) continue;
            oqlWhere.append(oqlWhere).append(" ) ");
        }
        for (int i3 = 0; i3 < oqlItemCombinationField.length; ++i3) {
            x = 0;
            y = 0;
            for (int j = 0; oqlItemCombinationFieldWhere[i3] != null && j < oqlItemCombinationFieldWhere[i3].length; ++j) {
                boolean isComposion = BgBillIntegrateCommonHelper.isComposion(entity, oqlItemCombinationField[i3]);
                if (isComposion) {
                    if (x == 0) {
                        if (subOqlEntryWhere.length() == 0) {
                            subOqlEntryWhere.append(" ( ").append(oqlItemCombinationField[i3]).append(" ='").append(oqlItemCombinationFieldWhere[i3][j]).append("' ");
                        } else {
                            subOqlEntryWhere.append(" and ( ").append(oqlItemCombinationField[i3]).append(" ='").append(oqlItemCombinationFieldWhere[i3][j]).append("' ");
                        }
                    } else {
                        subOqlEntryWhere.append(" or ").append(oqlItemCombinationField[i3]).append(" ='").append(oqlItemCombinationFieldWhere[i3][j]).append("' ");
                    }
                    ++x;
                } else {
                    if (y == 0) {
                        oqlWhere.append(" and ( ").append(oqlItemCombinationField[i3]).append(" ='").append(oqlItemCombinationFieldWhere[i3][j]).append("' ");
                    } else {
                        oqlWhere.append(" or ").append(oqlItemCombinationField[i3]).append(" ='").append(oqlItemCombinationFieldWhere[i3][j]).append("' ");
                    }
                    ++y;
                }
                if (x >= 1 && j == oqlItemCombinationFieldWhere[i3].length - 1) {
                    subOqlEntryWhere.append(" ) ");
                }
                if (y < 1 || j != oqlItemCombinationFieldWhere[i3].length - 1) continue;
                oqlWhere.append(" ) ");
            }
        }
        StringBuffer oql = new StringBuffer(oqlSelect).append(" where ");
        boolean hasCond = false;
        if (filter != null && !filter.getFilterItems().isEmpty()) {
            oql.append(" ( ").append(filter.toSql()).append(" ) ");
            hasCond = true;
        }
        if (oqlWhere.length() > 0) {
            oql.append(hasCond ? " and ( " : " ( ").append(oqlWhere).append(" ) ");
            hasCond = true;
        }
        if (subOqlEntryWhere.length() > 0) {
            oql.append(hasCond ? " and ( " : " ( ").append(subOqlEntryWhere).append(" ) ");
            hasCond = true;
        }
        if (!StringUtils.isEmpty((String)rule.getOqlRuleCondition())) {
            oql.append(hasCond ? " and ( " : "(").append(rule.getOqlRuleCondition()).append(" ) ");
            hasCond = true;
        }
        IDataProvider dataProvider = this.getDataProvider(ctx, scheme.getBoName());
        dataProvider.option().optimizeMode = 1;
        dataProvider.setObjectView(oql.toString());
        try {
            String queryBillSQL = dataProvider.getSQL();
            return queryBillSQL;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BgBillIntegrateCommonException(BgBillIntegrateCommonException.CONFIGERROR);
        }
    }

    protected IDataProvider getDataProvider(Context ctx, String boName) throws BOSException, EASBizException {
        return EntityExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)boName));
    }

    protected int appendSelectField(int currIndex, StringBuffer select, String field, Map fieldIndex) {
        if (!StringUtils.isEmpty((String)field) && !fieldIndex.containsKey(field)) {
            if (currIndex > 0) {
                select.append(",");
            }
            select.append(field);
            fieldIndex.put(field, new Integer(currIndex));
            return currIndex + 1;
        }
        return currIndex;
    }

    public abstract FilterInfo buildDefaultFilter(Context var1, IObjectValue var2, IObjectValue var3) throws BOSException, EASBizException;

    public FilterInfo addPeriodFilter(Context ctx, IObjectValue scheme, IObjectValue rule, FilterInfo filter, Map bgPeriodMap) throws BOSException, EASBizException {
        if (ctx == null || rule == null) {
            return filter;
        }
        BgBillIntegrateRuleInfo r = (BgBillIntegrateRuleInfo)rule;
        Timestamp startDate = null;
        Timestamp endDate = null;
        Integer periodType = new Integer(r.getOqlPeriodType().getValue());
        if (bgPeriodMap != null && bgPeriodMap.containsKey(periodType)) {
            Timestamp[] ts = (Timestamp[])bgPeriodMap.get(periodType);
            startDate = new Timestamp(BgBillIntegrateCommonHelper.setBeginDate(ts[0]).getTime());
            endDate = new Timestamp(BgBillIntegrateCommonHelper.setEndDate(ts[1]).getTime());
        } else {
            startDate = Timestamp.valueOf("2012-01-01 00:00:000");
            endDate = Timestamp.valueOf("2010-01-01 00:00:000");
        }
        if (filter == null) {
            filter = new FilterInfo();
        }
        String periodField = r.getOqlBizDate().split("\\|")[0];
        filter.getFilterItems().add(new FilterItemInfo(periodField, (Object)startDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo(periodField, (Object)endDate, CompareType.LESS_EQUALS));
        return filter;
    }

    public FilterInfo addOrgFilter(Context ctx, IObjectValue scheme, IObjectValue rule, FilterInfo filter, Map bgDataMap) throws BOSException, EASBizException {
        String[] orgSource;
        if (ctx == null || rule == null || bgDataMap == null || bgDataMap.size() > 1000) {
            return filter;
        }
        if (filter == null) {
            filter = new FilterInfo();
        }
        if ((orgSource = ((BgBillIntegrateRuleInfo)rule).getOqlOrgUnit().split("\\|"))[0].toLowerCase(Locale.ENGLISH).endsWith("id")) {
            filter.getFilterItems().add(new FilterItemInfo(orgSource[0], new HashSet(bgDataMap.keySet()), CompareType.INCLUDE));
        } else if (orgSource[0].toLowerCase(Locale.ENGLISH).endsWith("number") && !orgSource[0].toLowerCase(Locale.ENGLISH).endsWith("longnumber")) {
            HashSet<String> orgNumbers = new HashSet<String>();
            orgNumbers.add("#");
            if (!bgDataMap.isEmpty()) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(bgDataMap.keySet()), CompareType.INCLUDE));
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("id");
                evi.getSelector().add("number");
                FullOrgUnitCollection col = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(evi);
                if (col != null && !col.isEmpty()) {
                    for (int i = 0; i < col.size(); ++i) {
                        orgNumbers.add(col.get(i).getNumber());
                    }
                }
                filter.getFilterItems().add(new FilterItemInfo(orgSource[0], orgNumbers, CompareType.INCLUDE));
            }
        } else {
            String o = null;
            o = orgSource[0].lastIndexOf("\\.") > 0 ? orgSource[0].substring(0, orgSource[0].lastIndexOf("\\.")) : orgSource[0];
            filter.getFilterItems().add(new FilterItemInfo(o, new HashSet(bgDataMap.keySet()), CompareType.INCLUDE));
        }
        return filter;
    }

    @Override
    public boolean isNeedExtractData(Context ctx, BgBillIntegrateSchemeInfo scheme, BgPeriodEnum bgPeriod) throws BOSException, EASBizException {
        return true;
    }

    public static IBgBillIntegrateInterface getInterface(BgBillIntegrateSchemeInfo scheme) throws BOSException {
        return AbstractBgBillIntegrate.getInterface(scheme.getBoName());
    }

    public static IBgBillIntegrateInterface getInterface(String boName) throws BOSException {
        IBgBillIntegrateInterface bbi;
        String className = null;
        Map billMap = BgBillIntegrateConstants.getSupportBill();
        if (billMap != null && billMap.containsKey(boName)) {
            className = (String)billMap.get(boName);
        }
        if (StringUtils.isEmpty(className)) {
            bbi = new DefaultBgBillIntegrate();
        } else {
            try {
                bbi = (IBgBillIntegrateInterface)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                logger.error((Object)("className[" + className + "]"), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return bbi;
    }

    @Override
    public String getBillIdField(Context ctx, BgBillIntegrateSchemeInfo scheme, BgBillIntegrateRuleInfo rule) throws BOSException, EASBizException {
        return "id";
    }

    @Override
    public String getEntryIdField(Context ctx, BgBillIntegrateSchemeInfo scheme, BgBillIntegrateRuleInfo rule) throws BOSException, EASBizException {
        return null;
    }
}

