/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.view.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.view.BgBillIntegrateCommonException;
import com.kingdee.eas.ma.view.BgBillIntegrateItemMapCollection;
import com.kingdee.eas.ma.view.BgBillIntegrateItemMapInfo;
import com.kingdee.eas.ma.view.common.BgBillIntegrateItemMapComparator;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgBillIntegrateCommonHelper {
    private static Logger logger = Logger.getLogger((String)BgBillIntegrateCommonHelper.class.getName());

    public static String getConditionProperty(String condition) {
        if (StringUtils.isEmpty((String)condition)) {
            return "";
        }
        try {
            FilterInfo filter = new FilterInfo(condition);
            StringBuffer cod = new StringBuffer();
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                if (cod.length() != 0) {
                    cod.append("@");
                }
                cod.append(filter.getFilterItems().get(i).getPropertyName());
            }
            return cod.toString();
        }
        catch (ParserException e) {
            logger.error((Object)"", (Throwable)e);
            return "";
        }
    }

    public static Date setBeginDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date setEndDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }

    public static Map getBillProperty(String billProperty) {
        String[] onItem;
        HashMap<String, String> rs = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)billProperty) && (onItem = billProperty.split("\\|")) != null) {
            for (int i = 0; i < onItem.length; ++i) {
                String[] items;
                if (StringUtils.isEmpty((String)onItem[i]) || (items = onItem[i].split(":")) == null || items.length <= 0) continue;
                if (items.length == 1) {
                    rs.put(items[0], "%");
                    continue;
                }
                rs.put(items[0], items[1].trim());
            }
        }
        return rs;
    }

    public static String getBillProperty(Set props) {
        if (props == null || props.isEmpty()) {
            return null;
        }
        if (!(props instanceof LinkedHashSet)) {
            props = BgBillIntegrateCommonHelper.getSortSet(props);
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = props.iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append("@");
            }
            sb.append(it.next());
        }
        return sb.toString();
    }

    public static Set getSortSet(Set set) {
        if (set == null) {
            return null;
        }
        LinkedHashSet<Object> res = new LinkedHashSet<Object>();
        if (!set.isEmpty()) {
            Object[] p = set.toArray();
            Arrays.sort(p);
            for (int i = 0; i < p.length; ++i) {
                res.add(p[i]);
            }
        }
        return res;
    }

    public static void sortItemMap(BgBillIntegrateItemMapCollection col) {
        if (col != null && !col.isEmpty()) {
            Object[] itemMaps = col.toArray();
            Arrays.sort(itemMaps, new BgBillIntegrateItemMapComparator());
            col.clear();
            for (int i = 0; i < itemMaps.length; ++i) {
                col.add((BgBillIntegrateItemMapInfo)itemMaps[i]);
            }
        }
    }

    public static String getNewCombinName(String oldNumber, String oldName, String newNumber) {
        if (StringUtils.isEmpty((String)oldName) || StringUtils.isEmpty((String)oldNumber) || StringUtils.isEmpty((String)newNumber)) {
            return "";
        }
        if (newNumber.equals(oldNumber)) {
            return oldName;
        }
        String name = null;
        String[] oldNumbers = oldNumber.split("_");
        String[] oldNames = oldName.split("_");
        String[] newNumbers = newNumber.split("_");
        StringBuffer newName = new StringBuffer();
        for (int i = 0; i < newNumbers.length; ++i) {
            name = null;
            for (int j = 0; j < oldNumbers.length; ++j) {
                if (!oldNumbers[j].equals(newNumbers[i]) || j >= oldNames.length) continue;
                name = oldNames[j];
                break;
            }
            if (name != null) {
                if (newName.length() > 0) {
                    newName.append("_");
                }
            } else {
                return oldName;
            }
            newName.append(name);
        }
        return newName.toString();
    }

    public static void applyMutexService(Context ctx, String id, String userID) throws BgBillIntegrateCommonException, BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id);
        BgBillIntegrateCommonHelper.batchApplyMutexService(ctx, ids, userID);
    }

    public static void batchApplyMutexService(Context ctx, List ids, String userID) throws BgBillIntegrateCommonException, BOSException {
        IMutexServiceControl iMC = null;
        iMC = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map res = iMC.batchRequestObjIDForUpdate(ids);
        if (res != null && !res.isEmpty()) {
            for (Object b : res.values()) {
                if (!(b instanceof Boolean) || ((Boolean)b).booleanValue()) continue;
                throw new BgBillIntegrateCommonException(BgBillIntegrateCommonException.MESSAGE, new Object[]{EASResource.getString((String)"com.kingdee.eas.ma.view.client.BgBillIntegrateSchemeResource", (String)"lockInfo")});
            }
        }
    }

    public static void batchReleaseMutexService(Context ctx, List ids) throws BOSException {
        IMutexServiceControl iMC = null;
        iMC = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        iMC.batchReleaseObjIDForUpdate(ids);
    }

    public static void releaseMutexService(Context ctx, String id) throws BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id);
        BgBillIntegrateCommonHelper.batchReleaseMutexService(ctx, ids);
    }

    public static SorterItemCollection getSchemeSorter() {
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("rules.seq"));
        sorter.add(new SorterItemInfo("itemMap.billItemNumber"));
        sorter.add(new SorterItemInfo("periodMap.seq"));
        return sorter;
    }

    public static SelectorItemCollection addSchemeSelectors(SelectorItemCollection sic) {
        if (sic == null) {
            sic = new SelectorItemCollection();
            sic.add("id");
        }
        sic.add("subSystemName");
        sic.add("subSystemAlias");
        sic.add("boName");
        sic.add("boAlias");
        sic.add("orgUnit.id");
        sic.add("rules.id");
        sic.add("rules.scheme.id");
        sic.add("rules.seq");
        sic.add("rules.oqlOrgUnit");
        sic.add("rules.aliasOrgUnit");
        sic.add("rules.oqlDimension");
        sic.add("rules.aliasDimension");
        sic.add("rules.oqlCurrency");
        sic.add("rules.aliasCurrency");
        sic.add("rules.oqlPeriodType");
        sic.add("rules.oqlBizDate");
        sic.add("rules.aliasBizDate");
        sic.add("rules.oqlElement");
        sic.add("rules.aliasElement");
        sic.add("rules.oqlRequest");
        sic.add("rules.aliasRequest");
        sic.add("rules.oqlRequestExt");
        sic.add("rules.oqlRuleCondition");
        sic.add("rules.aliasRuleCondition");
        sic.add("itemMap.id");
        sic.add("itemMap.billItemNumber");
        sic.add("itemMap.billItemAlias");
        sic.add("itemMap.bgItemNumber");
        sic.add("itemMap.bgItemAlias");
        return sic;
    }

    public static boolean isComposion(EntityObjectInfo entity, String oqlField) {
        LinkPropertyInfo linkPro;
        CardinalityType cType;
        PropertyInfo prop;
        boolean isComposion = false;
        String[] temp = oqlField.split("\\.");
        if (temp != null && temp.length >= 1 && (prop = entity.getPropertyByName(temp[0])) instanceof LinkPropertyInfo && ((cType = (linkPro = (LinkPropertyInfo)prop).getRelationship().getSupplierCardinality()).getName().equals(CardinalityType.ONE_TO_UNBOUNDED.getName()) || cType.getName().equals(CardinalityType.ZERO_TO_UNBOUNDED.getName()))) {
            isComposion = true;
        }
        return isComposion;
    }

    public static Set splitBgCombination(Set numbers, String itemCombinaltion) {
        if (!StringUtils.isEmpty((String)itemCombinaltion)) {
            if (numbers == null) {
                numbers = new HashSet<String>();
            }
            String[] ns = itemCombinaltion.replaceAll(",", "_").split("_");
            for (int i = 0; i < ns.length; ++i) {
                numbers.add(ns[i]);
            }
        }
        return numbers;
    }

    public static int getBgItemRefField(BgItemInfo bgItem) {
        int refField = -1;
        if (bgItem != null && !StringUtils.isEmpty((String)bgItem.getRefField())) {
            refField = Integer.parseInt(bgItem.getRefField().replaceAll("F", ""));
        }
        return refField;
    }

    public static String getBgFormKey(String bgSchemeRootId, String currencyId, String bgPeriodId, String bgTemplateRootId) {
        return bgSchemeRootId + "|" + bgPeriodId + "|" + currencyId + "|" + bgTemplateRootId;
    }
}

